/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelKeyResult;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelOAMInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnConfigOAMInfoReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnConfigOAMInfoRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.MplsOamTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelOAMInfoTranslator;
import java.util.Collection;
import java.util.Set;

public class ConfigOamInfoForModifyDBTask
extends AbstractConfigQTask<QAsnConfigOAMInfoReq, QAsnConfigOAMInfoRsp> {
    private QAsnTunnelOAMInfo qasnTunnelOAMInfo;

    protected ConfigOamInfoForModifyDBTask(QAsnTunnelOAMInfo qasnTunnelOAMInfo) {
        super(EOperationType.MODIFY);
        this.qasnTunnelOAMInfo = qasnTunnelOAMInfo;
    }

    protected void decode(QAsnConfigOAMInfoReq req, Task task, IAsnTranslationContext context) {
        QAsnTunnelOAMInfo decodeAsn = this.qasnTunnelOAMInfo;
        try {
            MplsOamTunnel mo = new MplsOamTunnel();
            QAsnTunnelOAMInfoTranslator translator = new QAsnTunnelOAMInfoTranslator();
            translator.decode(decodeAsn, mo, context);
        }
        catch (VMFException e) {
            this.getLogger().error("decode req error. decodeAsns=" + decodeAsn, (Throwable)e);
        }
    }

    protected void encode(QAsnConfigOAMInfoRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        rsp.oResult.result = 0;
        QAsnTunnelKeyResult Result = new QAsnTunnelKeyResult();
        Context context = asnTranslatorContext.getTransactionContext();
        IMOChangeRecord tunnelChangeRecord = context.getChangeRecord(MplsOamTunnel.class);
        OperResult operResult = context.getOperResult();
        Set tunnels = tunnelChangeRecord.getAllChanges();
        Result.result.errCode = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)tunnels, (OperResult)operResult).result;
        MplsOamTunnelFdnParser fdnParser = new MplsOamTunnelFdnParser();
        for (MplsOamTunnel tunnel : tunnels) {
            Result.oTunnelKey = fdnParser.getUniResID((VmfMO)tunnel);
        }
        rsp.lstOAMKeySuccess.add((Object)Result);
        if (Result.result.errCode > 0) {
            rsp.oResult.result = 1107499878;
        }
    }

    protected void executeTask(QAsnConfigOAMInfoReq req, QAsnConfigOAMInfoRsp rsp, Task task) {
        IAsnTranslationContext asnTranslatorContext = this.getContext(req);
        this.decode(req, task, asnTranslatorContext);
        try {
            Context ctx = asnTranslatorContext.getTransactionContext();
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
            dao.merge(MplsOamTunnel.class, false);
        }
        catch (VMFException e) {
            this.getLogger().error("ConfigOamInfoForModifyDBTask error. ", (Throwable)e);
        }
        this.encode(rsp, asnTranslatorContext);
    }

    protected Integer getAsnBestEffort(QAsnConfigOAMInfoReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnConfigOAMInfoReq req) {
        return req.strTaskFlag;
    }

    protected Collection<QAsnTunnelOAMInfo> getDecodeAsns(QAsnConfigOAMInfoReq req) {
        return null;
    }

    protected void setEncodeAsns(Collection<QAsnTunnelOAMInfo> encodeAsns, QAsnConfigOAMInfoRsp rsp, IAsnTranslationContext context) {
    }

    private IAsnTranslationContext getContext(QAsnConfigOAMInfoReq req) {
        AsnTranslationContext asnTranslationContext = new AsnTranslationContext();
        asnTranslationContext.setOperType(this.getOperType());
        Context context = new Context();
        asnTranslationContext.setTransactionContext(context);
        Integer bestEffort = this.getAsnBestEffort(req);
        if (null != bestEffort && bestEffort.equals(1)) {
            context.setBestEffort(true);
        }
        context.setTaskFlag(StringUtil.globalString((byte[])this.getAsnTaskFlag(req)));
        return asnTranslationContext;
    }
}

