/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelKeyResult;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelOAMInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnConfigOAMInfoReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnConfigOAMInfoRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractSingleMoConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.MplsOamTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelOAMInfoTranslator;
import java.util.Collection;
import java.util.Set;

public class ConfigOamInfoForCreateNETask
extends AbstractSingleMoConfigQTask<QAsnConfigOAMInfoReq, QAsnConfigOAMInfoRsp, QAsnTunnelOAMInfo, QAsnTunnelOAMInfo, MplsOamTunnel> {
    private QAsnTunnelOAMInfo qasnTunnelOAMInfo;

    protected ConfigOamInfoForCreateNETask(QAsnTunnelOAMInfo qasnTunnelOAMInfo) {
        super(MplsOamTunnel.class, EOperationType.CREATE, (IAsnTranslator)new QAsnTunnelOAMInfoTranslator(), (IAsnTranslator)new QAsnTunnelOAMInfoTranslator());
        this.qasnTunnelOAMInfo = qasnTunnelOAMInfo;
    }

    protected void decode(QAsnConfigOAMInfoReq req, Task task, IAsnTranslationContext context) {
        QAsnTunnelOAMInfo decodeAsn = this.qasnTunnelOAMInfo;
        try {
            MplsOamTunnel mo = new MplsOamTunnel();
            QAsnTunnelOAMInfoTranslator translator = new QAsnTunnelOAMInfoTranslator();
            translator.decode(decodeAsn, mo, context);
        }
        catch (VMFException e) {
            this.getLogger().error("decode req error. decodeAsns=" + decodeAsn, (Throwable)e);
        }
    }

    protected void encode(QAsnConfigOAMInfoRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        QAsnTunnelKeyResult Result = new QAsnTunnelKeyResult();
        Context context = asnTranslatorContext.getTransactionContext();
        IMOChangeRecord tunnelChangeRecord = context.getChangeRecord(this.getMoClazz());
        OperResult operResult = context.getOperResult();
        Set tunnels = tunnelChangeRecord.getAllChanges();
        Result.result.errCode = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)tunnels, (OperResult)operResult).result;
        MplsOamTunnelFdnParser fdnParser = new MplsOamTunnelFdnParser();
        for (MplsOamTunnel tunnel : tunnels) {
            Result.oTunnelKey = fdnParser.getUniResID((VmfMO)tunnel);
        }
        rsp.lstOAMKeySuccess.add((Object)Result);
        if (Result.result.errCode > 0) {
            rsp.oResult.result = 1107499878;
        }
    }

    protected Integer getAsnBestEffort(QAsnConfigOAMInfoReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnConfigOAMInfoReq req) {
        return req.strTaskFlag;
    }

    protected Collection<QAsnTunnelOAMInfo> getDecodeAsns(QAsnConfigOAMInfoReq req) {
        return null;
    }

    protected void setEncodeAsns(Collection<QAsnTunnelOAMInfo> encodeAsns, QAsnConfigOAMInfoRsp rsp, IAsnTranslationContext context) {
    }
}

