/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelOAMInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnConfigOAMInfoReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnConfigOAMInfoRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.fservice.model.DeployableMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.task.ConfigOamInfoForModifyDBTask;
import com.huawei.vmf.adapter.mpls.task.ConfigOamInfoForModifyTask;
import com.huawei.vmf.adapter.mpls.task.ConfigOamInfoForPreDeployTask;
import java.util.ArrayList;
import java.util.Collection;
import net.commustru.fstru.FStruct;
import org.apache.commons.collections.CollectionUtils;

public class ConfigOAMInfoTask
extends AbstractQTask<QAsnConfigOAMInfoReq, QAsnConfigOAMInfoRsp> {
    protected void executeTask(QAsnConfigOAMInfoReq req, QAsnConfigOAMInfoRsp rsp, Task task) {
        try {
            for (Object qasnTunnelOAMInfo : req.lstTunnelOAMInfo) {
                Object configCreatTask;
                QAsnTunnelOAMInfo asnTunnelOAMInfo = (QAsnTunnelOAMInfo)qasnTunnelOAMInfo;
                QAsnUniResID tunnelOAMInfoKey = asnTunnelOAMInfo.oOAMKey;
                Collection<MplsOamTunnel> oamResults = MplsDao.newInstance().queryOAMByQAsnUniResID(tunnelOAMInfoKey);
                boolean exitsFlag = !oamResults.isEmpty();
                Collection<RsvpTeTunnel> tunnelResults = MplsDao.newInstance().queryTunnelByQAsnUniResID(tunnelOAMInfoKey);
                ArrayList<String> tunelKey = new ArrayList<String>();
                tunelKey.add(new String(tunnelOAMInfoKey.strFDN));
                Collection<StaticTunnel> staticTunnelResults = MplsDao.newInstance().queryStaticTunnelByFdn(tunelKey, true);
                if (CollectionUtils.isEmpty(tunnelResults) && CollectionUtils.isEmpty(staticTunnelResults)) {
                    this.getLogger().info("ConfigOAMInfoTask queryTunnelByQAsnUniResID result isempty. FDN:" + new String(tunnelOAMInfoKey.strFDN));
                    continue;
                }
                DeployableMO tnlInfo = !CollectionUtils.isEmpty(tunnelResults) ? (DeployableMO)tunnelResults.iterator().next() : (DeployableMO)staticTunnelResults.iterator().next();
                if (tnlInfo.isDeployed()) {
                    if (!exitsFlag) continue;
                    ConfigOamInfoForModifyTask configDeployTask = new ConfigOamInfoForModifyTask(asnTunnelOAMInfo);
                    configDeployTask.execute((FStruct)req, (FStruct)rsp, task);
                    continue;
                }
                if (exitsFlag) {
                    configCreatTask = new ConfigOamInfoForModifyDBTask(asnTunnelOAMInfo);
                    configCreatTask.execute((FStruct)req, (FStruct)rsp, task);
                    continue;
                }
                configCreatTask = new ConfigOamInfoForPreDeployTask(asnTunnelOAMInfo);
                configCreatTask.execute((FStruct)req, (FStruct)rsp, task);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("ConfigOAMInfoTask executeTask failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
        }
    }
}

