/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnTnlPolicyKey;
import com.huawei.network.qasn.m_q_ip_tnl_policy.QAsnCheckTnlPolicyNameReq;
import com.huawei.network.qasn.m_q_ip_tnl_policy.QAsnCheckTnlPolicyNameRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelPolicy;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnTnlPolicyKeyTranslator;
import java.util.ArrayList;
import java.util.Collection;
import net.commustru.fstru.FStruct;

public class CheckTnlPolicyNameTask
extends AbstractQTask<QAsnCheckTnlPolicyNameReq, QAsnCheckTnlPolicyNameRsp> {
    protected void executeTask(QAsnCheckTnlPolicyNameReq req, QAsnCheckTnlPolicyNameRsp rsp, Task task) {
        for (Object resObj : req.tnlPolicyNamelst) {
            QAsnTnlPolicyKey tnlPlyKey = (QAsnTnlPolicyKey)resObj;
            tnlPlyKey.poOperResult = new QAsnSingleReturn();
            tnlPlyKey.poOperResult.isSuccess = false;
            tnlPlyKey.poOperResult.retCode = 555803139;
            rsp.tnlPolicyNamelst.add(resObj);
        }
        ArrayList<TunnelPolicy> conditions = new ArrayList<TunnelPolicy>();
        QAsnTnlPolicyKeyTranslator translator = new QAsnTnlPolicyKeyTranslator();
        try {
            AsnTranslationContext context = new AsnTranslationContext();
            context.setTransactionContext(new Context());
            for (Object resObj : req.tnlPolicyNamelst) {
                TunnelPolicy mo = (TunnelPolicy)translator.decode((FStruct)((QAsnTnlPolicyKey)resObj), (IAsnTranslationContext)context);
                conditions.add(mo);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("CheckTnlPolicyNameTask query failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.reslut, (VMFException)e);
            return;
        }
        Collection tnlPolicyList = null;
        try {
            tnlPolicyList = MplsDao.newInstance().queryByKey(TunnelPolicy.class, conditions, false);
        }
        catch (VMFException e) {
            this.getLogger().error("CheckTnlPolicyNameTask query failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.reslut, (VMFException)e);
            return;
        }
        try {
            Collection asns = translator.encode(tnlPolicyList, (IAsnTranslationContext)new AsnTranslationContext());
            for (QAsnTnlPolicyKey resObj : asns) {
                for (Object o : rsp.tnlPolicyNamelst) {
                    QAsnTnlPolicyKey tnlKey = (QAsnTnlPolicyKey)o;
                    if (!this.isEqualsQAsnTnlPolicyKey(resObj, tnlKey)) continue;
                    tnlKey.poOperResult.isSuccess = true;
                    tnlKey.poOperResult.retCode = 0;
                }
            }
            rsp.reslut.result = 0;
        }
        catch (VMFException e) {
            this.getLogger().error("CheckTnlPolicyNameTask query failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.reslut, (VMFException)e);
        }
    }

    private boolean isEqualsQAsnTnlPolicyKey(QAsnTnlPolicyKey resObj, QAsnTnlPolicyKey tnlKey) {
        return resObj.neID == tnlKey.neID && AsnUtil.strValue((byte[])resObj.strTnlPolicyName).equals(AsnUtil.strValue((byte[])tnlKey.strTnlPolicyName));
    }
}

