/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnExpath;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnExpathResult;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnBulkCreateExPathReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnBulkCreateExPathRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractSingleMoConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.ExplicitPath;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnExpathResultTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnExpathTranslator;
import java.util.Collection;
import java.util.Set;

public class BulkCreateExPathTask
extends AbstractSingleMoConfigQTask<QAsnBulkCreateExPathReq, QAsnBulkCreateExPathRsp, QAsnExpath, QAsnExpathResult, ExplicitPath> {
    protected BulkCreateExPathTask() {
        super(ExplicitPath.class, EOperationType.CREATE, (IAsnTranslator)new QAsnExpathTranslator(), (IAsnTranslator)new QAsnExpathResultTranslator());
    }

    protected void encode(QAsnBulkCreateExPathRsp rsp, IAsnTranslationContext context) {
        Context transactionContext = context.getTransactionContext();
        Set mos = transactionContext.getChangeRecord(this.getMoClazz()).getCreates();
        OperResult operResult = transactionContext.getOperResult();
        rsp.oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)mos, (OperResult)operResult);
        try {
            for (ExplicitPath path : mos) {
                QAsnExpathResult asn = (QAsnExpathResult)this.getEncodeTranslator().encode((Object)path, context);
                asn.oResult = AsnTranslatorUtil.getMoQAsnSingleReturn((VmfMO)path, (OperResult)operResult);
                rsp.lstResult.add((Object)asn);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("BulkCreateExPathTask encode failed. mos=" + mos, (Throwable)e);
            return;
        }
    }

    protected Integer getAsnBestEffort(QAsnBulkCreateExPathReq req) {
        return null;
    }

    protected byte[] getAsnTaskFlag(QAsnBulkCreateExPathReq req) {
        return null;
    }

    protected Collection<QAsnExpath> getDecodeAsns(QAsnBulkCreateExPathReq req) {
        return req.lstExpath;
    }

    protected void setEncodeAsns(Collection<QAsnExpathResult> encodeAsns, QAsnBulkCreateExPathRsp rsp, IAsnTranslationContext context) {
    }
}

