/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnUniResIDResult;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnAutoFRRReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnAutoFRRRsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpInterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpInterface;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import java.util.Set;

public class AutoFRRTask
extends AbstractConfigQTask<QAsnAutoFRRReq, QAsnAutoFRRRsp> {
    private static final int AUTO_FRR_TYPE_DEFAULT = 2;
    private static final int AUTO_FRR_TYPE_LINK = 0;
    private static final int AUTO_FRR_TYPE_NODE = 1;
    protected final IFdnParser<RsvpInterface> fdnParser = new RsvpInterfaceFdnParser();

    public AutoFRRTask() {
        super(EOperationType.MODIFY);
        this.addMoCompositeService(RsvpInterface.class, (ICompositeService)new DefaultCompositeService(RsvpInterface.class));
    }

    protected void decode(QAsnAutoFRRReq req, Task task, IAsnTranslationContext context) {
        Integer autoFrrMode = req.iAutoFRR == 0 ? RsvpInterface.AUTO_FRR_MODE_ENUM.LINK : (req.iAutoFRR == 1 ? RsvpInterface.AUTO_FRR_MODE_ENUM.NODE : (req.iAutoFRR == 2 ? RsvpInterface.AUTO_FRR_MODE_ENUM.DEFAULT : RsvpInterface.AUTO_FRR_MODE_ENUM.DISABLE));
        IMOChangeRecord moChangeRecord = context.getTransactionContext().addChangeRecord(RsvpInterface.class);
        for (Object obj : req.lstInterfaceKey) {
            QAsnUniResID uniResId = (QAsnUniResID)obj;
            RsvpInterface mo = (RsvpInterface)this.fdnParser.getIndexMo(uniResId);
            mo.setAutoFrrMode(autoFrrMode);
            mo.setDevID(Integer.valueOf(uniResId.neID));
            mo.setFdn(StringUtil.globalString((byte[])uniResId.strFDN));
            PropertyChangeItem propertyChangeItem = new PropertyChangeItem("autoFrrMode");
            propertyChangeItem.setNewValue((Object)autoFrrMode);
            moChangeRecord.addModify((Object)mo, propertyChangeItem);
        }
    }

    protected void encode(QAsnAutoFRRRsp rsp, IAsnTranslationContext context) {
        OperResult operResult = context.getTransactionContext().getOperResult();
        Set mos = context.getTransactionContext().getChangeRecord(RsvpInterface.class).getAllChanges();
        rsp.oResult.result = 0;
        for (RsvpInterface mo : mos) {
            QAsnUniResIDResult uniResIDResult = new QAsnUniResIDResult();
            uniResIDResult.oTunnelKey = this.fdnParser.getUniResID((VmfMO)mo);
            ErrorInfo error = operResult.getMoOperResult((VmfMO)mo);
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.objID.add((Object)mo.getDevID());
            errInfo.objName = AsnUtil.getBytes((String)mo.getInterfaceName());
            if (this.isSuccess(error)) {
                errInfo.errCode = 0;
            } else {
                errInfo.errCode = error.getErrorCode();
                errInfo.strOperDesc = StringUtil.globalByte((String)error.getErrorMessage());
            }
            uniResIDResult.result = errInfo;
            rsp.lstInterfaceKeyFail.add((Object)uniResIDResult);
        }
    }

    protected Integer getAsnBestEffort(QAsnAutoFRRReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnAutoFRRReq req) {
        return req.strTaskFlag;
    }
}

