/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_resourcemgr_op.QAsnAskTunnelLabelReq;
import com.huawei.network.qasn.m_q_ip_resourcemgr_op.QAsnAskTunnelLabelRsp;
import com.huawei.network.qasn.m_q_ip_resourcemgr_op.QAsnNeIDAllocNum;
import com.huawei.network.qasn.m_q_ip_resourcemgr_op.QAsnNeIDAllocRes;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.fservice.mpls.model.GresmPreReserve;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AskTunnelLabelTask
extends AbstractQTask<QAsnAskTunnelLabelReq, QAsnAskTunnelLabelRsp> {
    protected void executeTask(QAsnAskTunnelLabelReq req, QAsnAskTunnelLabelRsp rsp, Task task) {
        Collection<GresmPreReserve> reserveRes = this.parseNeIdNumLabel(req);
        MplsDevDao dao = MplsDevDao.newInstance();
        rsp.result.retCode = 0;
        rsp.result.isSuccess = true;
        Map<Integer, List<Long>> labels = null;
        try {
            labels = dao.queryFreeReserveLabel(reserveRes);
        }
        catch (VMFException e) {
            this.getLogger().error("AskTunnelLabelTask query failed!");
            QAsnNeIDAllocRes labelAsn = new QAsnNeIDAllocRes();
            labelAsn.oResult.isSuccess = false;
            labelAsn.oResult.retCode = e.getErrorCode();
            labelAsn.oResult.reason = AsnUtil.getBytes((String)e.getErrorMessage());
            Integer neID = StringUtil.getInteger((String)e.getMessage());
            labelAsn.neID = null == neID ? -1 : neID;
            rsp.neIDLabelsList.add((Object)labelAsn);
            rsp.result.retCode = e.getErrorCode();
            rsp.result.isSuccess = false;
            rsp.result.reason = AsnUtil.getBytes((String)e.getErrorMessage());
            return;
        }
        for (Integer devID : labels.keySet()) {
            QAsnNeIDAllocRes labelAsn = new QAsnNeIDAllocRes();
            for (Long lable : labels.get(devID)) {
                labelAsn.resList.add((Object)lable.intValue());
            }
            labelAsn.neID = devID;
            labelAsn.oResult.isSuccess = true;
            labelAsn.oResult.retCode = 0;
            rsp.neIDLabelsList.add((Object)labelAsn);
        }
    }

    private Collection<GresmPreReserve> parseNeIdNumLabel(QAsnAskTunnelLabelReq req) {
        HashMap<Integer, GresmPreReserve> segMap = new HashMap<Integer, GresmPreReserve>();
        for (Object neIdNumObj : req.neIDnumList) {
            QAsnNeIDAllocNum neIdNumLabel = (QAsnNeIDAllocNum)neIdNumObj;
            Integer devId = neIdNumLabel.neID;
            GresmPreReserve reserveRes = (GresmPreReserve)segMap.get(devId);
            if (reserveRes == null) {
                reserveRes = new GresmPreReserve();
                reserveRes.setDevID(devId);
                reserveRes.setVrID(Integer.valueOf(0));
                reserveRes.setResPreResvNum(Long.valueOf(0L));
                segMap.put(devId, reserveRes);
            }
            reserveRes.setResPreResvNum(Long.valueOf(reserveRes.getResPreResvNum() + (long)neIdNumLabel.allocNum));
            reserveRes.setResType(GresmPreReserve.RES_TYPE_ENUM.SLABEL);
        }
        return segMap.values();
    }
}

