/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.sync;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.extendpoint.mpls.sync.IMplsSyncHandlerExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.device.DeviceAccessorFactory;
import com.huawei.vmf.adapter.framework.device.INetconfPoller;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.syncdata.AbstractFeatureSyncHandler;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.schema.FullSyncTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.IncreaseSyncTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.BiStaticCrLspStateInfo;
import com.huawei.vmf.adapter.fservice.mpls.model.ExplicitPath;
import com.huawei.vmf.adapter.fservice.mpls.model.IsisTE;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpInstance;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsCommonCfg;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsInterface;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamPw;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsTeSite;
import com.huawei.vmf.adapter.fservice.mpls.model.OspfTE;
import com.huawei.vmf.adapter.fservice.mpls.model.ReverseRsvpTeLsp;
import com.huawei.vmf.adapter.fservice.mpls.model.Ring;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpInterface;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.TeLink;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelGroup;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import com.huawei.vmf.netconf.service.TargetType;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.springframework.util.CollectionUtils;

public class MplsSyncHandler
extends AbstractFeatureSyncHandler {
    private LinkedHashSet<Class<? extends VmfMO>> moTypes = new LinkedHashSet();

    public MplsSyncHandler() {
        this.moTypes.add(ExplicitPath.class);
        this.moTypes.add(IsisTE.class);
        this.moTypes.add(LdpInstance.class);
        this.moTypes.add(MplsCommonCfg.class);
        this.moTypes.add(MplsInterface.class);
        this.moTypes.add(MplsTeSite.class);
        this.moTypes.add(OspfTE.class);
        this.moTypes.add(RsvpInterface.class);
        this.moTypes.add(ReverseRsvpTeLsp.class);
        this.moTypes.add(RsvpTeTunnel.class);
        this.moTypes.add(TeLink.class);
        this.moTypes.add(BiStaticCrLspStateInfo.class);
        this.moTypes.add(MplsOamTunnel.class);
        this.moTypes.add(MplsRing.class);
        this.moTypes.add(Ring.class);
        this.moTypes.add(StaticTunnel.class);
        this.moTypes.add(MplsOamPw.class);
        IMplsSyncHandlerExtPoint mplsSyncExtPoint = (IMplsSyncHandlerExtPoint)ExtendPointServiceMgr.getInstance().getExtendPoitService(IMplsSyncHandlerExtPoint.class);
        if (mplsSyncExtPoint != null) {
            mplsSyncExtPoint.registerTopMos(this.moTypes);
        } else {
            this.moTypes.add(TunnelGroup.class);
        }
    }

    public FeatureName getFeatureName() {
        return FeatureName.MPLS;
    }

    public LinkedHashSet<Class<? extends VmfMO>> getTopMoClasses() {
        return this.moTypes;
    }

    protected void fullSyncPreProcess(FullSyncTranslationContext translationContext) throws VMFException {
        super.fullSyncPreProcess(translationContext);
        Context ctx = translationContext.getContext();
        this.dealIgpMetricValue(ctx);
    }

    protected void incrSyncDynamicStatus(IncreaseSyncTranslationContext incrSyncContext) throws VMFException {
        IMOChangeRecord changedRecord = incrSyncContext.getContext().getChangeRecord(RsvpTeTunnel.class);
        if (changedRecord == null || CollectionUtils.isEmpty((Collection)changedRecord.getCreates())) {
            return;
        }
        QuerySchemaTranslatorContext querySchemaContext = new QuerySchemaTranslatorContext(incrSyncContext.getDevID());
        for (RsvpTeTunnel tunnel : changedRecord.getCreates()) {
            querySchemaContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)tunnel, Arrays.asList("operStatus", "tunnelState"));
        }
        INetconfPoller poller = DeviceAccessorFactory.getNetconfPoller((int)incrSyncContext.getDevID(), (TargetType)TargetType.RDB);
        poller.query(querySchemaContext);
    }

    protected void incrSyncPost(int ret, Context ctx) {
        IMOChangeRecord tunnelRecord = ctx.addChangeRecord(RsvpTeTunnel.class);
        for (RsvpTeTunnel tunnel : tunnelRecord.getModifies()) {
            if (!tunnelRecord.isModified((Object)tunnel, "mplsTunnelEgressLSRId") || this.isMplsTunnelEgressLSRIdRealChanged(tunnel)) continue;
            tunnelRecord.cancelModify((Object)tunnel, "mplsTunnelEgressLSRId");
        }
    }

    protected void incrSyncPreProcess(IncreaseSyncTranslationContext incrSyncContext) throws VMFException {
        super.incrSyncPreProcess(incrSyncContext);
        Context ctx = incrSyncContext.getContext();
        this.dealIgpMetricValue(ctx);
        IMOChangeRecord staticTunnelRecord = ctx.addChangeRecord(StaticTunnel.class);
        DaoFactory daoFactory = DaoFactory.getInstance();
        DaoFactory.getInstance();
        IDao dao = daoFactory.getDefaultDao(DaoFactory.VMF_DB, null);
        for (StaticTunnel staticTunnel : staticTunnelRecord.getModifies()) {
            try {
                Collection dbTunnel = dao.queryByKey(StaticTunnel.class, Arrays.asList(staticTunnel), false);
                if (CollectionUtils.isEmpty((Collection)dbTunnel)) continue;
                StaticTunnel dbStaticTunnel = (StaticTunnel)dbTunnel.iterator().next();
                this.cancelNoModifyRecord(dbStaticTunnel.getBackwardBkpLabel(), staticTunnel.getBackwardBkpLabel(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "backwardBkpLabel");
                this.cancelNoModifyRecord(dbStaticTunnel.getBackwardInLabel(), staticTunnel.getBackwardInLabel(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "backwardInLabel");
                this.cancelNoModifyRecord(dbStaticTunnel.getBackwardNextHop(), staticTunnel.getBackwardNextHop(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "backwardNextHop");
                this.cancelNoModifyRecord(dbStaticTunnel.getBackwardOutLabel(), staticTunnel.getBackwardOutLabel(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "backwardOutLabel");
                this.cancelNoModifyRecord(dbStaticTunnel.getDirection(), staticTunnel.getDirection(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "direction");
                this.cancelNoModifyRecord(dbStaticTunnel.getEgressLsrId(), staticTunnel.getEgressLsrId(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "egressLsrId");
                this.cancelNoModifyRecord(dbStaticTunnel.getEnterRingDirection(), staticTunnel.getEnterRingDirection(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "enterRingDirection");
                this.cancelNoModifyRecord(dbStaticTunnel.getEnterRingId(), staticTunnel.getEnterRingId(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "enterRingId");
                this.cancelNoModifyRecord(dbStaticTunnel.getEnterRingSinkNodeId(), staticTunnel.getEnterRingSinkNodeId(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "enterRingSinkNodeId");
                this.cancelNoModifyRecord(dbStaticTunnel.getForwardBkpLabel(), staticTunnel.getForwardBkpLabel(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "forwardBkpLabel");
                this.cancelNoModifyRecord(dbStaticTunnel.getForwardInLabel(), staticTunnel.getForwardInLabel(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "forwardInLabel");
                this.cancelNoModifyRecord(dbStaticTunnel.getForwardOutLabel(), staticTunnel.getForwardOutLabel(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "forwardOutLabel");
                this.cancelNoModifyRecord(dbStaticTunnel.getLsrRole(), staticTunnel.getLsrRole(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "lsrRole");
                this.cancelNoModifyRecord(dbStaticTunnel.getForwardNextHop(), staticTunnel.getForwardNextHop(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "forwardNextHop");
                this.cancelNoModifyRecord(dbStaticTunnel.getIncomingIfName(), staticTunnel.getIncomingIfName(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "incomingIfName");
                this.cancelNoModifyRecord(dbStaticTunnel.getQuitRingDirection(), staticTunnel.getQuitRingDirection(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "quitRingDirection");
                this.cancelNoModifyRecord(dbStaticTunnel.getQuitRingId(), staticTunnel.getQuitRingId(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "quitRingId");
                this.cancelNoModifyRecord(dbStaticTunnel.getQuitRingSrcNodeId(), staticTunnel.getQuitRingSrcNodeId(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "quitRingSrcNodeId");
                this.cancelNoModifyRecord(dbStaticTunnel.getTrafficEnable(), staticTunnel.getTrafficEnable(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "trafficEnable");
                this.cancelNoModifyRecord(dbStaticTunnel.getTunnelId(), staticTunnel.getTunnelId(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "tunnelId");
                this.cancelNoModifyRecord(dbStaticTunnel.getUserLabel(), staticTunnel.getUserLabel(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "userLabel");
                this.cancelNoModifyRecord(dbStaticTunnel.getIngressLsrId(), staticTunnel.getIngressLsrId(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "ingressLsrId");
                this.cancelNoModifyRecord(dbStaticTunnel.getOutgoingIfName(), staticTunnel.getOutgoingIfName(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "outgoingIfName");
                this.cancelNoModifyRecord(dbStaticTunnel.getTunnelDescription(), staticTunnel.getTunnelDescription(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "tunnelName");
                this.cancelNoModifyRecord(dbStaticTunnel.getCir(), staticTunnel.getCir(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "cir");
                this.cancelNoModifyRecord(dbStaticTunnel.getCbs(), staticTunnel.getCbs(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "cbs");
                this.cancelNoModifyRecord(dbStaticTunnel.getPir(), staticTunnel.getPir(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "pir");
                this.cancelNoModifyRecord(dbStaticTunnel.getPbs(), staticTunnel.getPbs(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "pbs");
                this.cancelNoModifyRecord(dbStaticTunnel.getInBearerType(), staticTunnel.getInBearerType(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "inBearerType");
                this.cancelNoModifyRecord(dbStaticTunnel.getOutBearerType(), staticTunnel.getOutBearerType(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "outBearerType");
                this.cancelNoModifyRecord(dbStaticTunnel.getExpMode(), staticTunnel.getExpMode(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "expMode");
                this.cancelNoModifyRecord(dbStaticTunnel.getMtu(), staticTunnel.getMtu(), (IMOChangeRecord<StaticTunnel>)staticTunnelRecord, staticTunnel, "mtu");
            }
            catch (VMFException e) {
                this.getLogger().error("MplsSyncHandler.incrSyncPreProcess query StaticTunnel error");
            }
        }
    }

    private void dealIgpMetricValue(Context ctx) {
        IMOChangeRecord advRecord = ctx.addChangeRecord(RsvpTeTunnelAdv.class);
        for (RsvpTeTunnelAdv adv : advRecord.getModifies()) {
            if (RsvpTeTunnelAdv.IGP_METRIC_TYPE_ENUM.RELATIVE.equals(adv.getIgpMetricType())) {
                adv.setAbsoluteIgpMetricValue(null);
                continue;
            }
            if (RsvpTeTunnelAdv.IGP_METRIC_TYPE_ENUM.ABSOLUTE.equals(adv.getIgpMetricType())) {
                adv.setRelativeIgpMetricValue(null);
                continue;
            }
            adv.setAbsoluteIgpMetricValue(null);
            adv.setRelativeIgpMetricValue(null);
        }
    }

    private boolean isMplsTunnelEgressLSRIdRealChanged(RsvpTeTunnel tunnel) {
        try {
            MplsDao dao = MplsDao.newInstance();
            Collection dbTunnels = dao.queryByKey(RsvpTeTunnel.class, CommonUtil.genList((Object[])new RsvpTeTunnel[]{tunnel}), false);
            if (!CollectionUtils.isEmpty((Collection)dbTunnels)) {
                RsvpTeTunnel dbTunnel = (RsvpTeTunnel)dbTunnels.iterator().next();
                return !dbTunnel.getMplsTunnelEgressLSRId().equals(tunnel.getMplsTunnelEgressLSRId());
            }
        }
        catch (VMFException e) {
            this.getLogger().error("MplsSyncHandler query RsvpTeTunnel=" + tunnel + " failed!", (Throwable)e);
        }
        return true;
    }

    private void cancelNoModifyRecord(Long dbRecord, Long record, IMOChangeRecord<StaticTunnel> staticTunnelRecord, StaticTunnel staticTunnel, String recordName) {
        if (AsnUtil.intValue((Long)dbRecord) == AsnUtil.intValue((Long)record)) {
            staticTunnelRecord.cancelModify((Object)staticTunnel, recordName);
        }
    }

    private void cancelNoModifyRecord(String dbRecord, String record, IMOChangeRecord<StaticTunnel> staticTunnelRecord, StaticTunnel staticTunnel, String recordName) {
        if (null != dbRecord && null != record && dbRecord.equals(record)) {
            staticTunnelRecord.cancelModify((Object)staticTunnel, recordName);
        }
    }

    private void cancelNoModifyRecord(Integer dbRecord, Integer record, IMOChangeRecord<StaticTunnel> staticTunnelRecord, StaticTunnel staticTunnel, String recordName) {
        if (null != dbRecord && null != record && dbRecord.equals(record)) {
            staticTunnelRecord.cancelModify((Object)staticTunnel, recordName);
        }
    }

    private void cancelNoModifyRecord(Boolean dbRecord, Boolean record, IMOChangeRecord<StaticTunnel> staticTunnelRecord, StaticTunnel staticTunnel, String recordName) {
        if (null != dbRecord && null != record && dbRecord.equals(record)) {
            staticTunnelRecord.cancelModify((Object)staticTunnel, recordName);
        }
    }
}

