/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.service;

import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.framework.capability.CapabilityInfo;
import com.huawei.vmf.adapter.framework.service.DefaultMOConflictChecker;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.SubTnlPolicy;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelPolicy;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.common.exception.VMFException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.util.CollectionUtils;

public class TnlPolicyConflictChecker
extends DefaultMOConflictChecker<TunnelPolicy> {
    public TnlPolicyConflictChecker() {
        super(TunnelPolicy.class);
    }

    public OperResult checkDelete(Collection<TunnelPolicy> tunnelPolicies, Context context) {
        OperResult operResult = super.checkDelete(tunnelPolicies, context);
        this.checkDeployedSelectSeq(operResult, tunnelPolicies);
        this.checkDeployedTnlPolicySub(operResult, tunnelPolicies);
        return operResult;
    }

    public OperResult checkUndeploy(Collection<TunnelPolicy> tunnelPolicies, Context context) {
        OperResult operResult = super.checkUndeploy(tunnelPolicies, context);
        this.checkDeployedSelectSeq(operResult, tunnelPolicies);
        this.checkDeployedTnlPolicySub(operResult, tunnelPolicies);
        return operResult;
    }

    private void checkDeployedSelectSeq(OperResult operResult, Collection<TunnelPolicy> tunnelPolicies) {
        if (CollectionUtils.isEmpty(tunnelPolicies)) {
            return;
        }
        for (TunnelPolicy tunnelPolicy : tunnelPolicies) {
            if (operResult.hasHandled((VmfMO)tunnelPolicy) || !tunnelPolicy.isDeployed() || !ObjectUtils.equals((Object)TunnelPolicy.TNL_POLICY_TYPE_ENUM.TNL_SELECT_SEQ, (Object)tunnelPolicy.getTnlPolicyType())) continue;
            this.getLogger().error("tunnelPolicy {} {} {} {} is deployed and is select-seq,can't delete", new Object[]{tunnelPolicy.getTnlPolicyName(), tunnelPolicy.getDevID(), tunnelPolicy.getVrID(), tunnelPolicy.getTnlPolicyType()});
            operResult.addMoOperResult((VmfMO)tunnelPolicy, 0);
        }
    }

    private void checkDeployedTnlPolicySub(OperResult operResult, Collection<TunnelPolicy> tunnelPolicies) {
        if (CollectionUtils.isEmpty(tunnelPolicies)) {
            return;
        }
        DefaultMOService pollService = new DefaultMOService();
        HashMap<SubTnlPolicy, TunnelPolicy> subTunnelPolicies = new HashMap<SubTnlPolicy, TunnelPolicy>();
        for (TunnelPolicy tunnelPolicy : tunnelPolicies) {
            if (operResult.hasHandled((VmfMO)tunnelPolicy) || !tunnelPolicy.isDeployed()) continue;
            SubTnlPolicy subTnlPolicy = new SubTnlPolicy();
            subTnlPolicy.setDevID(tunnelPolicy.getDevID());
            subTnlPolicy.setVrID(tunnelPolicy.getVrID());
            subTnlPolicy.setTnlPolicyName(tunnelPolicy.getTnlPolicyName());
            try {
                if (!this.isSupportSubTnlPolicy(subTnlPolicy)) {
                    continue;
                }
            }
            catch (com.huawei.vmf.adapter.common.exception.VMFException e) {
                this.getLogger().error("isSupportSubTnlPolicy failed {}", (Object)subTnlPolicy);
                operResult.addMoOperResult((VmfMO)tunnelPolicy, e.getErrorCode());
            }
            subTunnelPolicies.put(subTnlPolicy, tunnelPolicy);
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(tunnelPolicy.getDevID().intValue());
            if (queryContext == null) {
                queryContext = new QuerySchemaTranslatorContext(tunnelPolicy.getDevID().intValue());
                pollService.addQueryJob(queryContext);
            }
            queryContext.addQueryAttributes(FeatureName.TNLM, (VmfMO)subTnlPolicy, Arrays.asList("tnlPolicyExist", "tpSubCount"));
        }
        if (CollectionUtils.isEmpty(subTunnelPolicies)) {
            return;
        }
        try {
            pollService.poll();
        }
        catch (com.huawei.vmf.adapter.common.exception.VMFException e) {
            operResult.addMoOperResults(subTunnelPolicies.values(), e.getErrorCode());
            this.getLogger().error("poll failed", (Throwable)e);
            return;
        }
        for (Map.Entry entry : subTunnelPolicies.entrySet()) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(((SubTnlPolicy)entry.getKey()).getDevID().intValue());
            ErrorInfo errInfo = pollService.getErrorInfo((VmfMO)entry.getKey());
            if (errInfo != null && 0 != errInfo.getErrorCode()) {
                this.getLogger().error("get SubTnlPolicy {} failed {}", entry.getKey(), (Object)errInfo);
                operResult.addMoOperResult((VmfMO)subTunnelPolicies.get(entry.getKey()), errInfo.getErrorCode());
                continue;
            }
            if (!queryContext.getQueryResult(SubTnlPolicy.class).contains(entry.getKey()) || ((SubTnlPolicy)entry.getKey()).getTpSubCount() == null || ((SubTnlPolicy)entry.getKey()).getTpSubCount() <= 0) continue;
            this.getLogger().error("tunnelPolicy {} is used by VPN", entry.getKey());
            operResult.addMoOperResult((VmfMO)entry.getValue(), 603980058);
        }
    }

    private boolean isSupportSubTnlPolicy(SubTnlPolicy subTnlPolicy) throws com.huawei.vmf.adapter.common.exception.VMFException {
        if (!this.isSupportSubTnlPolicyImp(subTnlPolicy)) {
            this.getLogger().error("{} not support SubTnlPolicy", (Object)subTnlPolicy);
            return false;
        }
        return true;
    }

    private boolean isSupportSubTnlPolicyImp(SubTnlPolicy subTnlPolicy) throws com.huawei.vmf.adapter.common.exception.VMFException {
        CapabilityInfo capInfo;
        try {
            capInfo = MplsUtil.getMoCapInfo((VmfMO)subTnlPolicy);
        }
        catch (VMFException e) {
            throw new com.huawei.vmf.adapter.common.exception.VMFException(e.getErrorCode(), e.getMessage());
        }
        if (capInfo == null) {
            return false;
        }
        return !CollectionUtils.isEmpty((Collection)capInfo.getMoAttrCapabilityInfos(SubTnlPolicy.class));
    }
}

