/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.service;

import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.AbstractCompositeService;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.model.DeployableMO;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class StaticTunnelService
extends AbstractCompositeService<StaticTunnel> {
    public StaticTunnelService() {
        super(StaticTunnel.class);
    }

    public void delete(Context context) {
        ArrayList mos = new ArrayList(context.getChangeRecord(this.getMoClass()).getDeletes());
        this.checkDevCapability(mos, context);
        this.checkParams(mos, context);
        this.checkDeleteMoConflict(mos, context);
        List nestingContexts = this.composeDeleteNestingContext(mos, context);
        List operSuccessMos = this.sendConfig(nestingContexts, mos, EOperationType.DELETE, context);
        this.reportMoConfigChanges(operSuccessMos, context);
    }

    public void predeploy(Context context) {
        ArrayList mos = new ArrayList(context.getChangeRecord(this.getMoClass()).getCreates());
        this.checkDevCapability(mos, context);
        this.checkParams(mos, context);
        this.checkPredeployMoConflict(mos, context);
        List nestingContexts = this.composePredeployNestingContext(mos, context);
        List operSuccessMos = this.sendConfig(nestingContexts, mos, EOperationType.PREDEPLOY, context);
        this.reportMoConfigChanges(operSuccessMos, context);
    }

    protected void reportMoConfigChanges(List<StaticTunnel> mos, Context context) {
        if (CollectionUtils.isEmpty(mos)) {
            return;
        }
        Map moRecords = context.getAllChanges();
        Context reportContext = new Context();
        reportContext.setTaskFlag(context.getTaskFlag());
        for (StaticTunnel mo : mos) {
            if (0 != context.getMoErrorCode((VmfMO)mo)) continue;
            IMOChangeRecord allMoChangeRecord = (IMOChangeRecord)moRecords.get(mo.getClass());
            IMOChangeRecord successMoChangeRecord = reportContext.addChangeRecord(mo.getClass());
            if (allMoChangeRecord.isCreated((Object)mo)) {
                if (((DeployableMO)mo).isDeployed()) {
                    successMoChangeRecord.addModify((Object)mo, new PropertyChangeItem("deployStatus"));
                    continue;
                }
                successMoChangeRecord.addCreate((Object)mo);
                continue;
            }
            if (allMoChangeRecord.isDeleted((Object)mo)) {
                if (mo instanceof DeployableMO && context.getProperty(EOperationType.class.getName()).equals(EOperationType.UNDEPLOY)) {
                    successMoChangeRecord.addModify((Object)mo, new PropertyChangeItem("deployStatus"));
                    continue;
                }
                successMoChangeRecord.addDelete((Object)mo);
                continue;
            }
            Collection modifyPropertyItems = allMoChangeRecord.getModifyPropertyItems((Object)mo);
            for (PropertyChangeItem propertyChangeItem : modifyPropertyItems) {
                successMoChangeRecord.addModify((Object)mo, propertyChangeItem);
            }
        }
        MOChangePublisher.getInstance().notifyChanges(reportContext);
    }
}

