/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.service;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.service.DefaultMOConflictChecker;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RsvpTeTunnelConflictChecker
extends DefaultMOConflictChecker<RsvpTeTunnel> {
    private static final String STR_INVALIDATE_VALUE = "--";

    public RsvpTeTunnelConflictChecker() {
        super(RsvpTeTunnel.class);
    }

    public OperResult checkPredeploy(Collection<RsvpTeTunnel> mos, Context context) {
        OperResult operResult = new OperResult();
        if (CollectionUtils.isEmpty(mos)) {
            return operResult;
        }
        ArrayList<RsvpTeTunnel> queryMos = new ArrayList<RsvpTeTunnel>(mos);
        IDao dao = this.getDao(null);
        try {
            this.checkTunnelName(queryMos, dao, operResult);
            if (!queryMos.isEmpty()) {
                this.checkTunnelIndex(queryMos, dao, operResult);
            }
            if (!queryMos.isEmpty()) {
                this.checkUserDefinedName(queryMos, dao, operResult);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("query RsvpTeTunnel exist error. mos=" + mos, (Throwable)e);
            operResult.addMoOperResults(mos, e.getErrorCode());
        }
        return operResult;
    }

    private void checkTunnelIndex(List<RsvpTeTunnel> queryMos, IDao dao, OperResult operResult) throws VMFException {
        Collection tmpExistMos = dao.queryByFields(RsvpTeTunnel.class, new String[]{"devID", "mplsTunnelIndex"}, queryMos, false);
        for (RsvpTeTunnel tmpExistMo : tmpExistMos) {
            Iterator<RsvpTeTunnel> iter = queryMos.iterator();
            while (iter.hasNext()) {
                RsvpTeTunnel mo = iter.next();
                if (!tmpExistMo.getDevID().equals(mo.getDevID()) || !tmpExistMo.getMplsTunnelIndex().equals(mo.getMplsTunnelIndex())) continue;
                operResult.addMoOperResult((VmfMO)mo, 1107501602);
                iter.remove();
            }
        }
    }

    private void checkTunnelName(List<RsvpTeTunnel> queryMos, IDao dao, OperResult operResult) throws VMFException {
        Collection tmpExistMos = dao.queryByFields(RsvpTeTunnel.class, new String[]{"devID", "tunnelName"}, queryMos, false);
        for (RsvpTeTunnel tmpExistMo : tmpExistMos) {
            Iterator<RsvpTeTunnel> iter = queryMos.iterator();
            while (iter.hasNext()) {
                RsvpTeTunnel mo = iter.next();
                if (!tmpExistMo.getDevID().equals(mo.getDevID()) || !tmpExistMo.getTunnelName().equals(mo.getTunnelName())) continue;
                operResult.addMoOperResult((VmfMO)mo, 1107501601);
                iter.remove();
            }
        }
    }

    private void checkUserDefinedName(List<RsvpTeTunnel> queryMos, IDao dao, OperResult operResult) throws VMFException {
        ArrayList<RsvpTeTunnel> tmpQueryMos = new ArrayList<RsvpTeTunnel>();
        for (RsvpTeTunnel queryMo : queryMos) {
            if (!this.isUserDefinedNameValidate(queryMo.getUserDefinedName())) continue;
            tmpQueryMos.add(queryMo);
        }
        if (tmpQueryMos.isEmpty()) {
            return;
        }
        Collection tmpExistMos = dao.queryByFields(RsvpTeTunnel.class, new String[]{"devID", "userDefinedName"}, tmpQueryMos, false);
        for (RsvpTeTunnel tmpExistMo : tmpExistMos) {
            Iterator<RsvpTeTunnel> iter = queryMos.iterator();
            while (iter.hasNext()) {
                RsvpTeTunnel mo = iter.next();
                if (!tmpExistMo.getDevID().equals(mo.getDevID()) || !tmpExistMo.getUserDefinedName().equals(mo.getUserDefinedName())) continue;
                operResult.addMoOperResult((VmfMO)mo, 1107501603);
                iter.remove();
            }
        }
    }

    private boolean isUserDefinedNameValidate(String userDefinedName) {
        return StringUtils.hasText((String)userDefinedName) && !STR_INVALIDATE_VALUE.equals(userDefinedName);
    }
}

