/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.service;

import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.framework.common.EOperResultType;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.service.AbstractCompositeService;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.IMOConflictChecker;
import com.huawei.vmf.adapter.framework.service.MOConflictCheckerMgr;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.ExplicitPath;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.TpNexthop;
import com.huawei.vmf.adapter.fservice.mpls.model.TpTunnel;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class RsvpTETunnelService
extends AbstractCompositeService<RsvpTeTunnel> {
    public RsvpTETunnelService() {
        super(RsvpTeTunnel.class);
    }

    public void delete(Context context) {
        ArrayList mos = new ArrayList(context.getChangeRecord(this.getMoClass()).getDeletes());
        IMOChangeRecord pathRecord = context.getChangeRecord(ExplicitPath.class);
        Set recordPaths = pathRecord.getDeletes();
        HashSet<ExplicitPath> paths = new HashSet<ExplicitPath>(recordPaths);
        recordPaths.clear();
        for (RsvpTeTunnel mo : mos) {
            mo.getKeyRefMos(ExplicitPath.class).clear();
        }
        this.checkDevCapability(mos, context);
        this.checkParams(mos, context);
        this.checkDeleteMoConflict(mos, context);
        List nestingContexts = this.composeDeleteNestingContext(mos, context);
        List operSuccessMos = this.sendConfig(nestingContexts, mos, EOperationType.DELETE, context);
        List devOperSuccessMos = this.getDevOperSuccessMos(operSuccessMos, EOperationType.DELETE, context);
        this.reportMoConfigChanges(devOperSuccessMos, context);
        this.deletePaths(paths);
    }

    public void deploy(Context context) {
        super.deploy(context);
        ArrayList<RsvpTeTunnel> mos = new ArrayList<RsvpTeTunnel>(context.getChangeRecord(this.getMoClass()).getAllChanges());
        if (CollectionUtils.isEmpty(mos)) {
            return;
        }
        try {
            HashMap<VmfMO, ErrorInfo> moResults = new HashMap<VmfMO, ErrorInfo>();
            MplsDevDao.newInstance().syncTunnelStatus(mos, moResults);
            String[] fieldNames = new String[]{"operStatus", "adminStatus"};
            Context ctx = new Context();
            IMOChangeRecord record = ctx.addChangeRecord(RsvpTeTunnel.class);
            for (RsvpTeTunnel mo : mos) {
                ErrorInfo err = MplsUtil.getMOOperResult((VmfMO)mo, moResults);
                if (err.getErrorCode() != 0) {
                    this.getLogger().error("sync revp tunnel status fialed, tunnel = {}, error = {}", (Object)mo, (Object)err);
                    continue;
                }
                record.addModify((Object)mo, Arrays.asList(fieldNames));
            }
            MplsDao.newInstance(ctx).merge(false, new Class[]{RsvpTeTunnel.class});
        }
        catch (VMFException e) {
            this.getLogger().error("RsvpTeTunnelService syncTunnelStatus failed!", (Throwable)e);
        }
    }

    public void undeploy(Context context) {
        super.undeploy(context);
        this.deleteTpTunnel(context);
    }

    protected void checkMoConflict(List<RsvpTeTunnel> mos, EOperationType operType, Context context) {
        List unhandleMos = this.getUnHandleMos(mos, context);
        if (CollectionUtils.isEmpty((Collection)unhandleMos)) {
            return;
        }
        Class moClazz = CommonUtil.getClass((Collection)unhandleMos);
        IMOConflictChecker moConflictChecker = MOConflictCheckerMgr.getMOConflictChecker((Class)moClazz);
        OperResult operResult = null;
        switch (operType) {
            case CREATE: {
                operResult = moConflictChecker.checkCreate((Collection)unhandleMos, context);
                break;
            }
            case DELETE: {
                operResult = moConflictChecker.checkDelete((Collection)unhandleMos, context);
                break;
            }
            case MODIFY: {
                operResult = moConflictChecker.checkModify((Collection)unhandleMos, context);
                break;
            }
            case DEPLOY: {
                operResult = moConflictChecker.checkDeploy((Collection)unhandleMos, context);
                break;
            }
            case PREDEPLOY: {
                operResult = moConflictChecker.checkPredeploy((Collection)unhandleMos, context);
                break;
            }
            case UNDEPLOY: {
                operResult = moConflictChecker.checkUndeploy((Collection)unhandleMos, context);
                break;
            }
            default: {
                this.getLogger().warn("operType is invalidate. operType=" + operType);
            }
        }
        context.getOperResult().addMoOperResults(operResult);
        if (!EOperResultType.SUCCESS.equals((Object)operResult.getOperResult((Collection)unhandleMos)) && !context.isBestEffort()) {
            context.addMoOperResults((Collection)this.getUnHandleMos(unhandleMos, context), 1107499884);
        }
    }

    protected void syncDevMoInfos(List<RsvpTeTunnel> mos, Context context) {
        Context ifmContext = new Context();
        MplsDao dao = MplsDao.newInstance(ifmContext);
        try {
            Collection<Interface> ifms = MplsDevDao.newInstance().queryTunnelInterface(mos);
            Collection dbIfms = dao.queryByKey(Interface.class, ifms, true);
            HashMap<String, Interface> dbIfmMap = new HashMap<String, Interface>();
            for (Interface ifm : dbIfms) {
                String key = CommonUtil.composeTmpKey((Object[])new Object[]{ifm.getDevID(), ifm.getVrID(), ifm.getIfName()});
                dbIfmMap.put(key, ifm);
            }
            IMOChangeRecord ifmRecord = ifmContext.addChangeRecord(Interface.class);
            List propertyNames = CommonUtil.genList((Object[])new String[]{"autopickSapID", "enableFlag", "ifAdminStatus", "ifDescr", "ifIndex", "ifLinkProtocol", "ifMac", "ifMtu", "ifNumber", "ifOperSpeed", "ifOperStatus", "ifParentIfName", "ifPhyType", "ifPosition", "iQIfType", "ifRouterType", "ifStatItvl", "ifStatiEnable", "ifTrunkIfName", "ifV6State", "ipv6Enable", "isL2SwitchPort", "isPhysical", "operBit", "timeInternal", "veGroupId", "veType", "unNumIfName"});
            IMOChangeRecord addressRecord = ifmContext.addChangeRecord(Ipv4Address.class);
            for (Interface ifm : ifms) {
                String key = CommonUtil.composeTmpKey((Object[])new Object[]{ifm.getDevID(), ifm.getVrID(), ifm.getIfName()});
                Interface dbIfm = (Interface)dbIfmMap.get(key);
                if (dbIfm != null) {
                    ifmRecord.addModify((Object)ifm, (Collection)propertyNames);
                    MplsUtil.compareIfmIpAddress(ifm, dbIfm, (IMOChangeRecord<Ipv4Address>)addressRecord);
                    continue;
                }
                ifmRecord.addCreate((Object)ifm);
            }
            dao.merge(true, new Class[]{Interface.class});
        }
        catch (VMFException e) {
            this.getLogger().error("RsvpTETunnelService syncDevMoInfos failed!", (Throwable)e);
        }
    }

    private void checkPaths(Set<ExplicitPath> paths) {
        MplsDao dao = MplsDao.newInstance();
        try {
            Collection dbPaths = dao.queryByKey(ExplicitPath.class, paths, false);
            if (CollectionUtils.isEmpty((Collection)dbPaths)) {
                paths.clear();
                return;
            }
            Iterator<ExplicitPath> iter = paths.iterator();
            while (iter.hasNext()) {
                ExplicitPath path = iter.next();
                if (dbPaths.contains(path)) continue;
                iter.remove();
            }
        }
        catch (VMFException e) {
            this.getLogger().error("Query ExplicitPath failed!", (Throwable)e);
            return;
        }
        try {
            dao.loadExplicitPathTunnels(paths);
        }
        catch (VMFException e) {
            this.getLogger().error("LoadExplicitPathTunnels failed! ", (Throwable)e);
            return;
        }
        for (ExplicitPath explicitPath : paths) {
            List tunnels = explicitPath.getKeyRefMos(RsvpTeTunnel.class);
            if (CollectionUtils.isEmpty((Collection)tunnels)) continue;
            paths.remove(explicitPath);
        }
    }

    private void deletePaths(Set<ExplicitPath> paths) {
        if (CollectionUtils.isEmpty(paths)) {
            return;
        }
        this.checkPaths(paths);
        if (CollectionUtils.isEmpty(paths)) {
            return;
        }
        DefaultCompositeService pathService = new DefaultCompositeService(ExplicitPath.class);
        Context context = new Context();
        IMOChangeRecord pathRecord = context.addChangeRecord(ExplicitPath.class);
        pathRecord.addDelete(paths);
        pathService.delete(context);
        OperResult operResult = context.getOperResult();
        Iterator iter = pathRecord.getDeletes().iterator();
        while (iter.hasNext()) {
            ExplicitPath path = (ExplicitPath)iter.next();
            ErrorInfo info = operResult.getMoOperResult((VmfMO)path);
            if (info == null || info.getErrorCode() == 0) continue;
            iter.remove();
        }
        MOChangePublisher.getInstance().notifyChanges(context);
    }

    private void deleteTpTunnel(Context context) {
        IMOChangeRecord record = context.getChangeRecord(RsvpTeTunnel.class);
        Set tunnels = record.getDeletes();
        if (CollectionUtils.isEmpty((Collection)tunnels)) {
            return;
        }
        Collection tpTunnels = new ArrayList<TpTunnel>();
        for (RsvpTeTunnel tunnel : tunnels) {
            TpTunnel tpTunnel = new TpTunnel();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnel, (VmfMO)tpTunnel);
            tpTunnel.setTunnelName(tunnel.getTunnelName());
            tpTunnels.add(tpTunnel);
        }
        MplsDao dao = MplsDao.newInstance();
        try {
            tpTunnels = dao.queryByFields(TpTunnel.class, new String[]{"devID", "vrID", "tunnelName"}, tpTunnels, false);
            if (CollectionUtils.isEmpty(tpTunnels)) {
                return;
            }
            Context ctx = new Context();
            IMOChangeRecord tpRecord = ctx.addChangeRecord(TpTunnel.class);
            tpRecord.addDelete(tpTunnels);
            MplsDao.newInstance(ctx).merge(TpTunnel.class, false);
            HashSet<TpNexthop> hopSet = new HashSet<TpNexthop>();
            for (TpTunnel tpTunnel : tpTunnels) {
                TpNexthop hop = new TpNexthop();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)tpTunnel, (VmfMO)hop);
                hop.setNexthopIPaddr(tpTunnel.getNexthopIPaddr());
                hop.setTnlPolicyName(tpTunnel.getTnlPolicyName());
                hopSet.add(hop);
            }
            Collection hops = dao.queryByKey(TpNexthop.class, hopSet, true);
            if (CollectionUtils.isEmpty((Collection)hops)) {
                return;
            }
            ctx = new Context();
            IMOChangeRecord hopRecord = ctx.addChangeRecord(TpNexthop.class);
            for (TpNexthop hop : hops) {
                if (!CollectionUtils.isEmpty((Collection)hop.getTpTunnels())) continue;
                hopRecord.addDelete((Object)hop);
            }
            if (hopRecord.hasDelete()) {
                MplsDao.newInstance(ctx).merge(TpNexthop.class, false);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("RsvpTETunnelService deleteTpTunnel failed!", (Throwable)e);
        }
    }
}

