/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.service;

import com.huawei.network.qasn.m_q_common.QAsnStrList;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_dev_character_op.QAsnCharacterArgDesc;
import com.huawei.network.qasn.m_q_dev_character_op.QAsnGetDeviceAdaptLabelReq;
import com.huawei.network.qasn.m_q_dev_character_op.QAsnGetDeviceAdaptLabelRsp;
import com.huawei.network.qasn.m_q_dev_character_op.QAsnGetStaticDevArgDescReq;
import com.huawei.network.qasn.m_q_dev_character_op.QAsnGetStaticDevArgDescRsp;
import com.huawei.network.qasn.m_q_dev_character_op.QAsnStaticDevArgDesc;
import com.huawei.network.qasn.m_q_dev_character_op.QAsnStaticDevArgDescList;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnPwOamAttr;
import com.huawei.network.qasn.m_q_ip_pwe3_model.QAsnPwInfo;
import com.huawei.network.qasn.m_q_ip_pwe3_model.QAsnPwe3Service;
import com.huawei.network.qasn.m_q_ip_vpls_model.QAsnVplsPw;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.mpls.dao.ITunnelGroupDaoExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.MethodSchemaTranslatorContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.MplsRingFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.method.MplsOamPwMethodMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamPw;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.TpNexthop;
import com.huawei.vmf.adapter.fservice.mpls.model.TpTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelPolicy;
import com.huawei.vmf.adapter.fservice.mpls.service.IMplsService;
import com.huawei.vmf.adapter.fservice.pwe3.fdn.VpwsPwFdnParser;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsInstance;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsPw;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsSwitchPw;
import com.huawei.vmf.adapter.fservice.pwe3.service.IPwe3Service;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.fservice.service.IKeyrefInfoService;
import com.huawei.vmf.adapter.fservice.tpoam.service.ITpoamService;
import com.huawei.vmf.adapter.fservice.vpls.model.VplsInstance;
import com.huawei.vmf.adapter.fservice.vpls.model.VplsLdpPw;
import com.huawei.vmf.adapter.mpls.Activator;
import com.huawei.vmf.adapter.mpls.common.MplsAsnUtil;
import com.huawei.vmf.adapter.mpls.common.MplsConstant;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import com.huawei.vmf.adapter.mpls.service.MplsMsgService;
import com.huawei.vmf.adapter.mpls.service.RsvpTETunnelService;
import com.huawei.vmf.adapter.mpls.task.GetTunnelIfAndIDByDevIDTask;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnPwOamAttrTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

public class MplsService
implements IKeyrefInfoService,
IMplsService {
    private Logger logger = RunLogger.getLogger(this.getClass());
    public static final Integer TPOAM_SERVICE_TYPE_PW = 1;

    public void checkMergeTunnelPolicyToDev(TunnelPolicy tunnelPolicy, Object contextObj) throws VMFException {
        if (tunnelPolicy == null || contextObj == null) {
            return;
        }
        Context context = (Context)contextObj;
        DefaultMOService pollService = new DefaultMOService();
        QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(tunnelPolicy.getDevID().intValue());
        queryContext.addQueryAttributes(FeatureName.TNLM, (VmfMO)tunnelPolicy, null);
        pollService.addQueryJob(queryContext);
        pollService.poll();
        QuerySchemaTranslatorContext queryContextRsp = pollService.getQueryContext(tunnelPolicy.getDevID().intValue());
        Collection devTnlms = queryContextRsp.getQueryResult(TunnelPolicy.class);
        if (!CollectionUtils.isEmpty((Collection)devTnlms)) {
            context.getChangeRecord(TunnelPolicy.class).getCreates().remove(tunnelPolicy);
            return;
        }
        if (CollectionUtils.isEmpty((Collection)tunnelPolicy.getTpNexthops())) {
            return;
        }
        IMOChangeRecord tunnelPolicyRecord = context.getChangeRecord(TunnelPolicy.class);
        IMOChangeRecord nexthopRecord = context.getChangeRecord(TpNexthop.class);
        IMOChangeRecord tpTunnelRecord = context.getChangeRecord(TpTunnel.class);
        HashSet<RsvpTeTunnel> tunnelSet = new HashSet<RsvpTeTunnel>();
        for (TpNexthop nexthop : tunnelPolicy.getTpNexthops()) {
            if (CollectionUtils.isEmpty((Collection)nexthop.getTpTunnels())) continue;
            for (TpTunnel tpTunnel : nexthop.getTpTunnels()) {
                RsvpTeTunnel tunnel = new RsvpTeTunnel();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)tpTunnel, (VmfMO)tunnel);
                tunnel.setTunnelName(tpTunnel.getTunnelName());
                if (tunnelPolicyRecord.isDeleted((Object)tunnelPolicy) || nexthopRecord.isDeleted((Object)nexthop) || tpTunnelRecord.isDeleted((Object)tpTunnel)) continue;
                tunnelSet.add(tunnel);
            }
        }
        if (CollectionUtils.isEmpty(tunnelSet)) {
            return;
        }
        this.setTunnelDeployInfo(tunnelSet);
    }

    public void deleteTunnelPolicies(Collection<TunnelPolicy> tunnelPolicies) throws VMFException {
        Context context = new Context();
        IMOChangeRecord record = context.addChangeRecord(TunnelPolicy.class);
        for (TunnelPolicy tunnelPolicy : tunnelPolicies) {
            if (this.isInUsed(tunnelPolicy)) continue;
            record.addDelete((Object)tunnelPolicy);
        }
        if (record.hasDelete()) {
            DefaultCompositeService service = new DefaultCompositeService(TunnelPolicy.class);
            service.delete(context);
        }
    }

    public Collection<Interface> getUsedInterface(Collection<Interface> infs) {
        Collection exists;
        if (CollectionUtils.isEmpty(infs)) {
            return Collections.emptyList();
        }
        ArrayList<RsvpTeTunnel> rsvpTeTunnelIndexs = new ArrayList<RsvpTeTunnel>();
        for (Interface inf : infs) {
            if (null == inf) continue;
            RsvpTeTunnel rsvpTeTunnelIndex = new RsvpTeTunnel();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)inf, (VmfMO)rsvpTeTunnelIndex);
            rsvpTeTunnelIndex.setTunnelName(inf.getIfName());
            rsvpTeTunnelIndexs.add(rsvpTeTunnelIndex);
        }
        MplsDao dao = MplsDao.newInstance();
        try {
            exists = dao.exists(RsvpTeTunnel.class, rsvpTeTunnelIndexs);
        }
        catch (VMFException e) {
            this.getLogger().error("query usedInterface error. rsvpTeTunnels=" + rsvpTeTunnelIndexs);
            return infs;
        }
        if (CollectionUtils.isEmpty((Collection)exists)) {
            return Collections.emptyList();
        }
        List<Interface> existInfIndexs = MplsUtil.translate2Interfaces(exists);
        LinkedHashSet<Interface> existInfs = new LinkedHashSet<Interface>(infs);
        existInfs.retainAll(existInfIndexs);
        return existInfs;
    }

    public boolean isInUsed(TunnelPolicy tunnelPolicy) throws VMFException {
        MplsDao dao = MplsDao.newInstance();
        return this.isUsedByVc(tunnelPolicy, (IDao)dao) || this.isUsedByVsi(tunnelPolicy, (IDao)dao) || this.isUsedByVrf(tunnelPolicy, (IDao)dao) || this.isUsedByVpwsPw(tunnelPolicy, (IDao)dao) || this.isUsedByVpwsSwitchPw(tunnelPolicy, (IDao)dao);
    }

    public void resetTunnelIndexAndNameCache() {
        GetTunnelIfAndIDByDevIDTask.resetCache();
    }

    private Logger getLogger() {
        return this.logger;
    }

    private boolean isUsedByVc(TunnelPolicy tunnelPolicy, IDao dao) throws VMFException {
        VplsLdpPw pw = new VplsLdpPw();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnelPolicy, (VmfMO)pw);
        pw.setTnlPolicyName(tunnelPolicy.getTnlPolicyName());
        String[] fieldNames = new String[]{"devID", "vrID", "tnlPolicyName"};
        Collection pwList = dao.queryByFields(VplsLdpPw.class, fieldNames, Arrays.asList(pw), false);
        return !CollectionUtils.isEmpty((Collection)pwList);
    }

    private boolean isUsedByVpwsPw(TunnelPolicy tunnelPolicy, IDao dao) throws VMFException {
        VpwsPw pw = new VpwsPw();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnelPolicy, (VmfMO)pw);
        pw.setTnlPolicyName(tunnelPolicy.getTnlPolicyName());
        String[] fieldNames = new String[]{"devID", "vrID", "tnlPolicyName"};
        Collection pwList = dao.queryByFields(VpwsPw.class, fieldNames, Arrays.asList(pw), false);
        return !CollectionUtils.isEmpty((Collection)pwList);
    }

    private boolean isUsedByVpwsSwitchPw(TunnelPolicy tunnelPolicy, IDao dao) throws VMFException {
        VpwsSwitchPw pw = new VpwsSwitchPw();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnelPolicy, (VmfMO)pw);
        pw.setTnlPolicyName(tunnelPolicy.getTnlPolicyName());
        String[] fieldNames = new String[]{"devID", "vrID", "tnlPolicyName"};
        Collection pwList = dao.queryByFields(VpwsSwitchPw.class, fieldNames, Arrays.asList(pw), false);
        return !CollectionUtils.isEmpty((Collection)pwList);
    }

    private boolean isUsedByVrf(TunnelPolicy tunnelPolicy, IDao dao) throws VMFException {
        VpnInstAF af = new VpnInstAF();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnelPolicy, (VmfMO)af);
        af.setTnlPolicyName(tunnelPolicy.getTnlPolicyName());
        String[] fieldNames = new String[]{"devID", "vrID", "tnlPolicyName"};
        Collection afList = dao.queryByFields(VpnInstAF.class, fieldNames, Arrays.asList(af), false);
        return !CollectionUtils.isEmpty((Collection)afList);
    }

    private boolean isUsedByVsi(TunnelPolicy tunnelPolicy, IDao dao) throws VMFException {
        VplsInstance vpls = new VplsInstance();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnelPolicy, (VmfMO)vpls);
        vpls.setTnlPolicyName(tunnelPolicy.getTnlPolicyName());
        String[] fieldNames = new String[]{"devID", "vrID", "tnlPolicyName"};
        Collection vplsList = dao.queryByFields(VplsInstance.class, fieldNames, Arrays.asList(vpls), false);
        return !CollectionUtils.isEmpty((Collection)vplsList);
    }

    private void setTunnelDeployInfo(Set<RsvpTeTunnel> tunnelSet) throws VMFException {
        Collection dbTunnels = MplsDao.newInstance().queryByKey(RsvpTeTunnel.class, tunnelSet, false);
        if (dbTunnels == null) {
            return;
        }
        AsnTranslationContext ctx = new AsnTranslationContext();
        ctx.setOperType(EOperationType.DEPLOY);
        ctx.setTransactionContext(new Context());
        ArrayList<RsvpTeTunnel> unDeployTunnels = new ArrayList<RsvpTeTunnel>();
        for (RsvpTeTunnel tunnel : dbTunnels) {
            if (tunnel.isDeployed()) continue;
            unDeployTunnels.add(tunnel);
        }
        MplsUtil.setDeployTunnelCotext(unDeployTunnels, (IAsnTranslationContext)ctx);
        if (ctx.getTransactionContext().getChangeRecord(RsvpTeTunnel.class).hasChanges()) {
            new RsvpTETunnelService().deploy(ctx.getTransactionContext());
        }
    }

    public Map<String, Integer> getTunnelBindMplsOamInfo(Collection<String> tunnelFdns) throws VMFException {
        MplsOamTunnel oamTunnel;
        String key;
        if (CollectionUtils.isEmpty(tunnelFdns)) {
            return Collections.emptyMap();
        }
        ArrayList<RsvpTeTunnel> rsvpTeFdnTunnels = new ArrayList<RsvpTeTunnel>();
        ArrayList<StaticTunnel> staticFdnTunnels = new ArrayList<StaticTunnel>();
        MplsAsnUtil.parseTunnelFdns(tunnelFdns, rsvpTeFdnTunnels, staticFdnTunnels);
        MplsDao dao = MplsDao.newInstance();
        Collection<StaticTunnel> dbStaticTunnels = dao.queryStaticTunnelByFdnKeys(staticFdnTunnels, false);
        Collection dbRsvpTeTunnels = dao.queryByKey(RsvpTeTunnel.class, rsvpTeFdnTunnels, false);
        HashMap<String, StaticTunnel> tunnelMap = new HashMap<String, StaticTunnel>();
        ArrayList<MplsOamTunnel> conditions = new ArrayList<MplsOamTunnel>();
        for (StaticTunnel tunnel : dbStaticTunnels) {
            key = CommonUtil.composeTmpKey((Object[])new Object[]{tunnel.getDevID(), tunnel.getVrID(), tunnel.getTunnelName()});
            tunnelMap.put(key, tunnel);
            oamTunnel = new MplsOamTunnel();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnel, (VmfMO)oamTunnel);
            oamTunnel.setTunnelName(tunnel.getTunnelName());
            conditions.add(oamTunnel);
        }
        for (StaticTunnel tunnel : dbRsvpTeTunnels) {
            key = CommonUtil.composeTmpKey((Object[])new Object[]{tunnel.getDevID(), tunnel.getVrID(), tunnel.getTunnelName()});
            tunnelMap.put(key, tunnel);
            oamTunnel = new MplsOamTunnel();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnel, (VmfMO)oamTunnel);
            oamTunnel.setTunnelName(tunnel.getTunnelName());
            conditions.add(oamTunnel);
        }
        Collection dbOamTunnels = dao.queryByKey(MplsOamTunnel.class, conditions, false);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (MplsOamTunnel dbOamTunnel : dbOamTunnels) {
            String key2 = CommonUtil.composeTmpKey((Object[])new Object[]{dbOamTunnel.getDevID(), dbOamTunnel.getVrID(), dbOamTunnel.getTunnelName()});
            String fdn = MplsUtil.getTunnelFdn((VmfMO)tunnelMap.get(key2));
            result.put(fdn, MplsConstant.OAM_ENUM_MPLS_OAM);
        }
        return result;
    }

    public Map<Integer, Integer> getDevSupportMplsOamInfo(Collection<Integer> neIds) {
        ArrayList devIds = (ArrayList)neIds;
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        int reCode = 0;
        for (int i = 0; i < devIds.size(); ++i) {
            int iDevID = (Integer)devIds.get(i);
            QAsnGetDeviceAdaptLabelReq getAdaptLabelReq = new QAsnGetDeviceAdaptLabelReq();
            getAdaptLabelReq.lstNeID.add(devIds.get(i));
            QAsnGetDeviceAdaptLabelRsp getAdaptLabelRsp = new QAsnGetDeviceAdaptLabelRsp();
            reCode = MplsMsgService.getInstance().sendMessage(11535704, iDevID, (FStruct)getAdaptLabelReq, (FStruct)getAdaptLabelRsp);
            if (0 != reCode) {
                this.getLogger().info("checkDevSupportTpOam() getAdaptLabel semdMessage() error, ErrorCode = " + reCode);
                result.put(iDevID, reCode);
                continue;
            }
            QAsnGetStaticDevArgDescReq getReq = new QAsnGetStaticDevArgDescReq();
            getReq.devAdaptLabelList = getAdaptLabelRsp.devAdaptLabelList;
            getReq.characterList = new QAsnStrList();
            getReq.characterList.add((Object)"OAM".getBytes());
            QAsnGetStaticDevArgDescRsp getRsp = new QAsnGetStaticDevArgDescRsp();
            reCode = MplsMsgService.getInstance().sendMessage(0xB0055B, iDevID, (FStruct)getReq, (FStruct)getRsp);
            if (0 != reCode) {
                this.getLogger().info("checkDevSupportTpOam() QGetStaticDevArgDescTask semdMessage() error, ErrorCode = " + reCode);
                result.put(iDevID, reCode);
                continue;
            }
            QAsnStaticDevArgDescList descList = getRsp.staticArgDescList;
            block1: for (Object arg : descList) {
                QAsnStaticDevArgDesc argDesc = (QAsnStaticDevArgDesc)arg;
                for (Object object : argDesc.charArgDescList) {
                    QAsnCharacterArgDesc describe = (QAsnCharacterArgDesc)object;
                    String name = new String(describe.characterName);
                    if (!"OAM.Tnl".equals(name)) continue;
                    result.put(iDevID, reCode);
                    continue block1;
                }
            }
        }
        return result;
    }

    public Map<String, Collection<? extends VmfMO>> getIfmTunnelInfo(Collection<String> ifmFdns) throws VMFException {
        if (CollectionUtils.isEmpty(ifmFdns)) {
            return Collections.emptyMap();
        }
        InterfaceFdnParser ifmFdnParser = new InterfaceFdnParser();
        ArrayList<StaticTunnel> inIfmTunnelCondition = new ArrayList<StaticTunnel>();
        ArrayList<StaticTunnel> outIfmTunnelCondition = new ArrayList<StaticTunnel>();
        for (String ifmFdn : ifmFdns) {
            Interface ifm = (Interface)ifmFdnParser.getIndexMo(ifmFdn);
            if (StringUtil.isEmpty((String)ifm.getIfName())) continue;
            StaticTunnel inIfmTunnel = new StaticTunnel();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)ifm, (VmfMO)inIfmTunnel);
            inIfmTunnel.setIncomingIfName(ifm.getIfName());
            inIfmTunnelCondition.add(inIfmTunnel);
            StaticTunnel outIfmTunnel = new StaticTunnel();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)ifm, (VmfMO)outIfmTunnel);
            outIfmTunnel.setOutgoingIfName(ifm.getIfName());
            outIfmTunnelCondition.add(outIfmTunnel);
        }
        ArrayList tunnels = new ArrayList();
        MplsDao dao = MplsDao.newInstance();
        String[] inIfmFieldNames = new String[]{"devID", "vrID", "incomingIfName"};
        Collection inIfmTunnels = dao.queryByFields(StaticTunnel.class, inIfmFieldNames, inIfmTunnelCondition, false);
        tunnels.addAll(inIfmTunnels);
        String[] outIfmFieldNames = new String[]{"devID", "vrID", "outgoingIfName"};
        Collection outIfmTunnels = dao.queryByFields(StaticTunnel.class, outIfmFieldNames, outIfmTunnelCondition, false);
        tunnels.addAll(outIfmTunnels);
        HashMap<String, Collection<? extends VmfMO>> resultMap = new HashMap<String, Collection<? extends VmfMO>>();
        for (StaticTunnel tunnel : tunnels) {
            String[] ifmNames;
            for (String ifmName : ifmNames = new String[]{tunnel.getIncomingIfName(), tunnel.getOutgoingIfName()}) {
                if (StringUtil.isEmpty((String)ifmName)) continue;
                Interface ifm = new Interface();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnel, (VmfMO)ifm);
                ifm.setIfName(ifmName);
                String ifmFdn = ifmFdnParser.getFdn((VmfMO)ifm);
                HashSet<StaticTunnel> resultTtunnels = (HashSet<StaticTunnel>)resultMap.get(ifmFdn);
                if (resultTtunnels == null) {
                    resultTtunnels = new HashSet<StaticTunnel>();
                    resultMap.put(ifmFdn, resultTtunnels);
                }
                resultTtunnels.add(tunnel);
            }
        }
        return resultMap;
    }

    public Map<String, Collection<MplsRing>> getIfmMplsRingInfo(Collection<String> ifmFdns) throws VMFException {
        if (CollectionUtils.isEmpty(ifmFdns)) {
            return Collections.emptyMap();
        }
        InterfaceFdnParser ifmFdnParser = new InterfaceFdnParser();
        ArrayList<MplsRing> eastIfmRingCondition = new ArrayList<MplsRing>();
        ArrayList<MplsRing> westIfmRingCondition = new ArrayList<MplsRing>();
        for (String ifmFdn : ifmFdns) {
            Interface ifm = (Interface)ifmFdnParser.getIndexMo(ifmFdn);
            if (StringUtil.isEmpty((String)ifm.getIfName())) continue;
            MplsRing eastIfmRing = new MplsRing();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)ifm, (VmfMO)eastIfmRing);
            eastIfmRing.setEastOutIf(ifm.getIfName());
            eastIfmRingCondition.add(eastIfmRing);
            MplsRing westIfmRing = new MplsRing();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)ifm, (VmfMO)westIfmRing);
            westIfmRing.setWestOutIf(ifm.getIfName());
            westIfmRingCondition.add(westIfmRing);
        }
        ArrayList mplsRings = new ArrayList();
        MplsDao dao = MplsDao.newInstance();
        String[] eastIfmFieldNames = new String[]{"devID", "vrID", "eastOutIf"};
        Collection inIfmRings = dao.queryByFields(MplsRing.class, eastIfmFieldNames, eastIfmRingCondition, false);
        mplsRings.addAll(inIfmRings);
        String[] westIfmFieldNames = new String[]{"devID", "vrID", "westOutIf"};
        Collection outIfmRings = dao.queryByFields(MplsRing.class, westIfmFieldNames, westIfmRingCondition, false);
        mplsRings.addAll(outIfmRings);
        HashMap<String, Collection<MplsRing>> resultMap = new HashMap<String, Collection<MplsRing>>();
        for (MplsRing mplsRing : mplsRings) {
            String[] ifmNames;
            for (String ifmName : ifmNames = new String[]{mplsRing.getEastOutIf(), mplsRing.getWestOutIf()}) {
                if (StringUtil.isEmpty((String)ifmName)) continue;
                Interface ifm = new Interface();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)mplsRing, (VmfMO)ifm);
                ifm.setIfName(ifmName);
                String ifmFdn = ifmFdnParser.getFdn((VmfMO)ifm);
                HashSet<MplsRing> mplsRingFdns = (HashSet<MplsRing>)resultMap.get(ifmFdn);
                if (mplsRingFdns == null) {
                    mplsRingFdns = new HashSet<MplsRing>();
                    resultMap.put(ifmFdn, mplsRingFdns);
                }
                mplsRingFdns.add(mplsRing);
            }
        }
        return resultMap;
    }

    public Map<String, Collection<? extends VmfMO>> getTunnelTpInfo(Collection<String> tunnelFdns) throws VMFException {
        if (CollectionUtils.isEmpty(tunnelFdns)) {
            return Collections.emptyMap();
        }
        ITunnelGroupDaoExtPoint ext = (ITunnelGroupDaoExtPoint)ExtendPointServiceMgr.getInstance().getExtendPoitService(ITunnelGroupDaoExtPoint.class);
        if (ext != null) {
            return ext.getTunnelTpInfo(tunnelFdns);
        }
        return Collections.emptyMap();
    }

    public Map<String, Collection<? extends VmfMO>> getMplsRingTunnelInfo(Collection<String> mplsRingFdns) throws VMFException {
        if (CollectionUtils.isEmpty(mplsRingFdns)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> ringFdnMap = new HashMap<String, String>();
        MplsRingFdnParser mplsRingFdnParser = new MplsRingFdnParser();
        ArrayList<StaticTunnel> enterConditions = new ArrayList<StaticTunnel>();
        ArrayList<StaticTunnel> quitConditions = new ArrayList<StaticTunnel>();
        for (String fdn : mplsRingFdns) {
            MplsRing mplsRing = mplsRingFdnParser.getIndexMo(fdn);
            StaticTunnel enterTunnel = new StaticTunnel();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)mplsRing, (VmfMO)enterTunnel);
            enterTunnel.setEnterRingId(mplsRing.getRingId());
            enterConditions.add(enterTunnel);
            StaticTunnel quitTunnel = new StaticTunnel();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)mplsRing, (VmfMO)quitTunnel);
            quitTunnel.setQuitRingId(mplsRing.getRingId());
            quitConditions.add(quitTunnel);
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{mplsRing.getDevID(), mplsRing.getVrID(), mplsRing.getRingId()});
            ringFdnMap.put(key, fdn);
        }
        MplsDao dao = MplsDao.newInstance();
        ArrayList tunnels = new ArrayList();
        String[] enterFieldNames = new String[]{"devID", "vrID", "enterRingId"};
        Collection enterTunnels = dao.queryByFields(StaticTunnel.class, enterFieldNames, enterConditions, false);
        tunnels.addAll(enterTunnels);
        String[] quitFieldNames = new String[]{"devID", "vrID", "quitRingId"};
        Collection quitTunnels = dao.queryByFields(StaticTunnel.class, quitFieldNames, quitConditions, false);
        tunnels.addAll(quitTunnels);
        HashMap<String, Collection<? extends VmfMO>> resultMap = new HashMap<String, Collection<? extends VmfMO>>();
        for (StaticTunnel tunnel : tunnels) {
            Integer[] ringIds;
            for (Integer ringId : ringIds = new Integer[]{tunnel.getEnterRingId(), tunnel.getQuitRingId()}) {
                if (ringId == null) continue;
                String key = CommonUtil.composeTmpKey((Object[])new Object[]{tunnel.getDevID(), tunnel.getVrID(), ringId});
                String ringFdn = (String)ringFdnMap.get(key);
                ArrayList<StaticTunnel> resultTunnels = (ArrayList<StaticTunnel>)resultMap.get(ringFdn);
                if (resultTunnels == null) {
                    resultTunnels = new ArrayList<StaticTunnel>();
                    resultMap.put(ringFdn, resultTunnels);
                }
                resultTunnels.add(tunnel);
            }
        }
        return resultMap;
    }

    public Collection<StaticTunnel> queryStaticTunnelByFdn(Collection<String> fdns, boolean cascade) throws VMFException {
        return MplsDao.newInstance().queryStaticTunnelByFdn(fdns, cascade);
    }

    public void loadStaticTunnelFdnByTnlName(Collection<StaticTunnel> tunnels) throws VMFException {
        if (CollectionUtils.isEmpty(tunnels)) {
            return;
        }
        ArrayList<StaticTunnel> conditions = new ArrayList<StaticTunnel>();
        HashMap<String, StaticTunnel> tunnelMap = new HashMap<String, StaticTunnel>();
        for (StaticTunnel tunnel : tunnels) {
            if (tunnel.getDevID() == null || tunnel.getVrID() == null || StringUtil.isEmpty((String)tunnel.getTunnelName())) continue;
            conditions.add(tunnel);
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{tunnel.getDevID(), tunnel.getVrID(), tunnel.getTunnelName()});
            tunnelMap.put(key, tunnel);
        }
        String[] fieldNames = new String[]{"devID", "vrID", "tunnelName"};
        Collection dbTunnels = MplsDao.newInstance().queryByFields(StaticTunnel.class, fieldNames, conditions, false);
        IFdnParser<StaticTunnel> fdnParser = MplsUtil.getStaticTunnelFdnParser();
        for (StaticTunnel dbTunnel : dbTunnels) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{dbTunnel.getDevID(), dbTunnel.getVrID(), dbTunnel.getTunnelName()});
            StaticTunnel srcTunnel = (StaticTunnel)tunnelMap.get(key);
            srcTunnel.setFdn(fdnParser.getFdn((VmfMO)dbTunnel));
        }
    }

    public Collection<MplsOamPw> queryMplsOamPwDetailInfo(Collection<MplsOamPw> oamPws) throws VMFException {
        if (CollectionUtils.isEmpty(oamPws)) {
            return null;
        }
        ArrayList<MplsOamPw> conditions = new ArrayList<MplsOamPw>();
        for (MplsOamPw oamPw : oamPws) {
            conditions.add(oamPw);
        }
        String[] fieldNames = new String[]{"devID", "vrID", "peerIp", "vcId", "vcType"};
        Collection pws = MplsDao.newInstance().queryByFields(MplsOamPw.class, fieldNames, conditions, false);
        Collection<MplsOamPw> pwOams = MplsDevDao.newInstance().syncPwOamStatus(pws);
        if (null == pwOams) {
            return new ArrayList<MplsOamPw>();
        }
        block1: for (MplsOamPw oamPw : oamPws) {
            for (MplsOamPw pw : pwOams) {
                if (!pw.equals((Object)oamPw)) continue;
                pw.setFdn(oamPw.getFdn());
                continue block1;
            }
        }
        return pwOams;
    }

    public Map<MplsOamPw, Integer> getPWBindMplsOamInfo(Collection<MplsOamPw> oamPws) throws VMFException {
        HashMap<MplsOamPw, Integer> result = new HashMap<MplsOamPw, Integer>();
        Collection<MplsOamPw> pws = this.queryMplsOamPwDetailInfo(oamPws);
        for (MplsOamPw pw : pws) {
            result.put(pw, MplsConstant.OAM_ENUM_MPLS_OAM);
        }
        return result;
    }

    public void syncPwOam(Collection<VpwsPw> pws) throws VMFException {
        if (CollectionUtils.isEmpty(pws)) {
            return;
        }
        ArrayList<MplsOamPw> pwOamLst = new ArrayList<MplsOamPw>();
        for (VpwsPw pw : pws) {
            MplsOamPw pwOam = new MplsOamPw();
            pwOam.setDevID(pw.getDevID());
            pwOam.setVrID(pw.getVrID());
            pwOam.setVcId(pw.getPwId());
            pwOam.setPeerIp(pw.getPeerIp());
            pwOam.setVcType(pw.getPwType());
            pwOamLst.add(pwOam);
        }
        if (!CollectionUtils.isEmpty(pwOamLst)) {
            Collection oamTunnelFromDB = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(MplsOamPw.class, pwOamLst, true);
            for (MplsOamPw oamPw : pwOamLst) {
                if (oamTunnelFromDB.contains(oamPw)) continue;
                MplsDevDao.newInstance().syncPwOam(pwOamLst);
            }
        }
    }

    public Map<String, Collection<Integer>> queryDevIDByLsrID(Collection<String> lsrIds) throws VMFException {
        return MplsDao.newInstance().queryDevIDByLsrID(lsrIds);
    }

    public void switchOamToTpOam(QAsnUniResID pwResKey) throws VMFException {
        VpwsPwFdnParser pwfdnParser = new VpwsPwFdnParser();
        VpwsPw pw = (VpwsPw)pwfdnParser.getIndexMo(pwResKey);
        VpwsPw vpwspw = new VpwsPw();
        IPwe3Service pwe3Service = Activator.getService(IPwe3Service.class);
        try {
            Collection vpwsInst = pwe3Service.getVpwsInstances(pw.getFdn());
            if (CollectionUtils.isEmpty((Collection)vpwsInst)) {
                this.getLogger().error("pwe3Service.getVpwsInstances: no pwe3 instance record!");
                return;
            }
            Collection pwLst = ((VpwsInstance)vpwsInst.iterator().next()).getVpwsPws();
            if (CollectionUtils.isEmpty((Collection)pwLst)) {
                this.getLogger().error("pwe3Service.getVpwsInstances: no vpwspw record!");
                return;
            }
            for (VpwsPw pwIndex : pwLst) {
                if (!pwIndex.getDevID().equals(pw.getDevID()) || !pwIndex.getPwId().equals(pw.getPwId()) || !pwIndex.getPwType().equals(pw.getPwType())) continue;
                vpwspw = pwIndex;
                break;
            }
        }
        catch (VMFException e) {
            this.getLogger().error("Activator.getService failed!", (Throwable)e);
        }
        MplsOamPwMethodMO pwMo = new MplsOamPwMethodMO();
        pwMo.setDevID(pw.getDevID());
        pwMo.setFdn(pw.getFdn());
        pwMo.setMethodName("switchSinglePw");
        pwMo.setPeerIp(vpwspw.getPeerIp());
        pwMo.setVcId(Integer.valueOf(Integer.parseInt(String.valueOf(vpwspw.getPwId()))));
        pwMo.setVrID(vpwspw.getVrID());
        pwMo.setVcType(vpwspw.getPwType());
        DefaultMOService moService = new DefaultMOService();
        MethodSchemaTranslatorContext methodContext = new MethodSchemaTranslatorContext(pw.getDevID().intValue());
        methodContext.addMethod(FeatureName.MPLSOAM, (VmfMO)pwMo);
        moService.addMethodJob(methodContext);
        moService.sendMethod();
        ErrorInfo errorInfo = moService.getErrorInfo((VmfMO)pwMo);
        if (null == errorInfo || 0 == errorInfo.getErrorCode()) {
            this.deletePwOam(pwMo);
        }
    }

    private void deletePwOam(MplsOamPwMethodMO pw) {
        MplsOamPw pwMo = new MplsOamPw();
        pwMo.setDevID(pw.getDevID());
        pwMo.setFdn(pw.getFdn());
        pwMo.setPeerIp(pw.getPeerIp());
        pwMo.setVcId(Long.valueOf(pw.getVcId().intValue()));
        pwMo.setVrID(pw.getVrID());
        pwMo.setVcType(pw.getVcType());
        ArrayList<MplsOamPw> pwMos = new ArrayList<MplsOamPw>();
        pwMos.add(pwMo);
        try {
            Collection dbPwMos = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(MplsOamPw.class, pwMos, false);
            if (!CollectionUtils.isEmpty((Collection)dbPwMos)) {
                Context ctx = new Context();
                IMOChangeRecord record = ctx.addChangeRecord(MplsOamPw.class);
                record.addDelete(dbPwMos);
                MplsDao.newInstance(ctx).merge(MplsOamPw.class, false);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("MplsService.switchOamToTpOam after switch to 1731 then delete pwOam failed!", (Throwable)e);
        }
    }

    public Map<Integer, String> queryLsrIDByDevID(Collection<Integer> devIds) {
        if (CollectionUtils.isEmpty(devIds)) {
            return null;
        }
        HashMap<Integer, String> devAndLsrIDMap = new HashMap<Integer, String>();
        for (Integer devId : devIds) {
            try {
                String lsrId = MplsDao.newInstance().queryLsrIDByDevID(devId);
                devAndLsrIDMap.put(devId, lsrId);
            }
            catch (VMFException e) {
                this.getLogger().error("queryLsrIDByDevID failed!", (Throwable)e);
            }
        }
        return devAndLsrIDMap;
    }

    public void decodePwe3PwOam(QAsnPwOamAttr asnPwOam, VpwsInstance vpn, VpwsPw pw, Object context) {
        this.logger.info("Enter MplsService.decodePwe3PwOam ");
        if (null == vpn || null == context) {
            this.logger.error("MplsService.decodePwe3PwOam asnPwOam/vpnPw/context is null");
            return;
        }
        IAsnTranslationContext asnContext = (IAsnTranslationContext)context;
        if (EOperationType.PREDEPLOY.equals((Object)asnContext.getOperType())) {
            this.logger.info("Enter MplsService.decodeCreatePwOam vpn = " + vpn.getInstanceName());
            this.decodeCreatePwOam(asnPwOam, vpn, pw, asnContext);
        }
        if (EOperationType.DEPLOY.equals((Object)asnContext.getOperType())) {
            this.logger.info("Enter MplsService.decodeDeployPwOam vpn = " + vpn.getFdn());
            this.decodeDeployPwOam(vpn, asnContext);
        }
        if (EOperationType.UNDEPLOY.equals((Object)asnContext.getOperType())) {
            this.logger.info("Enter MplsService.decodeUnDeployPwOam vpn = " + vpn.getFdn());
            this.decodeUnDeployPwOam(vpn, asnContext.getTransactionContext());
        }
        if (EOperationType.DELETE.equals((Object)asnContext.getOperType())) {
            this.logger.info("Enter MplsService.decodeDeletePwOam vpn = " + vpn.getFdn());
            this.decodeDeletePwOam(vpn, asnContext.getTransactionContext());
        }
    }

    private void decodeCreatePwOam(QAsnPwOamAttr asnPwOam, VpwsInstance vpn, VpwsPw pw, IAsnTranslationContext context) {
        if (null == asnPwOam) {
            this.logger.error("MplsService.decodeCreatePwOam asnPwOam is null");
            return;
        }
        MplsOamPw pwOam = new MplsOamPw();
        QAsnPwOamAttrTranslator translator = new QAsnPwOamAttrTranslator(pw.getFdn());
        try {
            translator.decode(asnPwOam, pwOam, context);
        }
        catch (VMFException e) {
            this.logger.error("MplsService.decodeCreatePwOam decode error");
        }
        pwOam.setDeployStatus(Integer.valueOf(0));
        vpn.addKeyRefMo((VmfMO)pwOam);
    }

    private void decodeDeployPwOam(VpwsInstance vpn, IAsnTranslationContext context) {
        if (CollectionUtils.isEmpty((Collection)vpn.getVpwsPws())) {
            this.logger.info("addPwOamDeployRecord vpwsInstance.getVpwsPws() is empty:" + vpn.getInstanceName());
            return;
        }
        HashMap<MplsOamPw, VpwsPw> mplsOam2PwMap = new HashMap<MplsOamPw, VpwsPw>();
        try {
            ArrayList<MplsOamPw> conditions = new ArrayList<MplsOamPw>();
            for (VpwsPw vpwsPw : vpn.getVpwsPws()) {
                MplsOamPw pwOam = new MplsOamPw();
                pwOam.setDevID(vpwsPw.getDevID());
                pwOam.setVrID(vpwsPw.getVrID());
                pwOam.setVcId(vpwsPw.getPwId());
                pwOam.setVcType(vpwsPw.getPwType());
                pwOam.setPeerIp(vpwsPw.getPeerIp());
                conditions.add(pwOam);
                mplsOam2PwMap.put(pwOam, vpwsPw);
            }
            Map<MplsOamPw, Integer> mplsOamPwMap = this.getPWBindMplsOamInfo(conditions);
            for (Map.Entry<MplsOamPw, Integer> entry : mplsOamPwMap.entrySet()) {
                if (MplsConstant.OAM_ENUM_MPLS_OAM != entry.getValue()) continue;
                vpn.addKeyRefMo((VmfMO)entry.getKey());
            }
            this.addPwOamModifyRecord(context.getTransactionContext(), vpn.getKeyRefMos(MplsOamPw.class));
        }
        catch (VMFException e) {
            this.logger.error("DeployPwe3ServiceTask addPwOamKeyRefRecord failed.", (Throwable)e);
        }
    }

    private void addPwOamModifyRecord(Context context, List<MplsOamPw> tpKeyRefMos) throws VMFException {
        if (CollectionUtils.isEmpty(tpKeyRefMos)) {
            return;
        }
        IMOChangeRecord tpMoChangeRecord = context.addDBChangeRecord(MplsOamPw.class);
        PropertyChangeItem deployStatusItem = new PropertyChangeItem("deployStatus");
        for (MplsOamPw pwOam : tpKeyRefMos) {
            if (pwOam.isDeployed()) continue;
            pwOam.setDeployStatus(Integer.valueOf(1));
            tpMoChangeRecord.addModify((Object)pwOam, deployStatusItem);
            context.addChangeRecord(MplsOamPw.class).addModify((Object)pwOam, Arrays.asList("peerIp", "vcId", "vcType", "remoteLsrId", "remoteVcId", "remoteVcType", "detectPktType", "detectMode", "detectFrequence", "oamActiveState", "oamLossSd", "oamLossSf", "localDetectStatus", "localInvalidTime", "localDefectLocation", "localDefectType"));
        }
    }

    private void decodeUnDeployPwOam(VpwsInstance vpwsInstance, Context ctx) {
        if (CollectionUtils.isEmpty((Collection)vpwsInstance.getVpwsPws())) {
            this.logger.info("MplsService decodeUnDeployPwOam vpwsPws is empty.");
            return;
        }
        ArrayList<VpwsPw> tpOamPwList = new ArrayList<VpwsPw>();
        try {
            ArrayList<MplsOamPw> conditions = new ArrayList<MplsOamPw>();
            for (VpwsPw vpwsPw : vpwsInstance.getVpwsPws()) {
                MplsOamPw pwOam = new MplsOamPw();
                pwOam.setDevID(vpwsPw.getDevID());
                pwOam.setVrID(vpwsPw.getVrID());
                pwOam.setVcId(vpwsPw.getPwId());
                pwOam.setVcType(vpwsPw.getPwType());
                pwOam.setPeerIp(vpwsPw.getPeerIp());
                conditions.add(pwOam);
                ITpoamService tpOamService = Activator.getService(ITpoamService.class);
                if (null == tpOamService.queryPOAM(new VpwsPwFdnParser().getUniResID((VmfMO)vpwsPw))) continue;
                tpOamPwList.add(vpwsPw);
            }
            Collection oamPwFromDB = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(MplsOamPw.class, conditions, true);
            if (!CollectionUtils.isEmpty((Collection)oamPwFromDB)) {
                vpwsInstance.addKeyRefMos(oamPwFromDB);
                this.addUndeployPwOamModifyRecord(ctx, vpwsInstance.getKeyRefMos(MplsOamPw.class));
            }
            if (!CollectionUtils.isEmpty(tpOamPwList)) {
                this.undeployTPOAM(tpOamPwList);
            }
        }
        catch (VMFException e) {
            this.logger.error("setPwOamChanges failed.", (Throwable)e);
        }
    }

    private void addUndeployPwOamModifyRecord(Context context, List<MplsOamPw> tpKeyRefMos) throws VMFException {
        if (CollectionUtils.isEmpty(tpKeyRefMos)) {
            return;
        }
        IMOChangeRecord tpMoChangeRecord = context.addDBChangeRecord(MplsOamPw.class);
        for (MplsOamPw pwOam : tpKeyRefMos) {
            pwOam.setDeployStatus(Integer.valueOf(0));
            tpMoChangeRecord.addModify((Object)pwOam, new PropertyChangeItem("deployStatus", (Object)0, (Object)1));
        }
    }

    private void undeployTPOAM(Collection<VpwsPw> vpwsPws) throws VMFException {
        ITpoamService tpOamService = Activator.getService(ITpoamService.class);
        if (null == tpOamService) {
            this.logger.error("get TP OAM Service is null.");
            return;
        }
        for (VpwsPw vpwsPw : vpwsPws) {
            QAsnUniResID uniResId = new VpwsPwFdnParser().getUniResID((VmfMO)vpwsPw);
            uniResId.poSerialNum = StringUtil.globalByte((String)vpwsPw.getPeerIp());
            tpOamService.undeployTPOAM(TPOAM_SERVICE_TYPE_PW.intValue(), uniResId);
        }
    }

    private void decodeDeletePwOam(VpwsInstance vpwsInstance, Context ctx) {
        if (CollectionUtils.isEmpty((Collection)vpwsInstance.getVpwsPws())) {
            this.logger.info("vpwsInstance.getVpwsPws() is empty: " + vpwsInstance.getInstanceName());
            return;
        }
        ArrayList<VpwsPw> tpOamPwList = new ArrayList<VpwsPw>();
        try {
            ArrayList<MplsOamPw> conditions = new ArrayList<MplsOamPw>();
            for (VpwsPw vpwsPw : vpwsInstance.getVpwsPws()) {
                MplsOamPw pwOam = new MplsOamPw();
                pwOam.setDevID(vpwsPw.getDevID());
                pwOam.setVrID(vpwsPw.getVrID());
                pwOam.setVcId(vpwsPw.getPwId());
                pwOam.setVcType(vpwsPw.getPwType());
                pwOam.setPeerIp(vpwsPw.getPeerIp());
                conditions.add(pwOam);
                ITpoamService tpOamService = Activator.getService(ITpoamService.class);
                if (null == tpOamService.queryPOAM(new VpwsPwFdnParser().getUniResID((VmfMO)vpwsPw))) continue;
                tpOamPwList.add(vpwsPw);
            }
            Collection oamPwFromDB = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(MplsOamPw.class, conditions, true);
            if (!CollectionUtils.isEmpty((Collection)oamPwFromDB)) {
                vpwsInstance.addKeyRefMos(oamPwFromDB);
                this.deletePwOamRecord(ctx, vpwsInstance.getKeyRefMos(MplsOamPw.class));
            }
            if (!CollectionUtils.isEmpty(tpOamPwList)) {
                this.deleteTPOAM(tpOamPwList);
            }
        }
        catch (VMFException e) {
            this.logger.error("setPwOamChanges failed.", (Throwable)e);
        }
    }

    private void deletePwOamRecord(Context context, List<MplsOamPw> tpKeyRefMos) throws VMFException {
        if (CollectionUtils.isEmpty(tpKeyRefMos)) {
            return;
        }
        IMOChangeRecord tpMoChangeRecord = context.addDBChangeRecord(MplsOamPw.class);
        for (MplsOamPw oamPw : tpKeyRefMos) {
            tpMoChangeRecord.addDelete((Object)oamPw);
        }
    }

    private void deleteTPOAM(Collection<VpwsPw> vpwsPws) throws VMFException {
        ITpoamService tpOamService = Activator.getService(ITpoamService.class);
        if (null == tpOamService) {
            this.logger.error("get TP OAM Service is null.");
            return;
        }
        for (VpwsPw vpwsPw : vpwsPws) {
            QAsnUniResID uniResId = new VpwsPwFdnParser().getUniResID((VmfMO)vpwsPw);
            uniResId.poSerialNum = StringUtil.globalByte((String)vpwsPw.getPeerIp());
            tpOamService.deleteTPOAM(TPOAM_SERVICE_TYPE_PW.intValue(), uniResId);
        }
    }

    public void encodePwe3PwOam(VpwsInstance vpn, QAsnPwe3Service pwe3Asn, Object objContext) {
        if (null == vpn || null == pwe3Asn || null == objContext) {
            this.logger.error("MplsService.encodePwe3PwOam vpn/pwe3Asn/objContext is null ");
            return;
        }
        block0: for (int i = 0; i < pwe3Asn.pwList.size(); ++i) {
            QAsnPwInfo asnPw = (QAsnPwInfo)pwe3Asn.pwList.get(i);
            for (VpwsPw pw : vpn.getVpwsPws()) {
                String fdn = AsnUtil.strValue((byte[])asnPw.pwKey.strFDN);
                if (!fdn.equals(pw.getFdn())) continue;
                if (null == asnPw.poPwOam) {
                    asnPw.pwOamAttr = new QAsnPwOamAttr();
                    AsnUtil.setDefaultAsnValue((FStruct)asnPw.pwOamAttr);
                }
                this.encodePwe3PwOam(pw, asnPw.pwOamAttr, objContext);
                continue block0;
            }
        }
    }

    private void encodePwe3PwOam(VpwsPw vpnPw, QAsnPwOamAttr asn, Object context) {
        List pwOams = vpnPw.getKeyRefMos(MplsOamPw.class);
        QAsnPwOamAttrTranslator translator = new QAsnPwOamAttrTranslator();
        for (MplsOamPw oam : pwOams) {
            try {
                translator.encode(oam, asn, (IAsnTranslationContext)context);
            }
            catch (VMFException e) {
                this.logger.error("MplsService.encodePwe3PwOam encode error");
            }
        }
    }

    public void decodeVplsPwOam(QAsnPwOamAttr asnPwOam, VplsInstance vpn, VplsLdpPw pw, Object context) {
        this.logger.info("Enter MplsService.decodeVplsPwOam ");
        if (null == vpn || null == context) {
            this.logger.error("MplsService.decodeVplsPwOam asnPwOam/vpn/context is null");
            return;
        }
        IAsnTranslationContext asnContext = (IAsnTranslationContext)context;
        if (EOperationType.PREDEPLOY.equals((Object)asnContext.getOperType())) {
            this.logger.info("Enter MplsService.decodeCreatePwOam vpn = " + vpn.getInstanceName());
            this.decodeCreateVplsOam(asnPwOam, vpn, pw, asnContext);
        }
        if (EOperationType.DEPLOY.equals((Object)asnContext.getOperType())) {
            this.logger.info("Enter MplsService.decodeDeployPwOam vpn = " + vpn.getFdn());
            this.decodeDeployVplsOam(vpn, asnContext);
        }
        if (EOperationType.UNDEPLOY.equals((Object)asnContext.getOperType())) {
            this.logger.info("Enter MplsService.decodeUnDeployPwOam vpn = " + vpn.getFdn());
            this.decodeUnDeployVplsOam(vpn, asnContext.getTransactionContext());
        }
        if (EOperationType.DELETE.equals((Object)asnContext.getOperType())) {
            this.logger.info("Enter MplsService.decodeDeleteVplsOam vpn = " + vpn.getFdn());
            this.decodeDeleteVplsOam(vpn, asnContext.getTransactionContext());
        }
    }

    private void decodeCreateVplsOam(QAsnPwOamAttr asnPwOam, VplsInstance vpn, VplsLdpPw pw, IAsnTranslationContext context) {
        if (null == asnPwOam) {
            this.logger.error("MplsService.decodeCreateVplsOam asnPwOam is null");
            return;
        }
        MplsOamPw pwOam = new MplsOamPw();
        pwOam.setDevID(pw.getDevID());
        pwOam.setVrID(pw.getVrID());
        pwOam.setPeerIp(pw.getPeerIp());
        pwOam.setVcId(pw.getNegotiationPwId());
        pwOam.setVcType(pw.getEncapsulateType());
        QAsnPwOamAttrTranslator translator = new QAsnPwOamAttrTranslator();
        try {
            translator.decode(asnPwOam, pwOam, context);
        }
        catch (VMFException e) {
            this.logger.error("MplsService.decodeCreateVplsOam decode error");
        }
        pwOam.setDeployStatus(Integer.valueOf(0));
        vpn.addKeyRefMo((VmfMO)pwOam);
    }

    private void decodeDeployVplsOam(VplsInstance vpn, IAsnTranslationContext context) {
        if (null == vpn.getVplsLdpInst() || CollectionUtils.isEmpty((Collection)vpn.getVplsLdpInst().getVplsLdpPws())) {
            this.logger.info("decodeDeployVplsOam vpn.getVplsLdpInst() is empty:" + vpn.getInstanceName());
            return;
        }
        HashMap<MplsOamPw, VplsLdpPw> mplsOam2PwMap = new HashMap<MplsOamPw, VplsLdpPw>();
        try {
            ArrayList<MplsOamPw> conditions = new ArrayList<MplsOamPw>();
            for (VplsLdpPw vpwsPw : vpn.getVplsLdpInst().getVplsLdpPws()) {
                MplsOamPw pwOam = new MplsOamPw();
                pwOam.setDevID(vpwsPw.getDevID());
                pwOam.setVrID(vpwsPw.getVrID());
                pwOam.setVcId(vpwsPw.getNegotiationPwId());
                pwOam.setVcType(vpwsPw.getEncapsulateType());
                pwOam.setPeerIp(vpwsPw.getPeerIp());
                conditions.add(pwOam);
                mplsOam2PwMap.put(pwOam, vpwsPw);
            }
            Map<MplsOamPw, Integer> mplsOamPwMap = this.getPWBindMplsOamInfo(conditions);
            for (Map.Entry<MplsOamPw, Integer> entry : mplsOamPwMap.entrySet()) {
                if (MplsConstant.OAM_ENUM_MPLS_OAM != entry.getValue()) continue;
                vpn.addKeyRefMo((VmfMO)entry.getKey());
            }
            this.addPwOamModifyRecord(context.getTransactionContext(), vpn.getKeyRefMos(MplsOamPw.class));
        }
        catch (VMFException e) {
            this.logger.error("DeployPwe3ServiceTask addPwOamKeyRefRecord failed.", (Throwable)e);
        }
    }

    private void decodeUnDeployVplsOam(VplsInstance vpwsInstance, Context ctx) {
        if (null == vpwsInstance.getVplsLdpInst() || CollectionUtils.isEmpty((Collection)vpwsInstance.getVplsLdpInst().getVplsLdpPws())) {
            this.logger.info("decodeUnDeployVplsOam vpn.getVplsLdpInst() or vpwsInstance.getVplsLdpInst().getVplsLdpPws() is empty:" + vpwsInstance.getInstanceName());
            return;
        }
        try {
            ArrayList<MplsOamPw> conditions = new ArrayList<MplsOamPw>();
            for (VplsLdpPw vplsLdpPw : vpwsInstance.getVplsLdpInst().getVplsLdpPws()) {
                MplsOamPw pwOam = new MplsOamPw();
                pwOam.setDevID(vplsLdpPw.getDevID());
                pwOam.setVrID(vplsLdpPw.getVrID());
                pwOam.setVcId(vplsLdpPw.getNegotiationPwId());
                pwOam.setVcType(vplsLdpPw.getEncapsulateType());
                pwOam.setPeerIp(vplsLdpPw.getPeerIp());
                conditions.add(pwOam);
            }
            Collection oamPwFromDB = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(MplsOamPw.class, conditions, true);
            if (!CollectionUtils.isEmpty((Collection)oamPwFromDB)) {
                vpwsInstance.addKeyRefMos(oamPwFromDB);
                this.addUndeployPwOamModifyRecord(ctx, vpwsInstance.getKeyRefMos(MplsOamPw.class));
            }
        }
        catch (VMFException e) {
            this.logger.error("setPwOamChanges failed.", (Throwable)e);
        }
    }

    private void decodeDeleteVplsOam(VplsInstance vpwsInstance, Context ctx) {
        if (null == vpwsInstance.getVplsLdpInst() || CollectionUtils.isEmpty((Collection)vpwsInstance.getVplsLdpInst().getVplsLdpPws())) {
            this.logger.info("decodeDeletePwOam vpn.getVplsLdpInst() is empty:" + vpwsInstance.getInstanceName());
            return;
        }
        try {
            ArrayList<MplsOamPw> conditions = new ArrayList<MplsOamPw>();
            for (VplsLdpPw vpwsPw : vpwsInstance.getVplsLdpInst().getVplsLdpPws()) {
                MplsOamPw pwOam = new MplsOamPw();
                pwOam.setDevID(vpwsPw.getDevID());
                pwOam.setVrID(vpwsPw.getVrID());
                pwOam.setVcId(vpwsPw.getNegotiationPwId());
                pwOam.setVcType(vpwsPw.getEncapsulateType());
                pwOam.setPeerIp(vpwsPw.getPeerIp());
                conditions.add(pwOam);
            }
            Collection oamPwFromDB = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(MplsOamPw.class, conditions, true);
            if (!CollectionUtils.isEmpty((Collection)oamPwFromDB)) {
                vpwsInstance.addKeyRefMos(oamPwFromDB);
                this.deletePwOamRecord(ctx, vpwsInstance.getKeyRefMos(MplsOamPw.class));
            }
        }
        catch (VMFException e) {
            this.logger.error("setPwOamChanges failed.", (Throwable)e);
        }
    }

    public void encodeVplsPwOam(VplsInstance vpn, QAsnVplsPw vplsAsn, Object context) {
        List pwOams = vpn.getKeyRefMos(MplsOamPw.class);
        QAsnPwOamAttrTranslator translator = new QAsnPwOamAttrTranslator();
        for (MplsOamPw oam : pwOams) {
            try {
                translator.encode(oam, vplsAsn.poPwOamAttr, (IAsnTranslationContext)context);
            }
            catch (VMFException e) {
                this.logger.error("MplsService.encodeVplsPwOam encode error");
            }
        }
    }

    public void getVplsPwOamFromDB(Collection<VplsInstance> vpns) {
        for (VplsInstance vpwsInstance : vpns) {
            ArrayList<MplsOamPw> conditions = new ArrayList<MplsOamPw>();
            if (null == vpwsInstance.getVplsLdpInst() || CollectionUtils.isEmpty((Collection)vpwsInstance.getVplsLdpInst().getVplsLdpPws())) continue;
            for (VplsLdpPw vplsLdpPw : vpwsInstance.getVplsLdpInst().getVplsLdpPws()) {
                MplsOamPw pwOam = new MplsOamPw();
                pwOam.setDevID(vplsLdpPw.getDevID());
                pwOam.setVrID(vplsLdpPw.getVrID());
                pwOam.setVcId(vplsLdpPw.getNegotiationPwId());
                pwOam.setVcType(vplsLdpPw.getPwType());
                pwOam.setPeerIp(vplsLdpPw.getPeerIp());
                conditions.add(pwOam);
            }
            try {
                Collection oamPwFromDB = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(MplsOamPw.class, conditions, true);
                if (CollectionUtils.isEmpty((Collection)oamPwFromDB)) continue;
                vpwsInstance.addKeyRefMos(oamPwFromDB);
            }
            catch (VMFException e) {
                this.logger.error("MplsService.getVplsPwOamFromDB queryOam error");
            }
        }
    }

    public Collection<MplsOamPw> getPwe3PwOamFromDB(Collection<VpwsInstance> vpns) {
        ArrayList<MplsOamPw> oamPws = new ArrayList<MplsOamPw>();
        for (VpwsInstance vpwsInstance : vpns) {
            if (CollectionUtils.isEmpty((Collection)vpwsInstance.getVpwsPws())) continue;
            ArrayList<MplsOamPw> conditions = new ArrayList<MplsOamPw>();
            for (VpwsPw pw : vpwsInstance.getVpwsPws()) {
                MplsOamPw pwOam = new MplsOamPw();
                pwOam.setDevID(pw.getDevID());
                pwOam.setVrID(pw.getVrID());
                pwOam.setVcId(pw.getPwId());
                pwOam.setVcType(pw.getPwType());
                pwOam.setPeerIp(pw.getPeerIp());
                conditions.add(pwOam);
            }
            try {
                Collection oamPwFromDB = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(MplsOamPw.class, conditions, true);
                if (CollectionUtils.isEmpty((Collection)oamPwFromDB)) continue;
                oamPws.addAll(oamPwFromDB);
            }
            catch (VMFException e) {
                this.logger.error("MplsService.getVplsPwOamFromDB queryOam error");
            }
        }
        return oamPws;
    }
}

