/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.service;

import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.AbstractCompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.Ring;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class MplsRingService
extends AbstractCompositeService<MplsRing> {
    public MplsRingService() {
        super(MplsRing.class);
    }

    public void create(Context context) {
        super.create(context);
        if (MplsUtil.isPtn()) {
            try {
                this.modifyOam(context);
            }
            catch (Exception e) {
                this.getLogger().error("ptn modifyOam failed!", (Throwable)e);
            }
        }
    }

    private void modifyOam(Context context) throws VMFException {
        String key;
        IMOChangeRecord mplsRingRecord = context.addChangeRecord(MplsRing.class);
        IMOChangeRecord oldRingRecord = context.addChangeRecord(Ring.class);
        Set rings = oldRingRecord.getCreates();
        ArrayList<MplsRing> sucMplsRings = new ArrayList<MplsRing>();
        OperResult operResult = context.getOperResult();
        HashMap<String, MplsRing> mplsRingMap = new HashMap<String, MplsRing>();
        for (MplsRing mplsRing : mplsRingRecord.getCreates()) {
            if (AsnTranslatorUtil.isSuccess((ErrorInfo)operResult.getMoOperResult((VmfMO)mplsRing))) {
                sucMplsRings.add(mplsRing);
            }
            key = CommonUtil.composeTmpKey((Object[])new Object[]{mplsRing.getDevID(), mplsRing.getVrID(), mplsRing.getRingId()});
            mplsRingMap.put(key, mplsRing);
        }
        if (CollectionUtils.isEmpty(sucMplsRings)) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)rings)) {
            MplsDevDao.newInstance().syncCreateMplsRingMplsOam(sucMplsRings);
            for (Ring ring : rings) {
                key = CommonUtil.composeTmpKey((Object[])new Object[]{ring.getDevID(), ring.getVrID(), ring.getRingId()});
                ((MplsRing)mplsRingMap.get(key)).addKeyRefMo((VmfMO)ring);
            }
        }
    }
}

