/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.service;

import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.service.DefaultMOConflictChecker;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.RingMapVirtualNode;
import com.huawei.vmf.adapter.fservice.mpls.model.RingPayload;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class MplsRingConflictChecker
extends DefaultMOConflictChecker<MplsRing> {
    public MplsRingConflictChecker() {
        super(MplsRing.class);
    }

    public OperResult checkDelete(Collection<MplsRing> mos, Context context) {
        OperResult operResult = super.checkDelete(mos, context);
        Set<MplsRing> hasVirtualNodeRings = this.queryHasVirtualNodeRings(mos);
        Set<MplsRing> hasTunnelRings = this.queryHasTunnelRings(mos);
        for (MplsRing mo : mos) {
            ErrorInfo error = operResult.getMoOperResult((VmfMO)mo);
            if (error != null && error.getErrorCode() != 0) continue;
            if (hasVirtualNodeRings.contains(mo)) {
                operResult.addMoOperResult((VmfMO)mo, 1107501606);
                continue;
            }
            if (!hasTunnelRings.contains(mo)) continue;
            operResult.addMoOperResult((VmfMO)mo, 1107501605);
        }
        return operResult;
    }

    private Set<MplsRing> queryHasTunnelRings(Collection<MplsRing> mos) {
        ArrayList<RingPayload> conditions = new ArrayList<RingPayload>(mos.size());
        for (MplsRing mo : mos) {
            RingPayload ringPayload = new RingPayload();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)mo, (VmfMO)ringPayload);
            ringPayload.setRingId(mo.getRingId());
            conditions.add(ringPayload);
        }
        try {
            String[] fieldNames = new String[]{"devID", "vrID", "ringId"};
            Collection ringPayloads = MplsDao.newInstance().queryByFields(RingPayload.class, fieldNames, conditions, false);
            HashSet<MplsRing> hasTunnelRings = new HashSet<MplsRing>();
            for (RingPayload ringPayload : ringPayloads) {
                MplsRing mo = new MplsRing();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)ringPayload, (VmfMO)mo);
                mo.setRingId(ringPayload.getRingId());
                hasTunnelRings.add(mo);
            }
            return hasTunnelRings;
        }
        catch (VMFException e) {
            this.getLogger().error("MplsRingConflictChecker query RingMapVirtualNode failed!", (Throwable)e);
            return Collections.emptySet();
        }
    }

    private Set<MplsRing> queryHasVirtualNodeRings(Collection<MplsRing> mos) {
        ArrayList<RingMapVirtualNode> conditions = new ArrayList<RingMapVirtualNode>(mos.size());
        for (MplsRing mo : mos) {
            RingMapVirtualNode node = new RingMapVirtualNode();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)mo, (VmfMO)node);
            node.setRingId(mo.getRingId());
            conditions.add(node);
        }
        try {
            String[] fieldNames = new String[]{"devID", "vrID", "ringId"};
            Collection virtualNodes = MplsDao.newInstance().queryByFields(RingMapVirtualNode.class, fieldNames, conditions, false);
            HashSet<MplsRing> hasVirtualNodeRings = new HashSet<MplsRing>();
            for (RingMapVirtualNode virtualNode : virtualNodes) {
                hasVirtualNodeRings.add(MplsUtil.translate2Ring(virtualNode));
            }
            return hasVirtualNodeRings;
        }
        catch (VMFException e) {
            this.getLogger().error("MplsRingConflictChecker query RingMapVirtualNode failed!", (Throwable)e);
            return Collections.emptySet();
        }
    }
}

