/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.service;

import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.IProxyService;
import com.huawei.communicate.proxy.MsgProxy;
import com.huawei.communicate.proxy.ProxyUtil;
import com.huawei.vmf.adapter.common.uflight.ProcessInfoHelper;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public final class MplsMsgService {
    private static final Logger LOGGER = RunLogger.getLogger(MplsMsgService.class);
    private static final MplsMsgService INSTANCE = new MplsMsgService();
    private static IProxyService mdpproxy;

    private MplsMsgService() {
        ProcessInfo procInfo = ProcessInfoHelper.getRuntimeProcessInfo();
        mdpproxy = MsgProxy.getProxyService((ProcessInfo)procInfo);
    }

    public static MplsMsgService getInstance() {
        return INSTANCE;
    }

    public int sendMessage(int cmdCode, int neID, FStruct request, FStruct response) {
        MSGHead msgHead = this.buildMSGHead(cmdCode, neID);
        LOGGER.info("MPLS OAM Send Req asn:[head={}, cmdCode={}, class={}, rpt={}]", new Object[]{msgHead.toString(), cmdCode, request.getClass().getName(), AsnUtil.toString((FStruct)request)});
        return mdpproxy.sendMessage(msgHead, request, response);
    }

    public MSGHead buildMSGHead(int cmdCode, int neID) {
        ProcessInfo processInfo = new ProcessInfo();
        int result = ProxyUtil.queryEMProcess((int)cmdCode, (int)neID, (ProcessInfo)processInfo);
        if (0 != result) {
            LOGGER.error("MsgService buildMSGHead(), ProxyUtil.queryEMProcess error, errorCode = " + result);
            return null;
        }
        MSGHead head = this.createMSGHead(cmdCode);
        head.receiverProcID = processInfo.getProcID().charValue();
        head.receiverProcHandle = processInfo.getProcHandle().charValue();
        return head;
    }

    public MSGHead createMSGHead(int cmdCode) {
        MSGHead head = new MSGHead();
        head.msgType = (byte)6;
        head.cmdCode = cmdCode;
        return head;
    }
}

