/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.service;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.AbstractCompositeService;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsInterface;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class MplsInterfaceService
extends AbstractCompositeService<MplsInterface> {
    public MplsInterfaceService() {
        super(MplsInterface.class);
    }

    public void modify(Context context) {
        super.create(context);
        super.delete(context);
        super.modify(context);
    }

    protected void syncDevMoInfos(List<MplsInterface> mos, Context context) {
        if (CollectionUtils.isEmpty(mos)) {
            return;
        }
        try {
            List<MplsInterface> resultList = this.queryMplsInterfaceFromDev(mos);
            Context dbContext = new Context();
            IMOChangeRecord record = dbContext.addChangeRecord(MplsInterface.class);
            for (MplsInterface mo : resultList) {
                record.addModify((Object)mo, (Collection)CommonUtil.genList((Object[])new String[]{"ldpEnable", "mplsTEEnable", "rsvpTEEnable"}));
            }
            MplsDao.newInstance(dbContext).merge(false, new Class[]{MplsInterface.class});
        }
        catch (Exception e) {
            this.getLogger().error("MplsInterfaceService syncDevMoInfos failed!", (Throwable)e);
        }
    }

    private List<MplsInterface> queryMplsInterfaceFromDev(List<MplsInterface> mos) throws VMFException {
        HashMap<Integer, ArrayList<MplsInterface>> mifmMap = new HashMap<Integer, ArrayList<MplsInterface>>();
        for (MplsInterface mifm : mos) {
            ArrayList<MplsInterface> mifms = (ArrayList<MplsInterface>)mifmMap.get(mifm.getDevID());
            if (mifms == null) {
                mifms = new ArrayList<MplsInterface>();
                mifmMap.put(mifm.getDevID(), mifms);
            }
            mifms.add(mifm);
        }
        DefaultMOService pollService = new DefaultMOService();
        for (Map.Entry entry : mifmMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(((Integer)entry.getKey()).intValue());
            for (MplsInterface mifm : (List)entry.getValue()) {
                queryContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)mifm, null);
                pollService.addQueryJob(queryContext);
            }
        }
        pollService.poll();
        ArrayList<MplsInterface> resultList = new ArrayList<MplsInterface>();
        for (Map.Entry entry : mifmMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(((Integer)entry.getKey()).intValue());
            Collection mifms = queryContext.getQueryResult(MplsInterface.class);
            if (CollectionUtils.isEmpty((Collection)mifms)) continue;
            resultList.addAll(mifms);
        }
        return resultList;
    }
}

