/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.service;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.AbstractCompositeService;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpInstance;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpRemotePeer;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsCommonCfg;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class MplsCommonCfgService
extends AbstractCompositeService<MplsCommonCfg> {
    public MplsCommonCfgService() {
        super(MplsCommonCfg.class);
    }

    public void modify(Context context) {
        super.modify(context);
        this.syncLdpRemotePeerState(context);
    }

    private void syncLdpRemotePeerState(Context context) {
        IMOChangeRecord ldpRecord = context.addChangeRecord(LdpInstance.class);
        HashSet<LdpRemotePeer> peerSet = new HashSet<LdpRemotePeer>();
        for (LdpInstance ldp : ldpRecord.getAllChanges()) {
            if (CollectionUtils.isEmpty((Collection)ldp.getLdpRemotePeers()) || !ldpRecord.isCreated((Object)ldp) && !ldpRecord.isModified((Object)ldp)) continue;
            peerSet.addAll(ldp.getLdpRemotePeers());
        }
        try {
            MplsDevDao.newInstance().loadLdpRemotePeerState(peerSet);
            Context ctx = new Context();
            IMOChangeRecord peerRecord = ctx.addChangeRecord(LdpRemotePeer.class);
            List<String> fieldNames = Arrays.asList("keepaliveHoldTime", "keepaliveSendTime", "helloHoldTime", "helloSendTime", "peerState");
            for (LdpRemotePeer peer : peerSet) {
                peerRecord.addModify((Object)peer, fieldNames);
            }
            MplsDao.newInstance(ctx).merge(LdpRemotePeer.class, false);
        }
        catch (VMFException e) {
            this.getLogger().error("MplsCommonCfgService syncLdpRemotePeerState failed!", (Throwable)e);
        }
    }
}

