/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.service;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.service.DefaultMOConflictChecker;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.ExplicitPath;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class ExplicitPathConflictChecker
extends DefaultMOConflictChecker<ExplicitPath> {
    public ExplicitPathConflictChecker() {
        super(ExplicitPath.class);
    }

    public OperResult checkCreate(Collection<ExplicitPath> mos, Context context) {
        OperResult operResult = new OperResult();
        if (CollectionUtils.isEmpty(mos)) {
            return operResult;
        }
        Collection allDbMos = null;
        try {
            allDbMos = this.getDao(null).queryByNeID(ExplicitPath.class, this.getDevIds(mos), false);
        }
        catch (VMFException e) {
            this.getLogger().error("query mo error. mos=" + mos, (Throwable)e);
            operResult.addMoOperResults(mos, e.getErrorCode());
            return operResult;
        }
        for (ExplicitPath dbMo : allDbMos) {
            for (ExplicitPath mo : mos) {
                if (!mo.equals((Object)dbMo)) continue;
                operResult.addMoOperResult((VmfMO)mo, 1107501600);
            }
        }
        return operResult;
    }

    private Set<Integer> getDevIds(Collection<ExplicitPath> mos) {
        HashSet<Integer> devIds = new HashSet<Integer>();
        for (ExplicitPath mo : mos) {
            devIds.add(mo.getDevID());
        }
        return devIds;
    }
}

