/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.notify;

import com.huawei.vmf.adapter.framework.notify.IMOChangeNotifyPreHandler;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.ReverseRsvpTeLsp;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import java.util.Arrays;
import java.util.Collection;

public class AddMplsTeKeyRefPreHandler
implements IMOChangeNotifyPreHandler {
    public void prepareChangeRecord(Context context) {
        IMOChangeRecord changeRecord = context.getChangeRecord(ReverseRsvpTeLsp.class);
        if (changeRecord == null) {
            return;
        }
        for (ReverseRsvpTeLsp keyRefMO : changeRecord.getAllChanges()) {
            this.addToVrfKeyRef(keyRefMO, context);
        }
    }

    private void addToVrfKeyRef(ReverseRsvpTeLsp keyRefMO, Context context) {
        String tunnelName = keyRefMO.getTunnelName();
        IMOChangeRecord tunnelChangeRecord = context.addChangeRecord(RsvpTeTunnel.class);
        RsvpTeTunnel tunnelKey = new RsvpTeTunnel();
        tunnelKey.setDevID(keyRefMO.getDevID());
        tunnelKey.setVrID(keyRefMO.getVrID());
        tunnelKey.setTunnelName(tunnelName);
        if (tunnelChangeRecord.isDeleted((Object)tunnelKey)) {
            return;
        }
        if (tunnelChangeRecord.isCreated((Object)tunnelKey)) {
            this.getRsvpTeInContextByHashCode(tunnelKey, tunnelChangeRecord.getCreates()).addKeyRefMo((VmfMO)keyRefMO);
            return;
        }
        if (tunnelChangeRecord.isModified((Object)tunnelKey)) {
            this.getRsvpTeInContextByHashCode(tunnelKey, tunnelChangeRecord.getModifies()).addKeyRefMo((VmfMO)keyRefMO);
            tunnelChangeRecord.addModify((Object)tunnelKey, Arrays.asList(keyRefMO.getClass().getName()));
            return;
        }
        tunnelKey.addKeyRefMo((VmfMO)keyRefMO);
        tunnelChangeRecord.addModify((Object)tunnelKey, Arrays.asList(keyRefMO.getClass().getName()));
    }

    private RsvpTeTunnel getRsvpTeInContextByHashCode(RsvpTeTunnel vrf, Collection<RsvpTeTunnel> vrfs) {
        for (RsvpTeTunnel v : vrfs) {
            if (!vrf.equals((Object)v)) continue;
            return v;
        }
        return vrf;
    }
}

