/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.fault;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.trapadmin.FaultUtil;
import com.huawei.vmf.adapter.framework.trapadmin.IFaultListener;
import com.huawei.vmf.adapter.fservice.mpls.model.BypassProtectIF;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.fault.LdpLspFault;
import com.swimap.imap.common.asn1.common.AsnForwardFaultRptStrc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public class TunnelFrrConfFault
implements IFaultListener {
    public static final String FAULT_GROUP_KEY = "com.huawei.vmf.adapter.mpls.frr";
    public static final int NE_MPLS_TUNNEL_FRR_CONF_CHANGE = 1102250;
    private static final int FRR_DISABLE = 0;
    private static final int FRR_ENABLE = 1;
    private static final Logger logger = RunLogger.getLogger(LdpLspFault.class);
    private static final String NEMPLD_FAULT_TUNNEL_FRR_CONFIG = "config";
    private static final int NEMPLD_FAULT_TUNNEL_FRR_COUNT = 2;

    public void handle(List<AsnForwardFaultRptStrc> alarms) {
        for (AsnForwardFaultRptStrc alarm : alarms) {
            this.handleAlarm(alarm);
        }
    }

    private void deleteBypassProtectIF(int devId, String tunnelName) {
        BypassProtectIF bypassProtectIF = new BypassProtectIF();
        bypassProtectIF.setDevID(Integer.valueOf(devId));
        bypassProtectIF.setTunnelName(tunnelName);
        bypassProtectIF.setVrID(Integer.valueOf(0));
        Context context = new Context();
        IMOChangeRecord record = context.addChangeRecord(BypassProtectIF.class);
        record.addDelete((Object)bypassProtectIF);
        try {
            MplsDao.newInstance(context).merge(false, new Class[]{BypassProtectIF.class});
        }
        catch (VMFException e) {
            logger.error("TunnelFrrConfFault delete BypassProtectIF failed!", (Throwable)e);
        }
    }

    private Integer getNeTunnelFrrConf(int devID, String tunnelName) {
        try {
            MplsDao dao = MplsDao.newInstance();
            RsvpTeTunnelAdv temp = new RsvpTeTunnelAdv();
            temp.setDevID(Integer.valueOf(devID));
            temp.setTunnelName(tunnelName);
            temp.setVrID(Integer.valueOf(0));
            Collection advs = dao.queryByKey(RsvpTeTunnelAdv.class, Arrays.asList(temp), false);
            if (CollectionUtils.isEmpty((Collection)advs)) {
                return null;
            }
            Boolean frrEnable = ((RsvpTeTunnelAdv)advs.iterator().next()).getFrrEnable();
            if (frrEnable != null && frrEnable.booleanValue()) {
                return 1;
            }
            return 0;
        }
        catch (VMFException e) {
            logger.error("TunnelFrrConfFault getNeTunnelFrrConf failed!", (Throwable)e);
            return null;
        }
    }

    private void handleAlarm(AsnForwardFaultRptStrc oEmfFaultInfo) {
        Integer frrConfOldOper;
        String fdn = StringUtil.globalString((byte[])oEmfFaultInfo.strFdn);
        int devId = FaultUtil.getDevIdByFdn((String)fdn);
        String paramStr = StringUtil.globalString((byte[])oEmfFaultInfo.strPara);
        ArrayList params = new ArrayList();
        FaultUtil.splitString((String)paramStr, params);
        if (CollectionUtils.isEmpty(params) || params.size() < 2) {
            logger.error("invalid alarm-format: para = " + paramStr);
            return;
        }
        Iterator itor = params.iterator();
        String tunnelName = (String)itor.next();
        String frrConfOperStr = (String)itor.next();
        if (StringUtil.isEmpty((String)tunnelName) || StringUtil.isEmpty((String)frrConfOperStr)) {
            logger.error("invalid tunnelName: " + tunnelName + " ,frrConfOper " + frrConfOperStr);
            return;
        }
        int frrConfOper = 0;
        if (frrConfOperStr.equals(NEMPLD_FAULT_TUNNEL_FRR_CONFIG)) {
            frrConfOper = 1;
        }
        if ((frrConfOldOper = this.getNeTunnelFrrConf(devId, tunnelName)) != null && frrConfOldOper != frrConfOper) {
            this.updateTunnelFrrStatus(devId, tunnelName, frrConfOper);
            if (1 == frrConfOper) {
                this.deleteBypassProtectIF(devId, tunnelName);
            }
        }
    }

    private void updateTunnelFrrStatus(int devId, String tunnelName, int frrConfOper) {
        RsvpTeTunnelAdv adv = new RsvpTeTunnelAdv();
        adv.setDevID(Integer.valueOf(devId));
        adv.setTunnelName(tunnelName);
        adv.setVrID(Integer.valueOf(0));
        if (frrConfOper == 1) {
            adv.setFrrEnable(Boolean.valueOf(true));
        } else {
            adv.setFrrEnable(Boolean.valueOf(false));
        }
        Context context = new Context();
        IMOChangeRecord record = context.addChangeRecord(RsvpTeTunnelAdv.class);
        record.addModify((Object)adv, new PropertyChangeItem("frrEnable"));
        try {
            MplsDao.newInstance(context).merge(false, new Class[]{RsvpTeTunnelAdv.class});
        }
        catch (VMFException e) {
            logger.error("TunnelFrrConfFault merge RsvpTeTunnelAdv frrEnable failed!", (Throwable)e);
        }
    }
}

