/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.fault;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnRsvpTunnelBackUpStatusInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnRsvpTunnelFrrStatusInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnRsvpTunnelBackUpStatusRpt;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnRsvpTunnelFrrStatusRpt;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.framework.trapadmin.FaultUtil;
import com.huawei.vmf.adapter.framework.trapadmin.IFaultListener;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsCommonCfg;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.fault.LdpLspFault;
import com.swimap.imap.common.asn1.common.AsnForwardFaultRptStrc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public class TunnelFault
implements IFaultListener {
    public static final String FAULT_GROUP_KEY = "com.huawei.vmf.adapter.mpls.tunnel";
    private static final int INGRESS_LSR_ID_INDEX = 1;
    private static final Logger logger = RunLogger.getLogger(LdpLspFault.class);
    private static final int NE_MPLS_TE_FRR_RESUME = 1101405;
    private static final int NE_MPLS_TE_FRR_SWITCH = 1101404;
    private static final int NE_MPLS_TUNNEL_BB_RESUME = 2600884;
    private static final int NE_MPLS_TUNNEL_BB_SWITCH = 2600883;
    private static final int NE_MPLS_TUNNEL_DOWN = 1100099;
    private static final int NE_MPLS_TUNNEL_HSB_RESUME = 1101407;
    private static final int NE_MPLS_TUNNEL_HSB_SWITCH = 1101406;
    private static final int NE_MPLS_TUNNEL_OB_RESUME = 1101409;
    private static final int NE_MPLS_TUNNEL_OB_SWITCH = 1101408;
    private static final int NE_MPLS_TUNNEL_UP = 1100098;
    private static final int NEMPLS_FAULT_TUNNEL_COUNT = 3;
    private static final int STATUS_FALSE = 0;
    private static final int STATUS_TRUE = 1;
    private static final int TUNNEL_ID_INDEX = 0;

    public void handle(List<AsnForwardFaultRptStrc> alarms) {
        QAsnRsvpTunnelFrrStatusRpt asnRpt;
        Context context = new Context();
        LinkedList<QAsnRsvpTunnelFrrStatusInfo> frrStatusInfos = new LinkedList<QAsnRsvpTunnelFrrStatusInfo>();
        LinkedList<QAsnRsvpTunnelBackUpStatusInfo> backupStatusInfos = new LinkedList<QAsnRsvpTunnelBackUpStatusInfo>();
        for (AsnForwardFaultRptStrc alarm : alarms) {
            this.handleAlarm(alarm, context, frrStatusInfos, backupStatusInfos);
        }
        this.reportMoFaultChanges(context);
        if (!CollectionUtils.isEmpty(frrStatusInfos)) {
            asnRpt = new QAsnRsvpTunnelFrrStatusRpt();
            asnRpt.lstRsvpTunnelFrrStatusInfo.addAll(frrStatusInfos);
            FaultUtil.sendNoReliableEvent((int)65704, (FStruct)asnRpt);
        }
        if (!CollectionUtils.isEmpty(backupStatusInfos)) {
            asnRpt = new QAsnRsvpTunnelBackUpStatusRpt();
            asnRpt.lstRsvpTunnelBackUpStatusInfo.addAll(backupStatusInfos);
            FaultUtil.sendNoReliableEvent((int)65705, (FStruct)asnRpt);
        }
    }

    protected void reportMoFaultChanges(Context context) {
        IMOChangeRecord record = context.addChangeRecord(RsvpTeTunnel.class);
        if (record.hasModify()) {
            MOChangePublisher.getInstance().notifyAlarmChanges(context);
            try {
                MplsDao.newInstance(context).merge(false, new Class[]{RsvpTeTunnel.class});
            }
            catch (VMFException e) {
                logger.error("TunnelFault merge to db error!", (Throwable)e);
            }
        }
    }

    private void addReportInfos(Collection<QAsnRsvpTunnelFrrStatusInfo> frrStatusInfos, Collection<QAsnRsvpTunnelBackUpStatusInfo> backupStatusInfos, int faultId, String ingressLsrID, RsvpTeTunnel tunnel) {
        if (1101404 == faultId) {
            frrStatusInfos.add(this.getFrrStatusRptAsn(tunnel, ingressLsrID, 1));
        } else if (1101405 == faultId) {
            frrStatusInfos.add(this.getFrrStatusRptAsn(tunnel, ingressLsrID, 0));
        } else if (1101406 == faultId) {
            backupStatusInfos.add(this.getBackupStatusRptAsn(tunnel, 1));
        } else if (1101407 == faultId) {
            backupStatusInfos.add(this.getBackupStatusRptAsn(tunnel, 0));
        } else if (1101408 == faultId) {
            backupStatusInfos.add(this.getBackupStatusRptAsn(tunnel, 1));
        } else if (1101409 == faultId) {
            backupStatusInfos.add(this.getBackupStatusRptAsn(tunnel, 0));
        } else if (2600883 == faultId) {
            backupStatusInfos.add(this.getBackupStatusRptAsn(tunnel, 1));
        } else if (2600884 == faultId) {
            backupStatusInfos.add(this.getBackupStatusRptAsn(tunnel, 0));
        } else {
            logger.debug("defense coding, do nothing");
        }
    }

    private int getAlarmID(AsnForwardFaultRptStrc alarm) {
        int iFaultId = alarm.sFaultID.intValue();
        if (FaultUtil.isRecoverFault((AsnForwardFaultRptStrc)alarm)) {
            switch (iFaultId) {
                case 1100099: {
                    iFaultId = 1100098;
                    break;
                }
                case 1101404: {
                    iFaultId = 1101405;
                    break;
                }
                case 1101408: {
                    iFaultId = 1101409;
                    break;
                }
                case 1101406: {
                    iFaultId = 1101407;
                    break;
                }
                case 2600883: {
                    iFaultId = 2600884;
                    break;
                }
            }
        }
        return iFaultId;
    }

    private QAsnRsvpTunnelBackUpStatusInfo getBackupStatusRptAsn(RsvpTeTunnel tunnel, int isBackupSwitch) {
        QAsnRsvpTunnelBackUpStatusInfo status = new QAsnRsvpTunnelBackUpStatusInfo();
        status.oNotifyTnlKey = new RsvpTeTunnelFdnParser().getUniResID((VmfMO)tunnel);
        status.iBackUpStatus = isBackupSwitch;
        return status;
    }

    private MplsCommonCfg getDevMplsConfigByLsrId(String lsrId) {
        MplsDao dao = MplsDao.newInstance();
        MplsCommonCfg param = new MplsCommonCfg();
        param.setMplsLsrID(lsrId);
        String[] fields = new String[]{"mplsLsrID"};
        try {
            Collection cfgs = dao.queryByFields(MplsCommonCfg.class, fields, Arrays.asList(param), false);
            if (CollectionUtils.isEmpty((Collection)cfgs)) {
                return null;
            }
            return (MplsCommonCfg)cfgs.iterator().next();
        }
        catch (VMFException e) {
            logger.error("getDevMplsConfigByLsrId:" + lsrId, (Throwable)e);
            return null;
        }
    }

    private QAsnRsvpTunnelFrrStatusInfo getFrrStatusRptAsn(RsvpTeTunnel tunnel, String strLsrID, int status) {
        QAsnRsvpTunnelFrrStatusInfo pasnFrrStatus = new QAsnRsvpTunnelFrrStatusInfo();
        pasnFrrStatus.oNotifyTnlKey = new RsvpTeTunnelFdnParser().getUniResID((VmfMO)tunnel);
        pasnFrrStatus.iNeID = tunnel.getDevID();
        pasnFrrStatus.iFrrStatus = status;
        pasnFrrStatus.strfrrNodeLsrID = StringUtil.globalByte((String)strLsrID);
        return pasnFrrStatus;
    }

    private RsvpTeTunnel getTunnelById(int devId, int index) {
        MplsDao dao = MplsDao.newInstance();
        RsvpTeTunnel param = new RsvpTeTunnel();
        param.setMplsTunnelIndex(Integer.valueOf(index));
        param.setDevID(Integer.valueOf(devId));
        String[] fields = new String[]{"mplsTunnelIndex", "devID"};
        try {
            Collection tunnels = dao.queryByFields(RsvpTeTunnel.class, fields, Arrays.asList(param), false);
            if (CollectionUtils.isEmpty((Collection)tunnels)) {
                return null;
            }
            return (RsvpTeTunnel)tunnels.iterator().next();
        }
        catch (VMFException e) {
            logger.error("getTunnelById:(" + devId + "," + index + ") failed!", (Throwable)e);
            return null;
        }
    }

    private RsvpTeTunnel getTunnelFromDev(RsvpTeTunnel tunnel) {
        QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(tunnel.getDevID().intValue());
        List<String> queryAttributeNames = Arrays.asList("operStatus", "adminStatus");
        queryContext.addQueryAttributes(tunnel.getFeatureName(), (VmfMO)tunnel, queryAttributeNames);
        DefaultMOService pollService = new DefaultMOService();
        pollService.addQueryJob(queryContext);
        try {
            pollService.poll();
            Collection tunnels = queryContext.getQueryResult(RsvpTeTunnel.class);
            if (CollectionUtils.isEmpty((Collection)tunnels)) {
                return null;
            }
            return (RsvpTeTunnel)tunnels.iterator().next();
        }
        catch (VMFException e) {
            logger.error("getTunnelFromDev " + tunnel.getDevID(), (Throwable)e);
            return null;
        }
    }

    private void handleAlarm(AsnForwardFaultRptStrc alarm, Context context, Collection<QAsnRsvpTunnelFrrStatusInfo> frrStatusInfos, Collection<QAsnRsvpTunnelBackUpStatusInfo> backupStatusInfos) {
        int tunnelId;
        RsvpTeTunnel tunnel;
        IMOChangeRecord tunnelRecord = context.addChangeRecord(RsvpTeTunnel.class);
        int faultId = this.getAlarmID(alarm);
        int devId = FaultUtil.getDevIdFromAlarm((AsnForwardFaultRptStrc)alarm);
        List<String> params = this.parseParams(alarm);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        String tunnelID = params.get(0);
        String ingressLsrID = params.get(1);
        int ingressDevID = devId;
        if (!StringUtil.isEmpty((String)ingressLsrID)) {
            MplsCommonCfg ingressDevMplsConfig = this.getDevMplsConfigByLsrId(ingressLsrID);
            if (ingressDevMplsConfig == null) {
                logger.error("null == getDevMplsConfigByLsrId{}", (Object)ingressLsrID);
                return;
            }
            ingressDevID = ingressDevMplsConfig.getDevID();
        }
        if ((tunnel = this.getTunnelById(ingressDevID, tunnelId = Integer.valueOf(tunnelID).intValue())) == null) {
            logger.error("null == getTunnelById{}", (Object)(ingressDevID + "," + tunnelId));
            return;
        }
        if (1100098 == faultId) {
            tunnel.setOperStatus(RsvpTeTunnel.OPER_STATUS_ENUM.UP);
            tunnelRecord.addModify((Object)tunnel, new PropertyChangeItem("operStatus"));
            return;
        }
        if (1100099 == faultId) {
            RsvpTeTunnel devTunnel = this.getTunnelFromDev(tunnel);
            if (devTunnel == null) {
                logger.error("null == getTunnelFromDev{}", (Object)tunnel);
            } else {
                tunnel.setOperStatus(RsvpTeTunnel.OPER_STATUS_ENUM.DOWN);
                tunnelRecord.addModify((Object)tunnel, new PropertyChangeItem("operStatus"));
            }
            return;
        }
        this.addReportInfos(frrStatusInfos, backupStatusInfos, faultId, ingressLsrID, tunnel);
    }

    private List<String> parseParams(AsnForwardFaultRptStrc alarm) {
        String para = StringUtil.globalString((byte[])alarm.strPara);
        String detail = StringUtil.globalString((byte[])alarm.strDetail);
        ArrayList<String> paraSources = new ArrayList<String>();
        FaultUtil.splitString((String)para, paraSources);
        FaultUtil.splitString((String)detail, paraSources);
        if (CollectionUtils.isEmpty(paraSources) || paraSources.size() < 3 || StringUtil.isEmpty((String)((String)paraSources.get(0)))) {
            logger.error("invalid alarm-format: para = " + para + " datil=" + detail);
            return Collections.emptyList();
        }
        return paraSources;
    }
}

