/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.fault;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelPGStatus;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnSwitchProtectionGroupRpt;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.trapadmin.FaultUtil;
import com.huawei.vmf.adapter.framework.trapadmin.IFaultListener;
import com.huawei.vmf.adapter.mpls.fault.LdpLspFault;
import com.swimap.imap.common.asn1.common.AsnForwardFaultRptStrc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public class ProtectionFault
implements IFaultListener {
    private static final Logger logger = RunLogger.getLogger(LdpLspFault.class);
    int NE_MPLS_OAM_SWITCH_PROTECT_TUNNEL_ID = 1100166;
    int NE_MPLS_OAM_SWITCH_WORK_TUNNEL_ID = 1100165;
    int NE_MPLS_PRIMARYLSP_DOWN = 2600454;
    int NE_MPLS_PRIMARYLSP_UP = 2600453;
    int NEMPLD_FAULT_LSP_COUNT = 1;

    public void handle(List<AsnForwardFaultRptStrc> alarms) {
        ArrayList<QAsnTunnelPGStatus> tunnelPGStatuses = new ArrayList<QAsnTunnelPGStatus>();
        for (AsnForwardFaultRptStrc alarm : alarms) {
            this.handleAlarm(alarm, tunnelPGStatuses);
        }
        if (CollectionUtils.isEmpty(tunnelPGStatuses)) {
            logger.info("Start notify QAsnSwitchProtectionGroupRpt");
            QAsnSwitchProtectionGroupRpt asnRpt = new QAsnSwitchProtectionGroupRpt();
            asnRpt.lstProtectGroupStatus.addAll(tunnelPGStatuses);
            FaultUtil.sendNoReliableEvent((int)65703, (FStruct)asnRpt);
            logger.info("End notify QAsnSwitchProtectionGroupRpt" + asnRpt);
        }
    }

    private void handleAlarm(AsnForwardFaultRptStrc alarm, List<QAsnTunnelPGStatus> tunnelPGStatuses) {
        String param = StringUtil.globalString((byte[])alarm.strPara);
        ArrayList params = new ArrayList();
        FaultUtil.splitString((String)param, params);
        if (CollectionUtils.isEmpty(params) || params.size() < this.NEMPLD_FAULT_LSP_COUNT) {
            logger.error("invalid alarm-format: para = " + param);
            return;
        }
        int faultId = alarm.sFaultID.intValue();
        String tunnelIfName = null;
        Iterator itor = params.iterator();
        if (this.NE_MPLS_OAM_SWITCH_WORK_TUNNEL_ID == faultId || this.NE_MPLS_OAM_SWITCH_PROTECT_TUNNEL_ID == faultId) {
            tunnelIfName = (String)itor.next();
        } else if (itor.hasNext()) {
            tunnelIfName = (String)itor.next();
        }
        if (StringUtil.isEmpty((String)tunnelIfName)) {
            logger.error("invalid alarm-format: para = " + param);
            return;
        }
    }
}

