/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.fault;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelRunStatusInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnRunStatusChangeTunnelRpt;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.trapadmin.FaultUtil;
import com.huawei.vmf.adapter.framework.trapadmin.IFaultListener;
import com.huawei.vmf.adapter.fservice.mpls.model.Lsp;
import com.huawei.vmf.adapter.mpls.fault.LdpLspFault;
import com.swimap.imap.common.asn1.common.AsnForwardFaultRptStrc;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public class LspFault
implements IFaultListener {
    public static final int NE_MPLS_LSP_DOWN = 1101401;
    public static final int NE_MPLS_LSP_UP = 1101400;
    private static final Logger logger = RunLogger.getLogger(LdpLspFault.class);
    int AsnEnumNeMplsServiceType_staticlsp = 2;
    int AsnEnumNeMplsServiceType_tunnel = 1;
    int AsnEnumScdOperStatus_down = 2;
    int AsnEnumScdOperStatus_frr_switch = 5;
    int AsnEnumScdOperStatus_hsb_switch = 6;
    int AsnEnumScdOperStatus_ob_switch = 7;
    int AsnEnumScdOperStatus_testing = 3;
    int AsnEnumScdOperStatus_unknown = 4;
    int AsnEnumScdOperStatus_up = 1;
    int EnumTunnelEnable_tunnelDisable = 0;
    int EnumTunnelEnable_tunnelEnable = 1;
    int NEMPLD_FAULT_LSP_COUNT = 1;

    public void handle(List<AsnForwardFaultRptStrc> alarms) {
        ArrayList<QAsnTunnelRunStatusInfo> tunnelRunStatusInfos = new ArrayList<QAsnTunnelRunStatusInfo>();
        for (AsnForwardFaultRptStrc alarm : alarms) {
            this.handleAlarm(alarm, tunnelRunStatusInfos);
        }
        if (!CollectionUtils.isEmpty(tunnelRunStatusInfos)) {
            QAsnRunStatusChangeTunnelRpt asnRpt = new QAsnRunStatusChangeTunnelRpt();
            asnRpt.lstTunnelStatusInfo.addAll(tunnelRunStatusInfos);
            FaultUtil.sendNoReliableEvent((int)65690, (FStruct)asnRpt);
        }
    }

    private int getAlarmId(AsnForwardFaultRptStrc oFaultRpt) {
        int faultId = oFaultRpt.sFaultID.intValue();
        if (FaultUtil.isPrimaryFault((AsnForwardFaultRptStrc)oFaultRpt)) {
            return faultId;
        }
        if (FaultUtil.isRecoverFault((AsnForwardFaultRptStrc)oFaultRpt)) {
            switch (faultId) {
                case 1101401: {
                    faultId = 1101400;
                    break;
                }
            }
        }
        return faultId;
    }

    private Lsp getLspFromDev(int iDevID, String strLspName) {
        return null;
    }

    private void handleAlarm(AsnForwardFaultRptStrc oEmfFaultInfo, List<QAsnTunnelRunStatusInfo> tunnelRunStatusInfos) {
        Lsp lsp;
        String fdn = StringUtil.globalString((byte[])oEmfFaultInfo.strFdn);
        int iDevID = FaultUtil.getDevIdByFdn((String)fdn);
        int faultId = this.getAlarmId(oEmfFaultInfo);
        String param = StringUtil.globalString((byte[])oEmfFaultInfo.strPara);
        ArrayList params = new ArrayList();
        FaultUtil.splitString((String)param, params);
        if (CollectionUtils.isEmpty(params) || params.size() < this.NEMPLD_FAULT_LSP_COUNT) {
            logger.error("invalid alarm-format: para = " + param);
            return;
        }
        String strLspName = (String)params.iterator().next();
        int iOperStatus = this.AsnEnumScdOperStatus_unknown;
        if (1101400 == faultId) {
            iOperStatus = this.AsnEnumScdOperStatus_up;
        }
        if (1101401 == faultId) {
            iOperStatus = this.AsnEnumScdOperStatus_down;
        }
        if ((lsp = this.getLspFromDev(iDevID, strLspName)) != null) {
            QAsnTunnelRunStatusInfo info = new QAsnTunnelRunStatusInfo();
            info.iRunStatus = this.switchTunnelRunStatus(iOperStatus);
            tunnelRunStatusInfos.add(info);
        }
    }

    private int switchTunnelRunStatus(int asnTunnelStatus) {
        if (this.AsnEnumScdOperStatus_up == asnTunnelStatus) {
            return this.EnumTunnelEnable_tunnelEnable;
        }
        if (this.AsnEnumScdOperStatus_unknown == asnTunnelStatus) {
            return -1;
        }
        return this.EnumTunnelEnable_tunnelDisable;
    }
}

