/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.fault;

import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.trapadmin.FaultUtil;
import com.huawei.vmf.adapter.framework.trapadmin.IFaultListener;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpLsp;
import com.swimap.imap.common.asn1.common.AsnForwardFaultRptStrc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public class LdpLspFault
implements IFaultListener {
    public static final String FAULT_GROUP_KEY = "com.huawei.vmf.adapter.mpls.ldplsp";
    private static final Logger logger = RunLogger.getLogger(LdpLspFault.class);
    private static int NE_MPLS_LDP_VIRTUAL_TUNNEL_DOWN = 2501049;
    private static int NE_MPLS_LDP_VIRTUAL_TUNNEL_UP = 2501050;

    public void handle(List<AsnForwardFaultRptStrc> alarms) {
        Context context = new Context();
        for (AsnForwardFaultRptStrc alarm : alarms) {
            this.handleAlarm(alarm, context);
        }
        IMOChangeRecord record = context.addChangeRecord(LdpLsp.class);
        if (record.hasChanges()) {
            MOChangePublisher.getInstance().notifyAlarmChanges(context);
        }
    }

    private void handleAlarm(AsnForwardFaultRptStrc alarm, Context context) {
        int faultId = alarm.sFaultID.intValue();
        String fdn = StringUtil.globalString((byte[])alarm.strFdn);
        int devID = FaultUtil.getDevIdByFdn((String)fdn);
        String param = StringUtil.globalString((byte[])alarm.strPara);
        ArrayList params = new ArrayList();
        FaultUtil.splitString((String)param, params);
        if (CollectionUtils.isEmpty(params)) {
            logger.error("invalid alarm-format: para = " + param);
            return;
        }
        Iterator itor = params.iterator();
        String destIpAddr = (String)itor.next();
        LdpLsp ldpLsp = new LdpLsp();
        ldpLsp.setDevID(Integer.valueOf(devID));
        ldpLsp.setVrID(Integer.valueOf(0));
        ldpLsp.setLspAddr(destIpAddr);
        IMOChangeRecord record = context.addChangeRecord(LdpLsp.class);
        if (NE_MPLS_LDP_VIRTUAL_TUNNEL_DOWN == faultId) {
            record.addDelete((Object)ldpLsp);
        } else if (NE_MPLS_LDP_VIRTUAL_TUNNEL_UP == faultId) {
            record.addCreate((Object)ldpLsp);
        }
    }
}

