/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.dao;

import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.service.IMOService;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.schema.ActionSchemaTranslatorContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnTunnelInfo;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnTunnel;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.CrossConnect;
import com.huawei.vmf.adapter.fservice.mpls.model.CspfPreCalc;
import com.huawei.vmf.adapter.fservice.mpls.model.GresmPreReserve;
import com.huawei.vmf.adapter.fservice.mpls.model.L3vpnInfo;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpInstance;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpLsp;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpPwInfo;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpRemotePeer;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpSession;
import com.huawei.vmf.adapter.fservice.mpls.model.Lsp;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsLabelStatistic;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamPw;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsStaticLabelSeg;
import com.huawei.vmf.adapter.fservice.mpls.model.Ring;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelPathConstraint;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.SwitchPwInfo;
import com.huawei.vmf.adapter.fservice.mpls.model.act.RingProtectSwitch;
import com.huawei.vmf.adapter.fservice.mpls.model.act.RsvpTeHotStandbySwitch;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsInstance;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsPw;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsPwTunnelInfo;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsSwitchInstance;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsSwitchPw;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsSwitchPwTunnelInfo;
import com.huawei.vmf.adapter.fservice.pwe3.service.IPwe3Service;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.fservice.vpls.model.TunnelInfo;
import com.huawei.vmf.adapter.fservice.vpls.model.VplsInstance;
import com.huawei.vmf.adapter.fservice.vpls.model.VplsLdpInst;
import com.huawei.vmf.adapter.fservice.vpls.model.VplsLdpPw;
import com.huawei.vmf.adapter.fservice.vpls.model.VplsLdpPwInfo;
import com.huawei.vmf.adapter.mpls.Activator;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public final class MplsDevDao {
    private Logger logger = RunLogger.getLogger(this.getClass());

    private MplsDevDao() {
    }

    public static MplsDevDao newInstance() {
        return new MplsDevDao();
    }

    public void loadCspfPreCalchops(Collection<CspfPreCalc> calcs) throws VMFException {
        QuerySchemaTranslatorContext queryContext;
        if (CollectionUtils.isEmpty(calcs)) {
            return;
        }
        DefaultMOService pollService = new DefaultMOService();
        HashMap<String, CspfPreCalc> srcCalcMap = new HashMap<String, CspfPreCalc>();
        Map<Integer, List<CspfPreCalc>> calcMap = this.groupVmfMOByDevId(calcs);
        for (Map.Entry<Integer, List<CspfPreCalc>> entry : calcMap.entrySet()) {
            queryContext = new QuerySchemaTranslatorContext(entry.getKey().intValue());
            for (CspfPreCalc calc : entry.getValue()) {
                queryContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)calc, null);
                String key = CommonUtil.composeTmpKey((Object[])new Object[]{calc.getDevID(), calc.getVrID(), calc.getDestination(), calc.getExplicitPathName()});
                srcCalcMap.put(key, calc);
            }
            pollService.addQueryJob(queryContext);
        }
        pollService.poll();
        for (Map.Entry<Integer, List<CspfPreCalc>> entry : calcMap.entrySet()) {
            queryContext = pollService.getQueryContext(entry.getKey().intValue());
            Collection devCalcs = queryContext.getQueryResult(CspfPreCalc.class);
            if (CollectionUtils.isEmpty((Collection)devCalcs)) continue;
            for (CspfPreCalc devCalc : devCalcs) {
                String key = CommonUtil.composeTmpKey((Object[])new Object[]{devCalc.getDevID(), devCalc.getVrID(), devCalc.getDestination(), devCalc.getExplicitPathName()});
                CspfPreCalc srcCspfPreCalc = (CspfPreCalc)srcCalcMap.get(key);
                if (srcCspfPreCalc == null) continue;
                srcCspfPreCalc.setCspfPreCalchops(devCalc.getCspfPreCalchops());
            }
        }
    }

    public void loadLdpRemotePeerState(Collection<LdpRemotePeer> peers) throws VMFException {
        QuerySchemaTranslatorContext queryContext;
        if (CollectionUtils.isEmpty(peers)) {
            return;
        }
        DefaultMOService pollService = new DefaultMOService();
        Map<Integer, List<LdpRemotePeer>> peerMap = this.groupVmfMOByDevId(peers);
        for (Map.Entry<Integer, List<LdpRemotePeer>> entry : peerMap.entrySet()) {
            LdpInstance ldpInstance = new LdpInstance();
            ldpInstance.setDevID(entry.getKey());
            ldpInstance.setVrID(Integer.valueOf(0));
            ldpInstance.setVrfName("_public_");
            queryContext = new QuerySchemaTranslatorContext(entry.getKey().intValue());
            ldpInstance.setLdpRemotePeers((Collection)entry.getValue());
            queryContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)ldpInstance, Arrays.asList("peerState"));
            pollService.addQueryJob(queryContext);
        }
        pollService.poll();
        HashMap<String, LdpRemotePeer> peerStateMap = new HashMap<String, LdpRemotePeer>();
        for (LdpRemotePeer ldpRemotePeer : peers) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{ldpRemotePeer.getDevID(), ldpRemotePeer.getVrID(), ldpRemotePeer.getVrfName(), ldpRemotePeer.getRemotePeerName()});
            peerStateMap.put(key, ldpRemotePeer);
        }
        for (Map.Entry entry : peerMap.entrySet()) {
            queryContext = pollService.getQueryContext(((Integer)entry.getKey()).intValue());
            Collection ldps = queryContext.getQueryResult(LdpInstance.class);
            for (LdpInstance ldp : ldps) {
                if (CollectionUtils.isEmpty((Collection)ldp.getLdpRemotePeers())) continue;
                for (LdpRemotePeer peer : ldp.getLdpRemotePeers()) {
                    if (peer.getPeerState() == null) continue;
                    String key = CommonUtil.composeTmpKey((Object[])new Object[]{peer.getDevID(), peer.getVrID(), peer.getVrfName(), peer.getRemotePeerName()});
                    LdpRemotePeer srcPeer = (LdpRemotePeer)peerStateMap.get(key);
                    if (srcPeer == null) continue;
                    srcPeer.setPeerState(peer.getPeerState());
                    srcPeer.setHelloHoldTime(peer.getHelloHoldTime());
                    srcPeer.setHelloSendTime(peer.getHelloSendTime());
                    srcPeer.setKeepaliveHoldTime(peer.getKeepaliveHoldTime());
                    srcPeer.setKeepaliveSendTime(peer.getKeepaliveSendTime());
                }
            }
        }
    }

    public void loadTunneLsps(Collection<RsvpTeTunnel> tunnels) throws VMFException {
        if (CollectionUtils.isEmpty(tunnels)) {
            return;
        }
        Map<Integer, List<RsvpTeTunnel>> tunnelDevMap = this.groupVmfMOByDevId(tunnels);
        DefaultMOService pollService = new DefaultMOService();
        List<String> queryTunnelFields = Arrays.asList("lsps", "workingLspId", "rsvpTeTunnelPathConstraint");
        List<String> queryConstraintFields = Arrays.asList("primaryLspId", "hotStandbyLspId", "ordinaryLspId", "bestEffortLspId");
        for (Map.Entry<Integer, List<RsvpTeTunnel>> entry : tunnelDevMap.entrySet()) {
            QuerySchemaTranslatorContext querySchemaTranslatorContext = new QuerySchemaTranslatorContext(entry.getKey().intValue());
            for (RsvpTeTunnel tunnel : entry.getValue()) {
                RsvpTeTunnel newTunnel = new RsvpTeTunnel();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnel, (VmfMO)newTunnel);
                newTunnel.setTunnelName(tunnel.getTunnelName());
                Lsp lsp = new Lsp();
                newTunnel.addLsps(Arrays.asList(lsp));
                RsvpTeTunnelPathConstraint constraint = new RsvpTeTunnelPathConstraint();
                newTunnel.setRsvpTeTunnelPathConstraint(constraint);
                querySchemaTranslatorContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)newTunnel, queryTunnelFields);
                querySchemaTranslatorContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)constraint, queryConstraintFields);
                pollService.addQueryJob(querySchemaTranslatorContext);
            }
        }
        pollService.poll();
        HashMap<String, RsvpTeTunnel> tunnelMap = new HashMap<String, RsvpTeTunnel>();
        for (RsvpTeTunnel rsvpTeTunnel : tunnels) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{rsvpTeTunnel.getDevID(), rsvpTeTunnel.getVrID(), rsvpTeTunnel.getTunnelName()});
            tunnelMap.put(key, rsvpTeTunnel);
        }
        for (Map.Entry entry : tunnelDevMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(((Integer)entry.getKey()).intValue());
            Collection tunnelResults = queryContext.getQueryResult(RsvpTeTunnel.class);
            if (CollectionUtils.isEmpty((Collection)tunnelResults)) continue;
            for (RsvpTeTunnel tunnel : tunnelResults) {
                Collection lsps = tunnel.getLsps();
                if (CollectionUtils.isEmpty((Collection)lsps)) continue;
                HashMap<String, Lsp> lspMap = new HashMap<String, Lsp>();
                Iterator iter = lsps.iterator();
                while (iter.hasNext()) {
                    Lsp lsp = (Lsp)iter.next();
                    if (lsp.getDevID() == null) {
                        iter.remove();
                        continue;
                    }
                    String lspKey = CommonUtil.composeTmpKey((Object[])new Object[]{lsp.getDevID(), lsp.getVrID(), lsp.getMplsSessionID(), lsp.getMplsTunnelIngressLSRId(), lsp.getMplsTunnelEgressLSRId(), lsp.getMplsTunnelInstance()});
                    if (null != lspMap.get(lspKey)) {
                        iter.remove();
                        continue;
                    }
                    lspMap.put(lspKey, lsp);
                }
                String key = CommonUtil.composeTmpKey((Object[])new Object[]{tunnel.getDevID(), tunnel.getVrID(), tunnel.getTunnelName()});
                RsvpTeTunnel srcTunnel = (RsvpTeTunnel)tunnelMap.get(key);
                srcTunnel.setLsps(lsps);
                srcTunnel.setWorkingLspId(tunnel.getWorkingLspId());
                RsvpTeTunnelPathConstraint srcConstraint = srcTunnel.getRsvpTeTunnelPathConstraint();
                if (srcConstraint == null) {
                    srcConstraint = new RsvpTeTunnelPathConstraint();
                    AsnTranslatorUtil.copyDevAndVrId((VmfMO)srcTunnel, (VmfMO)srcConstraint);
                    srcConstraint.setTunnelName(srcTunnel.getTunnelName());
                    srcTunnel.setRsvpTeTunnelPathConstraint(srcConstraint);
                }
                RsvpTeTunnelPathConstraint constraint = tunnel.getRsvpTeTunnelPathConstraint();
                srcConstraint.setPrimaryLspId(constraint.getPrimaryLspId());
                srcConstraint.setBestEffortLspId(constraint.getBestEffortLspId());
                srcConstraint.setOrdinaryLspId(constraint.getOrdinaryLspId());
                srcConstraint.setHotStandbyLspId(constraint.getHotStandbyLspId());
            }
        }
    }

    public void loadTunnelVPN(Collection<RsvpTeTunnel> tunnels, int queryType) throws VMFException {
        if (CollectionUtils.isEmpty(tunnels)) {
            return;
        }
        DefaultMOService pollService = new DefaultMOService();
        Map<Integer, List<RsvpTeTunnel>> tunnelDevMap = this.groupVmfMOByDevId(tunnels);
        this.loadTunnelVPNBqc(queryType, (IMOService)pollService, tunnelDevMap);
        pollService.poll();
        HashMap<String, RsvpTeTunnel> tunnelMap = new HashMap<String, RsvpTeTunnel>();
        for (RsvpTeTunnel rsvpTeTunnel : tunnels) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{rsvpTeTunnel.getDevID(), rsvpTeTunnel.getVrID(), rsvpTeTunnel.getTunnelName()});
            tunnelMap.put(key, rsvpTeTunnel);
        }
        for (Map.Entry entry : tunnelDevMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(((Integer)entry.getKey()).intValue());
            Collection resultTunnels = queryContext.getQueryResult(RsvpTeTunnel.class);
            if (CollectionUtils.isEmpty((Collection)resultTunnels)) continue;
            for (RsvpTeTunnel resultTunnel : resultTunnels) {
                String key = CommonUtil.composeTmpKey((Object[])new Object[]{resultTunnel.getDevID(), resultTunnel.getVrID(), resultTunnel.getTunnelName()});
                RsvpTeTunnel srcTunnel = (RsvpTeTunnel)tunnelMap.get(key);
                this.loadTunnelVPNDealVrfResult(resultTunnel, srcTunnel, queryType);
                this.loadTunnelVPNDealVsiResult(resultTunnel, srcTunnel, queryType);
                this.loadTunnelVPNDealVllResult(resultTunnel, srcTunnel, queryType);
            }
        }
    }

    public Collection<VpwsInstance> loadVpwsPwTunnel(Collection<VpwsInstance> vpwses) throws VMFException {
        if (CollectionUtils.isEmpty(vpwses)) {
            return null;
        }
        if (MplsUtil.isPtn()) {
            IDao dao = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null);
            vpwses = dao.queryByKey(VpwsInstance.class, vpwses, true);
            for (VpwsInstance pwInstance : vpwses) {
                for (VpwsPw pw : pwInstance.getVpwsPws()) {
                    Collection<Object> staticTunnels = new ArrayList<StaticTunnel>();
                    StaticTunnel tunnel = new StaticTunnel();
                    if (null == pw.getTunnelName()) {
                        tunnel.setTunnelName("--");
                    } else {
                        tunnel.setTunnelName(pw.getTunnelName());
                    }
                    tunnel.setDevID(pw.getDevID());
                    tunnel.setVrID(pw.getVrID());
                    staticTunnels.add(tunnel);
                    staticTunnels = dao.queryByKey(StaticTunnel.class, staticTunnels, true);
                    pw.addKeyRefMos(staticTunnels);
                }
            }
        } else {
            DefaultMOService pollService = new DefaultMOService();
            this.loadVpwsPwTunnelBqc(vpwses, (IMOService)pollService);
            pollService.poll();
            for (VpwsInstance vpwsInst : vpwses) {
                Collection vpwspwDevs = pollService.getQueryContext(vpwsInst.getDevID().intValue()).getQueryResult(VpwsPw.class);
                if (CollectionUtils.isEmpty((Collection)vpwspwDevs)) continue;
                Collection vpwspws = vpwsInst.getVpwsPws();
                for (VpwsPw pwInst : vpwspws) {
                    this.addTunnelInfoToVpwsPw(pwInst, vpwspwDevs);
                }
            }
            for (VpwsInstance vpws : vpwses) {
                Collection pws = vpws.getVpwsPws();
                if (CollectionUtils.isEmpty((Collection)pws)) continue;
                for (VpwsPw pw : pws) {
                    Collection infos = pw.getVpwsPwTunnelInfos();
                    if (pw.getPwRole() == null || CollectionUtils.isEmpty((Collection)infos)) continue;
                    pw.setPwType(vpws.getEncapsulateType());
                    Iterator iter = infos.iterator();
                    while (iter.hasNext()) {
                        VpwsPwTunnelInfo info = (VpwsPwTunnelInfo)iter.next();
                        if (info.getDevID() == null) {
                            iter.remove();
                            continue;
                        }
                        if (VpwsPwTunnelInfo.TUNNEL_TYPE_ENUM.LDP.equals(info.getTunnelType())) {
                            LdpLsp lsp = new LdpLsp();
                            AsnTranslatorUtil.copyDevAndVrId((VmfMO)info, (VmfMO)lsp);
                            lsp.setLspAddr(info.getPublicNextHop());
                            pw.addKeyRefMo((VmfMO)lsp);
                            continue;
                        }
                        if (VpwsPwTunnelInfo.TUNNEL_TYPE_ENUM.TE.equals(info.getTunnelType())) {
                            RsvpTeTunnel tunnel = new RsvpTeTunnel();
                            AsnTranslatorUtil.copyDevAndVrId((VmfMO)info, (VmfMO)tunnel);
                            tunnel.setTunnelName(info.getTunnelName());
                            pw.addKeyRefMo((VmfMO)tunnel);
                            continue;
                        }
                        this.logger.debug("The device not supoort load VpwsPw Tunnel now");
                    }
                }
            }
        }
        return vpwses;
    }

    public void addTunnelInfoToVpwsPw(VpwsPw vpwspw, Collection<VpwsPw> devVpwsPws) {
        for (VpwsPw pw : devVpwsPws) {
            if (!pw.getDevID().equals(vpwspw.getDevID()) || !pw.getInstanceName().equals(vpwspw.getInstanceName()) || !pw.getPeerIp().equals(vpwspw.getPeerIp()) || !pw.getPwId().equals(vpwspw.getPwId()) || !pw.getPwRole().equals(vpwspw.getPwRole())) continue;
            ArrayList<StaticTunnel> staticTunnels = new ArrayList<StaticTunnel>();
            StaticTunnel oTunnel = new StaticTunnel();
            oTunnel.setDevID(vpwspw.getDevID());
            oTunnel.setVrID(vpwspw.getVrID());
            oTunnel.setTunnelName(pw.getTunnelName());
            staticTunnels.add(oTunnel);
            String[] fieldNames = new String[]{"devID", "vrID", "tunnelName"};
            try {
                Collection tunnels = MplsDao.newInstance().queryByFields(StaticTunnel.class, fieldNames, staticTunnels, false);
                if (CollectionUtils.isEmpty((Collection)tunnels)) continue;
                vpwspw.addKeyRefMo((VmfMO)tunnels.iterator().next());
            }
            catch (VMFException e) {
                this.logger.debug("The device not supoort load Tunnel now");
            }
        }
    }

    public void loadVpwsSwitchPwTunnel(Collection<VpwsSwitchInstance> vpwses) throws VMFException {
        if (CollectionUtils.isEmpty(vpwses)) {
            return;
        }
        DefaultMOService pollService = new DefaultMOService();
        this.loadVpwsSwitchPwTunnelBqc(vpwses, (IMOService)pollService);
        pollService.poll();
        for (VpwsSwitchInstance vpws : vpwses) {
            Collection pws = vpws.getVpwsSwitchPws();
            if (CollectionUtils.isEmpty((Collection)pws)) continue;
            for (VpwsSwitchPw pw : pws) {
                Collection infos = pw.getVpwsSwitchPwTunnelInfos();
                if (CollectionUtils.isEmpty((Collection)infos)) continue;
                for (VpwsSwitchPwTunnelInfo info : infos) {
                    if (VpwsSwitchPwTunnelInfo.TUNNEL_TYPE_ENUM.LDP.equals(info.getTunnelType())) {
                        LdpLsp lsp = new LdpLsp();
                        AsnTranslatorUtil.copyDevAndVrId((VmfMO)info, (VmfMO)lsp);
                        lsp.setLspAddr(info.getPublicNextHop());
                        pw.addKeyRefMo((VmfMO)lsp);
                        continue;
                    }
                    if (VpwsSwitchPwTunnelInfo.TUNNEL_TYPE_ENUM.TE.equals(info.getTunnelType())) {
                        RsvpTeTunnel tunnel = new RsvpTeTunnel();
                        AsnTranslatorUtil.copyDevAndVrId((VmfMO)info, (VmfMO)tunnel);
                        tunnel.setTunnelName(info.getTunnelName());
                        pw.addKeyRefMo((VmfMO)tunnel);
                        continue;
                    }
                    this.logger.debug("The device not supoort load Vpws Switch Pw Tunnel now");
                }
            }
        }
    }

    public Collection<L3vpnInstance> loadVrfTunnel(Collection<L3vpnInstance> vrfs) throws VMFException {
        if (CollectionUtils.isEmpty(vrfs)) {
            return null;
        }
        if (MplsUtil.isPtn()) {
            IDao dao = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null);
            vrfs = dao.queryByKey(L3vpnInstance.class, vrfs, true);
            for (L3vpnInstance vrf : vrfs) {
                if (CollectionUtils.isEmpty((Collection)vrf.getVpnInstAFs())) continue;
                for (VpnInstAF af : vrf.getVpnInstAFs()) {
                    if (CollectionUtils.isEmpty((Collection)af.getVpnTunnels())) continue;
                    Collection<StaticTunnel> staticTunnels = new ArrayList();
                    for (VpnTunnel tunnelInfo : af.getVpnTunnels()) {
                        if (StringUtil.isEmpty((String)tunnelInfo.getTunnelName())) continue;
                        StaticTunnel tunnel = new StaticTunnel();
                        tunnel.setTunnelName(tunnelInfo.getTunnelName());
                        tunnel.setDevID(tunnelInfo.getDevID());
                        tunnel.setVrID(tunnelInfo.getVrID());
                        staticTunnels.add(tunnel);
                    }
                    staticTunnels = dao.queryByKey(StaticTunnel.class, staticTunnels, true);
                    for (StaticTunnel stunnel : staticTunnels) {
                        if (vrf.getKeyRefMos(StaticTunnel.class).contains(stunnel)) continue;
                        vrf.addKeyRefMo((VmfMO)stunnel);
                    }
                }
            }
        } else {
            DefaultMOService pollService = new DefaultMOService();
            Map<Integer, List<L3vpnInstance>> vrfMap = this.groupVmfMOByDevId(vrfs);
            List<String> vrfFieldNames = Arrays.asList("vpnInstAFs");
            List<String> vrfAFFieldNames = Arrays.asList("l3vpnTunnelInfos");
            for (Map.Entry<Integer, List<L3vpnInstance>> entry : vrfMap.entrySet()) {
                QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(entry.getKey().intValue());
                for (L3vpnInstance vrf : entry.getValue()) {
                    VpnInstAF vrfAF = new VpnInstAF();
                    AsnTranslatorUtil.copyDevAndVrId((VmfMO)vrf, (VmfMO)vrfAF);
                    vrfAF.setVrfName(vrf.getVrfName());
                    vrfAF.setAfType(VpnInstAF.AF_TYPE_ENUM.IPV4UNI);
                    vrf.addVpnInstAFs(Arrays.asList(vrfAF));
                    L3vpnTunnelInfo tunnelInfo = new L3vpnTunnelInfo();
                    AsnTranslatorUtil.copyDevAndVrId((VmfMO)vrfAF, (VmfMO)tunnelInfo);
                    tunnelInfo.setVrfName(vrfAF.getVrfName());
                    tunnelInfo.setAfType(vrfAF.getAfType());
                    vrfAF.addL3vpnTunnelInfos(Arrays.asList(tunnelInfo));
                    queryContext.addQueryAttributes(FeatureName.L3VPN, (VmfMO)vrf, vrfFieldNames);
                    queryContext.addQueryAttributes(FeatureName.L3VPN, (VmfMO)vrfAF, vrfAFFieldNames);
                }
                pollService.addQueryJob(queryContext);
            }
            pollService.poll();
            for (L3vpnInstance vrf : vrfs) {
                if (CollectionUtils.isEmpty((Collection)vrf.getVpnInstAFs())) continue;
                for (VpnInstAF af : vrf.getVpnInstAFs()) {
                    if (CollectionUtils.isEmpty((Collection)af.getL3vpnTunnelInfos())) continue;
                    for (L3vpnTunnelInfo tunnelInfo : af.getL3vpnTunnelInfos()) {
                        if (StringUtil.isEmpty((String)tunnelInfo.getTunnelName())) continue;
                        RsvpTeTunnel tunnel = new RsvpTeTunnel();
                        AsnTranslatorUtil.copyDevAndVrId((VmfMO)af, (VmfMO)tunnel);
                        tunnel.setTunnelName(tunnelInfo.getTunnelName());
                        if (vrf.getKeyRefMos(RsvpTeTunnel.class).contains(tunnel)) continue;
                        vrf.addKeyRefMo((VmfMO)tunnel);
                    }
                }
            }
        }
        return vrfs;
    }

    public void loadVsiPwTunnel(Collection<VplsInstance> vsis) throws VMFException {
        if (CollectionUtils.isEmpty(vsis)) {
            return;
        }
        DefaultMOService pollService = new DefaultMOService();
        this.loadVsiPwTunnelBqc(vsis, (IMOService)pollService);
        pollService.poll();
        for (VplsInstance vsi : vsis) {
            if (vsi.getVplsLdpInst() == null || CollectionUtils.isEmpty((Collection)vsi.getVplsLdpInst().getVplsLdpPws())) continue;
            for (VplsLdpPw pw : vsi.getVplsLdpInst().getVplsLdpPws()) {
                if (pw.getVplsLdpPwInfo() == null || CollectionUtils.isEmpty((Collection)pw.getVplsLdpPwInfo().getTunnelInfos())) continue;
                Iterator iter = pw.getVplsLdpPwInfo().getTunnelInfos().iterator();
                while (iter.hasNext()) {
                    TunnelInfo info = (TunnelInfo)iter.next();
                    if (info.getDevID() == null) {
                        iter.remove();
                        continue;
                    }
                    if (TunnelInfo.TUNNEL_TYPE_ENUM.LDP.equals(info.getTunnelType())) {
                        LdpLsp lsp = new LdpLsp();
                        AsnTranslatorUtil.copyDevAndVrId((VmfMO)info, (VmfMO)lsp);
                        lsp.setLspAddr(info.getPublicNextHop());
                        pw.addKeyRefMo((VmfMO)lsp);
                        continue;
                    }
                    if (TunnelInfo.TUNNEL_TYPE_ENUM.TE.equals(info.getTunnelType())) {
                        RsvpTeTunnel tunnel = new RsvpTeTunnel();
                        AsnTranslatorUtil.copyDevAndVrId((VmfMO)info, (VmfMO)tunnel);
                        tunnel.setTunnelName(info.getTunnelName());
                        pw.addKeyRefMo((VmfMO)tunnel);
                        continue;
                    }
                    this.logger.debug("The device not supoort load Vsi Pw Tunnel now");
                }
            }
        }
    }

    public Collection<CrossConnect> queryCrossConnectByLdpLsp(int devId, List<LdpLsp> ldpLsps) throws VMFException {
        if (CollectionUtils.isEmpty(ldpLsps)) {
            return Collections.emptyList();
        }
        DefaultMOService pollService = new DefaultMOService();
        HashMap<String, LdpLsp> ldpLspMap = new HashMap<String, LdpLsp>();
        QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(devId);
        for (LdpLsp ldpLsp : ldpLsps) {
            CrossConnect crossConnect = new CrossConnect();
            crossConnect.setDevID(ldpLsp.getDevID());
            crossConnect.setVrID(ldpLsp.getVrID());
            crossConnect.setXcIndex(ldpLsp.getLspIndex());
            ArrayList<String> queryAttributeNames = new ArrayList<String>();
            queryAttributeNames.add("xcInIfName");
            queryAttributeNames.add("xcInLabel");
            queryAttributeNames.add("xcIndex");
            queryAttributeNames.add("xcNextHop");
            queryAttributeNames.add("xcOutIfName");
            queryAttributeNames.add("xcOutLabel");
            queryContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)crossConnect, queryAttributeNames);
            pollService.addQueryJob(queryContext);
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{ldpLsp.getDevID(), ldpLsp.getVrID(), ldpLsp.getLspIndex().toString()});
            ldpLspMap.put(key, ldpLsp);
        }
        pollService.poll();
        Collection crossConnects = pollService.getQueryContext(devId).getQueryResult(CrossConnect.class);
        for (CrossConnect connect : crossConnects) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{connect.getDevID(), connect.getVrID(), connect.getXcIndex().toString()});
            connect.addKeyRefMo((VmfMO)ldpLspMap.get(key));
        }
        return crossConnects;
    }

    public List<LdpLsp> queryLdpLsp(Integer devId) throws VMFException {
        DefaultMOService pollService = new DefaultMOService();
        QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(devId.intValue());
        LdpInstance ldpInstance = new LdpInstance();
        LdpLsp ldpLsp = new LdpLsp();
        ldpInstance.addLdpLsps((Collection)CommonUtil.genList((Object[])new LdpLsp[]{ldpLsp}));
        queryContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)ldpInstance, null);
        pollService.addQueryJob(queryContext);
        pollService.poll();
        ArrayList<LdpLsp> ldpLspList = new ArrayList<LdpLsp>();
        Collection ldpInstanceList = pollService.getQueryContext(devId.intValue()).getQueryResult(LdpInstance.class);
        if (ldpInstanceList != null && ldpInstanceList.size() > 0) {
            for (LdpInstance ldpInst : ldpInstanceList) {
                if (ldpInst.getLdpLsps() == null || ldpInst.getLdpLsps().size() <= 0) continue;
                ldpLspList.addAll(ldpInst.getLdpLsps());
            }
        }
        return ldpLspList;
    }

    public List<LdpSession> queryLdpSessionsByDevIds(Collection<Integer> devIdList) throws VMFException {
        if (CollectionUtils.isEmpty(devIdList)) {
            return Collections.emptyList();
        }
        DefaultMOService pollService = new DefaultMOService();
        ArrayList<String> queryLdpNames = new ArrayList<String>();
        queryLdpNames.add("vrfName");
        ArrayList<String> queryLdpSessionNames = new ArrayList<String>();
        queryLdpSessionNames.add("ftFlag");
        queryLdpSessionNames.add("kaReceived");
        queryLdpSessionNames.add("kaSent");
        queryLdpSessionNames.add("localLsrid");
        queryLdpSessionNames.add("md5Flag");
        queryLdpSessionNames.add("negotiatedKaHoldTime");
        queryLdpSessionNames.add("peerLabelState");
        queryLdpSessionNames.add("peerLsrid");
        queryLdpSessionNames.add("reconnetTime");
        queryLdpSessionNames.add("recoveryTime");
        queryLdpSessionNames.add("sessionAge");
        queryLdpSessionNames.add("sessionDistMode");
        queryLdpSessionNames.add("sessionRole");
        queryLdpSessionNames.add("sessionState");
        queryLdpSessionNames.add("tcpDestAddr");
        queryLdpSessionNames.add("tcpSourceAddr");
        queryLdpSessionNames.add("vrfName");
        for (Integer devId : devIdList) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(devId.intValue());
            LdpInstance ldpInstance = new LdpInstance();
            LdpSession ldpSession = new LdpSession();
            ldpInstance.addLdpSessions((Collection)CommonUtil.genList((Object[])new LdpSession[]{ldpSession}));
            queryContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)ldpInstance, queryLdpNames);
            queryContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)ldpSession, queryLdpSessionNames);
            pollService.addQueryJob(queryContext);
        }
        pollService.poll();
        ArrayList<LdpSession> ldpSessionList = new ArrayList<LdpSession>();
        for (Integer devId : devIdList) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(devId.intValue());
            Collection ldpInstanceList = queryContext.getQueryResult(LdpInstance.class);
            if (CollectionUtils.isEmpty((Collection)ldpInstanceList)) continue;
            for (LdpInstance ldpInstance : ldpInstanceList) {
                Collection ldpSessions = ldpInstance.getLdpSessions();
                if (CollectionUtils.isEmpty((Collection)ldpSessions)) continue;
                ldpSessionList.addAll(ldpSessions);
            }
        }
        return ldpSessionList;
    }

    public Collection<Interface> queryTunnelInterface(Collection<RsvpTeTunnel> tunnels) throws VMFException {
        if (CollectionUtils.isEmpty(tunnels)) {
            return Collections.emptyList();
        }
        Map<Integer, List<RsvpTeTunnel>> tunnelMap = this.groupVmfMOByDevId(tunnels);
        DefaultMOService pollService = new DefaultMOService();
        for (Map.Entry<Integer, List<RsvpTeTunnel>> entry : tunnelMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(entry.getKey().intValue());
            for (RsvpTeTunnel tunnel : entry.getValue()) {
                Interface ifm = MplsUtil.translate2Interface(tunnel);
                queryContext.addQueryAttributes(FeatureName.IFM, (VmfMO)ifm, null);
            }
            pollService.addQueryJob(queryContext);
        }
        pollService.poll();
        ArrayList<Interface> interfeces = new ArrayList<Interface>();
        for (Integer devId : tunnelMap.keySet()) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(devId.intValue());
            Collection ifms = queryContext.getQueryResult(Interface.class);
            if (CollectionUtils.isEmpty((Collection)ifms)) continue;
            interfeces.addAll(ifms);
        }
        return interfeces;
    }

    public void syncOamStatus(List<MplsOamTunnel> mos) throws VMFException {
        if (CollectionUtils.isEmpty(mos)) {
            return;
        }
        Map<Integer, List<MplsOamTunnel>> tunnelMap = this.groupVmfMOByDevId(mos);
        DefaultMOService pollService = new DefaultMOService();
        String[] fieldNames = new String[]{"operStatus", "adminStatus"};
        for (Map.Entry<Integer, List<MplsOamTunnel>> entry : tunnelMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(entry.getKey().intValue());
            for (MplsOamTunnel tunnel : entry.getValue()) {
                MplsOamTunnel temp = new MplsOamTunnel();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnel, (VmfMO)temp);
                temp.setTunnelName(tunnel.getTunnelName());
                queryContext.addQueryAttributes(FeatureName.MPLSOAM, (VmfMO)temp, Arrays.asList(fieldNames));
            }
            pollService.addQueryJob(queryContext);
        }
        pollService.poll();
        HashMap<String, MplsOamTunnel> tunnelKeyMap = new HashMap<String, MplsOamTunnel>();
        for (MplsOamTunnel mo : mos) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{mo.getDevID(), mo.getVrID(), mo.getTunnelName()});
            tunnelKeyMap.put(key, mo);
        }
        for (Integer devId : tunnelMap.keySet()) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(devId.intValue());
            Collection tunnels = queryContext.getQueryResult(MplsOamTunnel.class);
            if (CollectionUtils.isEmpty((Collection)tunnels)) continue;
            for (MplsOamTunnel tunnel : tunnels) {
                if (tunnel.getLocalDetectStatus() == null) continue;
                String key = CommonUtil.composeTmpKey((Object[])new Object[]{tunnel.getDevID(), tunnel.getVrID(), tunnel.getTunnelName()});
                MplsOamTunnel mo = (MplsOamTunnel)tunnelKeyMap.get(key);
                mo.setOamActiveState(tunnel.getOamActiveState());
                mo.setLocalDetectStatus(tunnel.getLocalDetectStatus());
            }
        }
    }

    public void syncTunnelStatus(List<RsvpTeTunnel> mos, Map<VmfMO, ErrorInfo> moOperResult) throws VMFException {
        if (CollectionUtils.isEmpty(mos)) {
            return;
        }
        Map<Integer, List<RsvpTeTunnel>> tunnelMap = this.groupVmfMOByDevId(mos);
        DefaultMOService pollService = new DefaultMOService();
        String[] fieldNames = new String[]{"operStatus", "adminStatus"};
        for (Map.Entry<Integer, List<RsvpTeTunnel>> entry : tunnelMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(entry.getKey().intValue());
            for (RsvpTeTunnel tunnel : entry.getValue()) {
                RsvpTeTunnel temp = new RsvpTeTunnel();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnel, (VmfMO)temp);
                temp.setTunnelName(tunnel.getTunnelName());
                queryContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)temp, Arrays.asList(fieldNames));
            }
            pollService.addQueryJob(queryContext);
        }
        pollService.poll();
        if (moOperResult != null) {
            moOperResult.putAll(pollService.getAllErrorInfos());
        }
        HashMap<String, RsvpTeTunnel> tunnelKeyMap = new HashMap<String, RsvpTeTunnel>();
        for (RsvpTeTunnel mo : mos) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{mo.getDevID(), mo.getVrID(), mo.getTunnelName()});
            tunnelKeyMap.put(key, mo);
        }
        for (Integer devId : tunnelMap.keySet()) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(devId.intValue());
            Collection tunnels = queryContext.getQueryResult(RsvpTeTunnel.class);
            if (CollectionUtils.isEmpty((Collection)tunnels)) continue;
            for (RsvpTeTunnel tunnel : tunnels) {
                if (tunnel.getAdminStatus() == null) continue;
                String key = CommonUtil.composeTmpKey((Object[])new Object[]{tunnel.getDevID(), tunnel.getVrID(), tunnel.getTunnelName()});
                RsvpTeTunnel mo = (RsvpTeTunnel)tunnelKeyMap.get(key);
                mo.setOperStatus(tunnel.getOperStatus());
                mo.setAdminStatus(tunnel.getAdminStatus());
            }
        }
    }

    private void buildLoadVpnTunnelCondition(RsvpTeTunnel temp, int queryType) {
        com.huawei.vmf.adapter.fservice.mpls.model.VplsLdpPwInfo pwInfo;
        if (queryType == 0 || queryType == 1) {
            L3vpnInfo info = new L3vpnInfo();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)temp, (VmfMO)info);
            temp.addL3vpnInfos(Arrays.asList(info));
        }
        if (queryType == 0 || queryType == 2) {
            pwInfo = new com.huawei.vmf.adapter.fservice.mpls.model.VplsLdpPwInfo();
            temp.addVplsLdpPwInfos(Arrays.asList(pwInfo));
        }
        if (queryType == 0 || queryType == 3) {
            pwInfo = new LdpPwInfo();
            temp.addLdpPwInfos(Arrays.asList(pwInfo));
            SwitchPwInfo switchPwInfo = new SwitchPwInfo();
            temp.addSwitchPwInfos(Arrays.asList(switchPwInfo));
        }
    }

    private VpwsPw getVpwsPwForTunnel(Integer devID, String intefaceName, Long pwID, IPwe3Service service) {
        VpwsPw tmpVpwsPw = null;
        try {
            Collection vpwsInstances = service.getVpwsInstances(devID, intefaceName);
            if (null == vpwsInstances || 0 == vpwsInstances.size()) {
                return null;
            }
            VpwsInstance vpwsInstance = (VpwsInstance)vpwsInstances.iterator().next();
            Collection vpwsPws = vpwsInstance.getVpwsPws();
            if (null == vpwsPws || 0 == vpwsPws.size()) {
                return null;
            }
            for (VpwsPw tmpPw : vpwsPws) {
                if (!ObjectUtils.equals((Object)tmpPw.getPwId(), (Object)pwID)) continue;
                tmpVpwsPw = tmpPw;
                break;
            }
            return tmpVpwsPw;
        }
        catch (VMFException e) {
            this.logger.error("getVpwsInstances error,devID=" + devID + ",interfaceName=" + intefaceName, (Throwable)e);
            return null;
        }
    }

    private <T extends VmfMO> Map<Integer, List<T>> groupVmfMOByDevId(Collection<T> mos) {
        if (CollectionUtils.isEmpty(mos)) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<T>> moMap = new HashMap<Integer, List<T>>();
        for (VmfMO mo : mos) {
            ArrayList<VmfMO> list = (ArrayList<VmfMO>)moMap.get(mo.getDevID());
            if (list == null) {
                list = new ArrayList<VmfMO>();
                moMap.put(mo.getDevID(), list);
            }
            list.add(mo);
        }
        return moMap;
    }

    private void loadTunnelVPNBqc(int queryType, IMOService pollService, Map<Integer, List<RsvpTeTunnel>> tunnelDevMap) {
        ArrayList<String> queryTunnelVpnFields = new ArrayList<String>();
        if (queryType == 0 || queryType == 1) {
            queryTunnelVpnFields.add("l3vpnInfos");
        }
        if (queryType == 0 || queryType == 2) {
            queryTunnelVpnFields.add("vplsLdpPwInfos");
        }
        if (queryType == 0 || queryType == 3) {
            queryTunnelVpnFields.add("ldpPwInfos");
            queryTunnelVpnFields.add("switchPwInfos");
        }
        for (Map.Entry<Integer, List<RsvpTeTunnel>> entry : tunnelDevMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(entry.getKey().intValue());
            for (RsvpTeTunnel tunnel : entry.getValue()) {
                RsvpTeTunnel temp = new RsvpTeTunnel();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnel, (VmfMO)temp);
                temp.setTunnelName(tunnel.getTunnelName());
                this.buildLoadVpnTunnelCondition(temp, queryType);
                queryContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)temp, queryTunnelVpnFields);
            }
            pollService.addQueryJob(queryContext);
        }
    }

    private void loadTunnelVPNDealVllResult(RsvpTeTunnel resultTunnel, RsvpTeTunnel srcTunnel, int queryType) {
        IPwe3Service service = Activator.getService(IPwe3Service.class);
        if (queryType == 0 || queryType == 3) {
            VpwsSwitchPw pw;
            if (!CollectionUtils.isEmpty((Collection)resultTunnel.getLdpPwInfos()) && null != service) {
                for (LdpPwInfo info : resultTunnel.getLdpPwInfos()) {
                    if (info.getPwId() == null) continue;
                    srcTunnel.addLdpPwInfos(Arrays.asList(info));
                    pw = new VpwsPw();
                    AsnTranslatorUtil.copyDevAndVrId((VmfMO)info, (VmfMO)pw);
                    pw.setPwId(info.getPwId());
                    VpwsPw tmpVpwsPw = this.getVpwsPwForTunnel(info.getDevID(), info.getInterfaceName(), info.getPwId(), service);
                    if (null == tmpVpwsPw) continue;
                    pw.setPwType(tmpVpwsPw.getPwType());
                    srcTunnel.addKeyRefMo((VmfMO)pw);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)resultTunnel.getSwitchPwInfos())) {
                for (LdpPwInfo info : resultTunnel.getSwitchPwInfos()) {
                    if (info.getPwId() == null) continue;
                    pw = new VpwsSwitchPw();
                    AsnTranslatorUtil.copyDevAndVrId((VmfMO)info, (VmfMO)pw);
                    pw.setPwId(info.getPwId());
                    pw.setPeerIp(info.getPeerIp());
                    pw.setPwType(info.getEncapsulateType());
                    srcTunnel.addSwitchPwInfos(Arrays.asList(info));
                    srcTunnel.addKeyRefMo((VmfMO)pw);
                }
            }
        }
    }

    private void loadTunnelVPNDealVrfResult(RsvpTeTunnel resultTunnel, RsvpTeTunnel srcTunnel, int queryType) {
        if (!(queryType != 0 && queryType != 1 || CollectionUtils.isEmpty((Collection)resultTunnel.getL3vpnInfos()))) {
            for (L3vpnInfo info : resultTunnel.getL3vpnInfos()) {
                if (StringUtil.isEmpty((String)info.getVrfName())) continue;
                L3vpnInstance l3vpn = new L3vpnInstance();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)info, (VmfMO)l3vpn);
                l3vpn.setVrfName(info.getVrfName());
                srcTunnel.addL3vpnInfos(Arrays.asList(info));
                srcTunnel.addKeyRefMo((VmfMO)l3vpn);
            }
        }
    }

    private void loadTunnelVPNDealVsiResult(RsvpTeTunnel resultTunnel, RsvpTeTunnel srcTunnel, int queryType) {
        if (!(queryType != 0 && queryType != 2 || CollectionUtils.isEmpty((Collection)resultTunnel.getVplsLdpPwInfos()))) {
            for (com.huawei.vmf.adapter.fservice.mpls.model.VplsLdpPwInfo info : resultTunnel.getVplsLdpPwInfos()) {
                if (info.getNegotiationPwId() == null) continue;
                VplsLdpPw pw = new VplsLdpPw();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)info, (VmfMO)pw);
                pw.setNegotiationPwId(info.getNegotiationPwId());
                pw.setPeerIp(info.getPeerIp());
                pw.setInstanceName(info.getVsiName());
                srcTunnel.addVplsLdpPwInfos(Arrays.asList(info));
                srcTunnel.addKeyRefMo((VmfMO)pw);
            }
        }
    }

    private void loadVpwsPwTunnelBqc(Collection<VpwsInstance> vpwses, IMOService pollService) {
        Map<Integer, List<VpwsInstance>> vpwsDevMap = this.groupVmfMOByDevId(vpwses);
        for (Map.Entry<Integer, List<VpwsInstance>> entry : vpwsDevMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(entry.getKey().intValue());
            List<String> queryVpwsFields = Arrays.asList("vpwsPws", "encapsulateType");
            List<String> queryVpwsPwFields = Arrays.asList("tunnelName", "pwType", "pwRole");
            for (VpwsInstance vll : entry.getValue()) {
                Collection pws = vll.getVpwsPws();
                if (CollectionUtils.isEmpty((Collection)pws)) continue;
                queryContext.addQueryAttributes(FeatureName.L2VPN, (VmfMO)vll, queryVpwsFields);
                for (VpwsPw pw : pws) {
                    VpwsPwTunnelInfo info = new VpwsPwTunnelInfo();
                    pw.addVpwsPwTunnelInfos(Arrays.asList(info));
                    queryContext.addQueryAttributes(FeatureName.L2VPN, (VmfMO)pw, queryVpwsPwFields);
                    queryContext.addQueryAttributes(FeatureName.L2VPN, (VmfMO)info, null);
                }
            }
            pollService.addQueryJob(queryContext);
        }
    }

    private void loadVpwsSwitchPwTunnelBqc(Collection<VpwsSwitchInstance> vpwses, IMOService pollService) {
        Map<Integer, List<VpwsSwitchInstance>> vsiDevMap = this.groupVmfMOByDevId(vpwses);
        for (Map.Entry<Integer, List<VpwsSwitchInstance>> entry : vsiDevMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(entry.getKey().intValue());
            List<String> queryVpwsFields = Arrays.asList("vpwsSwitchPws");
            List<String> queryVpwsPwFields = Arrays.asList("vpwsSwitchPwTunnelInfos", "pwRole");
            for (VpwsSwitchInstance vpws : entry.getValue()) {
                Collection pws = vpws.getVpwsSwitchPws();
                if (CollectionUtils.isEmpty((Collection)pws)) continue;
                queryContext.addQueryAttributes(FeatureName.L2VPN, (VmfMO)vpws, queryVpwsFields);
                for (VpwsSwitchPw pw : pws) {
                    VpwsSwitchPwTunnelInfo info = new VpwsSwitchPwTunnelInfo();
                    pw.addVpwsSwitchPwTunnelInfos(Arrays.asList(info));
                    queryContext.addQueryAttributes(FeatureName.L2VPN, (VmfMO)pw, queryVpwsPwFields);
                    queryContext.addQueryAttributes(FeatureName.L2VPN, (VmfMO)info, null);
                }
            }
            pollService.addQueryJob(queryContext);
        }
    }

    private void loadVsiPwTunnelBqc(Collection<VplsInstance> vsis, IMOService pollService) {
        Map<Integer, List<VplsInstance>> vsiDevMap = this.groupVmfMOByDevId(vsis);
        List<String> queryVsiFields = Arrays.asList("vplsLdpInst");
        List<String> queryVsiInstFields = Arrays.asList("vplsLdpPws");
        List<String> queryVsiPwFields = Arrays.asList("vplsLdpPwInfo");
        List<String> queryVsiPwInfoFields = Arrays.asList("tunnelInfos");
        for (Map.Entry<Integer, List<VplsInstance>> entry : vsiDevMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(entry.getKey().intValue());
            for (VplsInstance vsi : entry.getValue()) {
                VplsLdpInst inst = vsi.getVplsLdpInst();
                if (inst == null || CollectionUtils.isEmpty((Collection)inst.getVplsLdpPws())) continue;
                queryContext.addQueryAttributes(FeatureName.L2VPN, (VmfMO)vsi, queryVsiFields);
                queryContext.addQueryAttributes(FeatureName.L2VPN, (VmfMO)inst, queryVsiInstFields);
                for (VplsLdpPw pw : inst.getVplsLdpPws()) {
                    VplsLdpPwInfo pwInfo = new VplsLdpPwInfo();
                    pw.setVplsLdpPwInfo(pwInfo);
                    TunnelInfo tunnelInfo = new TunnelInfo();
                    pwInfo.addTunnelInfos(Arrays.asList(tunnelInfo));
                    queryContext.addQueryAttributes(FeatureName.L2VPN, (VmfMO)pw, queryVsiPwFields);
                    queryContext.addQueryAttributes(FeatureName.L2VPN, (VmfMO)pwInfo, queryVsiPwInfoFields);
                    queryContext.addQueryAttributes(FeatureName.L2VPN, (VmfMO)tunnelInfo, null);
                }
            }
            pollService.addQueryJob(queryContext);
        }
    }

    public List<Long> queryFreeLabel(MplsStaticLabelSeg labelSeg) throws VMFException {
        DefaultMOService pollService = new DefaultMOService();
        String[] fieldNames = new String[]{"labelSegIndex", "labelEnd", "labelSegmentLength", "labelBegin"};
        QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(labelSeg.getDevID().intValue());
        MplsStaticLabelSeg tempLabelSeg = new MplsStaticLabelSeg();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)labelSeg, (VmfMO)tempLabelSeg);
        if (labelSeg.getLabelQuerySegmentLength() == null) {
            long segLength = labelSeg.getLabelEnd() - labelSeg.getLabelBegin();
            tempLabelSeg.setLabelQueryBegin(labelSeg.getLabelBegin());
            tempLabelSeg.setLabelQuerySegmentLength(Long.valueOf(segLength));
        } else {
            tempLabelSeg.setLabelQueryBegin(Long.valueOf(16L));
            tempLabelSeg.setLabelQuerySegmentLength(labelSeg.getLabelQuerySegmentLength());
        }
        queryContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)tempLabelSeg, Arrays.asList(fieldNames));
        pollService.addQueryJob(queryContext);
        pollService.poll();
        ArrayList<Long> freeLabels = new ArrayList<Long>();
        Collection labelSegs = queryContext.getQueryResult(MplsStaticLabelSeg.class);
        if (CollectionUtils.isEmpty((Collection)labelSegs)) {
            return freeLabels;
        }
        for (MplsStaticLabelSeg resultLabelSeg : labelSegs) {
            if (resultLabelSeg.getLabelBegin() == null || resultLabelSeg.getLabelEnd() == null) continue;
            Long begin = resultLabelSeg.getLabelBegin();
            while (begin <= resultLabelSeg.getLabelEnd()) {
                freeLabels.add(begin);
                Long l = begin;
                Long l2 = begin = Long.valueOf(begin + 1L);
            }
        }
        return freeLabels;
    }

    public Map<Integer, List<Long>> queryFreeReserveLabel(Collection<GresmPreReserve> labelSegs) throws VMFException {
        DefaultMOService pollService = new DefaultMOService();
        String[] fieldNames = new String[]{"resIndex"};
        for (GresmPreReserve labelSeg : labelSegs) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(labelSeg.getDevID().intValue());
            GresmPreReserve tempLabelSeg = new GresmPreReserve();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)labelSeg, (VmfMO)tempLabelSeg);
            tempLabelSeg.setResType(labelSeg.getResType());
            tempLabelSeg.setResPreResvNum(labelSeg.getResPreResvNum());
            queryContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)tempLabelSeg, Arrays.asList(fieldNames));
            pollService.addQueryJob(queryContext);
        }
        pollService.poll();
        HashMap<Integer, List<Long>> queryResult = new HashMap<Integer, List<Long>>();
        for (GresmPreReserve labelSeg : labelSegs) {
            ArrayList<Long> freeLabels = new ArrayList<Long>();
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(labelSeg.getDevID().intValue());
            Collection labelSegResults = queryContext.getQueryResult(GresmPreReserve.class);
            if (!CollectionUtils.isEmpty((Collection)labelSegResults)) {
                for (GresmPreReserve resultLabelSeg : labelSegResults) {
                    freeLabels.add(resultLabelSeg.getResIndex());
                }
            } else {
                ErrorInfo errorInfo = (ErrorInfo)pollService.getAllErrorInfos().get(labelSeg);
                if (null != errorInfo && 0 != errorInfo.getErrorCode()) {
                    throw new VMFException(errorInfo.getErrorCode(), labelSeg.getDevID().toString());
                }
            }
            queryResult.put(labelSeg.getDevID(), freeLabels);
        }
        return queryResult;
    }

    public void syncMplsRingSwitchStatus(Collection<MplsRing> dbRings, Context ctx) throws VMFException {
        if (CollectionUtils.isEmpty(dbRings)) {
            return;
        }
        DefaultMOService pollService = new DefaultMOService();
        Map<Integer, List<MplsRing>> ringDevMap = this.groupVmfMOByDevId(dbRings);
        String[] fieldNames = new String[]{"eastSwtichResult", "eastState", "westSwtichResult", "westState"};
        List<String> queryFieldNames = Arrays.asList(fieldNames);
        HashMap statusMap = new HashMap();
        for (Map.Entry<Integer, List<MplsRing>> entry : ringDevMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(entry.getKey().intValue());
            for (MplsRing mo : entry.getValue()) {
                queryContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)mo, queryFieldNames);
                HashMap<String, Integer> ringStatusMap = new HashMap<String, Integer>();
                ringStatusMap.put("eastSwtichResult", mo.getEastSwtichResult());
                ringStatusMap.put("eastState", mo.getEastState());
                ringStatusMap.put("westSwtichResult", mo.getWestSwtichResult());
                ringStatusMap.put("westState", mo.getWestState());
                statusMap.put(mo, ringStatusMap);
            }
            pollService.addQueryJob(queryContext);
        }
        pollService.poll();
        IMOChangeRecord record = ctx.addChangeRecord(MplsRing.class);
        for (MplsRing mo : dbRings) {
            Map ringStatusMap = (Map)statusMap.get(mo);
            if (!mo.getEastSwtichResult().equals(ringStatusMap.get("eastSwtichResult"))) {
                record.addModify((Object)mo, new PropertyChangeItem("eastSwtichResult"));
            }
            if (!mo.getEastState().equals(ringStatusMap.get("eastState"))) {
                record.addModify((Object)mo, new PropertyChangeItem("eastState"));
            }
            if (!mo.getWestSwtichResult().equals(ringStatusMap.get("westSwtichResult"))) {
                record.addModify((Object)mo, new PropertyChangeItem("westSwtichResult"));
            }
            if (mo.getWestState().equals(ringStatusMap.get("westState"))) continue;
            record.addModify((Object)mo, new PropertyChangeItem("westState"));
        }
        MplsDao.newInstance(ctx).merge(MplsRing.class, false);
    }

    public Map<VmfMO, ErrorInfo> executeSwitchStatusAction(Collection<RingProtectSwitch> switchMos) throws VMFException {
        if (CollectionUtils.isEmpty(switchMos)) {
            return null;
        }
        DefaultMOService pollService = new DefaultMOService();
        Map<Integer, List<RingProtectSwitch>> actionDevMap = this.groupVmfMOByDevId(switchMos);
        for (Map.Entry<Integer, List<RingProtectSwitch>> entry : actionDevMap.entrySet()) {
            ActionSchemaTranslatorContext actionContext = new ActionSchemaTranslatorContext(entry.getKey().intValue());
            for (RingProtectSwitch mo : entry.getValue()) {
                actionContext.addAction(FeatureName.MPLS, (VmfMO)mo);
            }
            pollService.addActionJob(actionContext);
        }
        pollService.execute();
        return pollService.getAllErrorInfos();
    }

    public Collection<MplsLabelStatistic> queryMplsStaticLabelSegById(Collection<Integer> devIds) throws VMFException {
        if (CollectionUtils.isEmpty(devIds)) {
            return Collections.emptyList();
        }
        List<String> queryAttributeNames = Arrays.asList("labelType", "minValue", "maxValue", "availableNum");
        DefaultMOService pollService = new DefaultMOService();
        for (Integer devId : devIds) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(devId.intValue());
            MplsLabelStatistic seg = new MplsLabelStatistic();
            seg.setDevID(devId);
            seg.setVrID(Integer.valueOf(0));
            seg.setLabelType(MplsLabelStatistic.LABEL_TYPE_ENUM.STATIC);
            queryContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)seg, queryAttributeNames);
            pollService.addQueryJob(queryContext);
        }
        pollService.poll();
        ArrayList<MplsLabelStatistic> resultList = new ArrayList<MplsLabelStatistic>();
        for (Integer devId : devIds) {
            MplsLabelStatistic label = new MplsLabelStatistic();
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(devId.intValue());
            Collection segs = queryContext.getQueryResult(MplsLabelStatistic.class);
            if (CollectionUtils.isEmpty((Collection)segs)) {
                this.logger.error("query MplsLabelStatistic error. devid = " + devId);
                return null;
            }
            for (MplsLabelStatistic seg : segs) {
                if (MplsLabelStatistic.LABEL_TYPE_ENUM.STATIC.intValue() == seg.getLabelType().intValue()) {
                    label.setDevID(devId);
                    label.setVrID(Integer.valueOf(0));
                    label.setMinValue(seg.getMinValue());
                }
                if (MplsLabelStatistic.LABEL_TYPE_ENUM.DYNAMIC.intValue() != seg.getLabelType().intValue()) continue;
                label.setMaxValue(seg.getMaxValue());
            }
            resultList.add(label);
        }
        return resultList;
    }

    public void syncCreateMplsRingMplsOam(Collection<MplsRing> mplsRings) throws VMFException {
        if (CollectionUtils.isEmpty(mplsRings)) {
            return;
        }
        Map<Integer, List<MplsRing>> ringMap = this.groupVmfMOByDevId(mplsRings);
        DefaultMOService pollService = new DefaultMOService();
        for (Map.Entry<Integer, List<MplsRing>> entry : ringMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(entry.getKey().intValue());
            for (MplsRing mplsRing : entry.getValue()) {
                BigInteger ringId = BigInteger.valueOf(mplsRing.getRingId().longValue());
                Ring eastRing = new Ring();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)mplsRing, (VmfMO)eastRing);
                eastRing.setRingId(ringId);
                eastRing.setRingDirection(Ring.RING_DIRECTION_ENUM.EAST);
                queryContext.addQueryAttributes(FeatureName.MPLSOAM, (VmfMO)eastRing, null);
                Ring westRing = new Ring();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)mplsRing, (VmfMO)westRing);
                westRing.setRingId(ringId);
                westRing.setRingDirection(Ring.RING_DIRECTION_ENUM.WEST);
                queryContext.addQueryAttributes(FeatureName.MPLSOAM, (VmfMO)westRing, null);
            }
            pollService.addQueryJob(queryContext);
        }
        pollService.poll();
        ArrayList<Ring> queryResults = new ArrayList<Ring>();
        for (Map.Entry<Integer, List<MplsRing>> entry : ringMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(entry.getKey().intValue());
            Collection rings = queryContext.getQueryResult(Ring.class);
            for (Ring ring : rings) {
                if (ring.getOamActiveState() == null) continue;
                queryResults.add(ring);
            }
        }
        Context ctx = new Context();
        IMOChangeRecord record = ctx.addChangeRecord(Ring.class);
        record.addCreate(queryResults);
        MplsDao.newInstance(ctx).merge(Ring.class, false);
    }

    public void syncTunnelOam(List<MplsOamTunnel> mos) throws VMFException {
        if (CollectionUtils.isEmpty(mos)) {
            return;
        }
        Map<Integer, List<MplsOamTunnel>> tunnelMap = this.groupVmfMOByDevId(mos);
        DefaultMOService pollService = new DefaultMOService();
        for (Map.Entry<Integer, List<MplsOamTunnel>> entry : tunnelMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(entry.getKey().intValue());
            for (MplsOamTunnel tunnel : entry.getValue()) {
                MplsOamTunnel temp = new MplsOamTunnel();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnel, (VmfMO)temp);
                temp.setTunnelName(tunnel.getTunnelName());
                queryContext.addQueryAttributes(FeatureName.MPLSOAM, (VmfMO)temp, null);
            }
            pollService.addQueryJob(queryContext);
        }
        pollService.poll();
        ArrayList<MplsOamTunnel> queryResults = new ArrayList<MplsOamTunnel>();
        for (Integer devId : tunnelMap.keySet()) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(devId.intValue());
            Collection tunnels = queryContext.getQueryResult(MplsOamTunnel.class);
            if (CollectionUtils.isEmpty((Collection)tunnels)) continue;
            for (MplsOamTunnel tunnel : tunnels) {
                if (tunnel.getLocalDetectStatus() == null) continue;
                queryResults.add(tunnel);
            }
        }
        Context ctx = new Context();
        IMOChangeRecord record = ctx.addChangeRecord(MplsOamTunnel.class);
        record.addCreate(queryResults);
        MplsDao.newInstance(ctx).merge(MplsOamTunnel.class, false);
    }

    public void syncPwOam(List<MplsOamPw> mos) throws VMFException {
        if (CollectionUtils.isEmpty(mos)) {
            return;
        }
        Map<Integer, List<MplsOamPw>> pwMap = this.groupVmfMOByDevId(mos);
        DefaultMOService pollService = new DefaultMOService();
        for (Map.Entry<Integer, List<MplsOamPw>> entry : pwMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(entry.getKey().intValue());
            for (MplsOamPw pw : entry.getValue()) {
                MplsOamPw temp = new MplsOamPw();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)pw, (VmfMO)temp);
                temp.setVcId(pw.getVcId());
                temp.setVcType(pw.getVcType());
                temp.setPeerIp(pw.getPeerIp());
                queryContext.addQueryAttributes(FeatureName.MPLSOAM, (VmfMO)temp, null);
            }
            pollService.addQueryJob(queryContext);
        }
        pollService.poll();
        ArrayList<MplsOamPw> queryResults = new ArrayList<MplsOamPw>();
        for (Integer devId : pwMap.keySet()) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(devId.intValue());
            Collection pws = queryContext.getQueryResult(MplsOamPw.class);
            if (CollectionUtils.isEmpty((Collection)pws)) continue;
            for (MplsOamPw pw : pws) {
                if (pw.getLocalDetectStatus() == null) continue;
                queryResults.add(pw);
            }
        }
        Collection oamTunnelFromDB = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(MplsOamPw.class, queryResults, true);
        ArrayList<MplsOamPw> needModifyOam = new ArrayList<MplsOamPw>();
        ArrayList<MplsOamPw> needAddOam = new ArrayList<MplsOamPw>();
        if (!CollectionUtils.isEmpty((Collection)oamTunnelFromDB)) {
            HashSet oamSet = new HashSet(oamTunnelFromDB);
            for (MplsOamPw oam : queryResults) {
                if (oamSet.contains(oam)) {
                    needModifyOam.add(oam);
                    continue;
                }
                needAddOam.add(oam);
            }
        } else {
            needAddOam = queryResults;
        }
        Context ctx = new Context();
        IMOChangeRecord record = ctx.addChangeRecord(MplsOamPw.class);
        if (!CollectionUtils.isEmpty(needAddOam)) {
            record.addCreate(needAddOam);
        }
        if (!CollectionUtils.isEmpty(needModifyOam)) {
            for (MplsOamPw modifyOam : needModifyOam) {
                record.addModify((Object)modifyOam, Arrays.asList("peerIp", "vcId", "vcType", "remoteLsrId", "remoteVcId", "remoteVcType", "detectPktType", "detectMode", "detectFrequence", "oamActiveState", "oamLossSd", "oamLossSf", "localDetectStatus", "localInvalidTime", "localDefectLocation", "localDefectType"));
            }
        }
        MplsDao.newInstance(ctx).merge(MplsOamPw.class, false);
    }

    public Collection<MplsOamPw> syncPwOamStatus(Collection<MplsOamPw> mos) throws VMFException {
        if (CollectionUtils.isEmpty(mos)) {
            return null;
        }
        Map<Integer, List<MplsOamPw>> pwMap = this.groupVmfMOByDevId(mos);
        DefaultMOService pollService = new DefaultMOService();
        String[] fieldNames = new String[]{"localDetectStatus"};
        for (Map.Entry<Integer, List<MplsOamPw>> entry : pwMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(entry.getKey().intValue());
            for (MplsOamPw pw : entry.getValue()) {
                MplsOamPw temp = new MplsOamPw();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)pw, (VmfMO)temp);
                temp.setPeerIp(pw.getPeerIp());
                temp.setVcId(pw.getVcId());
                temp.setVcType(pw.getVcType());
                queryContext.addQueryAttributes(FeatureName.MPLSOAM, (VmfMO)temp, Arrays.asList(fieldNames));
            }
            pollService.addQueryJob(queryContext);
        }
        pollService.poll();
        HashMap<String, MplsOamPw> pwKeyMap = new HashMap<String, MplsOamPw>();
        for (MplsOamPw mo : mos) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{mo.getDevID(), mo.getVrID(), mo.getPeerIp(), mo.getVcId(), mo.getVcType()});
            pwKeyMap.put(key, mo);
        }
        for (Integer devId : pwMap.keySet()) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(devId.intValue());
            Collection pws = queryContext.getQueryResult(MplsOamPw.class);
            if (CollectionUtils.isEmpty((Collection)pws)) continue;
            for (MplsOamPw pw : pws) {
                if (pw.getLocalDetectStatus() == null) continue;
                String key = CommonUtil.composeTmpKey((Object[])new Object[]{pw.getDevID(), pw.getVrID(), pw.getPeerIp(), pw.getVcId(), pw.getVcType()});
                MplsOamPw mo = (MplsOamPw)pwKeyMap.get(key);
                mo.setLocalDetectStatus(pw.getLocalDetectStatus());
            }
        }
        return pwKeyMap.values();
    }

    public Map<VmfMO, ErrorInfo> executeHsbSwitchAction(Collection<RsvpTeHotStandbySwitch> switchMos) throws VMFException {
        if (CollectionUtils.isEmpty(switchMos)) {
            return null;
        }
        DefaultMOService pollService = new DefaultMOService();
        Map<Integer, List<RsvpTeHotStandbySwitch>> actionDevMap = this.groupVmfMOByDevId(switchMos);
        for (Map.Entry<Integer, List<RsvpTeHotStandbySwitch>> entry : actionDevMap.entrySet()) {
            ActionSchemaTranslatorContext actionContext = new ActionSchemaTranslatorContext(entry.getKey().intValue());
            for (RsvpTeHotStandbySwitch mo : entry.getValue()) {
                actionContext.addAction(FeatureName.MPLS, (VmfMO)mo);
            }
            pollService.addActionJob(actionContext);
        }
        pollService.execute();
        return pollService.getAllErrorInfos();
    }

    public List<StaticTunnel> queryRemainBw(Collection<StaticTunnel> staticTunnels) throws VMFException {
        DefaultMOService pollService = new DefaultMOService();
        String[] fieldNames = new String[]{"remainBwCt0"};
        for (StaticTunnel staticTunnel : staticTunnels) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(staticTunnel.getDevID().intValue());
            StaticTunnel tempStaticTunnel = new StaticTunnel();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)staticTunnel, (VmfMO)tempStaticTunnel);
            tempStaticTunnel.setTunnelName(staticTunnel.getTunnelName());
            queryContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)tempStaticTunnel, Arrays.asList(fieldNames));
            pollService.addQueryJob(queryContext);
        }
        pollService.poll();
        ArrayList<StaticTunnel> devStaticTunnels = new ArrayList<StaticTunnel>();
        for (StaticTunnel staticTunnel : staticTunnels) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(staticTunnel.getDevID().intValue());
            Collection devStaticTunnel = queryContext.getQueryResult(StaticTunnel.class);
            devStaticTunnels.addAll(devStaticTunnel);
        }
        return devStaticTunnels;
    }
}

