/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.dao;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.mpls.dao.IStaticTunnelDaoExtPoint;
import com.huawei.vmf.adapter.framework.dao.CompareOperator;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.DefaultDao;
import com.huawei.vmf.adapter.framework.dao.RelationMetaMgr;
import com.huawei.vmf.adapter.framework.dao.SQLHelper;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.MplsOamTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.ExplicitPath;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsCommonCfg;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamPw;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.ReverseRsvpTeLsp;
import com.huawei.vmf.adapter.fservice.mpls.model.Ring;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelPathConstraint;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.TpNexthop;
import com.huawei.vmf.adapter.fservice.mpls.model.TpTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelGroup;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelPolicy;
import com.huawei.vmf.adapter.fservice.pwe3.fdn.VpwsPwFdnParser;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsPw;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.fservice.tpoam.model.Meg;
import com.huawei.vmf.adapter.fservice.tpoam.model.RingMe;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.springframework.util.CollectionUtils;

public final class MplsDao
extends DefaultDao {
    public MplsDao(SessionFactory sf, RelationMetaMgr relationMgr) {
        super(sf, relationMgr);
    }

    public static MplsDao newInstance() {
        return (MplsDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, new Context(), MplsDao.class);
    }

    public static MplsDao newInstance(Context context) {
        return (MplsDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, context, MplsDao.class);
    }

    public Collection<MplsOamTunnel> deleteOAMTunnelInfo(Collection<MplsOamTunnel> oamTunnels, Context context) {
        IMOChangeRecord ifmChangeRecord = context.addChangeRecord(MplsOamTunnel.class);
        for (MplsOamTunnel mo : oamTunnels) {
            List ifms = mo.getKeyRefMos(MplsOamTunnel.class);
            if (CollectionUtils.isEmpty((Collection)ifms)) continue;
            ifmChangeRecord.addDelete((Collection)ifms);
        }
        return oamTunnels;
    }

    public Collection<TunnelGroup> getAllMosByTunnelGroupKeys(Collection<TunnelGroup> tunnelGroupKeys, IAsnTranslationContext asnTranslatorContext, EOperationType operType) throws VMFException {
        Context cxt = asnTranslatorContext == null ? new Context() : asnTranslatorContext.getTransactionContext();
        Collection tunnelGroups = this.queryByKey(TunnelGroup.class, tunnelGroupKeys, true);
        MplsUtil.addMo2Context(cxt, operType, TunnelGroup.class, tunnelGroups);
        MplsUtil.processNotExistTunnelGroup(tunnelGroupKeys, tunnelGroups, cxt, operType);
        return tunnelGroups;
    }

    public boolean isBypassEnable(RsvpTeTunnel tunnel) throws VMFException {
        RsvpTeTunnelAdv adv = new RsvpTeTunnelAdv();
        adv.setDevID(tunnel.getDevID());
        adv.setVrID(tunnel.getVrID());
        adv.setTunnelName(tunnel.getTunnelName());
        Collection advs = this.queryByKey(RsvpTeTunnelAdv.class, Arrays.asList(adv), false);
        if (CollectionUtils.isEmpty((Collection)advs)) {
            return false;
        }
        adv = (RsvpTeTunnelAdv)advs.iterator().next();
        return adv.getBypassEnable() != null && adv.getBypassEnable() != false;
    }

    public void loadExplicitPathTunnels(Collection<ExplicitPath> explicitPaths) throws VMFException {
        if (CollectionUtils.isEmpty(explicitPaths)) {
            return;
        }
        ArrayList<RsvpTeTunnelPathConstraint> priCsts = new ArrayList<RsvpTeTunnelPathConstraint>();
        ArrayList<RsvpTeTunnelPathConstraint> hotCsts = new ArrayList<RsvpTeTunnelPathConstraint>();
        ArrayList<RsvpTeTunnelPathConstraint> ordCsts = new ArrayList<RsvpTeTunnelPathConstraint>();
        ArrayList<RsvpTeTunnelPathConstraint> bestCsts = new ArrayList<RsvpTeTunnelPathConstraint>();
        for (ExplicitPath explicitPath : explicitPaths) {
            RsvpTeTunnelPathConstraint constraint = new RsvpTeTunnelPathConstraint();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)explicitPath, (VmfMO)constraint);
            constraint.setPrimaryExplicitPathName(explicitPath.getExplicitPathName());
            priCsts.add(constraint);
            constraint = new RsvpTeTunnelPathConstraint();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)explicitPath, (VmfMO)constraint);
            constraint.setHotStandbyExplicitPathName(explicitPath.getExplicitPathName());
            hotCsts.add(constraint);
            constraint = new RsvpTeTunnelPathConstraint();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)explicitPath, (VmfMO)constraint);
            constraint.setOrdinaryExplicitPathName(explicitPath.getExplicitPathName());
            ordCsts.add(constraint);
            constraint = new RsvpTeTunnelPathConstraint();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)explicitPath, (VmfMO)constraint);
            constraint.setBestEffortExplicitPathName(explicitPath.getExplicitPathName());
            bestCsts.add(constraint);
        }
        HashSet<RsvpTeTunnelPathConstraint> constraints = new HashSet<RsvpTeTunnelPathConstraint>();
        constraints.addAll(this.queryConstraintFromDB(priCsts, "primaryExplicitPathName"));
        constraints.addAll(this.queryConstraintFromDB(hotCsts, "hotStandbyExplicitPathName"));
        constraints.addAll(this.queryConstraintFromDB(ordCsts, "ordinaryExplicitPathName"));
        constraints.addAll(this.queryConstraintFromDB(bestCsts, "bestEffortExplicitPathName"));
        HashMap<String, ArrayList<RsvpTeTunnel>> tunnelMap = new HashMap<String, ArrayList<RsvpTeTunnel>>();
        for (RsvpTeTunnelPathConstraint constraint : constraints) {
            RsvpTeTunnel tunnel = new RsvpTeTunnel();
            tunnel.setDevID(constraint.getDevID());
            tunnel.setVrID(constraint.getVrID());
            tunnel.setTunnelName(constraint.getTunnelName());
            for (String pathName : MplsUtil.getTunnelExpathNames(constraint)) {
                String key = CommonUtil.composeTmpKey((Object[])new Object[]{constraint.getDevID(), constraint.getVrID(), pathName});
                ArrayList<RsvpTeTunnel> tunnels = (ArrayList<RsvpTeTunnel>)tunnelMap.get(key);
                if (tunnels == null) {
                    tunnels = new ArrayList<RsvpTeTunnel>();
                    tunnelMap.put(key, tunnels);
                }
                tunnels.add(tunnel);
            }
        }
        for (ExplicitPath explicitPath : explicitPaths) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{explicitPath.getDevID(), explicitPath.getVrID(), explicitPath.getExplicitPathName()});
            List tunnels = (List)tunnelMap.get(key);
            explicitPath.addKeyRefMos((Collection)tunnels);
        }
    }

    public Collection<StaticTunnel> queryStaticTunnelByFdnKeys(Collection<StaticTunnel> fdnTunnels, boolean cascade) throws VMFException {
        IStaticTunnelDaoExtPoint dao = (IStaticTunnelDaoExtPoint)ExtendPointServiceMgr.getInstance().getExtendPoitService(IStaticTunnelDaoExtPoint.class);
        if (dao != null) {
            return dao.queryStaticTunnelByFdnKeys(fdnTunnels, cascade);
        }
        return this.queryByKey(StaticTunnel.class, fdnTunnels, cascade);
    }

    public void loadRsvpTeTunnelInterface(Collection<RsvpTeTunnel> tunnels, boolean cascade) throws VMFException {
        String key;
        if (CollectionUtils.isEmpty(tunnels)) {
            return;
        }
        List<Interface> conditions = MplsUtil.translate2Interfaces(tunnels);
        Collection ifms = this.queryByKey(Interface.class, conditions, cascade);
        HashMap<String, Interface> ifmMap = new HashMap<String, Interface>();
        for (Interface ifm : ifms) {
            key = CommonUtil.composeTmpKey((Object[])new Object[]{ifm.getDevID(), ifm.getVrID(), ifm.getIfName()});
            ifmMap.put(key, ifm);
        }
        for (RsvpTeTunnel tunnel : tunnels) {
            key = CommonUtil.composeTmpKey((Object[])new Object[]{tunnel.getDevID(), tunnel.getVrID(), tunnel.getTunnelName()});
            Interface ifm = (Interface)ifmMap.get(key);
            tunnel.addKeyRefMo((VmfMO)ifm);
        }
    }

    public Collection<StaticTunnel> loadStaticTunnelInterfaceByFdn(List<StaticTunnel> fdnTunnels, boolean cascade) throws VMFException {
        IStaticTunnelDaoExtPoint extDao = (IStaticTunnelDaoExtPoint)ExtendPointServiceMgr.getInstance().getExtendPoitService(IStaticTunnelDaoExtPoint.class);
        if (extDao != null) {
            Collection dbTunnels = extDao.queryStaticTunnelByFdnKeys(fdnTunnels, cascade);
            return dbTunnels;
        }
        this.loadStaticTunnelInterfaceByName(fdnTunnels, false);
        return fdnTunnels;
    }

    public void loadStaticTunnelInterfaceByName(Collection<StaticTunnel> tunnels, boolean cascade) throws VMFException {
        String key;
        if (CollectionUtils.isEmpty(tunnels)) {
            return;
        }
        List<Interface> conditions = MplsUtil.translateStaticTunnels2Interfaces(tunnels);
        Collection ifms = this.queryByKey(Interface.class, conditions, cascade);
        HashMap<String, Interface> ifmMap = new HashMap<String, Interface>();
        for (Interface ifm : ifms) {
            key = CommonUtil.composeTmpKey((Object[])new Object[]{ifm.getDevID(), ifm.getVrID(), ifm.getIfName()});
            ifmMap.put(key, ifm);
        }
        for (StaticTunnel tunnel : tunnels) {
            key = CommonUtil.composeTmpKey((Object[])new Object[]{tunnel.getDevID(), tunnel.getVrID(), tunnel.getTunnelName()});
            Interface ifm = (Interface)ifmMap.get(key);
            if (null == ifm) continue;
            tunnel.addKeyRefMo((VmfMO)ifm);
        }
    }

    public void loadTunnelIfAndKeyRef(Collection<RsvpTeTunnel> tunnels, boolean cascade) throws VMFException {
        this.loadRsvpTeTunnelInterface(tunnels, cascade);
        this.queryKeyRefMO(tunnels);
    }

    public void loadTunnelPolicyTunnels(Collection<TunnelPolicy> tunnelPolicies) throws VMFException {
        if (CollectionUtils.isEmpty(tunnelPolicies)) {
            return;
        }
        ArrayList tpTunnels = new ArrayList();
        for (TunnelPolicy tunnelPolicy : tunnelPolicies) {
            Collection tpNexthops = tunnelPolicy.getTpNexthops();
            if (CollectionUtils.isEmpty((Collection)tpNexthops)) continue;
            for (TpNexthop tpNexthop : tpNexthops) {
                Collection tmpTpTunnels = tpNexthop.getTpTunnels();
                if (CollectionUtils.isEmpty((Collection)tmpTpTunnels)) continue;
                tpTunnels.addAll(tmpTpTunnels);
            }
        }
        if (CollectionUtils.isEmpty(tpTunnels)) {
            return;
        }
        HashMap<String, TpTunnel> tpTunnelMap = new HashMap<String, TpTunnel>();
        for (TpTunnel tpTunnel : tpTunnels) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{tpTunnel.getDevID(), tpTunnel.getVrID(), tpTunnel.getTunnelName()});
            tpTunnelMap.put(key, tpTunnel);
        }
        ArrayList<RsvpTeTunnel> tunnelConditions = new ArrayList<RsvpTeTunnel>();
        for (TpTunnel tpTunnel : tpTunnels) {
            RsvpTeTunnel tunnel = new RsvpTeTunnel();
            tunnel.setDevID(tpTunnel.getDevID());
            tunnel.setVrID(tpTunnel.getVrID());
            tunnel.setTunnelName(tpTunnel.getTunnelName());
            tunnelConditions.add(tunnel);
        }
        Collection tunnels = this.queryByKey(RsvpTeTunnel.class, tunnelConditions, false);
        for (RsvpTeTunnel tunnel : tunnels) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{tunnel.getDevID(), tunnel.getVrID(), tunnel.getTunnelName()});
            TpTunnel tpTunnel = (TpTunnel)tpTunnelMap.get(key);
            tpTunnel.addKeyRefMo((VmfMO)tunnel);
        }
    }

    public Integer queryDevIDByLsrID(String lsrId) throws VMFException {
        MplsCommonCfg mplsCommonCfg = new MplsCommonCfg();
        mplsCommonCfg.setMplsLsrID(lsrId);
        String[] fieldNames = new String[]{"mplsLsrID"};
        List<MplsCommonCfg> conditions = Arrays.asList(mplsCommonCfg);
        Collection mplsCommonCfgs = this.queryByFields(MplsCommonCfg.class, fieldNames, conditions, false);
        if (!CollectionUtils.isEmpty((Collection)mplsCommonCfgs)) {
            return ((MplsCommonCfg)mplsCommonCfgs.iterator().next()).getDevID();
        }
        return -1;
    }

    public Map<String, Collection<Integer>> queryDevIDByLsrID(Collection<String> lsrIds) throws VMFException {
        HashMap<String, Collection<Integer>> result = new HashMap<String, Collection<Integer>>();
        if (CollectionUtils.isEmpty(lsrIds)) {
            return null;
        }
        ArrayList<MplsCommonCfg> conditions = new ArrayList<MplsCommonCfg>();
        for (String lsrId : lsrIds) {
            MplsCommonCfg mplsCommonCfg = new MplsCommonCfg();
            mplsCommonCfg.setMplsLsrID(lsrId);
            conditions.add(mplsCommonCfg);
        }
        String[] fieldNames = new String[]{"mplsLsrID"};
        Collection mplsCommonCfgs = this.queryByFields(MplsCommonCfg.class, fieldNames, conditions, false);
        if (!CollectionUtils.isEmpty((Collection)mplsCommonCfgs)) {
            for (MplsCommonCfg mplsCommonCfg : mplsCommonCfgs) {
                if (!CollectionUtils.isEmpty((Collection)((Collection)result.get(mplsCommonCfg.getMplsLsrID())))) {
                    ((Collection)result.get(mplsCommonCfg.getMplsLsrID())).add(mplsCommonCfg.getDevID());
                    continue;
                }
                ArrayList<Integer> devs = new ArrayList<Integer>();
                devs.add(mplsCommonCfg.getDevID());
                result.put(mplsCommonCfg.getMplsLsrID(), devs);
            }
            return result;
        }
        return null;
    }

    public void queryKeyRefMO(Collection<RsvpTeTunnel> tunnels) throws VMFException {
        if (CollectionUtils.isEmpty(tunnels)) {
            return;
        }
        ArrayList<ReverseRsvpTeLsp> reverseLspKey = new ArrayList<ReverseRsvpTeLsp>();
        HashMap<ReverseRsvpTeLsp, RsvpTeTunnel> reverseLspKey2Tunnel = new HashMap<ReverseRsvpTeLsp, RsvpTeTunnel>();
        for (RsvpTeTunnel t : tunnels) {
            ReverseRsvpTeLsp lsp = new ReverseRsvpTeLsp();
            lsp.setDevID(t.getDevID());
            lsp.setVrID(t.getVrID());
            lsp.setTunnelName(t.getTunnelName());
            reverseLspKey.add(lsp);
            reverseLspKey2Tunnel.put(lsp, t);
        }
        Collection reverseLsp = this.queryByKey(ReverseRsvpTeLsp.class, reverseLspKey, true);
        if (CollectionUtils.isEmpty((Collection)reverseLsp)) {
            return;
        }
        for (ReverseRsvpTeLsp lsp : reverseLsp) {
            RsvpTeTunnel tunnel = (RsvpTeTunnel)reverseLspKey2Tunnel.get(lsp);
            if (tunnel == null) continue;
            tunnel.addKeyRefMo((VmfMO)lsp);
        }
    }

    public String queryLsrIDByDevID(Integer devID) throws VMFException {
        MplsCommonCfg mplsCommonCfg = new MplsCommonCfg();
        mplsCommonCfg.setDevID(devID);
        String[] fieldNames = new String[]{"devID"};
        List<MplsCommonCfg> conditions = Arrays.asList(mplsCommonCfg);
        Collection mplsCommonCfgs = this.queryByFields(MplsCommonCfg.class, fieldNames, conditions, false);
        if (!CollectionUtils.isEmpty((Collection)mplsCommonCfgs)) {
            return ((MplsCommonCfg)mplsCommonCfgs.iterator().next()).getMplsLsrID();
        }
        return null;
    }

    public Collection<Interface> queryMplsAbleInterfaces(List<Integer> devIdList) throws VMFException {
        SQLHelper sqlHelper = SQLHelper.query(Interface.class, (SessionFactory)this.getSf());
        sqlHelper.selectAll(Interface.class);
        sqlHelper.whereIn(Interface.class, "devID", devIdList);
        sqlHelper.where(CompareOperator.AND);
        ArrayList<Integer> ifQTypes = new ArrayList<Integer>();
        ifQTypes.add(128);
        ifQTypes.add(2049);
        ifQTypes.add(65547);
        ifQTypes.add(65562);
        ifQTypes.add(18);
        ifQTypes.add(65563);
        ifQTypes.add(65564);
        ifQTypes.add(65543);
        ifQTypes.add(2050);
        ifQTypes.add(2051);
        ifQTypes.add(2049);
        sqlHelper.whereNotIn(Interface.class, "iQIfType", ifQTypes);
        Collection interfaces = this.executeQuery(Interface.class, sqlHelper, true, false);
        return interfaces;
    }

    public Collection<MplsOamTunnel> queryOAMByQAsnUniResID(QAsnUniResID qAsnUniResIDInfo) throws VMFException {
        ArrayList<MplsOamTunnel> oamTunnels = new ArrayList<MplsOamTunnel>();
        MplsOamTunnel oamTunnelKeyInfo = new MplsOamTunnel();
        MplsOamTunnelFdnParser fdnParser = new MplsOamTunnelFdnParser();
        QAsnUniResID resID = qAsnUniResIDInfo;
        MplsOamTunnel mo = (MplsOamTunnel)fdnParser.getIndexMo(resID);
        oamTunnelKeyInfo.setDevID(mo.getDevID());
        oamTunnelKeyInfo.setVrID(mo.getVrID());
        if (MplsUtil.isPtn() && "".equals(mo.getTunnelName())) {
            IFdnParser<StaticTunnel> tunnelFdnParser = MplsUtil.getStaticTunnelFdnParser();
            StaticTunnel tunnel = (StaticTunnel)tunnelFdnParser.getIndexMo(resID);
            oamTunnelKeyInfo.setTunnelName(MplsUtil.calStaticTunnelName(tunnel.getIngressLsrId(), tunnel.getTunnelId(), tunnel.getEgressLsrId(), tunnel.getLsrRole()));
        } else {
            oamTunnelKeyInfo.setTunnelName(mo.getTunnelName());
        }
        oamTunnels.add(oamTunnelKeyInfo);
        return this.queryByFields(MplsOamTunnel.class, new String[]{"devID", "tunnelName"}, oamTunnels, true);
    }

    public Collection<MplsOamPw> queryPwOAMByQAsnUniResID(QAsnUniResID qAsnUniResIDInfo) throws VMFException {
        ArrayList<MplsOamPw> oamPws = new ArrayList<MplsOamPw>();
        MplsOamPw oamPwKeyInfo = new MplsOamPw();
        VpwsPwFdnParser fdnParser = new VpwsPwFdnParser();
        QAsnUniResID resID = qAsnUniResIDInfo;
        VpwsPw mo = (VpwsPw)fdnParser.getIndexMo(resID);
        oamPwKeyInfo.setDevID(mo.getDevID());
        oamPwKeyInfo.setVrID(mo.getVrID());
        oamPwKeyInfo.setPeerIp(mo.getPeerIp());
        oamPwKeyInfo.setVcId(mo.getPwId());
        oamPwKeyInfo.setVcType(mo.getPwType());
        oamPws.add(oamPwKeyInfo);
        return this.queryByFields(MplsOamPw.class, new String[]{"devID", "vcId", "peerIp", "vcId", "vcType"}, oamPws, true);
    }

    public Collection<RsvpTeTunnel> queryRsvpTeTunnels(Collection<RsvpTeTunnel> fdnTunnels) throws VMFException {
        if (CollectionUtils.isEmpty(fdnTunnels)) {
            return Collections.emptyList();
        }
        Collection tunnels = this.queryByKey(RsvpTeTunnel.class, fdnTunnels, true);
        return tunnels;
    }

    public Map<String, TunnelPolicy> queryTnlPolicyByTunnel(Collection<RsvpTeTunnel> tunnels) throws VMFException {
        if (CollectionUtils.isEmpty(tunnels)) {
            return Collections.emptyMap();
        }
        ArrayList<TpTunnel> conditions = new ArrayList<TpTunnel>();
        for (RsvpTeTunnel tunnel : tunnels) {
            TpTunnel tpTunnel = new TpTunnel();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnel, (VmfMO)tpTunnel);
            tpTunnel.setTunnelName(tunnel.getTunnelName());
            conditions.add(tpTunnel);
        }
        String[] fieldNames = new String[]{"devID", "vrID", "tunnelName"};
        Collection tpTunnels = this.queryByFields(TpTunnel.class, fieldNames, conditions, false);
        if (CollectionUtils.isEmpty((Collection)tpTunnels)) {
            return Collections.emptyMap();
        }
        HashMap<String, RsvpTeTunnel> tunnelMap = new HashMap<String, RsvpTeTunnel>();
        for (RsvpTeTunnel tunnel : tunnels) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{tunnel.getDevID(), tunnel.getVrID(), tunnel.getTunnelName()});
            tunnelMap.put(key, tunnel);
        }
        HashMap<String, TunnelPolicy> tunnelPolicyMap = new HashMap<String, TunnelPolicy>();
        for (TpTunnel tpTunnel : tpTunnels) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{tpTunnel.getDevID(), tpTunnel.getVrID(), tpTunnel.getTnlPolicyName()});
            TunnelPolicy tunnelPolicy = (TunnelPolicy)tunnelPolicyMap.get(key);
            if (tunnelPolicy == null) {
                tunnelPolicy = new TunnelPolicy();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)tpTunnel, (VmfMO)tunnelPolicy);
                tunnelPolicy.setTnlPolicyName(tpTunnel.getTnlPolicyName());
                tunnelPolicyMap.put(key, tunnelPolicy);
            }
            String tunnelKey = CommonUtil.composeTmpKey((Object[])new Object[]{tpTunnel.getDevID(), tpTunnel.getVrID(), tpTunnel.getTunnelName()});
            RsvpTeTunnel tunnel = (RsvpTeTunnel)tunnelMap.get(tunnelKey);
            tunnelPolicy.addKeyRefMo((VmfMO)tunnel);
        }
        return tunnelPolicyMap;
    }

    public Collection<RsvpTeTunnel> queryTunnelByQAsnUniResID(QAsnUniResID qAsnUniResIDInfo) throws VMFException {
        ArrayList<RsvpTeTunnel> tunnels = new ArrayList<RsvpTeTunnel>();
        RsvpTeTunnel tunnelKeyInfo = new RsvpTeTunnel();
        MplsOamTunnelFdnParser fdnParser = new MplsOamTunnelFdnParser();
        QAsnUniResID resID = qAsnUniResIDInfo;
        MplsOamTunnel mo = (MplsOamTunnel)fdnParser.getIndexMo(resID);
        tunnelKeyInfo.setDevID(mo.getDevID());
        tunnelKeyInfo.setVrID(mo.getVrID());
        tunnelKeyInfo.setTunnelName(mo.getTunnelName());
        tunnels.add(tunnelKeyInfo);
        return this.queryByFields(RsvpTeTunnel.class, new String[]{"devID", "tunnelName"}, tunnels, true);
    }

    public Collection<RsvpTeTunnel> queryTunnelKey(Collection<TunnelGroup> TunnelGroupResults) throws VMFException {
        if (TunnelGroupResults.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RsvpTeTunnel> tunnels = new ArrayList<RsvpTeTunnel>();
        for (TunnelGroup tempTunnelGroup : TunnelGroupResults) {
            RsvpTeTunnel tunnelKeyInfo = new RsvpTeTunnel();
            tunnelKeyInfo.setDevID(tempTunnelGroup.getDevID());
            tunnelKeyInfo.setVrID(tempTunnelGroup.getVrID());
            tunnelKeyInfo.setTunnelName(tempTunnelGroup.getWorkingTunnel());
            tunnels.add(tunnelKeyInfo);
            String protectTunnelName = tempTunnelGroup.getProtectTunnel();
            if (StringUtil.isEmpty((String)protectTunnelName)) continue;
            RsvpTeTunnel backupTunnelKeyInfo = new RsvpTeTunnel();
            backupTunnelKeyInfo.setDevID(tempTunnelGroup.getDevID());
            backupTunnelKeyInfo.setVrID(tempTunnelGroup.getVrID());
            backupTunnelKeyInfo.setTunnelName(protectTunnelName);
            tunnels.add(backupTunnelKeyInfo);
        }
        return this.queryByFields(RsvpTeTunnel.class, new String[]{"devID", "tunnelName"}, tunnels, true);
    }

    public List<RsvpTeTunnel> queryTunnelsByTunnelPolicy(TunnelPolicy tunnelPolicy) throws VMFException {
        ArrayList<RsvpTeTunnel> tunnels = new ArrayList<RsvpTeTunnel>();
        TpTunnel tpTunnel = new TpTunnel();
        tpTunnel.setDevID(tunnelPolicy.getDevID());
        tpTunnel.setVrID(tunnelPolicy.getVrID());
        tpTunnel.setTnlPolicyName(tunnelPolicy.getTnlPolicyName());
        String[] fieldNames = new String[]{"devID", "vrID", "tnlPolicyName"};
        Collection tpTunnels = this.queryByFields(TpTunnel.class, fieldNames, Arrays.asList(tpTunnel), true);
        if (CollectionUtils.isEmpty((Collection)tpTunnels)) {
            return tunnels;
        }
        for (TpTunnel mo : tpTunnels) {
            RsvpTeTunnel tunnel = new RsvpTeTunnel();
            tunnel.setDevID(mo.getDevID());
            tunnel.setVrID(mo.getVrID());
            tunnel.setTunnelName(mo.getTunnelName());
            tunnels.add(tunnel);
        }
        return tunnels;
    }

    private Collection<RsvpTeTunnelPathConstraint> queryConstraintFromDB(Collection<RsvpTeTunnelPathConstraint> constraints, String constraintType) throws VMFException {
        String[] fieldNames = new String[]{"devID", "vrID", constraintType};
        return this.queryByFields(RsvpTeTunnelPathConstraint.class, fieldNames, constraints, false);
    }

    public Collection<Interface> querySupportMplsInterfaces(List<Integer> devIds, boolean cascade) throws VMFException {
        Collection ifms = MplsDao.newInstance().queryByNeID(Interface.class, devIds, cascade);
        if (CollectionUtils.isEmpty((Collection)ifms)) {
            return Collections.emptyList();
        }
        Iterator iter = ifms.iterator();
        while (iter.hasNext()) {
            Interface ifm = (Interface)iter.next();
            if (MplsUtil.isSupportMplsInterface(ifm.getIfName())) continue;
            iter.remove();
        }
        return ifms;
    }

    public void loadStaticCRTunnelNameById(Collection<StaticTunnel> mos) throws VMFException {
        if (CollectionUtils.isEmpty(mos)) {
            return;
        }
        ArrayList<StaticTunnel> conditions = new ArrayList<StaticTunnel>();
        HashMap<String, StaticTunnel> tunnelMap = new HashMap<String, StaticTunnel>();
        for (StaticTunnel mo : mos) {
            if (mo == null || mo.getDevID() == null || mo.getVrID() == null || mo.getTunnelId() == null || StringUtil.isEmpty((String)mo.getIngressLsrId()) || StringUtil.isEmpty((String)mo.getEgressLsrId())) continue;
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{mo.getDevID(), mo.getVrID(), mo.getTunnelId(), mo.getIngressLsrId(), mo.getEgressLsrId()});
            tunnelMap.put(key, mo);
            conditions.add(mo);
        }
        String[] fieldNames = new String[]{"devID", "vrID", "tunnelId"};
        Collection dbMos = MplsDao.newInstance().queryByFields(StaticTunnel.class, fieldNames, conditions, false);
        for (StaticTunnel dbMo : dbMos) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{dbMo.getDevID(), dbMo.getVrID(), dbMo.getTunnelId(), dbMo.getIngressLsrId(), dbMo.getEgressLsrId()});
            StaticTunnel mo = (StaticTunnel)tunnelMap.get(key);
            if (mo == null) continue;
            mo.setTunnelName(dbMo.getTunnelName());
        }
    }

    public void loadMplsRingOamInfo(Collection<MplsRing> mplsRings) throws VMFException {
        String[] tpOamRingQueryFieldNames;
        Collection dbTpOamRings;
        String key;
        if (CollectionUtils.isEmpty(mplsRings)) {
            return;
        }
        ArrayList<Ring> mplsOamRingConditions = new ArrayList<Ring>();
        ArrayList<RingMe> tpOamRingConditions = new ArrayList<RingMe>();
        ArrayList<Meg> megRingConditions = new ArrayList<Meg>();
        HashMap<String, MplsRing> mplsRingMap = new HashMap<String, MplsRing>();
        for (MplsRing mplsRing : mplsRings) {
            Ring ring = new Ring();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)mplsRing, (VmfMO)ring);
            ring.setRingId(AsnUtil.bigIntegerValue((Long)mplsRing.getRingId().longValue()));
            mplsOamRingConditions.add(ring);
            RingMe ringMe = new RingMe();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)mplsRing, (VmfMO)ringMe);
            ringMe.setRingId(Long.valueOf(mplsRing.getRingId().longValue()));
            tpOamRingConditions.add(ringMe);
            key = CommonUtil.composeTmpKey((Object[])new Object[]{mplsRing.getDevID(), mplsRing.getVrID(), mplsRing.getRingId()});
            mplsRingMap.put(key, mplsRing);
        }
        String[] mplsOamRingQueryFieldNames = new String[]{"devID", "vrID", "ringId"};
        Collection dbMplsOamRings = this.queryByFields(Ring.class, mplsOamRingQueryFieldNames, mplsOamRingConditions, false);
        if (!CollectionUtils.isEmpty((Collection)dbMplsOamRings)) {
            for (Ring mplsOamRing : dbMplsOamRings) {
                key = CommonUtil.composeTmpKey((Object[])new Object[]{mplsOamRing.getDevID(), mplsOamRing.getVrID(), mplsOamRing.getRingId()});
                MplsRing mplsRing = (MplsRing)mplsRingMap.get(key);
                mplsRing.setOamType(MplsRing.OAM_TYPE_ENUM.OAM);
                mplsRing.addKeyRefMo((VmfMO)mplsOamRing);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(dbTpOamRings = this.queryByFields(RingMe.class, tpOamRingQueryFieldNames = new String[]{"devID", "vrID", "ringId"}, tpOamRingConditions, false)))) {
            for (RingMe tpOamRing : dbTpOamRings) {
                String key2 = CommonUtil.composeTmpKey((Object[])new Object[]{tpOamRing.getDevID(), tpOamRing.getVrID(), tpOamRing.getRingId()});
                MplsRing mplsRing = (MplsRing)mplsRingMap.get(key2);
                mplsRing.addKeyRefMo((VmfMO)tpOamRing);
                Meg meg = new Meg();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)mplsRing, (VmfMO)meg);
                meg.setMegName(tpOamRing.getMegName());
                megRingConditions.add(meg);
                String megKey = CommonUtil.composeTmpKey((Object[])new Object[]{mplsRing.getDevID(), mplsRing.getVrID(), tpOamRing.getMegName()});
                mplsRingMap.put(megKey, mplsRing);
            }
            String[] megQueryFieldNames = new String[]{"devID", "vrID", "megName"};
            Collection megOamRings = this.queryByFields(Meg.class, megQueryFieldNames, megRingConditions, false);
            for (Meg megRing : megOamRings) {
                String key3 = CommonUtil.composeTmpKey((Object[])new Object[]{megRing.getDevID(), megRing.getVrID(), megRing.getMegName()});
                MplsRing mplsRing = (MplsRing)mplsRingMap.get(key3);
                mplsRing.addKeyRefMo((VmfMO)megRing);
                mplsRing.setOamType(MplsRing.OAM_TYPE_ENUM.TPOAM);
            }
        }
    }

    public Collection<StaticTunnel> queryStaticTunnelByFdn(Collection<String> fdns, boolean cascade) throws VMFException {
        if (CollectionUtils.isEmpty(fdns)) {
            return Collections.emptyList();
        }
        IFdnParser<StaticTunnel> fdnParser = MplsUtil.getStaticTunnelFdnParser();
        ArrayList<VmfMO> conditions = new ArrayList<VmfMO>();
        for (String fdn : fdns) {
            conditions.add(fdnParser.getIndexMo(fdn));
        }
        String[] fieldNames = null;
        fieldNames = MplsUtil.isPtn() ? new String[]{"devID", "vrID", "tunnelId", "ingressLsrId", "egressLsrId", "lsrRole"} : new String[]{"devID", "vrID", "tunnelName"};
        Collection tunnels = MplsDao.newInstance().queryByFields(StaticTunnel.class, fieldNames, conditions, cascade);
        for (StaticTunnel tunnel : tunnels) {
            tunnel.setFdn(fdnParser.getFdn((VmfMO)tunnel));
        }
        return tunnels;
    }
}

