/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.common;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tpoam_model.QAsnNEOamType;
import com.huawei.network.qasn.m_q_ip_tpoam_model.QAsnNEOamTypeList;
import com.huawei.network.qasn.m_q_ip_tpoam_model.QAsnTPOamResKey;
import com.huawei.network.qasn.m_q_ip_tpoam_model.QAsnTPOamResKeyList;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelBase;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.capability.AttrCapabilityInfo;
import com.huawei.vmf.adapter.framework.capability.CapabilityInfo;
import com.huawei.vmf.adapter.framework.capability.ICapabilityInfoMgr;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.mediation.FeatureAdapterInfo;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.MethodSchemaTranslatorContext;
import com.huawei.vmf.adapter.framework.util.ReflectHelper;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.model.DeployableMO;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.IStaticTunnelFdnParserExtPoint;
import com.huawei.vmf.adapter.fservice.mpls.fdn.MplsRingFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.fdn.StaticTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.method.MplsOamPwMethodMO;
import com.huawei.vmf.adapter.fservice.mpls.method.MplsOamRingMethodMO;
import com.huawei.vmf.adapter.fservice.mpls.method.MplsOamTunnelMethodMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsInterface;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.ReverseRsvpTeLsp;
import com.huawei.vmf.adapter.fservice.mpls.model.RingMapVirtualNode;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelPathConstraint;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelGroup;
import com.huawei.vmf.adapter.fservice.pwe3.fdn.VpwsPwFdnParser;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsInstance;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsPw;
import com.huawei.vmf.adapter.fservice.pwe3.service.IPwe3Service;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.fservice.tpoam.service.ITpoamService;
import com.huawei.vmf.adapter.mpls.Activator;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import com.huawei.vmf.common.mediation.AdapterInfo;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public final class MplsUtil {
    private static Class[] KEYREF_MO_CLAZZ_OF_TUNNEL = new Class[]{ReverseRsvpTeLsp.class};
    private static Logger logger = RunLogger.getLogger(MplsUtil.class);
    private static final String ATM_TRUNK = "Atm-Trunk";
    private static final String AUX = "Aux";
    private static final String CPOS = "Cpos";
    private static final String DIALER = "Dialer";
    private static final String E1 = "E1";
    private static final String IN_LOOPBACK = "InLoopBack";
    private static final String LOGIC_CHANNEL = "Logic-Channel";
    private static final String LOOPBACK = "LoopBack";
    private static final String M_TUNNEL = "MTunnel";
    private static final String NULL = "NULL";
    private static final String RPR = "Rpr";
    private static final String TUNNEL = "Tunnel";
    private static final String VC4 = "VC4";
    private static final String VC12 = "VC12";
    private static final String SERIAL = "Serial";
    private static final List<String> unSupporMplsInterfaceTypes = new ArrayList<String>();
    public static final int TP_OAM_TYPE_Y1731 = 2;
    public static final int OAM_TYPE_Y1711 = 1;
    public static final int TP_OAM_SERVICE_TYPE_LSP = 2;

    public static boolean isSupportMplsInterface(String ifName) {
        if (StringUtil.isEmpty((String)ifName)) {
            return false;
        }
        for (String ifType : unSupporMplsInterfaceTypes) {
            if (!ifName.startsWith(ifType)) continue;
            return false;
        }
        return true;
    }

    public static <T extends VmfMO> void addMo2Context(Context cxt, EOperationType operType, Class<T> clazz, Collection<T> mos) {
        if (CollectionUtils.isEmpty(mos)) {
            return;
        }
        for (VmfMO mo : mos) {
            MplsUtil.addMo2Context(cxt, operType, clazz, mo);
        }
    }

    public static void addModifyDbNull(RsvpTeTunnel tunnel, Context cxt, VmfMO chindOfTunnel, String ... propertyNames) {
        if (chindOfTunnel == null) {
            return;
        }
        if (MplsUtil.isCreate(cxt, (VmfMO)tunnel)) {
            ReflectHelper helper = ReflectHelper.getInstance();
            for (String fieldName : propertyNames) {
                helper.setPropertyValue((Object)chindOfTunnel, fieldName, (Object)null);
            }
            return;
        }
        AsnTranslatorUtil.addModifyDbNull((Context)cxt, (VmfMO)chindOfTunnel, (String[])propertyNames);
    }

    public static void cancelModify(IAsnTranslationContext context, VmfMO mo, String ... property) {
        if (property == null || property.length <= 0 || !EOperationType.MODIFY.equals((Object)context.getOperType())) {
            return;
        }
        IMOChangeRecord changeRecord = context.getTransactionContext().getChangeRecord(mo.getClass());
        if (changeRecord == null) {
            return;
        }
        for (String p : property) {
            changeRecord.cancelModify((Object)mo, p);
        }
    }

    public static void compareIfmIpAddress(Interface newIfm, Interface dbIfm, IMOChangeRecord<Ipv4Address> addressRecord) {
        Collection newIpv4Addresss = newIfm.getIpv4Addresss();
        Collection dbIpv4Addresss = dbIfm.getIpv4Addresss();
        addressRecord.clear();
        if (CollectionUtils.isEmpty((Collection)newIpv4Addresss) && CollectionUtils.isEmpty((Collection)dbIpv4Addresss)) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)newIpv4Addresss)) {
            newIfm.setIpv4Addresss(dbIpv4Addresss);
            addressRecord.addDelete(dbIpv4Addresss);
        } else if (CollectionUtils.isEmpty((Collection)dbIpv4Addresss)) {
            addressRecord.addCreate(newIpv4Addresss);
        } else {
            List propertyNames = CommonUtil.genList((Object[])new String[]{"addrType", "subnetMask"});
            for (Ipv4Address ipv4Address : newIpv4Addresss) {
                if (dbIpv4Addresss.contains(ipv4Address)) {
                    addressRecord.addModify((Object)ipv4Address, (Collection)propertyNames);
                    continue;
                }
                addressRecord.addCreate((Object)ipv4Address);
            }
            for (Ipv4Address dbIpv4Address : dbIpv4Addresss) {
                if (newIpv4Addresss.contains(dbIpv4Address)) continue;
                newIfm.getIpv4Addresss().add(dbIpv4Address);
                addressRecord.addDelete((Object)dbIpv4Address);
            }
        }
    }

    public static CapabilityInfo getMoCapInfo(VmfMO mo) throws com.huawei.vmf.common.exception.VMFException {
        ICapabilityInfoMgr service = Activator.getService(ICapabilityInfoMgr.class);
        if (service == null) {
            logger.error("get ICapabilityInfoMgr service failed");
            return null;
        }
        FeatureAdapterInfo featureAdapterInfo = new FeatureAdapterInfo(mo.getDevID().intValue(), mo.getFeatureName());
        CapabilityInfo capabilityInfo = (CapabilityInfo)service.getAdapterService((AdapterInfo)featureAdapterInfo);
        if (capabilityInfo == null) {
            logger.error("getCapabilityInfo failed , devID = {}, feature = {}", (Object)mo.getDevID(), (Object)mo.getFeatureName());
        }
        return capabilityInfo;
    }

    public static <T> T getMoDefaultValue(CapabilityInfo cap, Class<? extends VmfMO> moClazz, String attrName, Class<T> valueClazz) {
        if (cap == null) {
            return null;
        }
        Collection attrCaps = cap.getMoAttrCapabilityInfos(moClazz);
        if (attrCaps == null) {
            return null;
        }
        for (AttrCapabilityInfo attr : attrCaps) {
            if (!ObjectUtils.equals((Object)attrName, (Object)attr.getAttrName())) continue;
            Object defaultV = attr.getDefaultValue();
            if (defaultV == null) {
                return null;
            }
            if (ObjectUtils.equals(valueClazz, defaultV.getClass())) {
                return (T)defaultV;
            }
            return null;
        }
        return null;
    }

    public static ErrorInfo getMOOperResult(VmfMO mo, Map<VmfMO, ErrorInfo> moResults) {
        ErrorInfo err = moResults.get(mo);
        if (err != null) {
            return err;
        }
        return new ErrorInfo(0);
    }

    public static List<String> getTunnelExpathNames(RsvpTeTunnel tunnel) {
        return MplsUtil.getTunnelExpathNames(tunnel == null ? (RsvpTeTunnelPathConstraint)null : tunnel.getRsvpTeTunnelPathConstraint());
    }

    public static List<String> getTunnelExpathNames(RsvpTeTunnelPathConstraint constraint) {
        ArrayList<String> result = new ArrayList<String>();
        if (constraint == null) {
            return result;
        }
        if (!StringUtil.isEmpty((String)constraint.getBestEffortExplicitPathName())) {
            result.add(constraint.getBestEffortExplicitPathName());
        }
        if (!StringUtil.isEmpty((String)constraint.getPrimaryExplicitPathName())) {
            result.add(constraint.getPrimaryExplicitPathName());
        }
        if (!StringUtil.isEmpty((String)constraint.getOrdinaryExplicitPathName())) {
            result.add(constraint.getOrdinaryExplicitPathName());
        }
        if (!StringUtil.isEmpty((String)constraint.getHotStandbyExplicitPathName())) {
            result.add(constraint.getHotStandbyExplicitPathName());
        }
        return result;
    }

    public static boolean isCreate(Context cxt, VmfMO mo) {
        IMOChangeRecord changeRecord = cxt.getChangeRecord(mo.getClass());
        if (changeRecord == null) {
            return false;
        }
        return changeRecord.isCreated((Object)mo);
    }

    public static boolean isModify(IAsnTranslationContext context, VmfMO mo, String property) {
        if (!EOperationType.MODIFY.equals((Object)context.getOperType())) {
            return false;
        }
        IMOChangeRecord changeRecord = context.getTransactionContext().getChangeRecord(mo.getClass());
        if (changeRecord == null) {
            return false;
        }
        return changeRecord.isModified((Object)mo, property);
    }

    public static void processNotExistTunnelGroup(Collection<TunnelGroup> tunnelGroupKey, Collection<TunnelGroup> tunnelGroups, Context context, EOperationType operType) {
        HashSet<TunnelGroup> flag = new HashSet<TunnelGroup>();
        flag.addAll(tunnelGroups);
        for (TunnelGroup tunnelGroup : tunnelGroupKey) {
            if (MplsUtil.isExistTunnelGroup(flag, tunnelGroup)) continue;
            logger.info(String.format("tunnelGroup[%d,%s] do not exist opertype=%s", tunnelGroup.getDevID(), tunnelGroup.getWorkingTunnel(), operType.toString()));
            tunnelGroups.add(tunnelGroup);
            switch (operType) {
                case UNDEPLOY: 
                case DEPLOY: {
                    context.addMoOperResult((VmfMO)tunnelGroup, 555802843);
                    break;
                }
                case DELETE: {
                    context.addMoOperResult((VmfMO)tunnelGroup, 0);
                    break;
                }
            }
        }
    }

    public static void setDeployTunnelCotext(Collection<RsvpTeTunnel> tunnels, IAsnTranslationContext _context) throws VMFException {
        if (CollectionUtils.isEmpty(tunnels)) {
            return;
        }
        Context context = _context.getTransactionContext();
        MplsDao dao = MplsDao.newInstance();
        Collection<RsvpTeTunnel> dbTunnels = dao.queryRsvpTeTunnels(tunnels);
        dao.loadRsvpTeTunnelInterface(dbTunnels, true);
        for (RsvpTeTunnel fdnTunnel : tunnels) {
            if (dbTunnels.contains(fdnTunnel)) continue;
            AsnTranslatorUtil.addMoOperResult((VmfMO)fdnTunnel, (Context)context, (int)1107501604);
        }
        RsvpTeTunnelFdnParser fdnParser = new RsvpTeTunnelFdnParser();
        PropertyChangeItem deployStatusItem = new PropertyChangeItem("deployStatus");
        for (RsvpTeTunnel dbTunnel : dbTunnels) {
            dbTunnel.setFdn(fdnParser.getFdn((VmfMO)dbTunnel));
            List ifms = dbTunnel.getKeyRefMos(Interface.class);
            Interface ifm = null;
            if (!CollectionUtils.isEmpty((Collection)ifms)) {
                ifm = (Interface)ifms.iterator().next();
            }
            MplsUtil.setDeployTunnelKeyrefIfmContext(ifm, context);
            IMOChangeRecord recorder = context.addChangeRecord(RsvpTeTunnel.class);
            dbTunnel.setDeployStatus(Integer.valueOf(1));
            recorder.addModify((Object)dbTunnel, deployStatusItem);
        }
    }

    public static void setDeployStaticTunnelChanges(List<StaticTunnel> staticFdnTunnels, Context ctx) {
        Collection<StaticTunnel> dbStaticTunnels = null;
        try {
            MplsDao dao = MplsDao.newInstance();
            dbStaticTunnels = dao.queryStaticTunnelByFdnKeys(staticFdnTunnels, false);
            dao.loadStaticTunnelInterfaceByName(dbStaticTunnels, true);
        }
        catch (VMFException e) {
            for (StaticTunnel mo : staticFdnTunnels) {
                AsnTranslatorUtil.addMoOperResult((VmfMO)mo, (Context)ctx, (int)e.getErrorCode());
            }
            logger.error("query StaticTunnel & Interface failed!", (Throwable)e);
            return;
        }
        IMOChangeRecord devRecord = ctx.addChangeRecord(StaticTunnel.class);
        IMOChangeRecord dbRecord = ctx.addDBChangeRecord(StaticTunnel.class);
        IFdnParser<StaticTunnel> staticTunnelFdnParser = MplsUtil.getStaticTunnelFdnParser();
        for (StaticTunnel fdnTunnel : staticFdnTunnels) {
            if (MplsUtil.containsMo(dbStaticTunnels, fdnTunnel, staticTunnelFdnParser)) continue;
            AsnTranslatorUtil.addMoOperResult((VmfMO)fdnTunnel, (Context)ctx, (int)1107501604);
            devRecord.addCreate((Object)fdnTunnel);
        }
        PropertyChangeItem deployStatusItem = new PropertyChangeItem("deployStatus");
        for (StaticTunnel dbStaticTunnel : dbStaticTunnels) {
            dbStaticTunnel.setExpValue(null == dbStaticTunnel.getExpValue() || -1 == dbStaticTunnel.getExpValue() ? StaticTunnel.EXP_VALUE_ENUM.NONE : dbStaticTunnel.getExpValue());
            devRecord.addCreate((Object)dbStaticTunnel);
            dbStaticTunnel.setDeployStatus(Integer.valueOf(1));
            dbRecord.addModify((Object)dbStaticTunnel, deployStatusItem);
            List ifms = dbStaticTunnel.getKeyRefMos(Interface.class);
            Interface ifm = null;
            if (!CollectionUtils.isEmpty((Collection)ifms)) {
                ifm = (Interface)ifms.iterator().next();
            }
            MplsUtil.setDeployTunnelKeyrefIfmContext(ifm, ctx);
            MplsUtil.setDeployTunnelKeyrefOamContext(dbStaticTunnel, ctx);
        }
    }

    private static void setDeployTunnelKeyrefOamContext(StaticTunnel staticTunnel, Context ctx) {
        ArrayList<MplsOamTunnel> tunnelOamList = new ArrayList<MplsOamTunnel>();
        MplsOamTunnel tunnelOam = new MplsOamTunnel();
        tunnelOam.setDevID(staticTunnel.getDevID());
        tunnelOam.setVrID(staticTunnel.getVrID());
        tunnelOam.setTunnelName(staticTunnel.getTunnelName());
        tunnelOamList.add(tunnelOam);
        try {
            Collection oamTunnelFromDB = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(MplsOamTunnel.class, tunnelOamList, true);
            if (!CollectionUtils.isEmpty((Collection)oamTunnelFromDB)) {
                staticTunnel.addKeyRefMos(oamTunnelFromDB);
                MplsUtil.addTunnelOamDeployRecord(ctx, staticTunnel.getKeyRefMos(MplsOamTunnel.class));
            }
        }
        catch (VMFException e) {
            logger.error("the function of setDeployTunnelKeyrefOamContext failed.");
        }
    }

    private static void addTunnelOamDeployRecord(Context context, List<MplsOamTunnel> tpKeyRefMos) throws VMFException {
        if (CollectionUtils.isEmpty(tpKeyRefMos)) {
            return;
        }
        IMOChangeRecord tpMoChangeRecord = context.addDBChangeRecord(MplsOamTunnel.class);
        PropertyChangeItem deployStatusItem = new PropertyChangeItem("deployStatus");
        for (MplsOamTunnel tunnelOam : tpKeyRefMos) {
            if (tunnelOam.isDeployed()) continue;
            tunnelOam.setDeployStatus(Integer.valueOf(1));
            tpMoChangeRecord.addModify((Object)tunnelOam, deployStatusItem);
            if (null == tunnelOam.getSendEnable()) {
                context.addChangeRecord(MplsOamTunnel.class).addModify((Object)tunnelOam, Arrays.asList("bdiFrequence", "detectFrequence", "detectMode", "detectPktType", "localDetectStatus", "localInvalidTime", "lspName", "oamActiveState", "oamLossSd", "oamLossSf", "receiveEnable", "tunnelDirection", "tunnelName", "tunnelType"));
                continue;
            }
            context.addChangeRecord(MplsOamTunnel.class).addModify((Object)tunnelOam, Arrays.asList("bdiFrequence", "detectFrequence", "detectMode", "detectPktType", "localDetectStatus", "localInvalidTime", "lspName", "oamActiveState", "oamLossSd", "oamLossSf", "receiveEnable", "sendEnable", "tunnelDirection", "tunnelName", "tunnelType"));
        }
    }

    public static Interface translate2Interface(Integer devID, Integer vrID, String ifName) {
        Interface ifm = new Interface();
        ifm.setDevID(devID);
        ifm.setVrID(vrID);
        ifm.setIfName(ifName);
        return ifm;
    }

    public static Interface translate2Interface(RsvpTeTunnel tunnel) {
        if (tunnel == null) {
            return null;
        }
        Interface ifm = new Interface();
        ifm.setDevID(tunnel.getDevID());
        ifm.setVrID(tunnel.getVrID());
        ifm.setIfName(tunnel.getTunnelName());
        InterfaceFdnParser fdnParser = new InterfaceFdnParser();
        ifm.setFdn(fdnParser.getFdn(ifm));
        ifm.setiQIfType(Integer.valueOf(65547));
        return ifm;
    }

    public static Interface translate2Interface(StaticTunnel tunnel) {
        if (tunnel == null || StringUtil.isEmpty((String)tunnel.getTunnelName())) {
            return null;
        }
        Interface ifm = new Interface();
        ifm.setDevID(tunnel.getDevID());
        ifm.setVrID(tunnel.getVrID());
        ifm.setIfName(tunnel.getTunnelName());
        InterfaceFdnParser fdnParser = new InterfaceFdnParser();
        ifm.setFdn(fdnParser.getFdn(ifm));
        ifm.setiQIfType(Integer.valueOf(65547));
        return ifm;
    }

    public static List<Interface> translate2Interfaces(Collection<RsvpTeTunnel> tunnels) {
        if (CollectionUtils.isEmpty(tunnels)) {
            return Collections.emptyList();
        }
        ArrayList<Interface> ifms = new ArrayList<Interface>();
        for (RsvpTeTunnel tunnel : tunnels) {
            Interface ifm = MplsUtil.translate2Interface(tunnel);
            if (ifm == null) continue;
            ifms.add(ifm);
        }
        return ifms;
    }

    public static List<Interface> translateStaticTunnels2Interfaces(Collection<StaticTunnel> tunnels) {
        if (CollectionUtils.isEmpty(tunnels)) {
            return Collections.emptyList();
        }
        ArrayList<Interface> ifms = new ArrayList<Interface>();
        for (StaticTunnel tunnel : tunnels) {
            Interface ifm;
            if (StaticTunnel.LSR_ROLE_ENUM.TRANSIT.intValue() == tunnel.getLsrRole().intValue() || (ifm = MplsUtil.translate2Interface(tunnel)) == null) continue;
            ifms.add(ifm);
        }
        return ifms;
    }

    public static Map<String, RsvpTeTunnel> translaterTunnelMap(Collection<RsvpTeTunnel> tunnels) {
        HashMap<String, RsvpTeTunnel> tunnelMap = new HashMap<String, RsvpTeTunnel>();
        for (RsvpTeTunnel tunnel : tunnels) {
            tunnelMap.put(tunnel.getDevID() + tunnel.getTunnelName(), tunnel);
        }
        return tunnelMap;
    }

    private static <T extends VmfMO> void addMo2Context(Context cxt, EOperationType operType, Class<T> clazz, T mo) {
        switch (operType) {
            case CREATE: 
            case PREDEPLOY: {
                cxt.addChangeRecord(clazz).addCreate(mo);
                break;
            }
            case DEPLOY: {
                if (mo instanceof DeployableMO) {
                    if (Integer.valueOf(1).equals(((DeployableMO)mo).getDeployStatus())) break;
                    ((DeployableMO)mo).setDeployStatus(Integer.valueOf(1));
                    cxt.addDBChangeRecord(clazz).addModify(mo, new PropertyChangeItem("deployStatus", (Object)1, (Object)0));
                }
                cxt.addChangeRecord(clazz).addCreate(mo);
                break;
            }
            case UNDEPLOY: {
                if (mo instanceof DeployableMO) {
                    if (!((DeployableMO)mo).getDeployStatus().equals(1)) break;
                    ((DeployableMO)mo).setDeployStatus(Integer.valueOf(0));
                    cxt.addDBChangeRecord(clazz).addModify(mo, new PropertyChangeItem("deployStatus", (Object)0, (Object)1));
                }
                cxt.addChangeRecord(clazz).addDelete(mo);
                break;
            }
            case DELETE: {
                cxt.addChangeRecord(clazz).addDelete(mo);
                break;
            }
            case GET: {
                break;
            }
            default: {
                logger.error("unsupported oper-type:" + operType.name());
                return;
            }
        }
    }

    private static Collection<VmfMO> getKeyRefMOsOfTunnel(RsvpTeTunnel tunnel) {
        ArrayList<VmfMO> keyRefMOs = new ArrayList<VmfMO>();
        for (Class clazz : KEYREF_MO_CLAZZ_OF_TUNNEL) {
            List keyRefMO = tunnel.getKeyRefMos(clazz);
            if (CollectionUtils.isEmpty((Collection)keyRefMO)) continue;
            keyRefMOs.addAll(keyRefMO);
        }
        return keyRefMOs;
    }

    private static boolean isExistTunnelGroup(Collection<TunnelGroup> tunnelGroupList, TunnelGroup tunnelGroup) {
        if (CollectionUtils.isEmpty(tunnelGroupList)) {
            return false;
        }
        for (TunnelGroup tempTunnelGroup : tunnelGroupList) {
            if (!tunnelGroup.getDevID().equals(tempTunnelGroup.getDevID()) || !tunnelGroup.getVrID().equals(tempTunnelGroup.getVrID()) || !tunnelGroup.getWorkingTunnel().equals(tempTunnelGroup.getWorkingTunnel())) continue;
            return true;
        }
        return false;
    }

    private static void setDeployTunnelKeyrefIfmContext(Interface ifm, Context context) {
        if (ifm != null && !ifm.isDeployed()) {
            IMOChangeRecord ifmDbRecorder = context.addDBChangeRecord(Interface.class);
            ifm.setDeployStatus(Integer.valueOf(1));
            if (null != ifm.getUnNumIfName()) {
                ifm.setIpv4Addresss(null);
            }
            ifmDbRecorder.addModify((Object)ifm, new PropertyChangeItem("deployStatus"));
            IMOChangeRecord ifmDevRecorder = context.addChangeRecord(Interface.class);
            List propertyNames = CommonUtil.genList((Object[])new String[]{"ifAdminStatus", "ifDescr", "ifIndex", "ifLinkProtocol", "ifMtu", "ifNumber", "ifOperSpeed", "ifOperStatus", "ifParentIfName", "ifPhyType", "ifPosition", "ifRouterType", "ifStatItvl", "ifStatiEnable", "ifTrunkIfName", "ifV6State", "ipv6Enable", "isL2SwitchPort", "isPhysical", "timeInternal", "veGroupId", "veType", "unNumIfName", "ipv4Addresss", "ipv6Addresss"});
            Iterator iter = propertyNames.iterator();
            while (iter.hasNext()) {
                String propertyName = (String)iter.next();
                Object propertyValue = ReflectHelper.getInstance().getPropertyValue((Object)ifm, propertyName);
                boolean isCollection = propertyValue instanceof Collection;
                if ((!isCollection || !CollectionUtils.isEmpty((Collection)((Collection)propertyValue))) && propertyValue != null) continue;
                iter.remove();
            }
            if (!CollectionUtils.isEmpty((Collection)propertyNames)) {
                ifmDevRecorder.addModify((Object)ifm, (Collection)propertyNames);
                if (propertyNames.contains("ipv4Addresss") && !CollectionUtils.isEmpty((Collection)ifm.getIpv4Addresss())) {
                    IMOChangeRecord ipAddrDevRecorder = context.addChangeRecord(Ipv4Address.class);
                    IMOChangeRecord ipV4AddrDbRecorder = context.addDBChangeRecord(Ipv4Address.class);
                    ipAddrDevRecorder.addCreate(ifm.getIpv4Addresss());
                    try {
                        Collection ipv4FromDB = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(Ipv4Address.class, ifm.getIpv4Addresss(), true);
                        for (Ipv4Address ipv4 : ifm.getIpv4Addresss()) {
                            if (ipv4FromDB.contains(ipv4)) continue;
                            ipV4AddrDbRecorder.addCreate(ifm.getIpv4Addresss());
                        }
                    }
                    catch (VMFException e) {
                        logger.error("query ipv4 address from DB error");
                    }
                }
            }
        }
    }

    public static Interface translate2Interface(MplsInterface mo) {
        if (mo == null) {
            return null;
        }
        Interface ifm = new Interface();
        ifm.setDevID(mo.getDevID());
        ifm.setVrID(mo.getVrID());
        ifm.setIfName(mo.getInterfaceName());
        InterfaceFdnParser fdnParser = new InterfaceFdnParser();
        ifm.setFdn(fdnParser.getFdn(ifm));
        return ifm;
    }

    public static MplsRing translate2Ring(RingMapVirtualNode virtualNode) {
        MplsRing ring = new MplsRing();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)virtualNode, (VmfMO)ring);
        ring.setRingId(virtualNode.getRingId());
        return ring;
    }

    public static RsvpTeTunnel translate2RsvpTeTunnel(ReverseRsvpTeLsp reverseRsvpTeLsp) {
        RsvpTeTunnel mo = new RsvpTeTunnel();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)reverseRsvpTeLsp, (VmfMO)mo);
        mo.setTunnelName(reverseRsvpTeLsp.getTunnelName());
        return mo;
    }

    public static IFdnParser<StaticTunnel> getStaticTunnelFdnParser() {
        return new StaticTunnelFdnParser();
    }

    public static String calStaticTunnelName(String ingressLsrId, Integer tunnelId, String egressLsrId, Integer lsrRole) {
        if (StringUtil.isEmpty((String)ingressLsrId) || tunnelId == null || StringUtil.isEmpty((String)egressLsrId)) {
            logger.error("calStaticTunnelName failed! ingress Lsr Id = " + ingressLsrId + " tunnel id = " + tunnelId + " engress Lsr id = " + egressLsrId);
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (null != lsrRole && StaticTunnel.LSR_ROLE_ENUM.TRANSIT.intValue() == lsrRole.intValue()) {
            sb.append(TUNNEL);
            sb.append(tunnelId);
            sb.append("/");
            sb.append(MplsUtil.ipToNumber(ingressLsrId));
            sb.append("/");
            sb.append(MplsUtil.ipToNumber(egressLsrId));
        } else {
            sb.append(TUNNEL);
            sb.append(200000 + tunnelId);
        }
        return sb.toString();
    }

    public static long ipToNumber(String strIPAddress) {
        String[] ipArray = strIPAddress.split("\\.");
        long[] ipNum = new long[4];
        for (int i = 0; i < 4; ++i) {
            ipNum[i] = Long.parseLong(ipArray[i].trim());
        }
        long ipNumTotal = ipNum[0] * 256L * 256L * 256L + ipNum[1] * 256L * 256L + ipNum[2] * 256L + ipNum[3];
        return ipNumTotal;
    }

    public static int getMplsTunnelType(String fdn) {
        if (StringUtil.isEmpty((String)fdn) || fdn.indexOf("TUNNEL") == -1) {
            return -1;
        }
        String values = fdn.substring(fdn.indexOf("TUNNEL") + "TUNNEL".length()).trim();
        String[] valueArr = values.substring(1).split("\\|");
        return Integer.parseInt(valueArr[1]);
    }

    public static boolean isPtn() {
        ExtendPointServiceMgr extPointServiceMgr = ExtendPointServiceMgr.getInstance();
        IStaticTunnelFdnParserExtPoint parser = (IStaticTunnelFdnParserExtPoint)extPointServiceMgr.getExtendPoitService(IStaticTunnelFdnParserExtPoint.class);
        return parser != null;
    }

    public static <T extends VmfMO> boolean containsMo(Collection<T> mos, T mo, IFdnParser<T> fdnParser) {
        if (CollectionUtils.isEmpty(mos) || mo == null) {
            return false;
        }
        String fdn = fdnParser.getFdn(mo);
        for (VmfMO moc : mos) {
            String fdnc = fdnParser.getFdn(moc);
            if (!fdn.equals(fdnc)) continue;
            return true;
        }
        return false;
    }

    public static void setIfmFdn(Collection<Interface> ifms) {
        if (CollectionUtils.isEmpty(ifms)) {
            return;
        }
        InterfaceFdnParser fdnParser = new InterfaceFdnParser();
        for (Interface ifm : ifms) {
            if (ifm.getDevID() == null || ifm.getVrID() == null || StringUtil.isEmpty((String)ifm.getIfName())) continue;
            ifm.setFdn(fdnParser.getFdn((VmfMO)ifm));
        }
    }

    public static String getTunnelFdn(VmfMO tunnel) {
        if (tunnel instanceof RsvpTeTunnel) {
            return new RsvpTeTunnelFdnParser().getFdn((RsvpTeTunnel)tunnel);
        }
        if (tunnel instanceof StaticTunnel) {
            return MplsUtil.getStaticTunnelFdnParser().getFdn((VmfMO)((StaticTunnel)tunnel));
        }
        return null;
    }

    public static void getStaticTunnelFromAsn(QAsnTunnelBase asn, StaticTunnel mo) {
        mo.setIngressLsrId(new String(asn.strIngressLsrID));
        mo.setEgressLsrId(new String(asn.strEgressLsrID));
        mo.setTunnelId(Integer.valueOf(asn.iTunnelID));
        mo.setDevID(Integer.valueOf(asn.oTunnelKey.neID));
        mo.setVrID(Integer.valueOf(0));
        int lsrRole = asn.iPosition;
        mo.setLsrRole(Integer.valueOf(lsrRole));
        mo.setTunnelName(MplsUtil.calStaticTunnelName(mo.getIngressLsrId(), mo.getTunnelId(), mo.getEgressLsrId(), mo.getLsrRole()));
    }

    public static int getOamType(QAsnUniResID resID) {
        ITpoamService tpOamService = Activator.getService(ITpoamService.class);
        ArrayList<Integer> neIDList = new ArrayList<Integer>();
        neIDList.add(resID.neID);
        QAsnNEOamTypeList oamTypeLst = new QAsnNEOamTypeList();
        tpOamService.getNEOamType(neIDList, oamTypeLst);
        int len = oamTypeLst.size();
        for (int i = 0; i < len; ++i) {
            QAsnNEOamType oamType = (QAsnNEOamType)oamTypeLst.get(i);
            if (oamType.neID != resID.neID) continue;
            return oamType.iOamType;
        }
        return -1;
    }

    public static ErrorInfo switchLSP(QAsnTPOamResKey resKey) {
        StaticTunnelFdnParser lspfdnParser = new StaticTunnelFdnParser();
        StaticTunnel staticTunnel = (StaticTunnel)lspfdnParser.getIndexMo(resKey.oResKey);
        MplsOamTunnelMethodMO tunnelMo = new MplsOamTunnelMethodMO();
        tunnelMo.setDevID(staticTunnel.getDevID());
        tunnelMo.setFdn(staticTunnel.getFdn());
        tunnelMo.setMethodName("switchSingleTunnel");
        tunnelMo.setTunnelName(staticTunnel.getTunnelName());
        DefaultMOService moService = new DefaultMOService();
        MethodSchemaTranslatorContext methodContext = new MethodSchemaTranslatorContext(tunnelMo.getDevID().intValue());
        methodContext.addMethod(FeatureName.MPLSOAM, (VmfMO)tunnelMo);
        moService.addMethodJob(methodContext);
        try {
            moService.sendMethod();
        }
        catch (VMFException e) {
            logger.error("sendMethod of switchSingleTunnel failed!", (Throwable)e);
        }
        return moService.getErrorInfo((VmfMO)tunnelMo);
    }

    public static ErrorInfo switchPW(QAsnTPOamResKey resKey) {
        VpwsPwFdnParser pwfdnParser = new VpwsPwFdnParser();
        VpwsPw pw = (VpwsPw)pwfdnParser.getIndexMo(resKey.oResKey);
        VpwsPw vpwspw = new VpwsPw();
        IPwe3Service pwe3Service = Activator.getService(IPwe3Service.class);
        try {
            Collection vpwsInst = pwe3Service.getVpwsInstances(pw.getFdn());
            if (CollectionUtils.isEmpty((Collection)vpwsInst)) {
                logger.error("pwe3Service.getVpwsInstances: no pwe3 instance record!");
                return null;
            }
            Collection pwLst = ((VpwsInstance)vpwsInst.iterator().next()).getVpwsPws();
            if (CollectionUtils.isEmpty((Collection)pwLst)) {
                logger.error("pwe3Service.getVpwsInstances: no vpwspw record!");
                return null;
            }
            for (VpwsPw pwIndex : pwLst) {
                if (!pwIndex.getDevID().equals(pw.getDevID()) || !pwIndex.getPwId().equals(pw.getPwId()) || !pwIndex.getPwType().equals(pw.getPwType())) continue;
                vpwspw = pwIndex;
                break;
            }
        }
        catch (VMFException e) {
            logger.error("Activator.getService failed!", (Throwable)e);
        }
        MplsOamPwMethodMO pwMo = new MplsOamPwMethodMO();
        pwMo.setDevID(pw.getDevID());
        pwMo.setFdn(pw.getFdn());
        pwMo.setMethodName("switchSinglePw");
        pwMo.setPeerIp(vpwspw.getPeerIp());
        pwMo.setVcId(Integer.valueOf(Integer.parseInt(String.valueOf(vpwspw.getPwId()))));
        pwMo.setVrID(vpwspw.getVrID());
        pwMo.setVcType(vpwspw.getPwType());
        DefaultMOService moService = new DefaultMOService();
        MethodSchemaTranslatorContext methodContext = new MethodSchemaTranslatorContext(pw.getDevID().intValue());
        methodContext.addMethod(FeatureName.MPLSOAM, (VmfMO)pwMo);
        moService.addMethodJob(methodContext);
        try {
            moService.sendMethod();
        }
        catch (VMFException e) {
            logger.error("sendMethod of switchSinglePw failed!", (Throwable)e);
        }
        return moService.getErrorInfo((VmfMO)pwMo);
    }

    public static Map<String, ErrorInfo> switchLSP(QAsnTPOamResKeyList resKeyList) {
        HashMap<String, ErrorInfo> result = new HashMap<String, ErrorInfo>();
        StaticTunnelFdnParser lspfdnParser = new StaticTunnelFdnParser();
        for (int i = 0; i < resKeyList.size(); ++i) {
            QAsnTPOamResKey resKey = (QAsnTPOamResKey)resKeyList.get(i);
            StaticTunnel staticTunnel = (StaticTunnel)lspfdnParser.getIndexMo(resKey.oResKey);
            if (StaticTunnel.LSR_ROLE_ENUM.TRANSIT == staticTunnel.getLsrRole()) continue;
            logger.debug("1711 oam need switch single lsp, the resID = " + new String(resKey.oResKey.strFDN));
            ErrorInfo errorInfo = MplsUtil.switchLSP(resKey);
            if (null == errorInfo || 0 == errorInfo.getErrorCode()) continue;
            result.put(new String(resKey.oResKey.strFDN), errorInfo);
        }
        return result;
    }

    public static ErrorInfo switchRing(QAsnTPOamResKey resKey, int direction) {
        MplsRingFdnParser ringFdnParser = new MplsRingFdnParser();
        MplsRing ring = (MplsRing)ringFdnParser.getIndexMo(resKey.oResKey);
        MplsOamRingMethodMO ringMo = new MplsOamRingMethodMO();
        ringMo.setDevID(ring.getDevID());
        ringMo.setVrID(ring.getVrID());
        ringMo.setFdn(ring.getFdn());
        ringMo.setMethodName("switchSingleRing");
        ringMo.setRingId(BigInteger.valueOf(ring.getRingId().intValue()));
        ringMo.setRingDirection(Integer.valueOf(direction));
        DefaultMOService moService = new DefaultMOService();
        MethodSchemaTranslatorContext methodContext = new MethodSchemaTranslatorContext(ringMo.getDevID().intValue());
        methodContext.addMethod(FeatureName.MPLSOAM, (VmfMO)ringMo);
        moService.addMethodJob(methodContext);
        try {
            moService.sendMethod();
        }
        catch (VMFException e) {
            logger.error("sendMethod of switchSingleTunnel failed!", (Throwable)e);
        }
        return moService.getErrorInfo((VmfMO)ringMo);
    }

    public static void setKeyRefToContext(List<RsvpTeTunnel> tunnels, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty(tunnels)) {
            return;
        }
        MplsDao.newInstance().queryKeyRefMO(tunnels);
        for (RsvpTeTunnel tunnel : tunnels) {
            for (VmfMO keyRefMO : MplsUtil.getKeyRefMOsOfTunnel(tunnel)) {
                MplsUtil.setKeyRefToContext(keyRefMO, context);
            }
        }
    }

    private static void setKeyRefToContext(VmfMO keyRefMO, IAsnTranslationContext context) {
        if (EOperationType.DELETE.equals((Object)context.getOperType())) {
            IMOChangeRecord changeRecord = context.getTransactionContext().addDBChangeRecord(keyRefMO.getClass());
            changeRecord.addDelete((Object)keyRefMO);
            return;
        }
        if (EOperationType.DEPLOY.equals((Object)context.getOperType())) {
            if (keyRefMO instanceof DeployableMO) {
                ((DeployableMO)keyRefMO).setDeployStatus(Integer.valueOf(1));
                IMOChangeRecord changeRecord = context.getTransactionContext().addChangeRecord(keyRefMO.getClass());
                changeRecord.addCreate((Object)keyRefMO);
                IMOChangeRecord changeDBRecord = context.getTransactionContext().addDBChangeRecord(keyRefMO.getClass());
                changeDBRecord.addModify((Object)keyRefMO, Arrays.asList("deployStatus"));
            } else {
                IMOChangeRecord changeRecord = context.getTransactionContext().addChangeRecord(keyRefMO.getClass());
                changeRecord.addCreate((Object)keyRefMO);
            }
            return;
        }
        if (EOperationType.UNDEPLOY.equals((Object)context.getOperType()) && keyRefMO instanceof DeployableMO) {
            ((DeployableMO)keyRefMO).setDeployStatus(Integer.valueOf(0));
            IMOChangeRecord changeDBRecord = context.getTransactionContext().addDBChangeRecord(keyRefMO.getClass());
            changeDBRecord.addModify((Object)keyRefMO, Arrays.asList("deployStatus"));
        }
    }

    public static boolean isConfigTpOam(QAsnUniResID oResKey) {
        ITpoamService service = Activator.getService(ITpoamService.class);
        try {
            return null != service.queryPOAM(oResKey);
        }
        catch (VMFException e) {
            logger.error("ITpoamService queryPOAM failed!", (Throwable)e);
            return false;
        }
    }

    static {
        unSupporMplsInterfaceTypes.add(ATM_TRUNK);
        unSupporMplsInterfaceTypes.add(AUX);
        unSupporMplsInterfaceTypes.add(CPOS);
        unSupporMplsInterfaceTypes.add(DIALER);
        unSupporMplsInterfaceTypes.add(E1);
        unSupporMplsInterfaceTypes.add(IN_LOOPBACK);
        unSupporMplsInterfaceTypes.add(LOGIC_CHANNEL);
        unSupporMplsInterfaceTypes.add(LOOPBACK);
        unSupporMplsInterfaceTypes.add(M_TUNNEL);
        unSupporMplsInterfaceTypes.add(NULL);
        unSupporMplsInterfaceTypes.add(RPR);
        unSupporMplsInterfaceTypes.add(TUNNEL);
        unSupporMplsInterfaceTypes.add(VC4);
        unSupporMplsInterfaceTypes.add(VC12);
        unSupporMplsInterfaceTypes.add(SERIAL);
    }
}

