/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.common;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_common.QAsnUniResIDList;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public final class MplsAsnUtil {
    private static final Logger logger = RunLogger.getLogger(MplsAsnUtil.class);

    public static void decodeStaticCRTunnelKeys(QAsnUniResID tunnelKey, StaticTunnel mo, IAsnTranslationContext context) {
        int serialNum;
        if (tunnelKey == null) {
            return;
        }
        if (!StringUtil.isEmpty((String)AsnUtil.strValue((byte[])tunnelKey.strFDN))) {
            IFdnParser<StaticTunnel> staticTunnFdnParser = MplsUtil.getStaticTunnelFdnParser();
            StaticTunnel tempMo = (StaticTunnel)staticTunnFdnParser.getIndexMo(tunnelKey);
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)tempMo, (VmfMO)mo);
            mo.setIngressLsrId(tempMo.getIngressLsrId());
            mo.setEgressLsrId(tempMo.getEgressLsrId());
            mo.setTunnelId(tempMo.getTunnelId());
            mo.setLsrRole(tempMo.getLsrRole());
            mo.setFdn(tempMo.getFdn());
            if (!StringUtil.isEmpty((String)tempMo.getTunnelName())) {
                mo.setTunnelName(tempMo.getTunnelName());
            }
            if (StringUtil.isEmpty((String)mo.getTunnelName())) {
                try {
                    MplsDao.newInstance().loadStaticCRTunnelNameById(Arrays.asList(mo));
                }
                catch (Exception e) {
                    logger.error("loadStaticCRTunnelNameById failed! tunnelId" + tempMo.getTunnelId(), (Throwable)e);
                }
            }
        }
        if (tunnelKey.neID != -1) {
            mo.setDevID(Integer.valueOf(tunnelKey.neID));
        }
        if (mo.getVrID() == null || mo.getVrID() == -1) {
            mo.setVrID(Integer.valueOf(0));
        }
        if ((serialNum = AsnUtil.intValue((byte[])tunnelKey.poSerialNum).intValue()) > -1) {
            mo.setSerialNum(AsnUtil.strValue((byte[])tunnelKey.poSerialNum));
        }
    }

    public static int getTunnelType(QAsnUniResID resId) {
        String fdn = AsnUtil.strValue((byte[])resId.strFDN);
        int tunnelType = MplsUtil.getMplsTunnelType(fdn);
        return tunnelType;
    }

    public static void parseTunnelKeys(QAsnUniResIDList tunnelKeys, List<RsvpTeTunnel> rsvpTeFdnTunnels, List<StaticTunnel> staticFdnTunnels) {
        if (CollectionUtils.isEmpty((Collection)tunnelKeys)) {
            return;
        }
        ArrayList<String> tunnelFdns = new ArrayList<String>();
        for (Object tunnelKey : tunnelKeys) {
            QAsnUniResID resId = (QAsnUniResID)tunnelKey;
            tunnelFdns.add(AsnUtil.strValue((byte[])resId.strFDN));
        }
        MplsAsnUtil.parseTunnelFdns(tunnelFdns, rsvpTeFdnTunnels, staticFdnTunnels);
    }

    public static void parseTunnelFdns(Collection<String> tunnelFdns, List<RsvpTeTunnel> rsvpTeFdnTunnels, List<StaticTunnel> staticFdnTunnels) {
        if (CollectionUtils.isEmpty(tunnelFdns)) {
            return;
        }
        RsvpTeTunnelFdnParser revpTeFdnParser = new RsvpTeTunnelFdnParser();
        IFdnParser<StaticTunnel> staticTunnelFdnParser = MplsUtil.getStaticTunnelFdnParser();
        for (String fdn : tunnelFdns) {
            int tunnelType = MplsUtil.getMplsTunnelType(fdn);
            if (tunnelType == 4) {
                rsvpTeFdnTunnels.add((RsvpTeTunnel)revpTeFdnParser.getIndexMo(fdn));
                continue;
            }
            if (tunnelType == 1) {
                staticFdnTunnels.add((StaticTunnel)staticTunnelFdnParser.getIndexMo(fdn));
                continue;
            }
            logger.info("none tunnel fdn parser for " + fdn);
        }
    }
}

