/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.translation.asn.spec;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnTunnelSelection;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnFrr;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnIsisInstance;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnOspfInstance;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnRoutingInstance;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnStaticRoute;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnVpnPeer;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnVpnPeerList;
import com.huawei.network.qasn.m_q_ip_route_model.QAsnBgpInstance;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.l3vpn.translation.asn.IQAsnRoutingInstanceTranslatorExtPoint;
import com.huawei.vmf.adapter.extendpoint.qos.service.IQosService;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.arp.model.ArpInterface;
import com.huawei.vmf.adapter.fservice.arp.model.ArpStaticTable;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpIntfOpt82Formate;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpOpt82Intf;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayIfCfg;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayVpnCfg;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnIf;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnPeer;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnTunnel;
import com.huawei.vmf.adapter.fservice.model.DeployableMO;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelPolicy;
import com.huawei.vmf.adapter.fservice.mpls.service.IMplsService;
import com.huawei.vmf.adapter.fservice.route.model.BgpSite;
import com.huawei.vmf.adapter.fservice.route.model.BgpVrf;
import com.huawei.vmf.adapter.fservice.route.model.IsSite;
import com.huawei.vmf.adapter.fservice.route.model.OspfSite;
import com.huawei.vmf.adapter.fservice.route.model.SrRoute;
import com.huawei.vmf.adapter.fservice.route.model.UniAf;
import com.huawei.vmf.adapter.l3vpn.Activator;
import com.huawei.vmf.adapter.l3vpn.common.Utility;
import com.huawei.vmf.adapter.l3vpn.translation.asn.QAsnFrrTranslator;
import com.huawei.vmf.adapter.l3vpn.translation.asn.QAsnRoutingInstanceTranslator;
import com.huawei.vmf.adapter.l3vpn.translation.asn.QAsnSapTranslator;
import com.huawei.vmf.adapter.l3vpn.translation.asn.QAsnVpnPeerTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnRoutingInstanceSpecTranslator
extends AbstractAsnSpecTranslator<QAsnRoutingInstanceTranslator> {
    public void decodeArpItemList(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeBgpInstList(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
        this.decodeRouteInstList((Collection<?>)asn.bgpInstList, mo, (Class)BgpVrf.class, (Class)QAsnBgpInstance.class, context, asn, 128);
    }

    public void decodeIsisInstList(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
        this.decodeRouteInstList((Collection<?>)asn.isisInstList, mo, (Class)IsSite.class, (Class)QAsnIsisInstance.class, context, asn, 1024);
    }

    public void decodeKeyProperties(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
        mo.setDevID(Integer.valueOf(asn.l3vpnKey.neID));
        if (!StringUtil.isEmpty((String)StringUtil.globalString((byte[])asn.l3vpnKey.strFDN))) {
            L3vpnInstanceFdnParser parser = new L3vpnInstanceFdnParser();
            L3vpnInstance moIndex = (L3vpnInstance)parser.getIndexMo(asn.l3vpnKey);
            if (moIndex != null) {
                mo.setDevID(moIndex.getDevID());
                mo.setVrID(moIndex.getVrID());
                mo.setVrfName(moIndex.getVrfName());
            }
        } else {
            Object l3vpnRoutingInstanceExtPoit = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnRoutingInstanceTranslatorExtPoint.class);
            if (null != l3vpnRoutingInstanceExtPoit) {
                ((IQAsnRoutingInstanceTranslatorExtPoint)l3vpnRoutingInstanceExtPoit).decodeL3vpnInstance(asn, mo, context);
            } else {
                mo.setVrfName(StringUtil.globalString((byte[])asn.vrfName));
            }
        }
        mo.setSerialNum(StringUtil.globalString((byte[])asn.l3vpnKey.poSerialNum));
        UniAf af = new UniAf();
        af.setDevID(mo.getDevID());
        af.setAfType(UniAf.AF_TYPE_ENUM.IPV4UNICAST);
        af.setVrID(mo.getVrID());
        af.setVrfName(mo.getVrfName());
        mo.addKeyRefMo((VmfMO)af);
        if (context.getOperType().equals((Object)EOperationType.CREATE) || context.getOperType().equals((Object)EOperationType.PREDEPLOY)) {
            context.getTransactionContext().addChangeRecord(UniAf.class).addCreate((Object)af);
        }
    }

    public void decodeLabelAssignMode(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
        Collection afs = mo.getVpnInstAFs();
        if (CollectionUtils.isEmpty((Collection)afs)) {
            return;
        }
        for (VpnInstAF af : afs) {
            switch (asn.labelAssignMode) {
                case 1: {
                    af.setVrfLabelMode(VpnInstAF.VRF_LABEL_MODE_ENUM.PER_ROUTE);
                    break;
                }
                case 2: {
                    af.setVrfLabelMode(VpnInstAF.VRF_LABEL_MODE_ENUM.PER_INSTANCE);
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }

    public void decodeOspfInstList(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
        this.decodeRouteInstList((Collection<?>)asn.ospfInstList, mo, (Class)OspfSite.class, (Class)QAsnOspfInstance.class, context, asn, 512);
    }

    public void decodePoAfIpv4Multicast(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodePoAfIpv6Multicast(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodePoAfIpv6Unicast(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodePoAsNumber(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodePoDhcpRelayInfo(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodePoFrr(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)mo.getVpnInstAFs())) {
            return;
        }
        if (null == asn.poFrr || 0 >= asn.poFrr.vpnFrrParaList.size()) {
            return;
        }
        QAsnFrrTranslator qasnFrrTrans = new QAsnFrrTranslator();
        qasnFrrTrans.decode(asn.poFrr, mo, context);
    }

    public void decodePoLoopBackIpList(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodePoMulticastInfo(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodePoPimInfo(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodePoRoutAggrList(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodePoUpePeerList(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodePoVrfQos(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeRipInstList(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeSapList(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeStaticRouteList(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
        this.decodeRouteInstList((Collection<?>)asn.staticRouteList, mo, (Class)SrRoute.class, (Class)QAsnStaticRoute.class, context, asn, 256);
    }

    public void decodeTnlPolicyList(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)mo.getVpnInstAFs())) {
            return;
        }
        ArrayList<VpnTunnel> vpnTunnels = new ArrayList<VpnTunnel>();
        for (Object tunnelSelectionAsn : asn.tnlPolicyList) {
            QAsnTunnelSelection tunnelSelection = (QAsnTunnelSelection)tunnelSelectionAsn;
            switch (tunnelSelection.type) {
                case 1: 
                case 6: {
                    String tunnelPolicyName = StringUtil.globalString((byte[])tunnelSelection.poTnlPolicy);
                    if (StringUtil.isEmpty((String)tunnelPolicyName)) break;
                    for (VpnInstAF af : mo.getVpnInstAFs()) {
                        af.setTnlPolicyName(tunnelPolicyName);
                    }
                }
                case 2: {
                    break;
                }
                case 3: {
                    VpnTunnel vpnTunnel = new VpnTunnel();
                    this.decodeVpnTunnel(tunnelSelection, vpnTunnel, context);
                    vpnTunnels.add(vpnTunnel);
                }
            }
        }
        for (VpnInstAF af : mo.getVpnInstAFs()) {
            if (af.getAfType() != VpnInstAF.AF_TYPE_ENUM.IPV4UNI || CollectionUtils.isEmpty(vpnTunnels)) continue;
            af.setVpnTunnels(vpnTunnels);
        }
    }

    public void decodeVpnPeerList(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)mo.getVpnInstAFs())) {
            return;
        }
        ArrayList<VpnPeer> VpnPeers = new ArrayList<VpnPeer>(asn.vpnPeerList.size());
        for (VpnInstAF af : mo.getVpnInstAFs()) {
            for (Object obj : asn.vpnPeerList) {
                QAsnVpnPeer qVpnPeer = (QAsnVpnPeer)obj;
                VpnPeer vpnPeer = new VpnPeer();
                QAsnVpnPeerTranslator qasnVpnPeerTrans = new QAsnVpnPeerTranslator();
                qasnVpnPeerTrans.decode(qVpnPeer, vpnPeer, context);
                VpnPeers.add(vpnPeer);
                String peerKey = CommonUtil.composeTmpKey((Object[])new Object[]{vpnPeer.getDevID(), vpnPeer.getVrID(), vpnPeer.getVrfName(), vpnPeer.getAfType(), vpnPeer.getPeerAddr(), vpnPeer.getLabel()});
                context.addProperty(peerKey, (Object)qVpnPeer.poOperMask);
            }
            af.setVpnPeers(VpnPeers);
        }
    }

    public void decodeVpnTunnel(QAsnTunnelSelection tunnelSelection, VpnTunnel vpnTunnel, IAsnTranslationContext context) throws VMFException {
        if (tunnelSelection.type != 3) {
            return;
        }
        if (null == tunnelSelection.poTnlKey) {
            return;
        }
        Object obj = context.getProperty(VpnInstAF.class.getName());
        VpnInstAF vpnInstAF = (VpnInstAF)obj;
        try {
            IMplsService mplsService = Activator.getService(IMplsService.class);
            String strFdn = AsnUtil.strValue((byte[])tunnelSelection.poTnlKey.strFDN);
            Collection tunnelObjs = mplsService.queryStaticTunnelByFdn(Arrays.asList(strFdn), false);
            if (!CollectionUtils.isEmpty((Collection)tunnelObjs)) {
                StaticTunnel tunnelObj = (StaticTunnel)tunnelObjs.iterator().next();
                vpnTunnel.setTunnelName(tunnelObj.getTunnelName());
            }
        }
        catch (VMFException e) {
            e.printStackTrace();
        }
        vpnTunnel.setDevID(vpnInstAF.getDevID());
        vpnTunnel.setVrID(vpnInstAF.getVrID());
        vpnTunnel.setAfType(VpnInstAF.AF_TYPE_ENUM.IPV4UNI);
        vpnTunnel.setVrfName(vpnInstAF.getVrfName());
        EOperationType operType = AsnTranslatorUtil.setAddOrDeleted((VmfMO)vpnTunnel, (int)1, (int)2, (Integer)tunnelSelection.poOperMask, (IAsnTranslationContext)context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        Object[][] masks = new Object[][]{};
        AsnTranslatorUtil.setChanged((VmfMO)vpnTunnel, (Object[][])masks, (Integer)tunnelSelection.poOperMask, (IAsnTranslationContext)context);
    }

    public void decodeVrfRD(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)mo.getVpnInstAFs())) {
            return;
        }
        int afType = this.qasnAfType2SchemaAfType(asn.poVrfType);
        for (VpnInstAF af : mo.getVpnInstAFs()) {
            if (af.getAfType() == null || af.getAfType() == -1) {
                af.setAfType(VpnInstAF.AF_TYPE_ENUM.IPV4UNI);
            }
            if (!StringUtil.isEmpty((String)af.getVrfRD())) continue;
            af.setVrfRD("--");
            if (af.getAfType().equals(VpnInstAF.AF_TYPE_ENUM.IPV4UNI) && afType == 1 && !StringUtil.isEmpty((String)StringUtil.globalString((byte[])asn.vrfRD))) {
                af.setVrfRD(StringUtil.globalString((byte[])asn.vrfRD));
                continue;
            }
            if (!af.getAfType().equals(VpnInstAF.AF_TYPE_ENUM.IPV6UNI) || afType != 2 || !StringUtil.isEmpty((String)StringUtil.globalString((byte[])asn.vrfRD))) continue;
            af.setVrfRD(StringUtil.globalString((byte[])asn.vrfRD));
        }
    }

    public void encodeArpItemList(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeBgpInstList(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        this.encodeRouteInstList(mo, (Collection)asn.bgpInstList, (Class)BgpVrf.class, (Class)QAsnBgpInstance.class, context);
    }

    public void encodeDhcpRelayVpn(L3vpnInstance vrf, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        List dhcpRelayVpns = vrf.getKeyRefMos(DhcpRelayVpnCfg.class);
        if (CollectionUtils.isEmpty((Collection)dhcpRelayVpns)) {
            return;
        }
        HashMap ifName2SapAsn = new HashMap();
        for (DhcpRelayVpnCfg ifMo : dhcpRelayVpns) {
            asn.poDhcpRelayInfo = Utility.INSTANCE.encodeDhcpRelayVpn(ifMo, context);
        }
    }

    public void encodeIsisInstList(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        this.encodeRouteInstList(mo, (Collection)asn.isisInstList, (Class)IsSite.class, (Class)QAsnIsisInstance.class, context);
    }

    public void encodeKeyProperties(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        L3vpnInstanceFdnParser parser = new L3vpnInstanceFdnParser();
        asn.l3vpnKey = parser.getUniResID((VmfMO)mo);
        context.addProperty(L3vpnInstance.class.getName(), (Object)mo);
    }

    public void encodeLabelAssignMode(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        Collection afs = mo.getVpnInstAFs();
        if (CollectionUtils.isEmpty((Collection)afs)) {
            return;
        }
        VpnInstAF af = (VpnInstAF)afs.iterator().next();
        if (VpnInstAF.VRF_LABEL_MODE_ENUM.PER_ROUTE.equals(af.getVrfLabelMode())) {
            asn.labelAssignMode = 1;
        } else if (VpnInstAF.VRF_LABEL_MODE_ENUM.PER_INSTANCE.equals(af.getVrfLabelMode())) {
            asn.labelAssignMode = 2;
        }
    }

    public void encodeOspfInstList(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        this.encodeRouteInstList(mo, (Collection)asn.ospfInstList, (Class)OspfSite.class, (Class)QAsnOspfInstance.class, context);
    }

    public void encodePoAfIpv4Multicast(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodePoAfIpv6Multicast(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodePoAfIpv6Unicast(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodePoAsNumber(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        List bgpSites = mo.getKeyRefMos(BgpSite.class);
        if (CollectionUtils.isEmpty((Collection)bgpSites)) {
            return;
        }
        BgpSite site = (BgpSite)bgpSites.iterator().next();
        if (site != null && !StringUtil.isEmpty((String)site.getAsNumber())) {
            try {
                asn.poAsNumber = Integer.parseInt(site.getAsNumber());
            }
            catch (NumberFormatException e) {
                this.getLogger().error("encodePoAsNumber error,", (Throwable)e);
                return;
            }
        }
    }

    public void encodePoDhcpRelayInfo(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodePoFrr(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)mo.getStaticFrrs())) {
            return;
        }
        asn.poFrr = new QAsnFrr();
        QAsnFrrTranslator qasnFrrTrans = new QAsnFrrTranslator();
        qasnFrrTrans.encode(mo, asn.poFrr, context);
    }

    public void encodePoLoopBackIpList(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodePoMulticastInfo(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodePoPimInfo(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodePoRoutAggrList(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodePoUpePeerList(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodePoVrfQos(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeRipInstList(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeSapList(L3vpnInstance vrf, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        List interfaces = vrf.getKeyRefMos(Interface.class);
        if (CollectionUtils.isEmpty((Collection)interfaces)) {
            return;
        }
        List dhcpRelayIfCfgs = vrf.getKeyRefMos(DhcpRelayIfCfg.class);
        Map<Interface, DhcpRelayIfCfg> ifCfgMap = this.getDhcpRelayIfCfgMap(interfaces, dhcpRelayIfCfgs);
        Map<Interface, DhcpOpt82Intf> opt82IntfMap = null;
        Map<Interface, Collection<DhcpIntfOpt82Formate>> opt82FormateMap = null;
        if (!CollectionUtils.isEmpty((Collection)dhcpRelayIfCfgs)) {
            List opt82Intfs = vrf.getKeyRefMos(DhcpOpt82Intf.class);
            List opt82Formates = vrf.getKeyRefMos(DhcpIntfOpt82Formate.class);
            opt82IntfMap = this.getDhcpOpt82IntfMap(ifCfgMap.keySet(), opt82Intfs);
            opt82FormateMap = this.getDhcpIntfOpt82FormateMap(ifCfgMap.keySet(), opt82Formates);
        }
        HashMap<String, Boolean> interfaceAddOrDelFlag = new HashMap<String, Boolean>();
        IMOChangeRecord rcd = context.getTransactionContext().getChangeRecord(L3vpnIf.class);
        if (!CollectionUtils.isEmpty((Collection)vrf.getL3vpnIfs()) && rcd != null) {
            for (L3vpnIf vrfIf : rcd.getDeletes()) {
                interfaceAddOrDelFlag.put(vrfIf.getIfName(), Boolean.FALSE);
            }
            for (L3vpnIf vrfIf : rcd.getCreates()) {
                interfaceAddOrDelFlag.put(vrfIf.getIfName(), Boolean.TRUE);
            }
        }
        Object qosSrv = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQosService.class);
        HashMap<String, QAsnSAP> ifName2SapAsn = new HashMap<String, QAsnSAP>();
        for (Interface ifMo : interfaces) {
            DhcpRelayIfCfg dhcpRelayifCfg;
            if (!CollectionUtils.isEmpty((Collection)dhcpRelayIfCfgs) && (dhcpRelayifCfg = ifCfgMap.get(ifMo)) != null) {
                ifMo.addKeyRefMo((VmfMO)dhcpRelayifCfg);
                ifMo.addKeyRefMo((VmfMO)opt82IntfMap.get(ifMo));
                ifMo.addKeyRefMos(opt82FormateMap.get(ifMo));
            }
            ifMo.addKeyRefMos((Collection)vrf.getKeyRefMos(ArpInterface.class));
            QAsnSAP sapAsn = Utility.INSTANCE.encodeSap(ifMo, context);
            if (null == sapAsn) {
                this.getLogger().info("Interface encode failed. {}", (Object)ifMo.getIfName());
                continue;
            }
            ifName2SapAsn.put(ifMo.getIfName(), sapAsn);
            sapAsn.poBindingRelationDeployStatus = 0;
            if (this.isBindingRelationDeploy(vrf, ifMo, interfaceAddOrDelFlag)) {
                sapAsn.poBindingRelationDeployStatus = 1;
            }
            if (null != qosSrv) {
                ((IQosService)qosSrv).encodeL3vpnUniQos(vrf, sapAsn, (Object)context);
            }
            asn.sapList.add((Object)sapAsn);
            Boolean flag = (Boolean)interfaceAddOrDelFlag.get(ifMo.getIfName());
            if (null != flag) {
                sapAsn.poOperMask = AsnTranslatorUtil.getOperMask((Integer)sapAsn.poOperMask, (int)8192);
            }
            if (Boolean.TRUE.equals(flag)) {
                sapAsn.poOperMask = AsnTranslatorUtil.getOperMask((Integer)sapAsn.poOperMask, (int)1);
            }
            if (!Boolean.FALSE.equals(flag)) continue;
            sapAsn.poOperMask = AsnTranslatorUtil.getOperMask((Integer)sapAsn.poOperMask, (int)2);
        }
        new QAsnSapTranslator().encodeServiceInterface(vrf, ifName2SapAsn, context, interfaceAddOrDelFlag);
    }

    public void encodeStaticArp(L3vpnInstance vrf, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        List staticTables = vrf.getKeyRefMos(ArpStaticTable.class);
        if (CollectionUtils.isEmpty((Collection)staticTables)) {
            return;
        }
        asn.arpItemList = Utility.INSTANCE.encodeStaticArp(staticTables, context);
    }

    public void encodeStaticRouteList(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        this.encodeRouteInstList(mo, (Collection)asn.staticRouteList, (Class)SrRoute.class, (Class)QAsnStaticRoute.class, context);
    }

    public void encodeTnlPolicyList(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)mo.getVpnInstAFs())) {
            return;
        }
        for (VpnInstAF vpnInstAF : mo.getVpnInstAFs()) {
            if (vpnInstAF.getAfType().equals(VpnInstAF.AF_TYPE_ENUM.IPV4UNI) && !StringUtil.isEmpty((String)vpnInstAF.getTnlPolicyName())) {
                TunnelPolicy tunnelPolicy = new TunnelPolicy();
                Utility.INSTANCE.setMoDevID((VmfMO)vpnInstAF, (VmfMO)tunnelPolicy);
                tunnelPolicy.setTnlPolicyName(vpnInstAF.getTnlPolicyName());
                QAsnTunnelSelection tunnelSelection = new QAsnTunnelSelection();
                tunnelSelection.neID = mo.getDevID();
                tunnelSelection.poVrID = mo.getVrID();
                tunnelSelection.poTnlPolicy = StringUtil.globalByte((String)vpnInstAF.getTnlPolicyName());
                tunnelSelection.type = 1;
                asn.tnlPolicyList.add((Object)tunnelSelection);
                break;
            }
            if (!vpnInstAF.getAfType().equals(VpnInstAF.AF_TYPE_ENUM.IPV4UNI) || CollectionUtils.isEmpty((Collection)vpnInstAF.getVpnTunnels())) continue;
            ArrayList<QAsnTunnelSelection> tunnelSelections = new ArrayList<QAsnTunnelSelection>();
            for (VpnTunnel vpnTunnel : vpnInstAF.getVpnTunnels()) {
                QAsnTunnelSelection tunnelSelection = new QAsnTunnelSelection();
                this.encodeVpnTunnel(vpnTunnel, tunnelSelection, context);
                tunnelSelections.add(tunnelSelection);
            }
            asn.tnlPolicyList.addAll(tunnelSelections);
            break;
        }
    }

    public void encodeVpnPeerList(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)mo.getVpnInstAFs())) {
            return;
        }
        asn.vpnPeerList = new QAsnVpnPeerList();
        for (VpnInstAF vpnInstAF : mo.getVpnInstAFs()) {
            if (!VpnInstAF.AF_TYPE_ENUM.IPV4UNI.equals(vpnInstAF.getAfType()) || CollectionUtils.isEmpty((Collection)vpnInstAF.getVpnPeers())) continue;
            for (VpnPeer vpnPeer : vpnInstAF.getVpnPeers()) {
                QAsnVpnPeer qasnvpnpeer = new QAsnVpnPeer();
                QAsnVpnPeerTranslator qasnVpnPeerTrans = new QAsnVpnPeerTranslator();
                qasnVpnPeerTrans.encode(vpnPeer, qasnvpnpeer, context);
                String peerKey = CommonUtil.composeTmpKey((Object[])new Object[]{vpnPeer.getDevID(), vpnPeer.getVrID(), vpnPeer.getVrfName(), vpnPeer.getAfType(), vpnPeer.getPeerAddr(), vpnPeer.getLabel()});
                Object iOper = context.getProperty(peerKey);
                if (null != iOper) {
                    qasnvpnpeer.poOperMask = (Integer)iOper;
                }
                asn.vpnPeerList.add((Object)qasnvpnpeer);
            }
        }
    }

    public void encodeVpnTunnel(VpnTunnel vpnTunnel, QAsnTunnelSelection tunnelSelection, IAsnTranslationContext context) {
        if (vpnTunnel.getTunnelName() == null || vpnTunnel.getTunnelName().equals("")) {
            return;
        }
        StaticTunnel staticTunnel = new StaticTunnel();
        staticTunnel.setDevID(vpnTunnel.getDevID());
        staticTunnel.setTunnelName(vpnTunnel.getTunnelName());
        ArrayList<StaticTunnel> tunnels = new ArrayList<StaticTunnel>();
        tunnels.add(staticTunnel);
        try {
            IMplsService mplsService = Activator.getService(IMplsService.class);
            mplsService.loadStaticTunnelFdnByTnlName(tunnels);
            if (!CollectionUtils.isEmpty(tunnels) && null != staticTunnel.getFdn()) {
                staticTunnel = (StaticTunnel)tunnels.iterator().next();
                QAsnUniResID tunnelKey = new QAsnUniResID();
                tunnelKey.neID = vpnTunnel.getDevID();
                tunnelKey.strFDN = StringUtil.globalByte((String)staticTunnel.getFdn());
                tunnelKey.strMOC = StringUtil.globalByte((String)FDNUtil.getFdnType((String)staticTunnel.getFdn()));
                tunnelSelection.poTnlKey = tunnelKey;
            }
        }
        catch (VMFException e) {
            e.printStackTrace();
        }
        tunnelSelection.neID = AsnUtil.intValue((Integer)vpnTunnel.getDevID());
        if (vpnTunnel.getVrID() != 0) {
            tunnelSelection.poVrID = new Integer(vpnTunnel.getVrID());
        }
        tunnelSelection.type = 3;
    }

    public void encodeVrfRD(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        if (!CollectionUtils.isEmpty((Collection)mo.getVpnInstAFs())) {
            for (VpnInstAF vpnInstAF : mo.getVpnInstAFs()) {
                if (!VpnInstAF.AF_TYPE_ENUM.IPV4UNI.equals(vpnInstAF.getAfType())) continue;
                asn.vrfRD = AsnUtil.getBytes((String)vpnInstAF.getVrfRD());
                break;
            }
        }
    }

    private <AsnType extends FStruct, MoType extends VmfMO> void decodeRouteInstList(Collection<?> asnList, L3vpnInstance vpn, Class<MoType> moClazz, Class<AsnType> asnClazz, IAsnTranslationContext context, QAsnRoutingInstance l3vpnAsn, int modifyFlag) throws VMFException {
        if (context.getOperType() == EOperationType.MODIFY && !AsnTranslatorUtil.isModifyProperty((IAsnTranslationContext)context, (Integer)l3vpnAsn.poOperMask, (int)modifyFlag)) {
            return;
        }
        if (asnList != null) {
            IAsnTranslator translator = Activator.getAsnTranslator(asnClazz, moClazz);
            for (Object routeAsn : asnList) {
                FStruct route = (FStruct)routeAsn;
                MoType site = Utility.INSTANCE.instanceMo(moClazz, (VmfMO)vpn);
                this.setVrfName((VmfMO)site, vpn.getVrfName());
                translator.decode(route, site, context);
                vpn.addKeyRefMo(site);
                if (context.getOperType() != EOperationType.PREDEPLOY || !(site instanceof DeployableMO)) continue;
                ((DeployableMO)site).setDeployStatus(Integer.valueOf(0));
            }
        }
    }

    private <AsnType extends FStruct, MoType extends VmfMO> void encodeRouteInstList(L3vpnInstance vpn, Collection<AsnType> asnList, Class<MoType> moClazz, Class<AsnType> asnClazz, IAsnTranslationContext context) throws VMFException {
        IAsnTranslator translator = Activator.getAsnTranslator(asnClazz, moClazz);
        List routes = vpn.getKeyRefMos(moClazz);
        if (CollectionUtils.isEmpty((Collection)routes)) {
            return;
        }
        Collection asns = translator.encode((Collection)routes, context);
        asnList.addAll(asns);
    }

    private Map<Interface, Collection<DhcpIntfOpt82Formate>> getDhcpIntfOpt82FormateMap(Collection<Interface> interfaceKeys, Collection<DhcpIntfOpt82Formate> dhcpRelayGiaddrs) {
        HashMap<Interface, Collection<DhcpIntfOpt82Formate>> dhcpRelayIfCgfMap = new HashMap<Interface, Collection<DhcpIntfOpt82Formate>>();
        for (Interface interfaceKey : interfaceKeys) {
            ArrayList<DhcpIntfOpt82Formate> giaddr = new ArrayList<DhcpIntfOpt82Formate>();
            for (DhcpIntfOpt82Formate dhcpIfCfg : dhcpRelayGiaddrs) {
                if (interfaceKey.getDevID().intValue() != dhcpIfCfg.getDevID().intValue() || interfaceKey.getVrID().intValue() != dhcpIfCfg.getVrID().intValue() || !interfaceKey.getIfName().equals(dhcpIfCfg.getIfName())) continue;
                giaddr.add(dhcpIfCfg);
            }
            dhcpRelayIfCgfMap.put(interfaceKey, giaddr);
        }
        return dhcpRelayIfCgfMap;
    }

    private Map<Interface, DhcpOpt82Intf> getDhcpOpt82IntfMap(Collection<Interface> interfaceKeys, Collection<DhcpOpt82Intf> dhcpRelayResults) {
        HashMap<Interface, DhcpOpt82Intf> dhcpRelayIfCgfMap = new HashMap<Interface, DhcpOpt82Intf>();
        block0: for (Interface interfaceKey : interfaceKeys) {
            for (DhcpOpt82Intf dhcpIfCfg : dhcpRelayResults) {
                if (interfaceKey.getDevID().intValue() != dhcpIfCfg.getDevID().intValue() || interfaceKey.getVrID().intValue() != dhcpIfCfg.getVrID().intValue() || !interfaceKey.getIfName().equals(dhcpIfCfg.getIfName())) continue;
                dhcpRelayIfCgfMap.put(interfaceKey, dhcpIfCfg);
                continue block0;
            }
        }
        return dhcpRelayIfCgfMap;
    }

    private Map<Interface, DhcpRelayIfCfg> getDhcpRelayIfCfgMap(Collection<Interface> interfaceKeys, Collection<DhcpRelayIfCfg> dhcpRelayResults) {
        HashMap<Interface, DhcpRelayIfCfg> dhcpRelayIfCgfMap = new HashMap<Interface, DhcpRelayIfCfg>();
        if (CollectionUtils.isEmpty(dhcpRelayResults)) {
            return dhcpRelayIfCgfMap;
        }
        block0: for (Interface interfaceKey : interfaceKeys) {
            for (DhcpRelayIfCfg dhcpIfCfg : dhcpRelayResults) {
                if (interfaceKey.getDevID().intValue() != dhcpIfCfg.getDevID().intValue() || interfaceKey.getVrID().intValue() != dhcpIfCfg.getVrID().intValue() || !interfaceKey.getIfName().equals(dhcpIfCfg.getInterfaceName())) continue;
                dhcpRelayIfCgfMap.put(interfaceKey, dhcpIfCfg);
                continue block0;
            }
        }
        return dhcpRelayIfCgfMap;
    }

    private boolean isBindingRelationDeploy(L3vpnInstance vrf, Interface ifMo, Map<String, Boolean> interfaceAddOrDelFlag) {
        if (Boolean.FALSE.equals(interfaceAddOrDelFlag.get(ifMo.getIfName()))) {
            return false;
        }
        return vrf.isDeployed() && ifMo.isDeployed();
    }

    private int qasnAfType2SchemaAfType(Integer ty) {
        if (ty == null) {
            return 1;
        }
        return ty;
    }

    private void setVrfName(VmfMO mo, String name) {
        if (mo instanceof BgpVrf) {
            ((BgpVrf)mo).setVrfName(name);
        } else if (mo instanceof OspfSite) {
            ((OspfSite)mo).setVrfName(name);
        } else if (mo instanceof IsSite) {
            ((IsSite)mo).setVpnName(name);
        } else if (mo instanceof SrRoute) {
            ((SrRoute)mo).setVrfName(name);
        }
    }
}

