/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_common_model.QAsnDiffServMode;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnRoutingInstIpv4Unicast;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.capability.AttrCapabilityInfo;
import com.huawei.vmf.adapter.framework.capability.CapabilityInfo;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.util.ReflectHelper;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.route.model.UniAf;
import com.huawei.vmf.adapter.l3vpn.common.BitHelper;
import com.huawei.vmf.adapter.l3vpn.common.Utility;
import com.huawei.vmf.adapter.l3vpn.translation.asn.QAsnRoutingInstIpv4UnicastTranslator;
import java.util.Collection;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QAsnRoutingInstIpv4UnicastSpecTranslator
extends AbstractAsnSpecTranslator<QAsnRoutingInstIpv4UnicastTranslator> {
    public static final Object[][] z_uniAFMasks = new Object[][]{{"alertPercent", 64}, {"routeLimitNum", 32}, {"simplyAlert", 128}};
    private final Logger logger = LoggerFactory.getLogger(QAsnRoutingInstIpv4UnicastSpecTranslator.class);

    private static Long getAlertPercent(QAsnRoutingInstIpv4Unicast asn) {
        if (asn.alertPercent > 0) {
            return asn.alertPercent;
        }
        return null;
    }

    private static Long getRouteLimitNum(QAsnRoutingInstIpv4Unicast asn) {
        if (asn.routeLimit != 0) {
            return AsnUtil.parseOverflowIntToLong((int)asn.routeLimit);
        }
        return null;
    }

    private static Boolean getSimplyAlert(QAsnRoutingInstIpv4Unicast asn) {
        if (asn.simplyAlert >= 0) {
            return asn.simplyAlert == 1;
        }
        return null;
    }

    public void decodePoDsMode(QAsnRoutingInstIpv4Unicast asn, VpnInstAF mo, IAsnTranslationContext context) throws VMFException {
        if (asn.poDsMode == null) {
            return;
        }
        L3vpnInstance vrf = this.getVrfFromContext(context);
        switch (context.getOperType()) {
            case CREATE: 
            case PREDEPLOY: {
                this.decodeDsMode(vrf, asn.poDsMode, context);
                this.decodeDsMode(mo, asn.poDsMode, context);
                break;
            }
            case MODIFY: {
                BitHelper bitHelper = new BitHelper(asn.poOperMask);
                if (!bitHelper.hasSet(512)) break;
                this.decodeDsMode(vrf, asn.poDsMode, context);
                this.decodeDsMode(mo, asn.poDsMode, context);
                break;
            }
        }
    }

    public void decodePoVpnFrrRoutePolicy(QAsnRoutingInstIpv4Unicast asn, VpnInstAF mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeQAsnRoutingInstIpv4UnicastSpecKeys(QAsnRoutingInstIpv4Unicast asn, VpnInstAF mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeRoutePolicyIDList(QAsnRoutingInstIpv4Unicast asn, VpnInstAF mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeTtlMode(QAsnRoutingInstIpv4Unicast asn, VpnInstAF af, IAsnTranslationContext context) throws VMFException {
        L3vpnInstance vrf = (L3vpnInstance)context.getProperty(L3vpnInstance.class.getName());
        if (this.hasDiffServiceCap(vrf)) {
            if (asn.ttlMode > 0) {
                vrf.setTtlMode(Integer.valueOf(asn.ttlMode));
            }
            if (AsnTranslatorUtil.isModifyProperty((IAsnTranslationContext)context, (Integer)asn.poOperMask, (int)256)) {
                context.getTransactionContext().addChangeRecord(L3vpnInstance.class).addModify((Object)vrf, new PropertyChangeItem("ttlMode", (Object)vrf.getTtlMode(), null));
            }
        }
        if (this.hasDiffServiceCap(af)) {
            if (asn.ttlMode > 0) {
                af.setTtlMode(Integer.valueOf(asn.ttlMode));
            }
            if (AsnTranslatorUtil.isModifyProperty((IAsnTranslationContext)context, (Integer)asn.poOperMask, (int)256)) {
                context.getTransactionContext().addChangeRecord(VpnInstAF.class).addModify((Object)af, new PropertyChangeItem("ttlMode", (Object)af.getTtlMode(), null));
            }
        }
    }

    public void decodeUniAF(QAsnRoutingInstIpv4Unicast asn, IAsnTranslationContext context) throws VMFException {
        L3vpnInstance vrf = (L3vpnInstance)context.getProperty(L3vpnInstance.class.getName());
        List uniAfs = vrf.getKeyRefMos(UniAf.class);
        UniAf afMo = null;
        if (uniAfs != null) {
            for (UniAf af : uniAfs) {
                if (!UniAf.AF_TYPE_ENUM.IPV4UNICAST.equals(af.getAfType())) continue;
                afMo = af;
                break;
            }
        }
        if (afMo == null) {
            this.logger.error("UniAF must be created when vrf is decoding");
            throw new VMFException(1107498880);
        }
        this.decodeUniAf(asn, afMo, context);
    }

    public void encodePoVpnFrrRoutePolicy(VpnInstAF mo, QAsnRoutingInstIpv4Unicast asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeRoutePolicyIDList(VpnInstAF mo, QAsnRoutingInstIpv4Unicast asn, IAsnTranslationContext context) throws VMFException {
    }

    public void encodeUniAfs(VpnInstAF mo, QAsnRoutingInstIpv4Unicast asn, IAsnTranslationContext context) throws VMFException {
        L3vpnInstance vrf = (L3vpnInstance)context.getProperty(L3vpnInstance.class.getName());
        if (vrf != null) {
            List uniAfs = vrf.getKeyRefMos(UniAf.class);
            for (UniAf af : uniAfs) {
                if (!UniAf.AF_TYPE_ENUM.IPV4UNICAST.equals(af.getAfType())) continue;
                this.encodeUniAf(af, asn, context);
                break;
            }
        }
        if (1 != asn.simplyAlert) {
            asn.simplyAlert = 0;
        }
    }

    public void encodeVrf(QAsnRoutingInstIpv4Unicast asn, VpnInstAF mo, IAsnTranslationContext context) throws VMFException {
        L3vpnInstance vrf = (L3vpnInstance)context.getProperty(L3vpnInstance.class.getName());
        this.encodeTTLAndDiffServiceMode(vrf, asn, context);
        this.encodeTTLAndDiffServiceMode(mo, asn, context);
    }

    private void decodeDsMode(L3vpnInstance vrf, QAsnDiffServMode asn, IAsnTranslationContext context) throws VMFException {
        if (!this.hasDiffServiceCap(vrf)) {
            return;
        }
        vrf.setPipeMode(AsnTranslatorUtil.integerValue((int)asn.type, (String)"pipeMode", (Object[][])QAsnRoutingInstIpv4UnicastTranslator.z_vrfDiffServiceMasks, (VmfMO)vrf, (IAsnTranslationContext)context));
        vrf.setServiceClass(AsnTranslatorUtil.integerValue((int)asn.phb, (String)"serviceClass", (Object[][])QAsnRoutingInstIpv4UnicastTranslator.z_vrfDiffServiceMasks, (VmfMO)vrf, (IAsnTranslationContext)context));
        vrf.setColor(AsnTranslatorUtil.integerValue((int)asn.color, (String)"color", (Object[][])QAsnRoutingInstIpv4UnicastTranslator.z_vrfDiffServiceMasks, (VmfMO)vrf, (IAsnTranslationContext)context));
        if (asn.poOperMask != null && AsnTranslatorUtil.isModifyProperty((IAsnTranslationContext)context, (Integer)asn.poOperMask, (int)1) && L3vpnInstance.PIPE_MODE_ENUM.UNIFORM.equals(vrf.getPipeMode())) {
            int mask = asn.poOperMask;
            mask &= 0xFFFFFFFD;
            asn.poOperMask = mask &= 0xFFFFFFFB;
        }
        AsnTranslatorUtil.setChanged((VmfMO)vrf, (Object[][])QAsnRoutingInstIpv4UnicastTranslator.z_vrfDiffServiceMasks, (Integer)asn.poOperMask, (IAsnTranslationContext)context);
    }

    private void decodeDsMode(VpnInstAF af, QAsnDiffServMode asn, IAsnTranslationContext context) throws VMFException {
        if (!this.hasDiffServiceCap(af)) {
            return;
        }
        af.setPipeMode(AsnTranslatorUtil.integerValue((int)asn.type, (String)"pipeMode", (Object[][])QAsnRoutingInstIpv4UnicastTranslator.z_vrfAFDiffServiceMasks, (VmfMO)af, (IAsnTranslationContext)context));
        af.setServiceClass(AsnTranslatorUtil.integerValue((int)asn.phb, (String)"serviceClass", (Object[][])QAsnRoutingInstIpv4UnicastTranslator.z_vrfAFDiffServiceMasks, (VmfMO)af, (IAsnTranslationContext)context));
        af.setColor(AsnTranslatorUtil.integerValue((int)asn.color, (String)"color", (Object[][])QAsnRoutingInstIpv4UnicastTranslator.z_vrfAFDiffServiceMasks, (VmfMO)af, (IAsnTranslationContext)context));
        if (asn.poOperMask != null && AsnTranslatorUtil.isModifyProperty((IAsnTranslationContext)context, (Integer)asn.poOperMask, (int)1) && VpnInstAF.PIPE_MODE_ENUM.UNIFORM.equals(af.getPipeMode())) {
            int mask = asn.poOperMask;
            mask &= 0xFFFFFFFD;
            asn.poOperMask = mask &= 0xFFFFFFFB;
        }
        AsnTranslatorUtil.setChanged((VmfMO)af, (Object[][])QAsnRoutingInstIpv4UnicastTranslator.z_vrfAFDiffServiceMasks, (Integer)asn.poOperMask, (IAsnTranslationContext)context);
    }

    private void decodeDsModeColor(L3vpnInstance vrf, QAsnDiffServMode dsMode, IAsnTranslationContext context) {
        this.decodeDsModeProperty(vrf, "color", 4, dsMode, context, dsMode.color);
    }

    private void decodeDsModePipeMode(L3vpnInstance vrf, QAsnDiffServMode dsMode, IAsnTranslationContext context) {
        this.decodeDsModeProperty(vrf, "pipeMode", 1, dsMode, context, dsMode.type);
    }

    private void decodeDsModeProperty(L3vpnInstance vrf, String propertyName, int mask, QAsnDiffServMode dsMode, IAsnTranslationContext context, int value) {
        switch (context.getOperType()) {
            case CREATE: 
            case PREDEPLOY: {
                if (value <= 0) break;
                ReflectHelper.getInstance().setPropertyValue((Object)vrf, propertyName, (Object)value);
                break;
            }
            case MODIFY: {
                BitHelper bitHelper = new BitHelper(dsMode.poOperMask);
                if (!bitHelper.hasSet(mask)) break;
                if (value > 0) {
                    ReflectHelper.getInstance().setPropertyValue((Object)vrf, propertyName, (Object)value);
                } else {
                    ReflectHelper.getInstance().setPropertyValue((Object)vrf, propertyName, (Object)null);
                }
                context.getTransactionContext().addChangeRecord(L3vpnInstance.class).addModify((Object)vrf, new PropertyChangeItem(propertyName, ReflectHelper.getInstance().getPropertyValue((Object)vrf, propertyName), null));
                break;
            }
        }
    }

    private void decodeDsModeServiceClass(L3vpnInstance vrf, QAsnDiffServMode dsMode, IAsnTranslationContext context) {
        this.decodeDsModeProperty(vrf, "serviceClass", 2, dsMode, context, dsMode.phb);
    }

    private void decodeUniAf(QAsnRoutingInstIpv4Unicast asn, UniAf uniAf, IAsnTranslationContext context) {
        uniAf.setRouteLimitNum(QAsnRoutingInstIpv4UnicastSpecTranslator.getRouteLimitNum(asn));
        uniAf.setAlertPercent(null);
        uniAf.setSimplyAlert(null);
        if (uniAf.getRouteLimitNum() != null) {
            uniAf.setAlertPercent(QAsnRoutingInstIpv4UnicastSpecTranslator.getAlertPercent(asn));
            if (uniAf.getAlertPercent() == null) {
                uniAf.setSimplyAlert(QAsnRoutingInstIpv4UnicastSpecTranslator.getSimplyAlert(asn));
            }
        }
        if (context.getOperType().equals((Object)EOperationType.CREATE) || context.getOperType().equals((Object)EOperationType.PREDEPLOY)) {
            uniAf.setDeployStatus(Integer.valueOf(0));
        }
        AsnTranslatorUtil.setChanged((VmfMO)uniAf, (Object[][])z_uniAFMasks, (Integer)asn.poOperMask, (IAsnTranslationContext)context);
    }

    private void encodeTTLAndDiffServiceMode(L3vpnInstance vrf, QAsnRoutingInstIpv4Unicast asn, IAsnTranslationContext context) throws VMFException {
        if (!this.hasDiffServiceCap(vrf)) {
            return;
        }
        asn.ttlMode = AsnTranslatorUtil.intValue((Integer)vrf.getTtlMode());
        if (vrf.getPipeMode() != null || vrf.getServiceClass() != null || vrf.getColor() != null) {
            if (asn.poDsMode == null) {
                asn.poDsMode = new QAsnDiffServMode();
            }
        } else {
            return;
        }
        AsnUtil.setDefaultAsnValue((FStruct)asn.poDsMode);
        asn.poDsMode.type = AsnTranslatorUtil.intValue((Integer)vrf.getPipeMode());
        asn.poDsMode.phb = AsnTranslatorUtil.intValue((Integer)vrf.getServiceClass());
        asn.poDsMode.color = AsnTranslatorUtil.intValue((Integer)vrf.getColor());
        if (L3vpnInstance.PIPE_MODE_ENUM.UNIFORM.equals(vrf.getPipeMode())) {
            asn.poDsMode.phb = -1;
            asn.poDsMode.color = -1;
        }
        asn.poDsMode.poOperMask = AsnTranslatorUtil.getOperMask((Integer)asn.poDsMode.poOperMask, (int)AsnTranslatorUtil.setChangeMask((VmfMO)vrf, (IAsnTranslationContext)context, (Object[][])QAsnRoutingInstIpv4UnicastTranslator.z_vrfDiffServiceMasks, (int)0, (int)0));
        asn.poOperMask = AsnTranslatorUtil.getOperMask((Integer)asn.poOperMask, (int)AsnTranslatorUtil.setChangeMask((VmfMO)vrf, (IAsnTranslationContext)context, (Object[][])QAsnRoutingInstIpv4UnicastTranslator.z_vrfMasks, (int)0, (int)0));
    }

    private void encodeTTLAndDiffServiceMode(VpnInstAF af, QAsnRoutingInstIpv4Unicast asn, IAsnTranslationContext context) throws VMFException {
        if (!this.hasDiffServiceCap(af)) {
            return;
        }
        asn.ttlMode = AsnTranslatorUtil.intValue((Integer)af.getTtlMode());
        if (af.getPipeMode() != null || af.getServiceClass() != null || af.getColor() != null) {
            if (asn.poDsMode == null) {
                asn.poDsMode = new QAsnDiffServMode();
            }
        } else {
            return;
        }
        AsnUtil.setDefaultAsnValue((FStruct)asn.poDsMode);
        asn.poDsMode.type = AsnTranslatorUtil.intValue((Integer)af.getPipeMode());
        asn.poDsMode.phb = AsnTranslatorUtil.intValue((Integer)af.getServiceClass());
        asn.poDsMode.color = AsnTranslatorUtil.intValue((Integer)af.getColor());
        if (VpnInstAF.PIPE_MODE_ENUM.UNIFORM.equals(af.getPipeMode())) {
            asn.poDsMode.phb = -1;
            asn.poDsMode.color = -1;
        }
        asn.poDsMode.poOperMask = AsnTranslatorUtil.getOperMask((Integer)asn.poDsMode.poOperMask, (int)AsnTranslatorUtil.setChangeMask((VmfMO)af, (IAsnTranslationContext)context, (Object[][])QAsnRoutingInstIpv4UnicastTranslator.z_vrfAFDiffServiceMasks, (int)0, (int)0));
    }

    private void encodeUniAf(UniAf af, QAsnRoutingInstIpv4Unicast asn, IAsnTranslationContext context) {
        if (af.getSimplyAlert() != null) {
            asn.simplyAlert = af.getSimplyAlert() != false ? 1 : 0;
        }
        asn.routeLimit = AsnUtil.intValue((Long)af.getRouteLimitNum(), (int)0);
        if (af.getAlertPercent() != null) {
            asn.alertPercent = af.getAlertPercent().intValue();
        }
        asn.poOperMask = AsnTranslatorUtil.getOperMask((Integer)asn.poOperMask, (int)AsnTranslatorUtil.setChangeMask((VmfMO)af, (IAsnTranslationContext)context, (Object[][])QAsnRoutingInstIpv4UnicastTranslator.z_uniAFMasks, (int)0, (int)0));
    }

    private L3vpnInstance getVrfFromContext(IAsnTranslationContext cxt) {
        return (L3vpnInstance)cxt.getProperty(L3vpnInstance.class.getName());
    }

    private boolean hasDiffServiceCap(L3vpnInstance vrf) throws VMFException {
        CapabilityInfo capabilityInfo = Utility.getCapabilityInfo((VmfMO)vrf);
        Collection attrCaps = capabilityInfo.getMoAttrCapabilityInfos(L3vpnInstance.class);
        for (AttrCapabilityInfo attr : attrCaps) {
            if (!"pipeMode".equals(attr.getAttrName())) continue;
            return true;
        }
        return false;
    }

    private boolean hasDiffServiceCap(VpnInstAF af) throws VMFException {
        CapabilityInfo capabilityInfo = Utility.getCapabilityInfo((VmfMO)af);
        Collection attrCaps = capabilityInfo.getMoAttrCapabilityInfos(VpnInstAF.class);
        for (AttrCapabilityInfo attr : attrCaps) {
            if (!"pipeMode".equals(attr.getAttrName())) continue;
            return true;
        }
        return false;
    }

    static class DS_MODE_MASK {
        private static final int DSPIPE_COLOR_CHG = 4;
        private static final int DSPIPE_DOMAIN_CHG = 8;
        private static final int DSPIPE_PHB_CHG = 2;
        private static final int DSPIPE_TYPE_CHG = 1;

        DS_MODE_MASK() {
        }
    }
}

