/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.translation.asn.spec;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnTunnelSelection;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnTunnelSelectionList;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnGetVrfBindingTunnel;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnTunnelInfo;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnTunnel;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.mpls.service.IMplsService;
import com.huawei.vmf.adapter.l3vpn.Activator;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class QAsnGetVrfBindingTunnelTranslator
extends AbstractAsnTranslator<QAsnGetVrfBindingTunnel, L3vpnInstance> {
    public void decode(QAsnGetVrfBindingTunnel asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encode(L3vpnInstance mo, QAsnGetVrfBindingTunnel asn, IAsnTranslationContext context) throws VMFException {
        L3vpnInstanceFdnParser fdnParser = new L3vpnInstanceFdnParser();
        asn.vrfKey = fdnParser.getUniResID((VmfMO)mo);
        if (CollectionUtils.isEmpty((Collection)mo.getVpnInstAFs())) {
            return;
        }
        if (asn.tnlPolicyList == null) {
            asn.tnlPolicyList = new QAsnTunnelSelectionList();
        }
        for (VpnInstAF vrfAF : mo.getVpnInstAFs()) {
            QAsnTunnelSelection tunnelAsn;
            if (!vrfAF.getAfType().equals(VpnInstAF.AF_TYPE_ENUM.IPV4UNI)) continue;
            if (!CollectionUtils.isEmpty((Collection)vrfAF.getL3vpnTunnelInfos())) {
                for (L3vpnTunnelInfo tunnelInfo : vrfAF.getL3vpnTunnelInfos()) {
                    tunnelAsn = new QAsnTunnelSelection();
                    tunnelAsn.neID = mo.getDevID();
                    tunnelAsn.poVrID = mo.getVrID();
                    tunnelAsn.type = 1;
                    tunnelAsn.poTnlPolicy = StringUtil.globalByte((String)tunnelInfo.getTunnelName());
                    asn.tnlPolicyList.add((Object)tunnelAsn);
                }
            }
            if (CollectionUtils.isEmpty((Collection)vrfAF.getVpnTunnels())) continue;
            for (VpnTunnel vpnTunnel : vrfAF.getVpnTunnels()) {
                tunnelAsn = new QAsnTunnelSelection();
                tunnelAsn.neID = mo.getDevID();
                tunnelAsn.poVrID = mo.getVrID();
                tunnelAsn.type = 3;
                StaticTunnel staticTunnel = new StaticTunnel();
                staticTunnel.setDevID(vpnTunnel.getDevID());
                staticTunnel.setTunnelName(vpnTunnel.getTunnelName());
                ArrayList<StaticTunnel> tunnels = new ArrayList<StaticTunnel>();
                tunnels.add(staticTunnel);
                try {
                    IMplsService mplsService = Activator.getService(IMplsService.class);
                    mplsService.loadStaticTunnelFdnByTnlName(tunnels);
                    if (!CollectionUtils.isEmpty(tunnels) && null != staticTunnel.getFdn()) {
                        staticTunnel = (StaticTunnel)tunnels.iterator().next();
                        QAsnUniResID tunnelKey = new QAsnUniResID();
                        tunnelKey.neID = vpnTunnel.getDevID();
                        tunnelKey.strFDN = StringUtil.globalByte((String)staticTunnel.getFdn());
                        tunnelKey.strMOC = StringUtil.globalByte((String)FDNUtil.getFdnType((String)staticTunnel.getFdn()));
                        tunnelAsn.poTnlKey = tunnelKey;
                    }
                }
                catch (VMFException e) {
                    e.printStackTrace();
                }
                asn.tnlPolicyList.add((Object)tunnelAsn);
            }
        }
    }

    public Class<QAsnGetVrfBindingTunnel> getAsnClass() {
        return QAsnGetVrfBindingTunnel.class;
    }

    public Class<L3vpnInstance> getMoClass() {
        return L3vpnInstance.class;
    }
}

