/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.translation.asn;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnVpnFrr;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.fdn.InterfaceUniResIDParser;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.StaticFrr;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.mpls.service.IMplsService;
import com.huawei.vmf.adapter.l3vpn.Activator;
import com.huawei.vmf.adapter.l3vpn.translation.asn.spec.QAsnVpnFrrSpecTranslator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class QAsnVpnFrrTranslator
extends AbstractAsnTranslator<QAsnVpnFrr, StaticFrr> {
    public static final int NONE = 0;
    public static final int RI_PTNFRR_IPFRRPARA_CHG = 2;
    public static final int RI_PTNFRR_VPNFRRPARA_CHG = 1;
    public static final int RI_VPNFRR_VPNWAITETIME_CHG = 4;
    public static final int STATIC_RI_VPNFRR_ADD = 1;
    public static final int STATIC_RI_VPNFRR_DEL = 2;
    public static final int STATIC_RI_VPNFRR_NEXTHOP = 8;
    public static final int STATIC_RI_VPNFRR_VPNWAITETIME_CHG = 16;
    public static final int STATIC_RI_VPNFRR_TRACKEVENTTYPE_CHG = 32;
    public static final int STATIC_RI_VPNFRR_BFDINDEX_CHG = 64;
    public static final int STATIC_RI_VPNFRR_VRRPKEY_CHG = 128;
    public static final Object[][] z_qasnVpnFrrMasks = new Object[][]{{StaticFrr.class.getName(), 2}};
    public static final Object[][] z_staticFrrMasks = new Object[][]{{"wtrTime", 16}, {"nextHopMaster", 8}, {"trackEventType", 32}, {"bfdSessionName", 64}, {"vrrpId", 128}, {"vrrpIfName", 128}};
    public static final Object[][] z_trackBfdMasks = new Object[0][];
    private QAsnVpnFrrSpecTranslator qasnVpnFrrSpecTranslator = new QAsnVpnFrrSpecTranslator();

    public void decode(QAsnVpnFrr asn, StaticFrr mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnVpnFrrSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeStaticFrr(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        if (null != asn.poTrackEventType && -1 != asn.poTrackEventType) {
            mo.setTrackEventType(Integer.valueOf(AsnUtil.intValue((Integer)asn.poTrackEventType)));
        }
        this.qasnVpnFrrSpecTranslator.decodePoBFDName(asn, mo, context);
        this.qasnVpnFrrSpecTranslator.decodePoVRRPKey(asn, mo, context);
        this.setChanged((VmfMO)mo, z_staticFrrMasks, asn.poOperMask, context);
    }

    public String decodeInterface(String fdn) {
        String ifName = null;
        if (StringUtil.isEmpty((String)fdn)) {
            return ifName;
        }
        InterfaceFdnParser parser = new InterfaceFdnParser();
        Interface ifMo = parser.getIndexMo(fdn);
        ifName = ifMo.getIfName();
        return ifName;
    }

    public void decodeStaticFrr(QAsnVpnFrr asn, StaticFrr mo, IAsnTranslationContext context) throws VMFException {
        L3vpnInstance l3vpnInstance = (L3vpnInstance)context.getProperty(L3vpnInstance.class.getName());
        mo.setDevID(l3vpnInstance.getDevID());
        mo.setVrID(l3vpnInstance.getVrID());
        mo.setVrfName(l3vpnInstance.getVrfName());
        this.qasnVpnFrrSpecTranslator.decodeQAsnVpnFrrSpecKeys(asn, mo, context);
        mo.setNextHopMaster(StringUtil.globalString((byte[])asn.nextHop));
        mo.setNextHopSlave(StringUtil.globalString((byte[])asn.poBackupNextHop));
        this.decodeTnlKey(asn, mo);
        context.addProperty(StaticFrr.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 1, 2, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setWtrTime(this.integerValue(asn.poWtr, "wtrTime", z_staticFrrMasks, (VmfMO)mo, context));
        mo.setDeployStatus(this.integerValue(asn.poDeployStatus, "poDeployStatus", null, (VmfMO)mo, context));
        this.setChanged((VmfMO)mo, z_staticFrrMasks, asn.poOperMask, context);
    }

    public void decodeTnlKey(QAsnVpnFrr asn, StaticFrr mo) {
        if (null != asn.poType && StaticFrr.FRR_TYPE.IP_FRR == asn.poType) {
            mo.setIfNameMaster(this.decodeInterface(StringUtil.globalString((byte[])asn.poTnlKey.strFDN)));
            mo.setIfNameSlave(this.decodeInterface(StringUtil.globalString((byte[])asn.poBackupTnlKey.strFDN)));
        } else if (null != asn.poType && StaticFrr.FRR_TYPE.VPN_FRR == asn.poType) {
            mo.setIfNameMaster(this.getTunnelNameByFDN(StringUtil.globalString((byte[])asn.poTnlKey.strFDN)));
            mo.setIfNameSlave(this.getTunnelNameByFDN(StringUtil.globalString((byte[])asn.poBackupTnlKey.strFDN)));
        } else if (null != asn.poType && StaticFrr.FRR_TYPE.MIX_VUNI_VNNI_FRR == asn.poType) {
            mo.setIfNameMaster(this.decodeInterface(StringUtil.globalString((byte[])asn.poTnlKey.strFDN)));
            mo.setIfNameSlave(this.getTunnelNameByFDN(StringUtil.globalString((byte[])asn.poBackupTnlKey.strFDN)));
        } else if (null != asn.poType && StaticFrr.FRR_TYPE.MIX_VNNI_VUNI_FRR == asn.poType) {
            mo.setIfNameMaster(this.getTunnelNameByFDN(StringUtil.globalString((byte[])asn.poTnlKey.strFDN)));
            mo.setIfNameSlave(this.decodeInterface(StringUtil.globalString((byte[])asn.poBackupTnlKey.strFDN)));
        }
    }

    public String decodeTunnel(String fdn) {
        String ifName = null;
        if (StringUtil.isEmpty((String)fdn)) {
            return ifName;
        }
        String moType = FDNUtil.getFdnType((String)fdn);
        if ("LP".equals(moType)) {
            InterfaceUniResIDParser parser = new InterfaceUniResIDParser();
            parser.deserialize(fdn);
            ifName = parser.getIfName();
        }
        return ifName;
    }

    public void encode(StaticFrr mo, QAsnVpnFrr asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnVpnFrrSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeStaticFrr(mo, asn, context);
        Integer trackEventType = mo.getTrackEventType();
        if (null != trackEventType && trackEventType.equals(StaticFrr.TRACK_EVENT_TYPE_ENUM.TRACK_BFD) && null != mo.getBfdSessionName()) {
            asn.poBFDName = this.getBytes(mo.getBfdSessionName());
        }
        asn.poTrackEventType = this.intValue(trackEventType);
        this.qasnVpnFrrSpecTranslator.encodePoVRRPKey(mo, asn, context);
        asn.poOperResult = this.getQAsnSingleReturn((VmfMO)mo, context);
    }

    public void encodeStaticFrr(StaticFrr mo, QAsnVpnFrr asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.nextHop = this.getBytes(mo.getNextHopMaster());
        asn.poBackupNextHop = this.getBytes(mo.getNextHopSlave());
        asn.poWtr = this.intValue(mo.getWtrTime());
        asn.poTnlKey = this.getTnlKey(mo, mo.getIfNameMaster());
        asn.poBackupTnlKey = this.getTnlKey(mo, mo.getIfNameSlave());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_staticFrrMasks, 1, 2));
        this.encodeFrrType(mo, asn);
    }

    public Class<QAsnVpnFrr> getAsnClass() {
        return QAsnVpnFrr.class;
    }

    public Class<StaticFrr> getMoClass() {
        return StaticFrr.class;
    }

    public String getTunnelNameByFDN(String strFdn) {
        try {
            IMplsService mplsService = Activator.getService(IMplsService.class);
            Collection tunnelObjs = mplsService.queryStaticTunnelByFdn(Arrays.asList(strFdn), false);
            if (!CollectionUtils.isEmpty((Collection)tunnelObjs)) {
                StaticTunnel tunnelObj = (StaticTunnel)tunnelObjs.iterator().next();
                return tunnelObj.getTunnelName();
            }
        }
        catch (VMFException e) {
            e.printStackTrace();
        }
        return "";
    }

    public boolean isTunnel(String ifName) {
        return ifName.startsWith("Tunnel");
    }

    private void encodeFrrType(StaticFrr mo, QAsnVpnFrr asn) {
        String masterIF = mo.getIfNameMaster();
        String slaveIf = mo.getIfNameSlave();
        if (this.isTunnel(masterIF) && this.isTunnel(slaveIf)) {
            asn.poType = StaticFrr.FRR_TYPE.VPN_FRR;
        } else if (!this.isTunnel(masterIF) && !this.isTunnel(slaveIf)) {
            asn.poType = StaticFrr.FRR_TYPE.IP_FRR;
        } else if (this.isTunnel(masterIF) && !this.isTunnel(slaveIf)) {
            asn.poType = StaticFrr.FRR_TYPE.MIX_VNNI_VUNI_FRR;
        } else if (!this.isTunnel(masterIF) && this.isTunnel(slaveIf)) {
            asn.poType = StaticFrr.FRR_TYPE.MIX_VUNI_VNNI_FRR;
        }
    }

    private QAsnUniResID getTnlKey(StaticFrr mo, String ifName) {
        QAsnUniResID ifKey = new QAsnUniResID();
        if (this.isTunnel(ifName)) {
            StaticTunnel staticTunnel = new StaticTunnel();
            staticTunnel.setDevID(mo.getDevID());
            staticTunnel.setTunnelName(ifName);
            ArrayList<StaticTunnel> tunnels = new ArrayList<StaticTunnel>();
            tunnels.add(staticTunnel);
            try {
                IMplsService mplsService = Activator.getService(IMplsService.class);
                mplsService.loadStaticTunnelFdnByTnlName(tunnels);
                if (!CollectionUtils.isEmpty(tunnels) && null != staticTunnel.getFdn()) {
                    staticTunnel = (StaticTunnel)tunnels.iterator().next();
                    ifKey.neID = mo.getDevID();
                    ifKey.strFDN = StringUtil.globalByte((String)staticTunnel.getFdn());
                    ifKey.strMOC = StringUtil.globalByte((String)FDNUtil.getFdnType((String)staticTunnel.getFdn()));
                    return ifKey;
                }
                QAsnVpnFrrTranslator.getLogger().info("get ifName FDN failed, return null :{} ", (Object)ifName);
                return null;
            }
            catch (VMFException e) {
                QAsnVpnFrrTranslator.getLogger().info("get ifName FDN failed, return null", (Throwable)e);
                return null;
            }
        }
        InterfaceFdnParser parser = new InterfaceFdnParser();
        Interface ifMo = new Interface();
        ifMo.setIfName(ifName);
        ifMo.setVrID(mo.getVrID());
        ifMo.setDevID(mo.getDevID());
        return parser.getUniResID((VmfMO)ifMo);
    }
}

