/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.translation.asn;

import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnEthCtp;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnLinkProtocol;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.IDBLinkageHandler;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.pwe3.model.ServiceInterface;
import com.huawei.vmf.adapter.l3vpn.common.Utility;
import com.huawei.vmf.adapter.l3vpn.service.InterfaceDBLinkageHandler;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class QAsnSapTranslator {
    private final Logger logger = LoggerFactory.getLogger(QAsnSapTranslator.class);

    public static ServiceInterface getSvcInterface(Interface interfaceMo) {
        ServiceInterface svcInterface = new ServiceInterface();
        svcInterface.setDevID(interfaceMo.getDevID());
        svcInterface.setVrID(interfaceMo.getVrID());
        svcInterface.setInterfaceName(interfaceMo.getIfName());
        return svcInterface;
    }

    public void decodeServiceInterface(IAsnTranslationContext asnTranslatorContext, L3vpnInstance vrf, Interface interfaceMo, QAsnSAP asn) {
        if (AsnTranslatorUtil.isModifyProperty((IAsnTranslationContext)asnTranslatorContext, (Integer)asn.poOperMask, (int)2)) {
            if (asnTranslatorContext.getProperty(InterfaceDBLinkageHandler.class.getName()) == null) {
                asnTranslatorContext.addProperty(InterfaceDBLinkageHandler.class.getName(), (Object)Boolean.TRUE);
                asnTranslatorContext.getTransactionContext().addDBLinkageHandler((IDBLinkageHandler)new InterfaceDBLinkageHandler());
            }
            return;
        }
        if (asnTranslatorContext.getOperType().equals((Object)EOperationType.PREDEPLOY) || asnTranslatorContext.getOperType().equals((Object)EOperationType.CREATE) || AsnTranslatorUtil.isModifyProperty((IAsnTranslationContext)asnTranslatorContext, (Integer)asn.poOperMask, (int)1)) {
            this.decodeForCreate(asnTranslatorContext, vrf, interfaceMo, asn);
            return;
        }
        if (asnTranslatorContext.getOperType().equals((Object)EOperationType.MODIFY) && AsnTranslatorUtil.isModifyProperty((IAsnTranslationContext)asnTranslatorContext, (Integer)asn.poOperMask, (int)4)) {
            this.decodeForModify(asnTranslatorContext, vrf, interfaceMo, asn);
            return;
        }
    }

    public void encodeServiceInterface(L3vpnInstance vrf, Map<String, QAsnSAP> ifName2SapAsn, IAsnTranslationContext context, Map<String, Boolean> interfaceAddOrDelFlag) {
        if (CollectionUtils.isEmpty((Collection)vrf.getKeyRefMos(ServiceInterface.class))) {
            return;
        }
        IMOChangeRecord svcInterfaceRcd = context.getTransactionContext().getChangeRecord(ServiceInterface.class);
        if (svcInterfaceRcd == null) {
            return;
        }
        for (ServiceInterface svcInterface : vrf.getKeyRefMos(ServiceInterface.class)) {
            QAsnSAP asn = ifName2SapAsn.get(svcInterface.getInterfaceName());
            if (asn == null) {
                this.logger.error(String.format("interface[%s] not exist, but ServiceInterface exist", svcInterface.getInterfaceName()));
                continue;
            }
            if (asn.poLinkProtocol == null) {
                asn.poLinkProtocol = new QAsnLinkProtocol();
                asn.poLinkProtocol.type = 1;
            }
            if (asn.poLinkProtocol.type != 1) {
                this.logger.error(String.format("linkProtocol[%d] of interface[%s] is not Eth", asn.poLinkProtocol.type, svcInterface.getInterfaceName()));
                continue;
            }
            if (asn.poLinkProtocol.poEthCtp == null) {
                asn.poLinkProtocol.poEthCtp = new QAsnEthCtp();
            }
            asn.poLinkProtocol.poEthCtp.poTrackPw = 0;
            if (svcInterfaceRcd.isCreated((Object)svcInterface)) {
                asn.poLinkProtocol.poEthCtp.poTrackPw = 1;
            }
            if (interfaceAddOrDelFlag.containsKey(svcInterface.getInterfaceName())) continue;
            asn.poOperMask = AsnTranslatorUtil.getOperMask((Integer)asn.poOperMask, (int)4);
            asn.poLinkProtocol.poEthCtp.poOperMask = AsnTranslatorUtil.getOperMask((Integer)asn.poLinkProtocol.poEthCtp.poOperMask, (int)0x200000);
        }
    }

    private void decodeForCreate(IAsnTranslationContext asnTranslatorContext, L3vpnInstance vrf, Interface interfaceMo, QAsnSAP asn) {
        if (asn.poLinkProtocol != null && asn.poLinkProtocol.type == 1 && asn.poLinkProtocol.poEthCtp != null && Integer.valueOf(1).equals(asn.poLinkProtocol.poEthCtp.poTrackPw)) {
            ServiceInterface svcInterface = QAsnSapTranslator.getSvcInterface(interfaceMo);
            if (asnTranslatorContext.getOperType().equals((Object)EOperationType.PREDEPLOY)) {
                svcInterface.setDeployStatus(Integer.valueOf(0));
            }
            Utility.INSTANCE.addMo2Context(asnTranslatorContext, ServiceInterface.class, svcInterface, (VmfMO)vrf, EOperationType.CREATE);
        }
    }

    private void decodeForModify(IAsnTranslationContext asnTranslatorContext, L3vpnInstance vrf, Interface interfaceMo, QAsnSAP asn) {
        if (asn.poLinkProtocol != null && asn.poLinkProtocol.type == 1 && asn.poLinkProtocol.poEthCtp != null && AsnTranslatorUtil.isModifyProperty((IAsnTranslationContext)asnTranslatorContext, (Integer)asn.poLinkProtocol.poEthCtp.poOperMask, (int)0x200000)) {
            ServiceInterface svcInterface = QAsnSapTranslator.getSvcInterface(interfaceMo);
            if (Integer.valueOf(1).equals(asn.poLinkProtocol.poEthCtp.poTrackPw)) {
                Utility.INSTANCE.addMo2Context(asnTranslatorContext, ServiceInterface.class, svcInterface, (VmfMO)vrf, EOperationType.CREATE);
            } else {
                Utility.INSTANCE.addMo2Context(asnTranslatorContext, ServiceInterface.class, svcInterface, (VmfMO)vrf, EOperationType.DELETE);
            }
        }
    }
}

