/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.translation.asn;

import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnRoutingInstIpv4Unicast;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnRoutingInstance;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.l3vpn.translation.asn.IQAsnRoutingInstanceTranslatorExtPoint;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.route.model.BgpVrf;
import com.huawei.vmf.adapter.fservice.route.model.IsSite;
import com.huawei.vmf.adapter.fservice.route.model.OspfSite;
import com.huawei.vmf.adapter.fservice.route.model.SrRoute;
import com.huawei.vmf.adapter.l3vpn.translation.asn.QAsnRoutingInstIpv4UnicastTranslator;
import com.huawei.vmf.adapter.l3vpn.translation.asn.spec.QAsnRoutingInstanceSpecTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnRoutingInstanceTranslator
extends AbstractAsnTranslator<QAsnRoutingInstance, L3vpnInstance> {
    public static final int RI_AFIPV4MULTICAST_CHG = 16384;
    public static final int RI_AFIPV4UNICAST_CHG = 8192;
    public static final int RI_AFIPV6MULTICAST_CHG = 65536;
    public static final int RI_AFIPV6UNICAST_CHG = 32768;
    public static final int RI_ARPITEMLIST_CHG = 4096;
    public static final int RI_ASNUMBER_CHG = 4;
    public static final int RI_BGPINSTLIST_CHG = 128;
    public static final int RI_CTPLIST_CHG = 32;
    public static final int RI_DEPLOY_STATUS_CHG = 0x100000;
    public static final int RI_DESCRIPTION_CHG = 64;
    public static final int RI_DHCPRELAY_CHG = 0x200000;
    public static final int RI_ENABLE_STATUS_CHG = 262144;
    public static final int RI_ISISINSTLIST_CHG = 1024;
    public static final int RI_LABELASSIGNMODE_CHG = 8;
    public static final int RI_OSPFINSTLIST_CHG = 512;
    public static final int RI_RIPINSTLIST_CHG = 2048;
    public static final int RI_RUNNING_STATUS_CHG = 524288;
    public static final int RI_STATIC_VRF_FRR_CHG = 0x20000000;
    public static final int RI_STATICROUTEINSTLIST_CHG = 256;
    public static final int RI_TNLPOLICYLIST_CHG = 16;
    public static final int RI_USERLABEL_CHG = 131072;
    public static final int SEC_RI_TRANSITVPN_CHG = 4;
    public static final int SEC_RI_VRFPEER_CHG = 2;
    public static final int SEC_RI_VRFPERVPNLABEL_CHG = 1;
    public static final Object[][] z_l3vpnInstanceMasks = new Object[][]{{"vrfDescription", 64}, {"deployStatus", 0x100000}, {"vpnInstAFs", 16}, {"vpnInstAFs", 16}, {BgpVrf.class.getName(), 128}, {OspfSite.class.getName(), 512}, {IsSite.class.getName(), 1024}, {SrRoute.class.getName(), 256}, {Interface.class.getName(), 32}, {"cfgRouterId", 32}, {"l3vpnIfs", 32}, {"vpnInstAFs", 16}, {"vpnInstAFs", 8}, {"vpnInstAFs", 8192}, {"staticFrrs", 0x20000000}};
    public static final Object[][] z_l3vpnInstanceSecMasks = new Object[][]{{"vpnInstAFs", 2}, {"vpnInstAFs", 1}, {"vpnInstAFs", 4}};
    public static final Object[][] z_qasnRoutingInstanceMasks = new Object[][]{{"poAsNumber", 4}, {"labelAssignMode", 8}, {"tnlPolicyList", 16}, {"sapList", 32}, {"description", 64}, {"bgpInstList", 128}, {"staticRouteList", 256}, {"ospfInstList", 512}, {"isisInstList", 1024}, {"ripInstList", 2048}, {"arpItemList", 4096}, {"poAfIpv4Unicast", 8192}, {"poAfIpv4Multicast", 16384}, {"poAfIpv6Unicast", 32768}, {"poAfIpv6Multicast", 65536}, {"poUserLabel", 131072}, {"enableStatus", 262144}, {"runningStatus", 524288}, {"deployStatus", 0x100000}, {"poDhcpRelayInfo", 0x200000}, {"poFrr", 0x20000000}};
    public static final Object[][] z_qasnRoutingInstanceSecMasks = new Object[][]{{"vpnPeerList", 2}, {"poInnerLabel", 1}};
    public static final Object[][] z_vpnInstAFMasks = new Object[][]{{"tnlPolicyName", 16}, {"vrfLabelMode", 8}, {"vrfStatus", 524288}};
    public static final Object[][] z_vpnInstAFMasksStatic = new Object[][]{{"vpnTunnels", 16}, {"vrfLabelMode", 8}, {"vrfStatus", 524288}};
    public static final Object[][] z_vpnInstAFSecMasks = new Object[][]{{"vpnPeers", 2}, {"vrfLabel", 1}, {"transitVpn", 4}};
    private QAsnRoutingInstanceSpecTranslator qasnRoutingInstanceSpecTranslator = new QAsnRoutingInstanceSpecTranslator();
    private IAsnTranslator<QAsnRoutingInstIpv4Unicast, VpnInstAF> qasnRoutingInstIpv4UnicastTranslator = new QAsnRoutingInstIpv4UnicastTranslator();

    public void decode(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnRoutingInstanceSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeL3vpnInstance(asn, mo, context);
        VpnInstAF vpnInstAF = new VpnInstAF();
        this.decodeVpnInstAF(asn, vpnInstAF, context);
        mo.addVpnInstAFs(Arrays.asList(vpnInstAF));
        this.qasnRoutingInstanceSpecTranslator.decodeVrfRD(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodePoAsNumber(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodeLabelAssignMode(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodeTnlPolicyList(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodeSapList(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodeBgpInstList(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodeStaticRouteList(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodeOspfInstList(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodeIsisInstList(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodeRipInstList(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodeArpItemList(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodePoAfIpv4Multicast(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodePoAfIpv6Unicast(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodePoAfIpv6Multicast(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodePoDhcpRelayInfo(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodePoPimInfo(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodePoVrfQos(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodePoUpePeerList(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodePoRoutAggrList(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodePoLoopBackIpList(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodePoMulticastInfo(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodePoFrr(asn, mo, context);
        this.qasnRoutingInstanceSpecTranslator.decodeVpnPeerList(asn, mo, context);
    }

    public void decodeL3vpnInstance(QAsnRoutingInstance asn, L3vpnInstance mo, IAsnTranslationContext context) throws VMFException {
        Object l3vpnRoutingInstanceExtPoit = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnRoutingInstanceTranslatorExtPoint.class);
        if (null != l3vpnRoutingInstanceExtPoit) {
            ((IQAsnRoutingInstanceTranslatorExtPoint)l3vpnRoutingInstanceExtPoit).decodeL3vpnInstance(asn, mo, context);
        } else {
            mo.setVrfName(this.strValue(asn.vrfName));
        }
        context.addProperty(L3vpnInstance.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setCfgRouterId(null);
        mo.setVrfDescription(this.strValue(asn.description, "vrfDescription", z_l3vpnInstanceMasks, (VmfMO)mo, context));
        mo.setDeployStatus(asn.deployStatus == -1 ? null : Integer.valueOf(asn.deployStatus));
        this.setChanged((VmfMO)mo, z_l3vpnInstanceMasks, asn.poOperMask, context);
        this.setChanged((VmfMO)mo, z_l3vpnInstanceSecMasks, asn.poSecOperMask, context);
    }

    public void decodeVpnInstAF(QAsnRoutingInstance asn, VpnInstAF mo, IAsnTranslationContext context) throws VMFException {
        L3vpnInstance l3vpnInstance = (L3vpnInstance)context.getProperty(L3vpnInstance.class.getName());
        mo.setDevID(l3vpnInstance.getDevID());
        mo.setVrID(l3vpnInstance.getVrID());
        mo.setVrfName(l3vpnInstance.getVrfName());
        if (asn.poVrfType == null || asn.poVrfType < 0) {
            mo.setAfType(VpnInstAF.AF_TYPE_ENUM.IPV4UNI);
        } else {
            mo.setAfType(Integer.valueOf(this.intValue(asn.poVrfType)));
        }
        if (asn.poInnerLabel != null && asn.poInnerLabel > 0) {
            mo.setVrfLabel(Integer.valueOf(this.intValue(asn.poInnerLabel)));
        }
        context.addProperty(VpnInstAF.class.getName(), (Object)mo);
        Object l3vpnRoutingInstanceExtPoit = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnRoutingInstanceTranslatorExtPoint.class);
        if (null != l3vpnRoutingInstanceExtPoit) {
            ((IQAsnRoutingInstanceTranslatorExtPoint)l3vpnRoutingInstanceExtPoit).decodeVpnInstAF(asn, mo, context);
        } else {
            mo.setTransitVpn(this.parseBoolean(asn.poTransitVpn, "transitVpn", z_vpnInstAFSecMasks, (VmfMO)mo, context));
        }
        this.decodePoAfIpv4Unicast(asn, mo, context);
        if (this.intValue(mo.getVrfLabel()) > 0) {
            this.setChanged((VmfMO)mo, z_vpnInstAFMasksStatic, asn.poOperMask, context);
        } else {
            this.setChanged((VmfMO)mo, z_vpnInstAFMasks, asn.poOperMask, context);
        }
        this.setChanged((VmfMO)mo, z_vpnInstAFSecMasks, asn.poSecOperMask, context);
    }

    public void encode(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnRoutingInstanceSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeL3vpnInstance(mo, asn, context);
        if (!CollectionUtils.isEmpty((Collection)mo.getVpnInstAFs())) {
            for (VpnInstAF vpnInstAF : mo.getVpnInstAFs()) {
                this.encodeVpnInstAF(vpnInstAF, asn, context);
            }
        }
        this.qasnRoutingInstanceSpecTranslator.encodeVrfRD(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodePoAsNumber(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodeLabelAssignMode(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodeTnlPolicyList(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodeDhcpRelayVpn(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodeSapList(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodeBgpInstList(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodeStaticRouteList(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodeOspfInstList(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodeIsisInstList(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodeRipInstList(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodeArpItemList(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodePoAfIpv4Multicast(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodePoAfIpv6Unicast(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodePoAfIpv6Multicast(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodePoDhcpRelayInfo(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodePoPimInfo(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodePoVrfQos(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodePoUpePeerList(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodePoRoutAggrList(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodePoLoopBackIpList(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodePoMulticastInfo(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodeStaticArp(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodeVpnPeerList(mo, asn, context);
        this.qasnRoutingInstanceSpecTranslator.encodePoFrr(mo, asn, context);
        int mask = 0;
        mask = this.setChangeMask((VmfMO)mo, context, z_vpnInstAFSecMasks);
        asn.poSecOperMask = this.getOperMask(asn.poSecOperMask, mask);
        asn.poOperResult = this.getQAsnSingleReturn((VmfMO)mo, context);
    }

    public void encodeL3vpnInstance(L3vpnInstance mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        Object l3vpnRoutingInstanceExtPoit = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnRoutingInstanceTranslatorExtPoint.class);
        if (null != l3vpnRoutingInstanceExtPoit) {
            ((IQAsnRoutingInstanceTranslatorExtPoint)l3vpnRoutingInstanceExtPoit).encodeL3vpnInstance(mo, asn, context);
        } else {
            asn.vrfID = 0;
            asn.vrfName = this.getBytes(mo.getVrfName());
        }
        asn.poRouterID = this.getBytes(mo.getCfgRouterId());
        asn.description = this.getBytes(mo.getVrfDescription());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_l3vpnInstanceMasks));
        asn.deployStatus = this.intValue(mo.getDeployStatus());
        if (null == asn.vrfRD || asn.vrfRD.equals("--")) {
            asn.vrfRD = StringUtil.globalByte((String)"");
        }
        asn.poDcnVrf = mo.getVrfName().equals("__dcn_vpn__") ? BigInteger.valueOf(1L) : BigInteger.valueOf(0L);
    }

    public void encodeVpnInstAF(VpnInstAF mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        if (!mo.getAfType().equals(VpnInstAF.AF_TYPE_ENUM.IPV4UNI)) {
            return;
        }
        int mask = 0;
        asn.poVrfType = this.intValue(mo.getAfType());
        asn.poTransitVpn = this.intValue(mo.getTransitVpn());
        asn.runningStatus = asn.deployStatus == 0 ? -1 : this.intValue(mo.getVrfStatus());
        asn.poInnerLabel = this.intValue(mo.getVrfLabel());
        asn.poL3vpnType = this.intValue(mo.getVrfLabel()) > 0 ? VpnInstAF.VRF_L3VPN_TYPE.STATIC : VpnInstAF.VRF_L3VPN_TYPE.ACTIVE;
        mask |= this.setChangeMask((VmfMO)mo, context, z_vpnInstAFMasks);
        this.encodePoAfIpv4Unicast(mo, asn, context);
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask(asn.poAfIpv4Unicast.poOperMask, z_qasnRoutingInstanceMasks, "poAfIpv4Unicast"));
    }

    public Class<QAsnRoutingInstance> getAsnClass() {
        return QAsnRoutingInstance.class;
    }

    public Class<L3vpnInstance> getMoClass() {
        return L3vpnInstance.class;
    }

    private void decodePoAfIpv4Unicast(QAsnRoutingInstance asn, VpnInstAF mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.poAfIpv4Unicast) {
            return;
        }
        this.qasnRoutingInstIpv4UnicastTranslator.decode((FStruct)asn.poAfIpv4Unicast, (Object)mo, context);
    }

    private void encodePoAfIpv4Unicast(VpnInstAF mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
        if (null == asn.poAfIpv4Unicast) {
            asn.poAfIpv4Unicast = new QAsnRoutingInstIpv4Unicast();
            AsnUtil.setDefaultAsnValue((FStruct)asn.poAfIpv4Unicast);
        }
        this.qasnRoutingInstIpv4UnicastTranslator.encode((Object)mo, (FStruct)asn.poAfIpv4Unicast, context);
    }
}

