/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnUndeployL3vpnReq;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnUndeployL3vpnRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.l3vpn.common.Utility;
import com.huawei.vmf.adapter.l3vpn.task.AbstractOperL3vpnTask;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class UndeployL3vpnTask
extends AbstractOperL3vpnTask<QAsnUndeployL3vpnReq, QAsnUndeployL3vpnRsp> {
    final Map<Class<? extends VmfMO>, Collection<VmfMO>> canceldMOs = new HashMap<Class<? extends VmfMO>, Collection<VmfMO>>();
    private Collection<L3vpnInstance> l3vpns;

    protected UndeployL3vpnTask() {
        super(EOperationType.UNDEPLOY);
    }

    protected void decode(QAsnUndeployL3vpnReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        this.l3vpns = Utility.INSTANCE.getAllMosByVpnKeys((Collection<QAsnUniResID>)req.l3vpnKeyList, asnTranslatorContext, EOperationType.UNDEPLOY);
        this.cancelDeleteFromDevOnVrfDeleted(asnTranslatorContext, this.canceldMOs);
    }

    protected void encode(QAsnUndeployL3vpnRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        Utility.reviseDeployStatus(asnTranslatorContext, L3vpnInstance.class, this.canceldMOs);
        rsp.result.result = 0;
        Context cxt = asnTranslatorContext.getTransactionContext();
        for (L3vpnInstance l3vpn : this.l3vpns) {
            int err = cxt.getMoErrorCode((VmfMO)l3vpn);
            try {
                rsp.l3vpnList.add((Object)this.encode(l3vpn, rsp.result, asnTranslatorContext));
            }
            catch (VMFException e) {
                this.getLogger().error("encode error", (Throwable)e);
                err = 1090646033;
            }
            if (err == 0) continue;
            rsp.result.result = 1090646033;
        }
    }

    protected Integer getAsnBestEffort(QAsnUndeployL3vpnReq req) {
        return req.poBestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnUndeployL3vpnReq req) {
        return req.poTaskFlg;
    }
}

