/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.task;

import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_common.QAsnUniResIDList;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnSyncL3vpnReq;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnSyncL3vpnRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.common.EOperResultType;
import com.huawei.vmf.adapter.framework.service.QueryResult;
import com.huawei.vmf.adapter.framework.task.DefaultQueryByDevIDAndAttributesTask;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.fservice.sync.service.ISyncService;
import com.huawei.vmf.adapter.fservice.sync.service.ISynchronizeJobProgressListener;
import com.huawei.vmf.adapter.l3vpn.Activator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.commustru.fstru.FStruct;

public class SyncL3vpnTask
extends DefaultQueryByDevIDAndAttributesTask<QAsnSyncL3vpnReq, QAsnSyncL3vpnRsp, L3vpnInstance> {
    private List<QAsnErrInfo> errInfoLst = new ArrayList<QAsnErrInfo>();
    private final L3vpnInstanceFdnParser fdnParser = new L3vpnInstanceFdnParser();
    private List<Integer> freshDevIDs = new ArrayList<Integer>();
    private final ISynchronizeJobProgressListener listener = new ISynchronizeJobProgressListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void handleProgress(int neID, int progress, int errorCode, String detail) {
            if (100 == progress) {
                if (0 != errorCode) {
                    QAsnErrInfo errInfo = new QAsnErrInfo();
                    errInfo.objName = AsnUtil.getBytes((Number)neID);
                    errInfo.errCode = errorCode;
                    errInfo.strOperDesc = AsnUtil.getBytes((String)detail);
                    SyncL3vpnTask.this.errInfoLst.add(errInfo);
                    SyncL3vpnTask.this.getLogger().error("sync devm data error. devId=" + neID + " errorCode=" + errorCode + " detail=" + detail);
                } else {
                    SyncL3vpnTask.this.getLogger().info("sync devm data succ. devId=" + neID);
                }
                SyncL3vpnTask.this.getLogger().info("finish sync the devm data and remove the fresh device. devID : " + neID);
                SyncL3vpnTask.this.freshDevIDs.remove((Object)neID);
            }
            if (SyncL3vpnTask.this.freshDevIDs.isEmpty()) {
                Object object = SyncL3vpnTask.this.lock;
                synchronized (object) {
                    SyncL3vpnTask.this.lock.notifyAll();
                }
            }
        }
    };
    private Object lock = new Object();

    public SyncL3vpnTask(Collection<Integer> devIDs, QAsnUniResIDList l3vpnKeyList, QAsnErrInfoReturn operResult) {
        super(devIDs, L3vpnInstance.class, null, (Collection)l3vpnKeyList, (FStruct)operResult, true, false);
        this.setQueryAttributeNamesFromDev(Arrays.asList("vrfName"));
    }

    protected void doExtendedProcAfterQuery(QAsnSyncL3vpnReq req, QAsnSyncL3vpnRsp rsp, QueryResult result) throws VMFException {
        result.setOperResult(EOperResultType.SUCCESS);
        Iterator it = result.getQueryResult(L3vpnInstance.class).iterator();
        while (it.hasNext()) {
            L3vpnInstance vpn = (L3vpnInstance)it.next();
            if (!vpn.getVrfName().equals("_public_")) continue;
            it.remove();
        }
        super.doExtendedProcAfterQuery((FStruct)req, (FStruct)rsp, result);
    }

    protected QueryResult doQuery(QAsnSyncL3vpnReq req, QAsnSyncL3vpnRsp rsp) {
        this.syncData(req, rsp);
        return super.doQuery((FStruct)req, (FStruct)rsp);
    }

    protected QAsnUniResID encodeMO(QAsnSyncL3vpnReq req, QAsnSyncL3vpnRsp rsp, VmfMO mo) {
        for (QAsnErrInfo info : this.errInfoLst) {
            rsp.result.errList.add((Object)info);
        }
        return this.fdnParser.getUniResID((VmfMO)((L3vpnInstance)mo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncData(QAsnSyncL3vpnReq req, QAsnSyncL3vpnRsp rsp) {
        ISyncService service = Activator.getService(ISyncService.class);
        for (Object obj : req.neIDList) {
            Integer devID = (Integer)obj;
            this.freshDevIDs.add(devID);
            try {
                service.singleFeatureSync(devID.intValue(), FeatureName.L3VPN, new ISynchronizeJobProgressListener[]{this.listener});
            }
            catch (VMFException e) {
                this.getLogger().error("manunalSyncDevuceAndWait fail. " + (Object)((Object)e));
                this.freshDevIDs.remove(devID);
                QAsnErrInfo errInfo = new QAsnErrInfo();
                errInfo.objName = AsnUtil.getBytes((Number)devID);
                errInfo.errCode = e.getErrorCode();
                rsp.result.errList.add((Object)errInfo);
            }
        }
        if (!this.freshDevIDs.isEmpty()) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.freshDevIDs.isEmpty()) {
                    try {
                        this.lock.wait(30000000L);
                    }
                    catch (InterruptedException e) {
                        this.getLogger().error("lock.wait fail. " + e);
                    }
                }
            }
        }
    }
}

