/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnVpnFrr;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnVpnFrrList;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnSwitchVpnFrrReq;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnSwitchVpnFrrRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.schema.ActionSchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnStaticFrrFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.ClearForceSwitchFrr;
import com.huawei.vmf.adapter.fservice.l3vpn.model.ForceSwitchFrr;
import com.huawei.vmf.adapter.fservice.l3vpn.model.StaticFrr;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class SwitchVpnFrrTask
extends AbstractQTask<QAsnSwitchVpnFrrReq, QAsnSwitchVpnFrrRsp> {
    public static final int CLEAR_FORCE_SWITCHFRR = 3;
    public static final int FORCE_BACKUPTOMASTER = 2;
    public static final int FORCE_MASTERTOBACKUP = 1;

    protected void executeTask(QAsnSwitchVpnFrrReq req, QAsnSwitchVpnFrrRsp rsp, Task task) {
        rsp.result.result = 0;
        try {
            switch (req.action) {
                case 1: {
                    this.forceSwitchFrrByKey(req.vpnFrrList, rsp);
                    break;
                }
                case 2: 
                case 3: {
                    this.cleanForceSwitchFrrByKey(req.vpnFrrList, rsp);
                    break;
                }
            }
        }
        catch (VMFException e) {
            this.getLogger().error("GetVpnFrrRouteFromDev failed", (Throwable)e);
            rsp.result.result = e.getErrorCode();
        }
    }

    private void cleanForceSwitchFrrByKey(QAsnVpnFrrList vpnFrrList, QAsnSwitchVpnFrrRsp rsp) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)vpnFrrList)) {
            return;
        }
        L3vpnStaticFrrFdnParser parser = new L3vpnStaticFrrFdnParser();
        DefaultMOService moService = new DefaultMOService();
        for (Object ob : vpnFrrList) {
            QAsnVpnFrr staticVpnFrr = (QAsnVpnFrr)ob;
            StaticFrr staticFrr = new StaticFrr();
            staticFrr = (StaticFrr)parser.getIndexMo(staticVpnFrr.poVpnFrrKey);
            ActionSchemaTranslatorContext actionContext = new ActionSchemaTranslatorContext(staticFrr.getDevID().intValue());
            ClearForceSwitchFrr clearForceSWFrr = new ClearForceSwitchFrr();
            this.staticFrrToClearForceSwitchFrr(staticFrr, clearForceSWFrr);
            actionContext.addAction(FeatureName.L3VPN, (VmfMO)clearForceSWFrr);
            moService.addActionJob(actionContext);
            QAsnVpnFrr qasnVpnFrr = new QAsnVpnFrr();
            qasnVpnFrr = staticVpnFrr;
            if (null == qasnVpnFrr.poOperResult) {
                qasnVpnFrr.poOperResult = new QAsnSingleReturn();
            }
            qasnVpnFrr.poOperResult.retCode = 0;
            qasnVpnFrr.poOperResult.isSuccess = true;
            try {
                moService.execute();
            }
            catch (VMFException e) {
                this.getLogger().error("cleanForceSwitchFrrByKey moService.execute failed.", (Throwable)e);
                qasnVpnFrr.poOperResult.retCode = e.getErrorCode();
                qasnVpnFrr.poOperResult.isSuccess = false;
                rsp.result.result = e.getErrorCode();
            }
            rsp.vpnFrrList.add((Object)qasnVpnFrr);
        }
    }

    private void forceSwitchFrrByKey(QAsnVpnFrrList vpnFrrList, QAsnSwitchVpnFrrRsp rsp) throws VMFException {
        if (CollectionUtils.isEmpty((Collection)vpnFrrList)) {
            return;
        }
        L3vpnStaticFrrFdnParser parser = new L3vpnStaticFrrFdnParser();
        DefaultMOService moService = new DefaultMOService();
        for (Object ob : vpnFrrList) {
            QAsnVpnFrr staticVpnFrr = (QAsnVpnFrr)ob;
            StaticFrr staticFrr = new StaticFrr();
            staticFrr = (StaticFrr)parser.getIndexMo(staticVpnFrr.poVpnFrrKey);
            ActionSchemaTranslatorContext actionContext = new ActionSchemaTranslatorContext(staticFrr.getDevID().intValue());
            ForceSwitchFrr forceSWFrr = new ForceSwitchFrr();
            this.staticFrrToForceSwitchFrr(staticFrr, forceSWFrr);
            actionContext.addAction(FeatureName.L3VPN, (VmfMO)forceSWFrr);
            moService.addActionJob(actionContext);
            QAsnVpnFrr qasnVpnFrr = new QAsnVpnFrr();
            qasnVpnFrr = staticVpnFrr;
            if (null == qasnVpnFrr.poOperResult) {
                qasnVpnFrr.poOperResult = new QAsnSingleReturn();
            }
            qasnVpnFrr.poOperResult.retCode = 0;
            qasnVpnFrr.poOperResult.isSuccess = true;
            try {
                moService.execute();
            }
            catch (VMFException e) {
                this.getLogger().error("forceSwitchFrrByKey moService.execute failed.", (Throwable)e);
                qasnVpnFrr.poOperResult.retCode = e.getErrorCode();
                qasnVpnFrr.poOperResult.isSuccess = false;
                rsp.result.result = e.getErrorCode();
            }
            rsp.vpnFrrList.add((Object)qasnVpnFrr);
        }
    }

    private void staticFrrToClearForceSwitchFrr(StaticFrr staticFrr, ClearForceSwitchFrr clearForceSWFrr) {
        clearForceSWFrr.setDevID(staticFrr.getDevID());
        clearForceSWFrr.setVrID(staticFrr.getVrID());
        clearForceSWFrr.setVrfName(staticFrr.getVrfName());
        clearForceSWFrr.setIfNameMaster(staticFrr.getIfNameMaster());
        clearForceSWFrr.setIfNameSlave(staticFrr.getIfNameSlave());
        clearForceSWFrr.setNextHopMaster(staticFrr.getNextHopMaster());
        clearForceSWFrr.setNextHopSlave(staticFrr.getNextHopSlave());
    }

    private void staticFrrToForceSwitchFrr(StaticFrr staticFrr, ForceSwitchFrr forceSWFrr) {
        forceSWFrr.setDevID(staticFrr.getDevID());
        forceSWFrr.setVrID(staticFrr.getVrID());
        forceSWFrr.setVrfName(staticFrr.getVrfName());
        forceSWFrr.setIfNameMaster(staticFrr.getIfNameMaster());
        forceSWFrr.setIfNameSlave(staticFrr.getIfNameSlave());
        forceSWFrr.setNextHopMaster(staticFrr.getNextHopMaster());
        forceSWFrr.setNextHopSlave(staticFrr.getNextHopSlave());
    }
}

