/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnTunnelSelection;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnRoutingInstance;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnModifyL3vpnReq;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnModifyL3vpnRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.l3vpn.task.ITaskSpecialAction;
import com.huawei.vmf.adapter.extendpoint.qos.service.IQosService;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.transaction.IDBLinkageHandler;
import com.huawei.vmf.adapter.framework.transaction.NestingContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.arp.model.ArpInterface;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpIntfOpt82Formate;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpOpt82Intf;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayIfCfg;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnIf;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelPolicy;
import com.huawei.vmf.adapter.fservice.route.model.BgpPeer;
import com.huawei.vmf.adapter.fservice.route.model.BgpPeerGroup;
import com.huawei.vmf.adapter.fservice.route.model.BgpVrf;
import com.huawei.vmf.adapter.fservice.route.model.BgpVrfAF;
import com.huawei.vmf.adapter.fservice.route.model.PeerAF;
import com.huawei.vmf.adapter.l3vpn.common.CheckedMOContext;
import com.huawei.vmf.adapter.l3vpn.common.Utility;
import com.huawei.vmf.adapter.l3vpn.dao.L3vpnDao;
import com.huawei.vmf.adapter.l3vpn.task.DeployL3vpnTask;
import com.huawei.vmf.adapter.l3vpn.translation.asn.QAsnRoutingInstanceTranslator;
import com.huawei.vmf.adapter.l3vpn.translation.asn.QAsnSapTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class ModifyL3vpnTask
extends AbstractConfigQTask<QAsnModifyL3vpnReq, QAsnModifyL3vpnRsp> {
    private final Map<BgpPeer, Collection<PropertyChangeItem>> existPeer2ChangedItems = new ConcurrentHashMap<BgpPeer, Collection<PropertyChangeItem>>(new HashMap());
    private final Map<PeerAF, Collection<PropertyChangeItem>> existPeerAF2ChangedItems = new ConcurrentHashMap<PeerAF, Collection<PropertyChangeItem>>(new HashMap());
    private boolean isExecuteService = true;
    private ITaskSpecialAction specialAction = (ITaskSpecialAction)ExtendPointServiceMgr.getInstance().getExtendPoitService(ITaskSpecialAction.class);
    private final Map<L3vpnInstance, Collection<TunnelPolicy>> vpn2deleteTunnelPolicy = new HashMap<L3vpnInstance, Collection<TunnelPolicy>>();
    private final Map<L3vpnInstance, Collection<TunnelPolicy>> vpn2NewOrUpdateTunnelPolicy = new HashMap<L3vpnInstance, Collection<TunnelPolicy>>();

    public ModifyL3vpnTask() {
        super(EOperationType.MODIFY);
        this.addMoCompositeService(L3vpnInstance.class, (ICompositeService)new ModifyVrfCompositeService(L3vpnInstance.class));
    }

    private static <T> T getMOByHashCode(Collection<T> peers, T peer) {
        if (CollectionUtils.isEmpty(peers)) {
            return null;
        }
        for (T p : peers) {
            if (peer.hashCode() != p.hashCode()) continue;
            return p;
        }
        return null;
    }

    protected void decode(QAsnModifyL3vpnReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        QAsnRoutingInstanceTranslator translator = new QAsnRoutingInstanceTranslator();
        CheckedMOContext checkedMOContext = new CheckedMOContext();
        checkedMOContext.setTaskFlag(asnTranslatorContext.getTransactionContext().getTaskFlag());
        asnTranslatorContext.setTransactionContext((Context)checkedMOContext);
        asnTranslatorContext.addProperty("flowType", (Object)EthSubIf.FLOW_TYPE_ENUM.DOT1Q_TERM);
        for (Object asn : req.vrfList) {
            QAsnRoutingInstance vrfAsn = (QAsnRoutingInstance)asn;
            try {
                L3vpnInstance vpn = (L3vpnInstance)translator.decode((FStruct)vrfAsn, asnTranslatorContext);
                Utility.INSTANCE.processDhcpRelayVpn(vrfAsn.poDhcpRelayInfo, vpn, asnTranslatorContext);
                this.processSap(vrfAsn, vpn, asnTranslatorContext);
                this.processTunnelPolicy(vrfAsn, vpn, asnTranslatorContext);
                Collection<TunnelPolicy> tunnelPolicys = this.vpn2NewOrUpdateTunnelPolicy.get(vpn);
                if (tunnelPolicys != null) {
                    for (TunnelPolicy policy : this.vpn2NewOrUpdateTunnelPolicy.get(vpn)) {
                        Utility.INSTANCE.deployMo(policy, TunnelPolicy.class);
                    }
                }
                IMOChangeRecord vrfChangedRcd = asnTranslatorContext.getTransactionContext().addChangeRecord(L3vpnInstance.class);
                for (Map.Entry entry : vpn.getKeyRefMos().entrySet()) {
                    IMOChangeRecord keyRefChangedRcd;
                    if (CollectionUtils.isEmpty((Collection)((Collection)entry.getValue())) || !(keyRefChangedRcd = asnTranslatorContext.getTransactionContext().addChangeRecord((Class)entry.getKey())).hasCreate() && !keyRefChangedRcd.hasDelete() && !keyRefChangedRcd.hasModify()) continue;
                    vrfChangedRcd.addModify((Object)vpn, Arrays.asList(((Class)entry.getKey()).getName()));
                }
                Utility.INSTANCE.reviseSrRouteDestVrf(vpn, asnTranslatorContext);
                Utility.INSTANCE.processStaticArp(vrfAsn.arpItemList, vpn, asnTranslatorContext);
            }
            catch (VMFException e) {
                this.getLogger().error("decode error", (Throwable)e);
            }
        }
        if (asnTranslatorContext.getProperty(BgpPeerGroupDeleteDBLinkageHandler.class.getName()) == null) {
            asnTranslatorContext.getTransactionContext().addDBLinkageHandler((IDBLinkageHandler)new BgpPeerGroupDeleteDBLinkageHandler());
            asnTranslatorContext.addProperty(BgpPeerGroupDeleteDBLinkageHandler.class.getName(), (Object)Boolean.TRUE);
        }
    }

    protected void encode(QAsnModifyL3vpnRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        Utility.reviseDeployStatus(asnTranslatorContext, L3vpnInstance.class);
        QAsnRoutingInstanceTranslator translator = new QAsnRoutingInstanceTranslator();
        rsp.result.result = 0;
        Context cxt = asnTranslatorContext.getTransactionContext();
        IMOChangeRecord rcd = cxt.getChangeRecord(L3vpnInstance.class);
        for (L3vpnInstance vpn : rcd.getModifies()) {
            int err = cxt.getMoErrorCode((VmfMO)vpn);
            if (err == 0) {
                Collection<TunnelPolicy> tunnelPolicys = this.vpn2deleteTunnelPolicy.get(vpn);
                if (tunnelPolicys != null) {
                    for (TunnelPolicy policy : tunnelPolicys) {
                        try {
                            Utility.INSTANCE.unDeployMo(policy, TunnelPolicy.class);
                        }
                        catch (VMFException e) {
                            this.getLogger().error("undeploy tunnel-policy error", (Object)policy);
                        }
                    }
                }
            } else {
                rsp.result.result = 1090646033;
            }
            try {
                QAsnRoutingInstance asn = (QAsnRoutingInstance)translator.encode(vpn, asnTranslatorContext);
                asn.poOperResult.retCode = err;
                rsp.l3vpnList.add((Object)asn);
            }
            catch (VMFException e) {
                this.getLogger().error("encode error", (Throwable)e);
            }
        }
        if (this.specialAction != null) {
            this.specialAction.configL3vpnIfIp(rsp.l3vpnList, asnTranslatorContext, this.getOperType(), rsp.result);
        }
    }

    protected Integer getAsnBestEffort(QAsnModifyL3vpnReq req) {
        return req.poBestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnModifyL3vpnReq req) {
        return req.poTaskFlg;
    }

    protected void service(IAsnTranslationContext asnTranslatorContext) {
        if (!this.isExecuteService && this.specialAction != null) {
            return;
        }
        super.service(asnTranslatorContext);
    }

    private void markVrfChangeRecord(BgpPeer peer, Context context) {
        BgpVrf vrfKey = new BgpVrf();
        vrfKey.setDevID(peer.getDevID());
        vrfKey.setVrID(peer.getVrID());
        vrfKey.setVrfName(peer.getVrfName());
        for (BgpVrf vrf : context.addChangeRecord(BgpVrf.class).getModifies()) {
            if (vrfKey.hashCode() != vrf.hashCode()) continue;
            if (null == vrf.getBgpPeers()) {
                vrf.setBgpPeers(new HashSet());
            }
            if (!vrf.getBgpPeers().contains(peer)) {
                vrf.getBgpPeers().add(peer);
            }
            context.addChangeRecord(BgpVrf.class).addModify((Object)vrf, Arrays.asList("bgpPeers"));
        }
    }

    private void processGroupNameOfPeerChanged(Context context) {
        IMOChangeRecord peerChangeRecord = context.getChangeRecord(BgpPeer.class);
        if (peerChangeRecord == null || CollectionUtils.isEmpty((Collection)peerChangeRecord.getModifies())) {
            return;
        }
        LinkedList<BgpPeer> toCancel = new LinkedList<BgpPeer>();
        for (BgpPeer peer : peerChangeRecord.getModifies()) {
            if (!peerChangeRecord.isModified((Object)peer, "groupName")) continue;
            peerChangeRecord.addDelete((Object)peer);
            peerChangeRecord.addCreate((Object)peer);
            LinkedList changedPropertyItems = new LinkedList(peerChangeRecord.getModifyPropertyItems((Object)peer));
            this.existPeer2ChangedItems.put(peer, changedPropertyItems);
            try {
                this.processPeerAFOnReNewPeer(peer, context);
            }
            catch (VMFException e) {
                super.getLogger().error("processPeerAFOnReNewPeer failed ", (Throwable)e);
                context.addMoOperResult((VmfMO)peer, e.getErrorCode());
            }
            toCancel.add(peer);
        }
        for (BgpPeer peer : toCancel) {
            peerChangeRecord.cancelModify((Object)peer);
        }
    }

    private void processPeerAFOnReNewPeer(BgpPeer peer, Context context) throws VMFException {
        Collection<PeerAF> peerAFs = L3vpnDao.newInstance().queryPeerAFByPeer(peer);
        if (CollectionUtils.isEmpty(peerAFs)) {
            return;
        }
        for (PeerAF peerAF : peerAFs) {
            this.processPeerAFOnReNewPeer(peerAF, context);
        }
    }

    private void processPeerAFOnReNewPeer(PeerAF peerAF, Context context) {
        IMOChangeRecord peerAFChangeRecord = context.addChangeRecord(PeerAF.class);
        if (peerAFChangeRecord.isDeleted((Object)peerAF) || peerAFChangeRecord.isCreated((Object)peerAF)) {
            return;
        }
        LinkedList changedItems = new LinkedList(peerAFChangeRecord.getModifyPropertyItems((Object)peerAF));
        PeerAF peerAFNew = ModifyL3vpnTask.getMOByHashCode(peerAFChangeRecord.getModifies(), peerAF);
        if (null == peerAFNew) {
            peerAFNew = peerAF;
        }
        peerAFChangeRecord.cancelModify((Object)peerAFNew);
        peerAFChangeRecord.addCreate((Object)peerAFNew);
        this.existPeerAF2ChangedItems.put(peerAFNew, changedItems);
        BgpVrfAF bgpVrfAFKey = new BgpVrfAF();
        bgpVrfAFKey.setDevID(peerAF.getDevID());
        bgpVrfAFKey.setVrID(peerAF.getVrID());
        bgpVrfAFKey.setVrfName(peerAF.getVrfName());
        bgpVrfAFKey.setAfType(peerAF.getAfType());
        IMOChangeRecord bgpVrfAFChangeRecord = context.addChangeRecord(BgpVrfAF.class);
        BgpVrfAF bgpVrfAFNew = ModifyL3vpnTask.getMOByHashCode(bgpVrfAFChangeRecord.getModifies(), bgpVrfAFKey);
        if (null == bgpVrfAFNew) {
            bgpVrfAFNew = bgpVrfAFKey;
            bgpVrfAFChangeRecord.addModify((Object)bgpVrfAFNew, Arrays.asList("peerAFs"));
        }
        if (null == ModifyL3vpnTask.getMOByHashCode(bgpVrfAFNew.getPeerAFs(), peerAFNew)) {
            bgpVrfAFNew.addPeerAFs(Arrays.asList(peerAFNew));
        }
        BgpVrf bgpVrfKey = new BgpVrf();
        bgpVrfKey.setDevID(peerAF.getDevID());
        bgpVrfKey.setVrID(peerAF.getVrID());
        bgpVrfKey.setVrfName(peerAF.getVrfName());
        IMOChangeRecord bgpVrfChangeRecord = context.addChangeRecord(BgpVrf.class);
        BgpVrf bgpVrfNew = ModifyL3vpnTask.getMOByHashCode(bgpVrfChangeRecord.getModifies(), bgpVrfKey);
        if (null == bgpVrfNew) {
            bgpVrfNew = bgpVrfKey;
            bgpVrfChangeRecord.addModify((Object)bgpVrfNew, Arrays.asList("bgpVrfAFs"));
        }
        if (null == ModifyL3vpnTask.getMOByHashCode(bgpVrfNew.getBgpVrfAFs(), bgpVrfAFNew)) {
            bgpVrfNew.addBgpVrfAFs(Arrays.asList(bgpVrfAFNew));
        }
    }

    private void processPeerGroupDelete(BgpPeerGroup peerGroup, Context context) throws VMFException {
        Collection<BgpPeer> peers = L3vpnDao.newInstance().queryBgpPeerByGroupName(peerGroup);
        if (CollectionUtils.isEmpty(peers)) {
            return;
        }
        IMOChangeRecord peerRcd = context.addChangeRecord(BgpPeer.class);
        for (BgpPeer peer : peers) {
            if (peerRcd.isDeleted((Object)peer)) continue;
            LinkedList<PropertyChangeItem> changedPropertyItems = new LinkedList<PropertyChangeItem>(peerRcd.getModifyPropertyItems((Object)peer));
            BgpPeer newPeer = ModifyL3vpnTask.getMOByHashCode(peerRcd.getModifies(), peer);
            if (newPeer == null) {
                newPeer = peer;
            }
            newPeer.setGroupName(null);
            changedPropertyItems.add(new PropertyChangeItem("groupName"));
            peerRcd.cancelModify((Object)peer);
            peerRcd.addCreate((Object)newPeer);
            this.existPeer2ChangedItems.put(newPeer, changedPropertyItems);
            this.markVrfChangeRecord(newPeer, context);
            try {
                this.processPeerAFOnReNewPeer(peer, context);
            }
            catch (VMFException e) {
                super.getLogger().error("processPeerAFOnReNewPeer failed ", (Throwable)e);
                context.addMoOperResult((VmfMO)peer, e.getErrorCode());
            }
        }
    }

    private void processPeerGroupDelete(Context context) {
        IMOChangeRecord groupChangeRecord = context.getChangeRecord(BgpPeerGroup.class);
        if (null == groupChangeRecord || CollectionUtils.isEmpty((Collection)groupChangeRecord.getDeletes())) {
            return;
        }
        IMOChangeRecord bgpVrfChangeRecord = context.addChangeRecord(BgpVrf.class);
        for (BgpPeerGroup gr : groupChangeRecord.getDeletes()) {
            BgpVrf vrfKey = new BgpVrf();
            vrfKey.setDevID(gr.getDevID());
            vrfKey.setVrID(gr.getVrID());
            vrfKey.setVrfName(gr.getVrfName());
            if (bgpVrfChangeRecord.isDeleted((Object)vrfKey)) continue;
            try {
                this.processPeerGroupDelete(gr, context);
            }
            catch (VMFException e) {
                super.getLogger().error("processPeerGroupDelete exception", (Throwable)e);
                context.addMoOperResult((VmfMO)gr, e.getErrorCode());
            }
        }
    }

    private void processPeerGroupDeleteBeforeDB(Context context) {
        Collection<PropertyChangeItem> changedItem;
        IMOChangeRecord peerChangeRecord = context.getChangeRecord(BgpPeer.class);
        LinkedList<Object> toCancel = new LinkedList<Object>();
        for (BgpPeer bgpPeer : peerChangeRecord.getCreates()) {
            changedItem = this.existPeer2ChangedItems.get(bgpPeer);
            if (changedItem == null) continue;
            toCancel.add(bgpPeer);
        }
        for (BgpPeer bgpPeer : toCancel) {
            peerChangeRecord.cancelCreate((Object)bgpPeer);
            peerChangeRecord.cancelDelete((Object)bgpPeer);
            for (PropertyChangeItem item : this.existPeer2ChangedItems.get(bgpPeer)) {
                peerChangeRecord.addModify((Object)bgpPeer, item);
            }
        }
        IMOChangeRecord peerAFChangeRecord = context.getChangeRecord(PeerAF.class);
        toCancel = new LinkedList();
        for (PeerAF peerAF : peerAFChangeRecord.getCreates()) {
            changedItem = this.existPeerAF2ChangedItems.get(peerAF);
            if (changedItem == null) continue;
            toCancel.add(peerAF);
        }
        for (PeerAF peerAF : toCancel) {
            peerAFChangeRecord.cancelCreate((Object)peerAF);
            peerAFChangeRecord.cancelDelete((Object)peerAF);
            for (PropertyChangeItem item : this.existPeerAF2ChangedItems.get(peerAF)) {
                peerAFChangeRecord.addModify((Object)peerAF, item);
            }
        }
    }

    private void processSap(QAsnRoutingInstance vrfAsn, L3vpnInstance vrf, IAsnTranslationContext asnTranslatorContext) throws VMFException {
        if (!AsnTranslatorUtil.isModifyProperty((IAsnTranslationContext)asnTranslatorContext, (Integer)vrfAsn.poOperMask, (int)32)) {
            return;
        }
        Object qosSrv = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQosService.class);
        for (Object asn : vrfAsn.sapList) {
            QAsnSAP sapAsn = (QAsnSAP)asn;
            Interface ifMo = Utility.INSTANCE.decodeSap(sapAsn, asnTranslatorContext);
            if (sapAsn.ctpKey.poSerialNum != null) {
                ifMo.setSerialNum(StringUtil.globalString((byte[])sapAsn.ctpKey.poSerialNum));
            }
            vrf.addKeyRefMos((Collection)ifMo.getKeyRefMos(DhcpRelayIfCfg.class));
            vrf.addKeyRefMos((Collection)ifMo.getKeyRefMos(DhcpOpt82Intf.class));
            vrf.addKeyRefMos((Collection)ifMo.getKeyRefMos(DhcpIntfOpt82Formate.class));
            vrf.addKeyRefMos((Collection)ifMo.getKeyRefMos(ArpInterface.class));
            ifMo.getKeyRefMos(DhcpRelayIfCfg.class).clear();
            ifMo.getKeyRefMos(DhcpOpt82Intf.class).clear();
            ifMo.getKeyRefMos(DhcpIntfOpt82Formate.class).clear();
            ifMo.getKeyRefMos(ArpInterface.class).clear();
            vrf.addKeyRefMo((VmfMO)ifMo);
            new QAsnSapTranslator().decodeServiceInterface(asnTranslatorContext, vrf, ifMo, sapAsn);
            L3vpnIf boundIf = new L3vpnIf();
            Utility.INSTANCE.setChildMoKeyByParentMo((VmfMO)boundIf, (VmfMO)vrf);
            boundIf.setIfName(ifMo.getIfName());
            vrf.addL3vpnIfs(Arrays.asList(boundIf));
            if (AsnTranslatorUtil.isModifyProperty((IAsnTranslationContext)asnTranslatorContext, (Integer)sapAsn.poOperMask, (int)1)) {
                ifMo.setDeployStatus(Integer.valueOf(0));
                asnTranslatorContext.getTransactionContext().addChangeRecord(L3vpnIf.class).addCreate((Object)boundIf);
                asnTranslatorContext.getTransactionContext().addChangeRecord(L3vpnInstance.class).addModify((Object)vrf, new PropertyChangeItem("l3vpnIfs"));
                if (null != qosSrv) {
                    ((IQosService)qosSrv).decodeNewL3vpnUniQos(vrf, sapAsn, (Object)asnTranslatorContext);
                }
            } else if (AsnTranslatorUtil.isModifyProperty((IAsnTranslationContext)asnTranslatorContext, (Integer)sapAsn.poOperMask, (int)2)) {
                asnTranslatorContext.getTransactionContext().addChangeRecord(L3vpnIf.class).addDelete((Object)boundIf);
                asnTranslatorContext.getTransactionContext().addChangeRecord(L3vpnInstance.class).addModify((Object)vrf, new PropertyChangeItem("l3vpnIfs"));
                if (null != qosSrv) {
                    ((IQosService)qosSrv).decodeDelL3vpnUniQos(vrf, boundIf, (Object)asnTranslatorContext);
                }
            } else {
                if (null != qosSrv) {
                    ((IQosService)qosSrv).decodeModifyL3vpnUniQos(vrf, sapAsn, (Object)asnTranslatorContext);
                }
                super.getLogger().debug("ignore oper-mask of sap " + sapAsn.poOperMask);
            }
            if (null == Utility.INSTANCE.getIfService()) continue;
            Utility.INSTANCE.getIfService().processVclusterIf(ifMo, sapAsn, (Object)asnTranslatorContext);
        }
    }

    private void processTunnelPolicy(QAsnRoutingInstance vrfAsn, L3vpnInstance l3vpn, IAsnTranslationContext asnTranslatorContext) throws VMFException {
        Object translator = Utility.INSTANCE.getTunnelPolicyTranslator();
        block4: for (Object asn : vrfAsn.tnlPolicyList) {
            QAsnTunnelSelection policyAsn = (QAsnTunnelSelection)asn;
            if (policyAsn.poOperMask == null) {
                this.getLogger().info("operMask is null");
                continue;
            }
            if (policyAsn.type == 3) {
                this.getLogger().info("type is tunnel is PTN");
                continue;
            }
            switch (policyAsn.poOperMask) {
                case 1: 
                case 8: {
                    Collection<TunnelPolicy> policys;
                    TunnelPolicy policy = (TunnelPolicy)translator.decode((FStruct)policyAsn, asnTranslatorContext);
                    if (policy != null && StringUtil.isEmpty((String)policy.getTnlPolicyName())) {
                        policys = this.vpn2NewOrUpdateTunnelPolicy.get(l3vpn);
                        if (policys == null) {
                            policys = Arrays.asList(policy);
                            this.vpn2NewOrUpdateTunnelPolicy.put(l3vpn, policys);
                        } else {
                            policys.add(policy);
                        }
                    }
                    for (VpnInstAF af : l3vpn.getVpnInstAFs()) {
                        af.setTnlPolicyName(policy.getTnlPolicyName());
                    }
                    continue block4;
                }
                case 2: {
                    TunnelPolicy policy = new TunnelPolicy();
                    policy.setDevID(l3vpn.getDevID());
                    policy.setVrID(l3vpn.getVrID());
                    policy.setTnlPolicyName(StringUtil.globalString((byte[])policyAsn.poTnlPolicy));
                    Collection<TunnelPolicy> policys = this.vpn2deleteTunnelPolicy.get(l3vpn);
                    if (policys == null) {
                        policys = Arrays.asList(policy);
                        this.vpn2deleteTunnelPolicy.put(l3vpn, policys);
                        break;
                    }
                    policys.add(policy);
                    break;
                }
                default: {
                    this.getLogger().error("unsupport operMask " + policyAsn.poOperMask);
                }
            }
        }
    }

    class ModifyVrfCompositeService
    extends DefaultCompositeService<L3vpnInstance> {
        public ModifyVrfCompositeService(Class<L3vpnInstance> moClazz) {
            super(moClazz);
        }

        protected boolean autoSetDeafultValue() {
            return false;
        }

        protected <T extends VmfMO> List<NestingContext> composeModifyNestingContext(List<T> mos, Context context) {
            ModifyL3vpnTask.this.processPeerGroupDelete(context);
            ModifyL3vpnTask.this.processGroupNameOfPeerChanged(context);
            Utility.INSTANCE.addStaticArpToTempContext4Modify(context);
            return super.composeModifyNestingContext(mos, context);
        }

        protected List<L3vpnInstance> sendConfig(List<NestingContext> nestingContexts, List<L3vpnInstance> mos, EOperationType operType, Context context) {
            IMOChangeRecord vrfChangeRecord = context.getChangeRecord(L3vpnInstance.class);
            IMOChangeRecord vrfIfChangeRecord = context.getChangeRecord(L3vpnIf.class);
            if (vrfChangeRecord == null || !vrfChangeRecord.hasModify() || vrfIfChangeRecord == null || !vrfIfChangeRecord.hasCreate()) {
                return super.sendConfig(nestingContexts, mos, operType, context);
            }
            ArrayList<L3vpnIf> toCreateVrfIfs = new ArrayList<L3vpnIf>();
            for (L3vpnInstance vrf : vrfChangeRecord.getModifies()) {
                if (!vrf.isDeployed() || CollectionUtils.isEmpty((Collection)vrf.getL3vpnIfs())) continue;
                for (L3vpnIf vrfIf : vrf.getL3vpnIfs()) {
                    if (!vrfIfChangeRecord.isCreated((Object)vrfIf)) continue;
                    toCreateVrfIfs.add(vrfIf);
                }
            }
            HashMap<Interface, Collection<Ipv4Address>> ifMo2Address = new HashMap<Interface, Collection<Ipv4Address>>();
            this.addNewInterfaceToTempContext(context, ifMo2Address, toCreateVrfIfs);
            this.addInterfaceToTempContextByVrfIf(context, toCreateVrfIfs);
            if (!ifMo2Address.isEmpty()) {
                context.addDBLinkageHandler((IDBLinkageHandler)new DeployL3vpnTask.RestoreIPV4ForInterfaceDBLinkageHandler(ifMo2Address));
            }
            return super.sendConfig(nestingContexts, mos, operType, context);
        }

        private void addInterfaceToTempContextByVrfIf(Context context, Collection<L3vpnIf> toCreateVrfIfs) {
            for (L3vpnIf vrfIf : toCreateVrfIfs) {
                Interface tempIfMo = new Interface();
                tempIfMo.setDevID(vrfIf.getDevID());
                tempIfMo.setVrID(vrfIf.getVrID());
                tempIfMo.setIfName(vrfIf.getIfName());
                Utility.INSTANCE.addInterfaceToTempContext4Modify(context, tempIfMo);
            }
        }

        private void addNewInterfaceToTempContext(Context context, Map<Interface, Collection<Ipv4Address>> ifMo2Address, Collection<L3vpnIf> toCreateVrfIfs) {
            IMOChangeRecord ifChangeRecord = context.getChangeRecord(Interface.class);
            if (null == ifChangeRecord) {
                return;
            }
            for (Interface ifMo : ifChangeRecord.getCreates()) {
                if (CollectionUtils.isEmpty((Collection)ifMo.getIpv4Addresss())) continue;
                ifMo2Address.put(ifMo, new ArrayList(ifMo.getIpv4Addresss()));
                Utility.INSTANCE.addInterfaceToTempContext4Modify(context, ifMo, toCreateVrfIfs);
                ifMo.setIpv4Addresss(new ArrayList());
            }
            for (Interface ifMo : ifChangeRecord.getModifies()) {
                if (CollectionUtils.isEmpty((Collection)ifMo.getIpv4Addresss())) continue;
                ifMo2Address.put(ifMo, new ArrayList(ifMo.getIpv4Addresss()));
                Utility.INSTANCE.addInterfaceToTempContext4Modify(context, ifMo, toCreateVrfIfs);
                ifMo.setIpv4Addresss(new ArrayList());
            }
        }
    }

    class BgpPeerGroupDeleteDBLinkageHandler
    implements IDBLinkageHandler {
        BgpPeerGroupDeleteDBLinkageHandler() {
        }

        public void handler(NestingContext transaction) {
            Context context = transaction.getTotalContext();
            if (null == context || null == context.getChangeRecord(BgpPeer.class) || !context.getChangeRecord(BgpPeer.class).hasCreate()) {
                return;
            }
            ModifyL3vpnTask.this.processPeerGroupDeleteBeforeDB(context);
        }
    }
}

