/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_diagnose_model.QAsnVrfCurrRouteNum;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnGetVrfCurrRouteNumReq;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnGetVrfCurrRouteNumRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.service.IMOService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.route.model.BgpPeerGroup;
import com.huawei.vmf.adapter.fservice.route.model.UniAf;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class GetVrfCurrRouteNumTask
extends AbstractQTask<QAsnGetVrfCurrRouteNumReq, QAsnGetVrfCurrRouteNumRsp> {
    protected void executeTask(QAsnGetVrfCurrRouteNumReq req, QAsnGetVrfCurrRouteNumRsp rsp, Task task) {
        L3vpnInstanceFdnParser parser = new L3vpnInstanceFdnParser();
        rsp.result.result = 0;
        try {
            for (Object ob : req.vrfKeyList) {
                QAsnUniResID vrfKey = (QAsnUniResID)ob;
                QAsnVrfCurrRouteNum vrfCurrRoute = new QAsnVrfCurrRouteNum();
                vrfCurrRoute.vrfKey = vrfKey;
                this.getCurrRouteFromDev((L3vpnInstance)parser.getIndexMo(vrfKey), vrfCurrRoute);
                rsp.vrfCurrRouteNum.add((Object)vrfCurrRoute);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("GetVrfCurrRouteNumReq failed", (Throwable)e);
            rsp.result.result = e.getErrorCode();
        }
    }

    private int encodeCurrRouteResult(IMOService pollService, int iDevID) {
        int currRoute = 0;
        QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(iDevID);
        Collection vrfs = queryContext.getQueryResult(L3vpnInstance.class);
        if (CollectionUtils.isEmpty((Collection)vrfs)) {
            return currRoute;
        }
        for (L3vpnInstance vrf : vrfs) {
            if (CollectionUtils.isEmpty((Collection)vrf.getVpnInstAFs())) {
                return currRoute;
            }
            for (VpnInstAF vpnAf : vrf.getVpnInstAFs()) {
                if (BgpPeerGroup.AF_TYPE_ENUM.IPV4UNI != vpnAf.getAfType()) continue;
                currRoute = vpnAf.getRoutingTables().size();
            }
        }
        return currRoute;
    }

    private int encodeMaxRouteResult(IMOService pollService, int iDevID) {
        int maxRoute = 0;
        QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(iDevID);
        Collection uniAfs = queryContext.getQueryResult(UniAf.class);
        if (CollectionUtils.isEmpty((Collection)uniAfs)) {
            return maxRoute;
        }
        for (UniAf uniAf : uniAfs) {
            if (BgpPeerGroup.AF_TYPE_ENUM.IPV4UNI != uniAf.getAfType()) continue;
            maxRoute = uniAf.getRouteLimitNum().intValue();
        }
        return maxRoute;
    }

    private void getCurrRouteFromDev(L3vpnInstance l3vpn, QAsnVrfCurrRouteNum vrfCurrRoute) throws VMFException {
        DefaultMOService pollService = new DefaultMOService();
        List<String> queryVrfNames = Arrays.asList("vpnInstAFs");
        List<String> queryvpnInstAFNames = Arrays.asList("routingTables");
        QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(l3vpn.getDevID().intValue());
        pollService.addQueryJob(queryContext);
        queryContext.addQueryAttributes(FeatureName.L3VPN, (VmfMO)l3vpn, queryVrfNames);
        VpnInstAF vpnInstAF = new VpnInstAF();
        vpnInstAF.setDevID(l3vpn.getDevID());
        vpnInstAF.setVrID(l3vpn.getVrID());
        vpnInstAF.setVrfName(l3vpn.getVrfName());
        vpnInstAF.setAfType(BgpPeerGroup.AF_TYPE_ENUM.IPV4UNI);
        l3vpn.addVpnInstAFs(Arrays.asList(vpnInstAF));
        queryContext.addQueryAttributes(FeatureName.L3VPN, (VmfMO)vpnInstAF, queryvpnInstAFNames);
        UniAf uniAf = new UniAf();
        List<String> queryUniAfNames = Arrays.asList("routeLimitNum");
        uniAf.setDevID(l3vpn.getDevID());
        uniAf.setVrID(l3vpn.getVrID());
        uniAf.setVrfName(l3vpn.getVrfName());
        uniAf.setAfType(BgpPeerGroup.AF_TYPE_ENUM.IPV4UNI);
        queryContext.addQueryAttributes(FeatureName.RM, (VmfMO)uniAf, queryUniAfNames);
        pollService.poll();
        vrfCurrRoute.currRouteNum = this.encodeCurrRouteResult((IMOService)pollService, l3vpn.getDevID());
        vrfCurrRoute.maxRouteNum = this.encodeMaxRouteResult((IMOService)pollService, l3vpn.getDevID());
    }
}

