/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnGetVrfBindingTunnelReq;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnGetVrfBindingTunnelRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.l3vpn.translation.asn.spec.QAsnGetVrfBindingTunnelTranslator;
import java.util.Collection;
import java.util.LinkedList;

public class GetVrfBindingTunnelTask
extends AbstractQTask<QAsnGetVrfBindingTunnelReq, QAsnGetVrfBindingTunnelRsp> {
    protected void executeTask(QAsnGetVrfBindingTunnelReq req, QAsnGetVrfBindingTunnelRsp rsp, Task task) {
        L3vpnInstanceFdnParser fdnParser = new L3vpnInstanceFdnParser();
        LinkedList<L3vpnInstance> vrfs = new LinkedList<L3vpnInstance>();
        for (Object ob : req.vrfKeyList) {
            vrfs.add((L3vpnInstance)fdnParser.getIndexMo((QAsnUniResID)ob));
        }
        if (null == rsp.result) {
            rsp.result = new QAsnErrInfoReturn();
        }
        rsp.result.result = 0;
        try {
            this.getVrfBindingTunnelPolicy(vrfs);
            this.encode(vrfs, rsp);
        }
        catch (VMFException e) {
            this.getLogger().error("getVrfStatusFromDev failed", (Throwable)e);
            rsp.result.result = e.getErrorCode();
            return;
        }
    }

    private void encode(Collection<L3vpnInstance> vrfs, QAsnGetVrfBindingTunnelRsp rsp) throws VMFException {
        AsnTranslationContext context = new AsnTranslationContext();
        context.setOperType(EOperationType.GET);
        rsp.vrfBindingTunnelList.addAll(new QAsnGetVrfBindingTunnelTranslator().encode(vrfs, (IAsnTranslationContext)context));
    }

    private void getVrfBindingTunnelPolicy(Collection<L3vpnInstance> vrfs) throws VMFException {
        DaoFactory.getInstance().getDefaultVmfDao(null).queryByParentKey(VpnInstAF.class, L3vpnInstance.class, vrfs);
    }
}

