/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnVpnFrr;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnGetVpnFrrStatusReq;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnGetVpnFrrStatusRsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.service.IMOService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnStaticFrrFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.StaticFrr;
import com.huawei.vmf.adapter.fservice.l3vpn.model.StaticFrrIpRouteTable;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.l3vpn.translation.asn.QAsnVpnFrrResultTranslator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class GetVpnFrrStatusFromDevTask
extends AbstractQTask<QAsnGetVpnFrrStatusReq, QAsnGetVpnFrrStatusRsp> {
    protected void executeTask(QAsnGetVpnFrrStatusReq req, QAsnGetVpnFrrStatusRsp rsp, Task task) {
        L3vpnStaticFrrFdnParser parser = new L3vpnStaticFrrFdnParser();
        LinkedList<StaticFrr> staticFrrs = new LinkedList<StaticFrr>();
        for (Object ob : req.vpnFrrList) {
            QAsnVpnFrr staticVpnFrr = (QAsnVpnFrr)ob;
            staticFrrs.add((StaticFrr)parser.getIndexMo(staticVpnFrr.poVpnFrrKey));
        }
        rsp.result.result = 0;
        AsnTranslationContext asnContext = new AsnTranslationContext();
        Context context = new Context();
        asnContext.setTransactionContext(context);
        try {
            this.encode(this.getStaticFrrFromDev(staticFrrs, (IAsnTranslationContext)asnContext), rsp, (IAsnTranslationContext)asnContext);
        }
        catch (VMFException e) {
            this.getLogger().error("getVrfStatusFromDev failed", (Throwable)e);
            rsp.result.result = e.getErrorCode();
        }
    }

    private void encode(Collection<StaticFrr> staticFrrs, QAsnGetVpnFrrStatusRsp rsp, IAsnTranslationContext context) throws VMFException {
        QAsnVpnFrrResultTranslator translator = new QAsnVpnFrrResultTranslator();
        context.setOperType(EOperationType.GET);
        rsp.lstVpnFrrResult.addAll(translator.encode(staticFrrs, context));
    }

    private Collection<StaticFrr> encodeQueryResult(Map<Integer, List<StaticFrr>> vpwsDevMap, IMOService pollService, Collection<StaticFrr> resultStaticFrrs) {
        for (Map.Entry<Integer, List<StaticFrr>> entry : vpwsDevMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(entry.getKey().intValue());
            Collection staticFrrs = queryContext.getQueryResult(StaticFrr.class);
            if (CollectionUtils.isEmpty((Collection)staticFrrs)) continue;
            for (StaticFrr frr : staticFrrs) {
                if (CollectionUtils.isEmpty((Collection)frr.getStaticFrrIpRouteTables()) && null == frr.getState()) continue;
                resultStaticFrrs.add(frr);
            }
        }
        return resultStaticFrrs;
    }

    private Collection<StaticFrr> getStaticFrrFromDev(Collection<StaticFrr> staticFrrs, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty(staticFrrs)) {
            return staticFrrs;
        }
        DefaultMOService pollService = new DefaultMOService();
        Map<Integer, List<StaticFrr>> vpwsDevMap = this.groupVmfMOByDevId(staticFrrs);
        List<String> queryVrfNames = Arrays.asList("staticFrrs");
        List<String> queryFrrNames = Arrays.asList("state", "staticFrrIpRouteTables");
        for (Map.Entry<Integer, List<StaticFrr>> entryDevMap : vpwsDevMap.entrySet()) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(entryDevMap.getKey().intValue());
            pollService.addQueryJob(queryContext);
            HashMap<String, L3vpnInstance> l3vpnNameMap = new HashMap<String, L3vpnInstance>();
            for (StaticFrr staticFrr : entryDevMap.getValue()) {
                L3vpnInstance vrf = (L3vpnInstance)l3vpnNameMap.get(staticFrr.getVrfName());
                if (null == vrf) {
                    vrf = new L3vpnInstance();
                    vrf.setDevID(staticFrr.getDevID());
                    vrf.setVrfName(staticFrr.getVrfName());
                    vrf.setVrID(staticFrr.getVrID());
                    l3vpnNameMap.put(staticFrr.getVrfName(), vrf);
                    queryContext.addQueryAttributes(FeatureName.L3VPN, (VmfMO)vrf, queryVrfNames);
                }
                vrf.addStaticFrrs(Arrays.asList(staticFrr));
                StaticFrrIpRouteTable ipRouteTable = new StaticFrrIpRouteTable();
                staticFrr.addStaticFrrIpRouteTables(Arrays.asList(ipRouteTable));
                queryContext.addQueryAttributes(FeatureName.L3VPN, (VmfMO)staticFrr, queryFrrNames);
            }
        }
        pollService.poll();
        Collection<StaticFrr> resultStaticFrrs = new ArrayList<StaticFrr>();
        resultStaticFrrs = this.encodeQueryResult(vpwsDevMap, (IMOService)pollService, resultStaticFrrs);
        Map mapError = pollService.getAllErrorInfos();
        for (Map.Entry entry : mapError.entrySet()) {
            context.getTransactionContext().addMoOperResult((VmfMO)entry.getKey(), (ErrorInfo)entry.getValue());
            if (!((VmfMO)entry.getKey()).getClass().equals(StaticFrr.class)) continue;
            resultStaticFrrs.add((StaticFrr)entry.getKey());
        }
        return resultStaticFrrs;
    }

    private <T extends VmfMO> Map<Integer, List<T>> groupVmfMOByDevId(Collection<T> mos) {
        if (CollectionUtils.isEmpty(mos)) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<T>> moMap = new HashMap<Integer, List<T>>();
        for (VmfMO mo : mos) {
            ArrayList<VmfMO> list = (ArrayList<VmfMO>)moMap.get(mo.getDevID());
            if (list == null) {
                list = new ArrayList<VmfMO>();
                moMap.put(mo.getDevID(), list);
            }
            list.add(mo);
        }
        return moMap;
    }
}

