/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnGetL3vpnStatusFromDevReq;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnGetL3vpnStatusFromDevRsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.framework.util.ReflectHelper;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnIf;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.l3vpn.common.Utility;
import com.huawei.vmf.adapter.l3vpn.translation.asn.QAsnRoutingInstanceTranslator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.util.CollectionUtils;

public class GetL3vpnStatusFromDevTask
extends AbstractQTask<QAsnGetL3vpnStatusFromDevReq, QAsnGetL3vpnStatusFromDevRsp> {
    private static String toString(VmfMO mo) {
        if (mo instanceof VpnInstAF) {
            return mo.getDevID() + "," + mo.getVrID() + "," + ((VpnInstAF)mo).getVrfName() + "," + ((VpnInstAF)mo).getAfType();
        }
        if (mo instanceof Interface) {
            return mo.getDevID() + "," + mo.getVrID() + "," + ((Interface)mo).getIfName();
        }
        return "";
    }

    protected void executeTask(QAsnGetL3vpnStatusFromDevReq req, QAsnGetL3vpnStatusFromDevRsp rsp, Task task) {
        rsp.result.result = 0;
        try {
            L3vpnInstanceFdnParser parser = new L3vpnInstanceFdnParser();
            HashSet<L3vpnInstance> vrfs = new HashSet<L3vpnInstance>();
            for (Object ob : req.l3vpnKeyList) {
                vrfs.add((L3vpnInstance)parser.getIndexMo((QAsnUniResID)ob));
            }
            this.querySapByVrfs(vrfs);
            HashMap<VmfMO, ErrorInfo> moOperResults = new HashMap<VmfMO, ErrorInfo>();
            this.getVrfStatusFromDev(vrfs, moOperResults);
            Context context = new Context();
            for (VmfMO mo : moOperResults.keySet()) {
                context.addMoOperResult(mo, (ErrorInfo)moOperResults.get(mo));
            }
            this.encode(vrfs, rsp, context);
            this.updateStatus(vrfs, context);
        }
        catch (VMFException e) {
            this.getLogger().error("getVrfStatusFromDev failed", (Throwable)e);
            rsp.result.result = e.getErrorCode();
            return;
        }
    }

    private void encode(Collection<L3vpnInstance> vrfs, QAsnGetL3vpnStatusFromDevRsp rsp, Context context) throws VMFException {
        QAsnRoutingInstanceTranslator translator = new QAsnRoutingInstanceTranslator();
        AsnTranslationContext translatorContext = new AsnTranslationContext();
        translatorContext.setOperType(EOperationType.GET);
        translatorContext.setTransactionContext(context);
        rsp.l3vpnList.addAll(translator.encode(vrfs, (IAsnTranslationContext)translatorContext));
    }

    private void getVrfStatusFromDev(Collection<L3vpnInstance> vrfs, Map<VmfMO, ErrorInfo> moOperResults) throws VMFException {
        DefaultMOService pollService = new DefaultMOService();
        for (L3vpnInstance vrf : vrfs) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(vrf.getDevID().intValue());
            if (queryContext == null) {
                queryContext = new QuerySchemaTranslatorContext(vrf.getDevID().intValue());
                pollService.addQueryJob(queryContext);
            }
            VpnInstAF vrfAF = new VpnInstAF();
            Utility.INSTANCE.setChildMoKeyByParentMo((VmfMO)vrfAF, (VmfMO)vrf);
            vrfAF.setAfType(VpnInstAF.AF_TYPE_ENUM.IPV4UNI);
            vrf.addVpnInstAFs(Arrays.asList(vrfAF));
            queryContext.addQueryAttributes(FeatureName.L3VPN, (VmfMO)vrf, Arrays.asList("vpnInstAFs"));
            queryContext.addQueryAttributes(FeatureName.L3VPN, (VmfMO)vrfAF, Arrays.asList("vrfStatus"));
            for (Interface ifMo : vrf.getKeyRefMos(Interface.class)) {
                queryContext.addQueryAttributes(FeatureName.IFM, (VmfMO)ifMo, Arrays.asList("ifAdminStatus", "ifOperStatus"));
            }
        }
        pollService.poll();
        moOperResults.putAll(pollService.getAllErrorInfos());
    }

    private void querySapByVrfs(Collection<L3vpnInstance> vrfs) throws VMFException {
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        dao.queryByParentKey(L3vpnIf.class, L3vpnInstance.class, vrfs);
        for (L3vpnInstance vrf : vrfs) {
            if (CollectionUtils.isEmpty((Collection)vrf.getL3vpnIfs())) continue;
            for (L3vpnIf vrfIf : vrf.getL3vpnIfs()) {
                Interface ifMo = new Interface();
                ifMo.setDevID(vrf.getDevID());
                ifMo.setVrID(vrf.getVrID());
                ifMo.setIfName(vrfIf.getIfName());
                vrf.addKeyRefMo((VmfMO)ifMo);
            }
        }
    }

    private <T extends VmfMO> void updateStatus(Class<T> clazz, Collection<T> newMOs, String ... statusPropertys) throws VMFException {
        Collection oldMOs = DaoFactory.getInstance().getDefaultVmfDao(null).queryByKey(clazz, newMOs, false);
        if (CollectionUtils.isEmpty((Collection)oldMOs)) {
            return;
        }
        Context cxt2Update = new Context();
        block0: for (VmfMO oldMO : oldMOs) {
            for (VmfMO newMO : newMOs) {
                if (!oldMO.equals((Object)newMO)) continue;
                for (String statusProperty : statusPropertys) {
                    Object newValue = ReflectHelper.getInstance().getPropertyValue((Object)newMO, statusProperty);
                    Object oldValue = ReflectHelper.getInstance().getPropertyValue((Object)oldMO, statusProperty);
                    if (ObjectUtils.equals((Object)newValue, (Object)ReflectHelper.getInstance().getPropertyValue((Object)oldMO, statusProperty))) continue;
                    cxt2Update.addChangeRecord(clazz).addModify((Object)newMO, new PropertyChangeItem(statusProperty, newValue, oldValue));
                    this.getLogger().info("update {} set {} = {}, oldValue = {}", new Object[]{GetL3vpnStatusFromDevTask.toString(newMO), statusProperty, newValue, oldValue});
                }
                continue block0;
            }
        }
        DaoFactory.getInstance().getDefaultVmfDao(cxt2Update).merge(false, new Class[]{clazz});
        MOChangePublisher.getInstance().notifyChanges(cxt2Update);
    }

    private void updateStatus(Collection<L3vpnInstance> vrfs, Context context) throws VMFException {
        ArrayList<VpnInstAF> vrfAFs = new ArrayList<VpnInstAF>();
        ArrayList<Interface> ifMos = new ArrayList<Interface>();
        for (L3vpnInstance vrf : vrfs) {
            if (0 != context.getMoErrorCode((VmfMO)vrf)) continue;
            if (!CollectionUtils.isEmpty((Collection)vrf.getVpnInstAFs())) {
                for (VpnInstAF af : vrf.getVpnInstAFs()) {
                    if (0 != context.getMoErrorCode((VmfMO)af) || af.getVrfStatus() == null) continue;
                    vrfAFs.add(af);
                }
            }
            for (Interface ifMo : vrf.getKeyRefMos(Interface.class)) {
                if (0 != context.getMoErrorCode((VmfMO)ifMo) || ifMo.getIfAdminStatus() == null || ifMo.getIfOperStatus() == null) continue;
                ifMos.add(ifMo);
            }
        }
        this.updateStatus(VpnInstAF.class, vrfAFs, "vrfStatus");
        this.updateStatus(Interface.class, ifMos, "ifAdminStatus", "ifOperStatus");
    }
}

