/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_diagnose_model.QAsnBgpVPNV4Peer;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnGetBgpVpnv4PeerReq;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnGetBgpVpnv4PeerRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.route.model.BgpPeer;
import com.huawei.vmf.adapter.fservice.route.model.BgpVrf;
import com.huawei.vmf.adapter.fservice.route.model.BgpVrfAF;
import com.huawei.vmf.adapter.fservice.route.model.PeerAF;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.l3vpn.common.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class GetBgpVpnv4PeerReqTask
extends AbstractQTask<QAsnGetBgpVpnv4PeerReq, QAsnGetBgpVpnv4PeerRsp> {
    public static int ENABLE4QAsnBgpVPNV4Peer = 1;
    private Logger logger = LoggerFactory.getLogger(GetBgpVpnv4PeerReqTask.class);

    protected void executeTask(QAsnGetBgpVpnv4PeerReq req, QAsnGetBgpVpnv4PeerRsp rsp, Task task) {
        this.execute(req, rsp);
    }

    private void addPeerAFToPeer(Collection<BgpPeer> peers, Collection<PeerAF> _peerAFs, boolean queryFromDB, IDao dao) throws VMFException {
        Collection peerAFs;
        if (CollectionUtils.isEmpty(peers)) {
            return;
        }
        LinkedList<PeerAF> conditions = new LinkedList<PeerAF>();
        HashMap<PeerAF, BgpPeer> peerAF2Peer = new HashMap<PeerAF, BgpPeer>();
        Iterator<BgpPeer> peerIt = peers.iterator();
        while (peerIt.hasNext()) {
            BgpPeer peer = peerIt.next();
            if (StringUtil.isEmpty((String)peer.getPeerAddr())) {
                peerIt.remove();
                continue;
            }
            PeerAF peerAF = new PeerAF();
            peerAF.setDevID(peer.getDevID());
            peerAF.setVrID(peer.getVrID());
            peerAF.setRemoteAddress(peer.getPeerAddr());
            peerAF.setVrfName(peer.getVrfName());
            peerAF.setAfType(BgpVrfAF.AF_TYPE_ENUM.IPV4VPN);
            peerAF2Peer.put(peerAF, peer);
            conditions.add(peerAF);
        }
        Collection collection = peerAFs = queryFromDB ? dao.queryByKey(PeerAF.class, conditions, false) : _peerAFs;
        if (CollectionUtils.isEmpty(peerAFs)) {
            return;
        }
        Iterator peerAFIt = peerAFs.iterator();
        while (peerAFIt.hasNext()) {
            PeerAF peerAF = (PeerAF)peerAFIt.next();
            if (StringUtil.isEmpty((String)peerAF.getRemoteAddress())) {
                peerAFIt.remove();
                continue;
            }
            BgpPeer peer = (BgpPeer)peerAF2Peer.get(peerAF);
            if (null == peer) continue;
            peer.addKeyRefMo((VmfMO)peerAF);
        }
    }

    private void encode(Collection<BgpPeer> peers, QAsnGetBgpVpnv4PeerRsp rsp) {
        if (CollectionUtils.isEmpty(peers)) {
            return;
        }
        InterfaceFdnParser ifFdnParser = new InterfaceFdnParser();
        for (BgpPeer peer : peers) {
            List afs;
            QAsnBgpVPNV4Peer asn = new QAsnBgpVPNV4Peer();
            asn.neID = peer.getDevID();
            asn.peerAddr = StringUtil.globalByte((String)peer.getPeerAddr());
            asn.connIp = StringUtil.globalByte((String)peer.getLocalIfAddress());
            if (!StringUtil.isEmpty((String)peer.getLocalIfName())) {
                Interface ifMo = new Interface();
                ifMo.setDevID(peer.getDevID());
                ifMo.setVrID(peer.getVrID());
                ifMo.setIfName(peer.getLocalIfName());
                asn.poConnIf = ifFdnParser.getUniResID((VmfMO)ifMo);
            }
            if (!CollectionUtils.isEmpty((Collection)(afs = peer.getKeyRefMos(PeerAF.class)))) {
                PeerAF af = (PeerAF)afs.iterator().next();
                if (af.getReflectClient() != null && af.getReflectClient().booleanValue()) {
                    asn.poReflectClient = ENABLE4QAsnBgpVPNV4Peer;
                }
                if (PeerAF.NEXT_HOP_CONFIGURE_ENUM.LOCAL.equals(af.getNextHopConfigure())) {
                    asn.poNextHopLocal = 1;
                }
                if (af.getUpeEnable() != null && af.getUpeEnable().booleanValue()) {
                    asn.poUpe = 1;
                }
                asn.status = PEER_STATUS.getStatusFromMo(af.getBgpCurState());
            }
            rsp.bgpvpnv4PeerList.add((Object)asn);
        }
    }

    private void execute(QAsnGetBgpVpnv4PeerReq req, QAsnGetBgpVpnv4PeerRsp rsp) {
        LinkedList<Integer> neIDs = new LinkedList<Integer>();
        for (Object id : req.neIDList) {
            neIDs.add((Integer)id);
        }
        rsp.result.result = 0;
        try {
            Collection<BgpPeer> afs = 0 != req.querySymbol ? this.queryFromDB(neIDs) : this.queryFromDev(neIDs);
            this.encode(afs, rsp);
        }
        catch (VMFException e) {
            this.logger.error("execute", (Throwable)e);
            rsp.result.result = e.getErrorCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<BgpPeer> queryFromDB(Collection<Integer> neIDs) throws VMFException {
        if (CollectionUtils.isEmpty(neIDs)) {
            return Collections.emptyList();
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            String[] fieldNames = new String[]{"devID", "vrID", "vrfName"};
            ArrayList<BgpPeer> conditions = new ArrayList<BgpPeer>();
            for (Integer neId : neIDs) {
                BgpPeer peer = new BgpPeer();
                peer.setDevID(neId);
                peer.setVrID(Integer.valueOf(0));
                peer.setVrfName("_public_");
                conditions.add(peer);
            }
            Collection peers = dao.queryByFields(BgpPeer.class, fieldNames, conditions, false);
            this.addPeerAFToPeer(peers, null, true, dao);
            Collection collection = peers;
            return collection;
        }
        finally {
            dao.rollback();
        }
    }

    private Collection<BgpPeer> queryFromDev(Collection<Integer> neIDs) throws VMFException {
        DefaultMOService pollService = new DefaultMOService();
        for (Integer neID : neIDs) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(neID.intValue());
            if (queryContext == null) {
                queryContext = new QuerySchemaTranslatorContext(neID.intValue());
                pollService.addQueryJob(queryContext);
            }
            BgpVrf bgpVrf = new BgpVrf();
            bgpVrf.setDevID(neID);
            bgpVrf.setVrfName("_public_");
            BgpPeer peer = new BgpPeer();
            Utility.INSTANCE.setChildMoKeyByParentMo((VmfMO)peer, (VmfMO)bgpVrf);
            bgpVrf.addBgpPeers(Arrays.asList(peer));
            BgpVrfAF bgpVrfAF = new BgpVrfAF();
            bgpVrfAF.setAfType(BgpVrfAF.AF_TYPE_ENUM.IPV4VPN);
            Utility.INSTANCE.setChildMoKeyByParentMo((VmfMO)bgpVrfAF, (VmfMO)bgpVrf);
            bgpVrf.addBgpVrfAFs(Arrays.asList(bgpVrfAF));
            PeerAF peerAF = new PeerAF();
            Utility.INSTANCE.setChildMoKeyByParentMo((VmfMO)peerAF, (VmfMO)bgpVrfAF);
            bgpVrfAF.addPeerAFs(Arrays.asList(peerAF));
            queryContext.addQueryAttributes(FeatureName.BGP, (VmfMO)bgpVrf, Arrays.asList("bgpPeers", "bgpVrfAFs"));
            queryContext.addQueryAttributes(FeatureName.BGP, (VmfMO)bgpVrfAF, Arrays.asList("peerAFs"));
            queryContext.addQueryAttributes(FeatureName.BGP, (VmfMO)peer, Arrays.asList("vrfName", "peerAddr", "localIfName", "localIfAddress"));
            queryContext.addQueryAttributes(FeatureName.BGP, (VmfMO)peerAF, Arrays.asList("vrfName", "afType", "remoteAddress", "reflectClient", "upeEnable", "nextHopConfigure", "bgpCurState"));
        }
        pollService.poll();
        ArrayList<PeerAF> peerAfs = new ArrayList<PeerAF>();
        ArrayList<BgpPeer> peers = new ArrayList<BgpPeer>();
        for (Integer neID : neIDs) {
            QuerySchemaTranslatorContext pollResult = pollService.getQueryContext(neID.intValue());
            peers.addAll(pollResult.getQueryResult(BgpPeer.class));
            peerAfs.addAll(pollResult.getQueryResult(PeerAF.class));
        }
        this.addPeerAFToPeer(peers, peerAfs, false, null);
        return peers;
    }

    public static class PEER_STATUS {
        public static final int active = 3;
        public static final int connect = 2;
        public static final int established = 6;
        public static final int idle = 1;
        public static final int openconfirm = 5;
        public static final int opensent = 4;
        public static final int unknown = -1;
        static Map<Integer, Integer> PeerAFStatus2AsnStatus = new HashMap<Integer, Integer>();

        static int getStatusFromMo(Integer s) {
            if (s == null) {
                return -1;
            }
            Integer ret = PeerAFStatus2AsnStatus.get(s);
            if (ret == null) {
                ret = -1;
            }
            return ret;
        }

        static {
            PeerAFStatus2AsnStatus.put(PeerAF.BGP_CUR_STATE_ENUM.ACTIVE, 3);
            PeerAFStatus2AsnStatus.put(PeerAF.BGP_CUR_STATE_ENUM.CONNECT, 2);
            PeerAFStatus2AsnStatus.put(PeerAF.BGP_CUR_STATE_ENUM.ESTABLISHED, 6);
            PeerAFStatus2AsnStatus.put(PeerAF.BGP_CUR_STATE_ENUM.IDLE, 1);
            PeerAFStatus2AsnStatus.put(PeerAF.BGP_CUR_STATE_ENUM.OPENCONFIRM, 5);
            PeerAFStatus2AsnStatus.put(PeerAF.BGP_CUR_STATE_ENUM.OPENSENT, 4);
        }
    }
}

