/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_common.QAsnUniResIDList;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnEnableL3vpnCtpReq;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnEnableL3vpnCtpRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.l3vpn.Activator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class EnableL3vpnCtpTask
extends AbstractConfigQTask<QAsnEnableL3vpnCtpReq, QAsnEnableL3vpnCtpRsp> {
    public EnableL3vpnCtpTask() {
        super(EOperationType.MODIFY);
        this.addMoCompositeService(Interface.class, (ICompositeService)new DefaultCompositeService(Interface.class));
    }

    protected void decode(QAsnEnableL3vpnCtpReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        InterfaceFdnParser fdnParser = new InterfaceFdnParser();
        QAsnUniResIDList resIdList = req.ctpKeyList;
        IMOChangeRecord record = asnTranslatorContext.getTransactionContext().addChangeRecord(Interface.class);
        for (QAsnUniResID resId : resIdList) {
            Interface ifm = (Interface)fdnParser.getIndexMo(resId);
            ifm.setIfAdminStatus(Interface.IF_ADMIN_STATUS_ENUM.UP);
            record.addModify((Object)ifm, new PropertyChangeItem("ifAdminStatus"));
        }
    }

    protected void encode(QAsnEnableL3vpnCtpRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        Context context = asnTranslatorContext.getTransactionContext();
        Set set = context.addChangeRecord(Interface.class).getAllChanges();
        IAsnTranslator translator = Activator.getAsnTranslator(QAsnSAP.class, Interface.class);
        try {
            Collection qasnSapList = translator.encode(new ArrayList(set), asnTranslatorContext);
            rsp.sapList.addAll(qasnSapList);
            rsp.result.result = 0;
        }
        catch (VMFException e) {
            rsp.result.result = e.getErrorCode();
            this.getLogger().error("EnableL3vpnCtpTask failed!", (Throwable)e);
        }
    }

    protected Integer getAsnBestEffort(QAsnEnableL3vpnCtpReq req) {
        return req.poBestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnEnableL3vpnCtpReq req) {
        return req.poTaskFlg;
    }
}

