/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_common.QAsnUniResIDList;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnRoutingInstance;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnDisableL3vpnReq;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnDisableL3vpnRsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnIf;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.l3vpn.dao.L3vpnDao;
import com.huawei.vmf.adapter.l3vpn.task.DisableL3vpnCtpTask;
import com.huawei.vmf.adapter.l3vpn.translation.asn.QAsnRoutingInstanceTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class DisableL3vpnTask
extends AbstractConfigQTask<QAsnDisableL3vpnReq, QAsnDisableL3vpnRsp> {
    private Collection<L3vpnInstance> l3vpnInstanceList;

    public DisableL3vpnTask() {
        super(EOperationType.MODIFY);
        this.addMoCompositeService(Interface.class, (ICompositeService)new DefaultCompositeService(Interface.class));
    }

    protected void decode(QAsnDisableL3vpnReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        L3vpnDao dao = L3vpnDao.newInstance();
        List<String> fdnList = this.parseFdns(req.l3vpnKeyList);
        try {
            this.l3vpnInstanceList = dao.queryL3vpnInstanceByFdns(fdnList);
            Context context = asnTranslatorContext.getTransactionContext();
            this.disableSap(this.l3vpnInstanceList, context);
        }
        catch (VMFException e) {
            this.getLogger().error("QAsnDisableL3vpnReq decode failed!", (Throwable)e);
        }
    }

    protected void encode(QAsnDisableL3vpnRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        Context context = asnTranslatorContext.getTransactionContext();
        OperResult operResult = context.getOperResult();
        QAsnRoutingInstanceTranslator translator = new QAsnRoutingInstanceTranslator();
        try {
            int result;
            for (L3vpnInstance l3vpnInstance : this.l3vpnInstanceList) {
                boolean isSuccess;
                ErrorInfo error = null;
                if (!CollectionUtils.isEmpty((Collection)l3vpnInstance.getL3vpnIfs())) {
                    L3vpnIf l3vpnIf;
                    Interface ifm;
                    Iterator i$ = l3vpnInstance.getL3vpnIfs().iterator();
                    while (i$.hasNext() && ((error = operResult.getMoOperResult((VmfMO)(ifm = this.translateL3vpnIF2Interface(l3vpnIf = (L3vpnIf)i$.next())))) == null || error.getErrorCode() == 0)) {
                    }
                }
                QAsnRoutingInstance asn = (QAsnRoutingInstance)translator.encode(l3vpnInstance, asnTranslatorContext);
                asn.poOperResult.isSuccess = isSuccess = error == null || error.getErrorCode() == 0;
                if (!isSuccess) {
                    asn.poOperResult.reason = StringUtil.globalByte((String)error.getErrorMessage());
                }
                rsp.l3vpnList.add((Object)asn);
            }
            rsp.result.result = result = context.getOperResult().hasFailed() ? 1107499878 : 0;
        }
        catch (VMFException e) {
            rsp.result.result = e.getErrorCode();
            this.getLogger().error("DisableL3vpnTask failed!", (Throwable)e);
        }
    }

    protected Integer getAsnBestEffort(QAsnDisableL3vpnReq req) {
        return req.poBestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnDisableL3vpnReq req) {
        return req.poTaskFlg;
    }

    private void disableSap(Collection<L3vpnInstance> l3vpnInstanceList, Context context) {
        for (L3vpnInstance l3vpnInstance : l3vpnInstanceList) {
            if (CollectionUtils.isEmpty((Collection)l3vpnInstance.getL3vpnIfs())) continue;
            for (L3vpnIf l3vpnIf : l3vpnInstance.getL3vpnIfs()) {
                Interface ifm = this.translateL3vpnIF2Interface(l3vpnIf);
                DisableL3vpnCtpTask.disableCTP2Context(ifm, context);
                l3vpnInstance.addKeyRefMo((VmfMO)ifm);
            }
        }
    }

    private List<String> parseFdns(QAsnUniResIDList l3vpnKeyList) {
        ArrayList<String> fdnList = new ArrayList<String>(l3vpnKeyList.size());
        for (Object resIdObj : l3vpnKeyList) {
            String fdn = StringUtil.globalString((byte[])((QAsnUniResID)resIdObj).strFDN);
            fdnList.add(fdn);
        }
        return fdnList;
    }

    private Interface translateL3vpnIF2Interface(L3vpnIf l3vpnIf) {
        Interface ifm = new Interface();
        ifm.setDevID(l3vpnIf.getDevID());
        ifm.setVrID(l3vpnIf.getVrID());
        ifm.setIfName(l3vpnIf.getIfName());
        return ifm;
    }
}

