/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_common.QAsnUniResIDList;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnDisableL3vpnCtpReq;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnDisableL3vpnCtpRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.extendpoint.l3vpn.task.ITaskSpecialAction;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.transaction.IDBLinkageHandler;
import com.huawei.vmf.adapter.framework.transaction.NestingContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.l3vpn.Activator;
import com.huawei.vmf.extendpoint.register.FrameExtendPointServiceMgr;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.LoggerFactory;

public class DisableL3vpnCtpTask
extends AbstractConfigQTask<QAsnDisableL3vpnCtpReq, QAsnDisableL3vpnCtpRsp> {
    public DisableL3vpnCtpTask() {
        super(EOperationType.MODIFY);
        this.addMoCompositeService(Interface.class, (ICompositeService)new DefaultCompositeService(Interface.class));
    }

    public static void disableCTP2Context(Interface ifm, Context context) {
        if (DisableL3vpnCtpTask.canShutDown(ifm)) {
            IMOChangeRecord record = context.addChangeRecord(Interface.class);
            ifm.setIfAdminStatus(Interface.IF_ADMIN_STATUS_ENUM.DOWN);
            record.addModify((Object)ifm, new PropertyChangeItem("ifAdminStatus"));
            if (null == context.getProperty(DBLinkageHandler.class.getName())) {
                context.addDBLinkageHandler((IDBLinkageHandler)new DBLinkageHandler());
            }
        } else {
            ifm.setIfAdminStatus(Interface.IF_ADMIN_STATUS_ENUM.UP);
            context.addMoOperResult((VmfMO)ifm, 0);
        }
    }

    private static boolean canShutDown(Interface mo) {
        ITaskSpecialAction specialAction = (ITaskSpecialAction)FrameExtendPointServiceMgr.getInstance().getExtendPoitService(ITaskSpecialAction.class);
        if (specialAction != null) {
            boolean isSupport = false;
            try {
                isSupport = specialAction.isSupportIfmEnableStatus();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(DisableL3vpnCtpTask.class).error("failed new instance for ITaskSpecialAction!", (Throwable)e);
            }
            return isSupport;
        }
        String ifName = mo.getIfName().toUpperCase();
        return !ifName.startsWith("LOOPBACK");
    }

    protected void decode(QAsnDisableL3vpnCtpReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        InterfaceFdnParser fdnParser = new InterfaceFdnParser();
        QAsnUniResIDList resIdList = req.ctpKeyList;
        for (QAsnUniResID resId : resIdList) {
            Interface ifm = (Interface)fdnParser.getIndexMo(resId);
            DisableL3vpnCtpTask.disableCTP2Context(ifm, asnTranslatorContext.getTransactionContext());
        }
    }

    protected void encode(QAsnDisableL3vpnCtpRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        Set mos = asnTranslatorContext.getTransactionContext().addChangeRecord(Interface.class).getAllChanges();
        IAsnTranslator translator = Activator.getAsnTranslator(QAsnSAP.class, Interface.class);
        try {
            Collection asns = translator.encode((Collection)mos, asnTranslatorContext);
            rsp.sapList.addAll(asns);
            rsp.result.result = 0;
        }
        catch (VMFException e) {
            this.getLogger().error("encode mo error. mos=" + mos, (Throwable)e);
            rsp.result.result = 1107499878;
        }
    }

    protected Integer getAsnBestEffort(QAsnDisableL3vpnCtpReq req) {
        return req.poBestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnDisableL3vpnCtpReq req) {
        return req.poTaskFlg;
    }

    private static class DBLinkageHandler
    implements IDBLinkageHandler {
        public void handler(NestingContext transaction) {
            this.setOperStatus2Down((Context)transaction, transaction.getTotalContext());
            this.setOperStatus2Down(transaction.getTotalContext(), transaction.getTotalContext());
        }

        private void setOperStatus2Down(Context context, Context totalContext) {
            IMOChangeRecord changeRecord = context.getChangeRecord(Interface.class);
            if (changeRecord == null) {
                return;
            }
            HashSet<Interface> toSetOperStatus = new HashSet<Interface>();
            for (Interface mo : changeRecord.getModifies()) {
                if (totalContext.getMoErrorCode((VmfMO)mo) != 0) continue;
                mo.setIfOperStatus(Interface.IF_OPER_STATUS_ENUM.DOWN);
                toSetOperStatus.add(mo);
            }
            for (Interface mo : toSetOperStatus) {
                changeRecord.addModify((Object)mo, new PropertyChangeItem("ifOperStatus", (Object)Interface.IF_OPER_STATUS_ENUM.DOWN, null));
            }
        }
    }
}

