/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnRoutingInstance;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnDeployL3vpnReq;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnDeployL3vpnRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.extendpoint.l3vpn.task.ITaskSpecialAction;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.transaction.IDBLinkageHandler;
import com.huawei.vmf.adapter.framework.transaction.NestingContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.route.model.UniAf;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.l3vpn.common.Utility;
import com.huawei.vmf.adapter.l3vpn.task.AbstractOperL3vpnTask;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DeployL3vpnTask
extends AbstractOperL3vpnTask<QAsnDeployL3vpnReq, QAsnDeployL3vpnRsp> {
    private static Logger LOGGER = LoggerFactory.getLogger(DeployL3vpnTask.class);
    private L3vpnInstanceFdnParser fdnParser = new L3vpnInstanceFdnParser();
    private boolean isExecuteService = true;
    private Collection<L3vpnInstance> l3vpns;
    private ITaskSpecialAction specialAction = (ITaskSpecialAction)ExtendPointServiceMgr.getInstance().getExtendPoitService(ITaskSpecialAction.class);

    public DeployL3vpnTask() {
        super(EOperationType.DEPLOY, (ICompositeService)new DefaultCompositeService<L3vpnInstance>(L3vpnInstance.class){

            protected boolean autoSetDeafultValue() {
                return false;
            }

            protected List<L3vpnInstance> sendConfig(List<NestingContext> nestingContexts, List<L3vpnInstance> mos, EOperationType operType, Context context) {
                IMOChangeRecord ifChangeRecord = context.getChangeRecord(Interface.class);
                if (null == ifChangeRecord || !ifChangeRecord.hasCreate()) {
                    return super.sendConfig(nestingContexts, mos, operType, context);
                }
                HashMap<Interface, Collection<Ipv4Address>> ifMo2Address = new HashMap<Interface, Collection<Ipv4Address>>();
                for (Interface ifMo : ifChangeRecord.getCreates()) {
                    if (CollectionUtils.isEmpty((Collection)ifMo.getIpv4Addresss())) continue;
                    ifMo2Address.put(ifMo, new ArrayList(ifMo.getIpv4Addresss()));
                    ifMo.setIpv4Addresss(new ArrayList());
                }
                if (!ifMo2Address.isEmpty()) {
                    context.addDBLinkageHandler((IDBLinkageHandler)new RestoreIPV4ForInterfaceDBLinkageHandler(ifMo2Address));
                }
                return super.sendConfig(nestingContexts, mos, operType, context);
            }
        });
    }

    protected void decode(QAsnDeployL3vpnReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        LinkedList<QAsnUniResID> keys = new LinkedList<QAsnUniResID>();
        L3vpnInstanceFdnParser fdnParser = new L3vpnInstanceFdnParser();
        for (Object asn : req.l3vpnList) {
            QAsnRoutingInstance instance = (QAsnRoutingInstance)asn;
            keys.add(instance.l3vpnKey);
            L3vpnInstance inst = (L3vpnInstance)fdnParser.getIndexMo(instance.l3vpnKey);
            String strKey = CommonUtil.composeTmpKey((Object[])new Object[]{inst.getDevID(), inst.getVrfName()});
            asnTranslatorContext.addProperty(strKey, (Object)instance);
        }
        this.l3vpns = Utility.INSTANCE.getAllMosByVpnKeys(keys, asnTranslatorContext, EOperationType.DEPLOY);
        IMOChangeRecord uniAfRcd = asnTranslatorContext.getTransactionContext().addChangeRecord(UniAf.class);
        ArrayList<UniAf> lstAf = new ArrayList<UniAf>();
        for (UniAf af : uniAfRcd.getCreates()) {
            lstAf.add(af);
            if (af.getRouteLimitNum() == null) continue;
            uniAfRcd.addModify((Object)af, Arrays.asList("alertPercent", "routeLimitNum", "simplyAlert"));
        }
        for (UniAf af : lstAf) {
            uniAfRcd.cancelCreate((Object)af);
        }
    }

    protected void encode(QAsnDeployL3vpnRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        this.patchL3vpnRunningStatus();
        Utility.reviseDeployStatus(asnTranslatorContext, L3vpnInstance.class);
        rsp.result.result = 0;
        Context cxt = asnTranslatorContext.getTransactionContext();
        for (L3vpnInstance l3vpn : this.l3vpns) {
            int err = cxt.getMoErrorCode((VmfMO)l3vpn);
            try {
                rsp.l3vpnList.add((Object)this.encode(l3vpn, rsp.result, asnTranslatorContext));
            }
            catch (VMFException e) {
                this.getLogger().error("encode error", (Throwable)e);
                err = 1090646033;
            }
            if (err == 0) continue;
            rsp.result.result = 1090646033;
        }
        if (this.specialAction != null) {
            this.specialAction.configL3vpnIfIp(rsp.l3vpnList, asnTranslatorContext, this.getOperType(), rsp.result);
        }
    }

    protected Integer getAsnBestEffort(QAsnDeployL3vpnReq req) {
        return req.poBestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnDeployL3vpnReq req) {
        return req.poTaskFlg;
    }

    protected void service(IAsnTranslationContext asnTranslatorContext) {
        if (!this.isExecuteService && this.specialAction != null) {
            return;
        }
        super.service(asnTranslatorContext);
    }

    private VpnInstAF getRelatedVpnInstAF(L3vpnInstance l3vpnFromDev) {
        if (CollectionUtils.isEmpty(this.l3vpns)) {
            return null;
        }
        String l3vpnFdnFromDev = this.fdnParser.getFdn(l3vpnFromDev);
        for (L3vpnInstance l3vpn : this.l3vpns) {
            if (!ObjectUtils.equals((Object)l3vpnFdnFromDev, (Object)this.fdnParser.getFdn(l3vpn)) || CollectionUtils.isEmpty((Collection)l3vpn.getVpnInstAFs())) continue;
            for (VpnInstAF vpnInstAF : l3vpn.getVpnInstAFs()) {
                if (!ObjectUtils.equals((Object)VpnInstAF.AF_TYPE_ENUM.IPV4UNI, (Object)vpnInstAF.getAfType())) continue;
                return vpnInstAF;
            }
        }
        return null;
    }

    private void getVrfStatusFromDev(Collection<L3vpnInstance> vrfs) throws VMFException {
        DefaultMOService pollService = new DefaultMOService();
        for (L3vpnInstance vrf : vrfs) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(vrf.getDevID().intValue());
            if (queryContext == null) {
                queryContext = new QuerySchemaTranslatorContext(vrf.getDevID().intValue());
                pollService.addQueryJob(queryContext);
            }
            VpnInstAF vrfAF = new VpnInstAF();
            Utility.INSTANCE.setChildMoKeyByParentMo((VmfMO)vrfAF, (VmfMO)vrf);
            vrfAF.setAfType(VpnInstAF.AF_TYPE_ENUM.IPV4UNI);
            vrf.addVpnInstAFs(Arrays.asList(vrfAF));
            queryContext.addQueryAttributes(FeatureName.L3VPN, (VmfMO)vrf, Arrays.asList("vpnInstAFs"));
            queryContext.addQueryAttributes(FeatureName.L3VPN, (VmfMO)vrfAF, Arrays.asList("vrfStatus"));
        }
        pollService.poll();
    }

    private void patchL3vpnRunningStatus() {
        ArrayList<L3vpnInstance> l3vpnsFromDev = new ArrayList<L3vpnInstance>();
        for (L3vpnInstance l3vpn : this.l3vpns) {
            L3vpnInstance l3vpnFromDev = new L3vpnInstance();
            l3vpnFromDev.setDevID(l3vpn.getDevID());
            l3vpnFromDev.setVrID(l3vpn.getVrID());
            l3vpnFromDev.setVrfName(l3vpn.getVrfName());
            l3vpnsFromDev.add(l3vpnFromDev);
        }
        try {
            this.getVrfStatusFromDev(l3vpnsFromDev);
        }
        catch (VMFException e) {
            LOGGER.error("GetVrfStatusFromDev failed.", (Throwable)e);
            return;
        }
        Context dbContext = new Context();
        IMOChangeRecord vpnInstAfChangeRecord = dbContext.addDBChangeRecord(VpnInstAF.class);
        for (L3vpnInstance l3vpnFromDev : l3vpnsFromDev) {
            if (CollectionUtils.isEmpty((Collection)l3vpnFromDev.getVpnInstAFs())) continue;
            for (VpnInstAF vpnInstAF : l3vpnFromDev.getVpnInstAFs()) {
                VpnInstAF relatedVpnInstAF;
                if (!ObjectUtils.equals((Object)VpnInstAF.AF_TYPE_ENUM.IPV4UNI, (Object)vpnInstAF.getAfType()) || null == (relatedVpnInstAF = this.getRelatedVpnInstAF(l3vpnFromDev))) continue;
                relatedVpnInstAF.setVrfStatus(vpnInstAF.getVrfStatus());
                vpnInstAfChangeRecord.addModify((Object)relatedVpnInstAF, new PropertyChangeItem("vrfStatus", (Object)relatedVpnInstAF.getVrfStatus(), null));
            }
        }
        try {
            DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, dbContext).merge(false, new Class[]{VpnInstAF.class});
        }
        catch (VMFException e) {
            LOGGER.error("Update running status for VpnInstAF failed.", (Throwable)e);
        }
    }

    public static class RestoreIPV4ForInterfaceDBLinkageHandler
    implements IDBLinkageHandler {
        final Map<Interface, Collection<Ipv4Address>> ifMo2Address;

        public RestoreIPV4ForInterfaceDBLinkageHandler(Map<Interface, Collection<Ipv4Address>> ifMo2Address) {
            this.ifMo2Address = ifMo2Address;
        }

        public void handler(NestingContext transaction) {
            for (Map.Entry<Interface, Collection<Ipv4Address>> entry : this.ifMo2Address.entrySet()) {
                entry.getKey().addIpv4Addresss(entry.getValue());
            }
        }
    }
}

