/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnDeleteL3vpnReq;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnDeleteL3vpnRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelPolicy;
import com.huawei.vmf.adapter.l3vpn.common.Utility;
import com.huawei.vmf.adapter.l3vpn.task.AbstractOperL3vpnTask;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.springframework.util.CollectionUtils;

public class DeleteL3vpnTask
extends AbstractOperL3vpnTask<QAsnDeleteL3vpnReq, QAsnDeleteL3vpnRsp> {
    private String FLAG_L3VPN = "L3VPN";
    private Collection<L3vpnInstance> l3vpns = null;

    public DeleteL3vpnTask() {
        super(EOperationType.DELETE);
    }

    protected void decode(QAsnDeleteL3vpnReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        LinkedList<QAsnUniResID> keys = new LinkedList<QAsnUniResID>();
        asnTranslatorContext.getTransactionContext().addProperty(this.FLAG_L3VPN, (Object)this.FLAG_L3VPN);
        for (Object asn : req.l3vpnKeyList) {
            QAsnUniResID key = (QAsnUniResID)asn;
            if (key.strFDN == null || key.strFDN.length == 0) continue;
            keys.add(key);
        }
        this.l3vpns = Utility.INSTANCE.getAllMosByVpnKeys(keys, asnTranslatorContext, EOperationType.DELETE);
        Context context = asnTranslatorContext.getTransactionContext();
        for (Class moClass : context.getAllChanges().keySet()) {
            context.addDBChangeRecord(moClass).addAll((IMOChangeRecord)context.getAllChanges().get(moClass));
        }
        this.cancelDeleteFromDevOnVrfDeleted(asnTranslatorContext, new HashMap<Class<? extends VmfMO>, Collection<VmfMO>>());
    }

    protected void encode(QAsnDeleteL3vpnRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        rsp.result.result = 0;
        Context cxt = asnTranslatorContext.getTransactionContext();
        for (L3vpnInstance l3vpn : this.l3vpns) {
            int err = cxt.getMoErrorCode((VmfMO)l3vpn);
            try {
                rsp.l3vpnList.add((Object)this.encode(l3vpn, rsp.result, asnTranslatorContext));
            }
            catch (VMFException e) {
                this.getLogger().error("encode error", (Throwable)e);
                err = 1090646033;
            }
            if (err != 0) {
                rsp.result.result = 1090646033;
                continue;
            }
            this.deleteTunnelPolicy(l3vpn);
        }
    }

    protected Integer getAsnBestEffort(QAsnDeleteL3vpnReq req) {
        return req.poBestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnDeleteL3vpnReq req) {
        return req.poTaskFlg;
    }

    private void deleteTunnelPolicy(L3vpnInstance l3vpn) {
        if (CollectionUtils.isEmpty((Collection)l3vpn.getVpnInstAFs())) {
            return;
        }
        for (VpnInstAF vpnAf : l3vpn.getVpnInstAFs()) {
            if (StringUtil.isEmpty((String)vpnAf.getTnlPolicyName())) continue;
            TunnelPolicy policy = new TunnelPolicy();
            policy.setDevID(l3vpn.getDevID());
            policy.setVrID(l3vpn.getVrID());
            policy.setTnlPolicyName(vpnAf.getTnlPolicyName());
            try {
                Utility.INSTANCE.unDeployMo(policy, TunnelPolicy.class);
            }
            catch (VMFException e) {
                this.getLogger().error("delete tunnelPolicy", (Throwable)e);
            }
        }
    }
}

