/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnRoutePolicy;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnTnlPolicy;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnTunnelSelection;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnIsisCtp;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnOspfCtp;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnOspfCtpList;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnArea;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnIsisInstance;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnIsisInstanceList;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnL3VPNMulticastInfo;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnOspfInstance;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnOspfInstanceList;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnRoutingInstance;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnStaticRoute;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnStaticRouteList;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnUpePeer;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnCreateL3vpnReq;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnCreateL3vpnRsp;
import com.huawei.network.qasn.m_q_ip_route_model.QAsnBgpInstance;
import com.huawei.network.qasn.m_q_ip_route_model.QAsnBgpInstanceList;
import com.huawei.network.qasn.m_q_ip_route_model.QAsnBgpPeer;
import com.huawei.network.qasn.m_q_ip_route_model.QAsnBgpPg;
import com.huawei.network.qasn.m_q_ip_route_model.QAsnImportRoute;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.IpAddressUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.qos.service.IQosService;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.arp.model.ArpInterface;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpIntfOpt82Formate;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpOpt82Intf;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayIfCfg;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.ifm.service.IInterfaceService;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnIf;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.MvpnFeature;
import com.huawei.vmf.adapter.fservice.l3vpn.model.MvpnIpmsi;
import com.huawei.vmf.adapter.fservice.l3vpn.model.MvpnTunnelInterface;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VrfUpePeer;
import com.huawei.vmf.adapter.fservice.mcast.model.McastAfsEnable;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelPolicy;
import com.huawei.vmf.adapter.fservice.route.model.PeerAF;
import com.huawei.vmf.adapter.fservice.route.model.PrefixFilter;
import com.huawei.vmf.adapter.fservice.route.model.RoutePolicy;
import com.huawei.vmf.adapter.l3vpn.Activator;
import com.huawei.vmf.adapter.l3vpn.common.CheckedMOContext;
import com.huawei.vmf.adapter.l3vpn.common.Utility;
import com.huawei.vmf.adapter.l3vpn.translation.asn.QAsnRoutingInstanceTranslator;
import com.huawei.vmf.adapter.l3vpn.translation.asn.QAsnSapTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class CreateL3vpnTask
extends AbstractConfigQTask<QAsnCreateL3vpnReq, QAsnCreateL3vpnRsp> {
    private static final int NESERVICE_AUTOPICKSAPID = 1;
    private final Map<L3vpnInstance, QAsnRoutingInstance> l3vpnMo2QAsn = new HashMap<L3vpnInstance, QAsnRoutingInstance>();

    public CreateL3vpnTask() {
        super(EOperationType.PREDEPLOY);
        this.addMoCompositeService(L3vpnInstance.class, (ICompositeService)new DefaultCompositeService<L3vpnInstance>(L3vpnInstance.class){

            protected boolean autoSetDeafultValue() {
                return false;
            }
        });
    }

    protected void decode(QAsnCreateL3vpnReq req, Task task, IAsnTranslationContext context) {
        try {
            this.decodeImp(req, context);
        }
        catch (VMFException e) {
            this.getLogger().error("decode failed", (Throwable)e);
        }
    }

    protected void encode(QAsnCreateL3vpnRsp rsp, IAsnTranslationContext context) {
        QAsnRoutingInstanceTranslator translator = new QAsnRoutingInstanceTranslator();
        rsp.result.result = 0;
        Context cxt = context.getTransactionContext();
        Set l3vpns = cxt.getDBChangeRecord(L3vpnInstance.class) != null ? cxt.getDBChangeRecord(L3vpnInstance.class).getCreates() : cxt.getChangeRecord(L3vpnInstance.class).getCreates();
        for (L3vpnInstance instance : l3vpns) {
            int err = cxt.getMoErrorCode((VmfMO)instance);
            if (err != 0) {
                rsp.result.result = 1090646033;
            } else {
                this.processUPEPeer(instance, cxt);
            }
            QAsnRoutingInstance asn = new QAsnRoutingInstance();
            try {
                translator.encode(instance, asn, context);
                rsp.l3vpnList.add((Object)asn);
            }
            catch (VMFException e) {
                this.getLogger().error("encode error", (Throwable)e);
            }
        }
    }

    protected Integer getAsnBestEffort(QAsnCreateL3vpnReq req) {
        return 1;
    }

    protected byte[] getAsnTaskFlag(QAsnCreateL3vpnReq req) {
        return req.poTaskFlg;
    }

    protected void postDecode(QAsnCreateL3vpnReq req, Task task, IAsnTranslationContext context) {
        IMOChangeRecord rcd = context.getTransactionContext().getChangeRecord(L3vpnInstance.class);
        Set l3vpns = rcd.getCreates();
        if (l3vpns == null) {
            return;
        }
        for (L3vpnInstance l3vpn : l3vpns) {
            try {
                this.processRoutePolicy(l3vpn);
            }
            catch (VMFException e) {
                this.getLogger().error("process RoutePolicy error", (Throwable)e);
                context.getTransactionContext().addMoOperResults((Collection)l3vpns, e.getErrorCode());
            }
            try {
                this.processTunnelPolicy(l3vpn);
            }
            catch (VMFException e) {
                this.getLogger().error("process tunnelPolicy error", (Throwable)e);
                context.getTransactionContext().addMoOperResults((Collection)l3vpns, e.getErrorCode());
            }
        }
    }

    private void decodeImp(QAsnCreateL3vpnReq req, IAsnTranslationContext context) throws VMFException {
        QAsnRoutingInstanceTranslator translator = new QAsnRoutingInstanceTranslator();
        context.setTransactionContext((Context)new CheckedMOContext());
        Context cxt = context.getTransactionContext();
        Object qosSrv = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQosService.class);
        context.addProperty("flowType", (Object)EthSubIf.FLOW_TYPE_ENUM.DOT1Q_TERM);
        HashMap<String, QAsnUniResID> serialNum2SapKey = new HashMap<String, QAsnUniResID>();
        for (Object ins : req.vrfList) {
            QAsnRoutingInstance vrfAsn = (QAsnRoutingInstance)ins;
            L3vpnInstance vrf = (L3vpnInstance)translator.decode((FStruct)vrfAsn, context);
            vrf.setSerialNum(StringUtil.globalString((byte[])vrfAsn.l3vpnKey.poSerialNum));
            vrf.setDeployStatus(Integer.valueOf(0));
            Utility.INSTANCE.processDhcpRelayVpn(vrfAsn.poDhcpRelayInfo, vrf, context);
            Collection<Object> ifMos = Collections.emptyList();
            ifMos = this.decodeSap(vrfAsn, serialNum2SapKey, context, vrf);
            IInterfaceService service = Activator.getService(IInterfaceService.class);
            service.deployInterfaceForL3vpn(ifMos, (Object)cxt);
            this.setFdn(vrfAsn);
            this.processBgpRouteSap(vrfAsn.bgpInstList, serialNum2SapKey);
            this.processISISRouteSap(vrfAsn.isisInstList, serialNum2SapKey);
            this.processOSPFRouteSap(vrfAsn.ospfInstList, serialNum2SapKey);
            this.processStaticRouteSap(vrfAsn.staticRouteList, serialNum2SapKey);
            for (Interface interface_ : ifMos) {
                vrf.addKeyRefMos((Collection)interface_.getKeyRefMos(DhcpRelayIfCfg.class));
                vrf.addKeyRefMos((Collection)interface_.getKeyRefMos(DhcpOpt82Intf.class));
                vrf.addKeyRefMos((Collection)interface_.getKeyRefMos(DhcpIntfOpt82Formate.class));
                vrf.addKeyRefMos((Collection)interface_.getKeyRefMos(ArpInterface.class));
                interface_.getKeyRefMos(DhcpRelayIfCfg.class).clear();
                interface_.getKeyRefMos(DhcpOpt82Intf.class).clear();
                interface_.getKeyRefMos(DhcpIntfOpt82Formate.class).clear();
                interface_.getKeyRefMos(ArpInterface.class).clear();
            }
            vrf.addKeyRefMos(ifMos);
            if (vrf.getL3vpnIfs() != null) {
                vrf.getL3vpnIfs().clear();
            }
            for (Interface interface_ : ifMos) {
                L3vpnIf bindIf = new L3vpnIf();
                Utility.INSTANCE.setMoDevID((VmfMO)vrf, (VmfMO)bindIf);
                bindIf.setVrfName(vrf.getVrfName());
                bindIf.setIfName(interface_.getIfName());
                vrf.addL3vpnIfs(Arrays.asList(bindIf));
                if (null != qosSrv) {
                    ((IQosService)qosSrv).decodeNewL3vpnUniQos(vrf, (QAsnSAP)context.getProperty(bindIf.getIfName()), (Object)context);
                }
                if (CollectionUtils.isEmpty((Collection)interface_.getIpv4Addresss())) continue;
                Ipv4Address ip = (Ipv4Address)interface_.getIpv4Addresss().iterator().next();
                bindIf.setIpv4Addr(ip.getIpAddr());
                bindIf.setSubnetMask(ip.getSubnetMask());
            }
            Utility.INSTANCE.reviseSrRouteDestVrf(vrf, context);
            this.l3vpnMo2QAsn.put(vrf, vrfAsn);
            this.decodeMcastInfo(vrf, context);
            Utility.INSTANCE.processStaticArp(vrfAsn.arpItemList, vrf, context);
        }
        cxt.getChangeRecord(TunnelPolicy.class).clear();
    }

    private void decodeMcastInfo(L3vpnInstance l3vpn, IAsnTranslationContext cxt) throws VMFException {
        String ip;
        QAsnRoutingInstance asn = this.l3vpnMo2QAsn.get(l3vpn);
        if (asn.poMulticastInfo == null) {
            return;
        }
        QAsnL3VPNMulticastInfo mcast = asn.poMulticastInfo;
        MvpnFeature mvpnFeature = Utility.INSTANCE.instanceMo(MvpnFeature.class, (VmfMO)l3vpn);
        mvpnFeature.setVrfName(l3vpn.getVrfName());
        mvpnFeature.setMvpnTunnelInterface(Utility.INSTANCE.instanceMo(MvpnTunnelInterface.class, (VmfMO)l3vpn));
        mvpnFeature.getMvpnTunnelInterface().setMtlNum(Long.valueOf(mcast.iMTunnelNum.intValue()));
        mvpnFeature.setMvpnTunnelInterface(Utility.INSTANCE.instanceMo(MvpnTunnelInterface.class, (VmfMO)l3vpn));
        MvpnTunnelInterface tunnelIf = mvpnFeature.getMvpnTunnelInterface();
        tunnelIf.setVrfName(l3vpn.getVrfName());
        tunnelIf.setMtlNum(Long.valueOf(mcast.iMTunnelNum.intValue()));
        if (mcast.poGroupAddress != null) {
            mvpnFeature.setMvpnIpmsi(Utility.INSTANCE.instanceMo(MvpnIpmsi.class, (VmfMO)l3vpn));
            mvpnFeature.getMvpnIpmsi().setVrfName(l3vpn.getVrfName());
        }
        if (mcast.poMtu != null) {
            Interface mtunnelInterfaceMo = Utility.INSTANCE.instanceMo(Interface.class, (VmfMO)l3vpn);
            mtunnelInterfaceMo.setIfMtu(mcast.poMtu);
            mtunnelInterfaceMo.setIfName("MTunnel" + mcast.iMTunnelNum);
            cxt.getTransactionContext().addChangeRecord(Interface.class).addCreate((Object)mtunnelInterfaceMo);
            mvpnFeature.addKeyRefMo((VmfMO)mtunnelInterfaceMo);
        }
        if (mcast.postrIPAddress != null && !StringUtil.isEmpty((String)(ip = StringUtil.globalString((byte[])mcast.postrIPAddress)))) {
            tunnelIf.setMtunnelIfIpAddress(ip);
            String mask = "0.0.0.0";
            if (mcast.postrIPAddMask != null) {
                mask = StringUtil.globalString((byte[])mcast.postrIPAddMask);
            }
            tunnelIf.setMtunnelIfIpMaskLength(Long.valueOf(IpAddressUtil.dotMask2Int((String)mask)));
        }
        mvpnFeature.setAddressFamily(MvpnFeature.ADDRESS_FAMILY_ENUM.IPV4UNICAST);
        cxt.getTransactionContext().addChangeRecord(MvpnFeature.class).addCreate((Object)mvpnFeature);
        if (asn.poMulticastInfo.pobRoutingEnable != null && Integer.valueOf(1).equals(asn.poMulticastInfo.pobRoutingEnable)) {
            McastAfsEnable enable = new McastAfsEnable();
            Utility.INSTANCE.setMoDevID((VmfMO)l3vpn, (VmfMO)enable);
            enable.setVrfName(l3vpn.getVrfName());
            l3vpn.addKeyRefMo((VmfMO)enable);
            cxt.getTransactionContext().addChangeRecord(McastAfsEnable.class).addCreate((Object)enable);
            mvpnFeature.addKeyRefMo((VmfMO)enable);
        }
        l3vpn.addKeyRefMo((VmfMO)mvpnFeature);
    }

    private Collection<Interface> decodeSap(QAsnRoutingInstance instanceAsn, Map<String, QAsnUniResID> serialNum2SapKey, IAsnTranslationContext context, L3vpnInstance vrf) throws VMFException {
        InterfaceFdnParser ifFdnParser = new InterfaceFdnParser();
        ArrayList<Interface> ret = new ArrayList<Interface>();
        for (Object sap : instanceAsn.sapList) {
            QAsnSAP sapAsn = (QAsnSAP)sap;
            Interface mo = Utility.INSTANCE.decodeSap(sapAsn, context);
            if (sapAsn.autopickSapID == 1) {
                Interface subSapMo = (Interface)Utility.INSTANCE.getIfService().allocSubIf(Arrays.asList(mo)).iterator().next();
                mo.setIfName(subSapMo.getIfName());
                mo.setIfIndex(subSapMo.getIfIndex());
            }
            if (sapAsn.ctpKey.poSerialNum != null) {
                String serialNum = StringUtil.globalString((byte[])sapAsn.ctpKey.poSerialNum);
                serialNum2SapKey.put(serialNum, ifFdnParser.getUniResID((VmfMO)mo));
            }
            if (!this.isValidFdn(sapAsn.ctpKey)) {
                sapAsn.ctpKey = new InterfaceFdnParser().getUniResID((VmfMO)mo);
            }
            new QAsnSapTranslator().decodeServiceInterface(context, vrf, mo, sapAsn);
            context.addProperty(mo.getIfName(), (Object)sapAsn);
            ret.add(mo);
        }
        return ret;
    }

    private boolean isValidFdn(QAsnUniResID fdn) {
        return !StringUtil.isEmpty((String)StringUtil.globalString((byte[])fdn.strFDN)) && !StringUtil.isEmpty((String)StringUtil.globalString((byte[])fdn.strMOC));
    }

    private void processBgpRouteSap(QAsnBgpInstanceList bgpAsns, Map<String, QAsnUniResID> serialNum2SapKey) {
        for (Object bgpOb : bgpAsns) {
            QAsnBgpInstance bgpAsn = (QAsnBgpInstance)bgpOb;
            for (Object peerOb : bgpAsn.bgpPeerList) {
                QAsnBgpPeer peer = (QAsnBgpPeer)peerOb;
                if (peer.poPeerIpv4Unicast == null || peer.poPeerIpv4Unicast.peerPgIpv4Unicast.poConnIf == null) continue;
                this.setSapUniResID(serialNum2SapKey, peer.poPeerIpv4Unicast.peerPgIpv4Unicast.poConnIf);
            }
            for (Object pgOb : bgpAsn.bgpPgList) {
                QAsnBgpPg pg = (QAsnBgpPg)pgOb;
                if (pg.poPgIpv4Unicast == null) continue;
                this.setSapUniResID(serialNum2SapKey, pg.poPgIpv4Unicast.peerPgIpv4Unicast.poConnIf);
            }
        }
    }

    private void processISISRouteSap(QAsnIsisInstanceList isisAsns, Map<String, QAsnUniResID> serialNum2SapKey) {
        for (Object isisOb : isisAsns) {
            QAsnIsisInstance isisAsn = (QAsnIsisInstance)isisOb;
            for (Object ob : isisAsn.isisCtpList) {
                QAsnIsisCtp isisCtp = (QAsnIsisCtp)ob;
                this.setSapUniResID(serialNum2SapKey, isisCtp.l3vpnCtpKey);
            }
        }
    }

    private void processOSPFRouteSap(QAsnOspfInstanceList ospfAsns, Map<String, QAsnUniResID> serialNum2SapKey) {
        for (Object ospfOb : ospfAsns) {
            QAsnOspfInstance ospfAsn = (QAsnOspfInstance)ospfOb;
            for (Object arOb : ospfAsn.areaList) {
                QAsnArea ar = (QAsnArea)arOb;
                this.setSapUniResID(serialNum2SapKey, ar.ospfCtpList);
            }
        }
    }

    private void processRoutePolicy(L3vpnInstance instance) throws VMFException {
        QAsnRoutingInstance qasn = this.l3vpnMo2QAsn.get(instance);
        if (qasn.bgpInstList != null) {
            for (Object bgpAsn : qasn.bgpInstList) {
                QAsnBgpInstance bgp = (QAsnBgpInstance)bgpAsn;
                this.processRoutePolicy(bgp);
            }
        }
        if (qasn.poAfIpv4Unicast != null && qasn.poAfIpv4Unicast.poVpnFrrRoutePolicy != null) {
            this.processRoutePolicy(qasn.poAfIpv4Unicast.poVpnFrrRoutePolicy);
        }
    }

    private void processRoutePolicy(QAsnBgpInstance bgp) throws VMFException {
        if (bgp.poAfIpv4Unicast == null) {
            return;
        }
        for (Object importRouteAsn : bgp.poAfIpv4Unicast.importRouteList) {
            QAsnImportRoute importRoute = (QAsnImportRoute)importRouteAsn;
            if (importRoute.poRoutePolicy == null) continue;
            this.processRoutePolicy(importRoute.poRoutePolicy);
        }
    }

    private void processRoutePolicy(QAsnRoutePolicy policyAsn) throws VMFException {
        if (policyAsn.poOperBit == null) {
            return;
        }
        if (policyAsn.poOperBit != 0 && policyAsn.poOperBit != 1) {
            return;
        }
        IAsnTranslator translator = Activator.getAsnTranslator(QAsnRoutePolicy.class, RoutePolicy.class);
        AsnTranslationContext context = new AsnTranslationContext();
        context.setTransactionContext(new Context());
        context.setOperType(EOperationType.CREATE);
        RoutePolicy routePolicy = (RoutePolicy)translator.decode((FStruct)policyAsn, (IAsnTranslationContext)context);
        if (!CollectionUtils.isEmpty((Collection)routePolicy.getKeyRefMos(PrefixFilter.class))) {
            Utility.INSTANCE.deployMo((VmfMO)routePolicy.getKeyRefMos(PrefixFilter.class).get(0), PrefixFilter.class);
        }
        Utility.INSTANCE.deployMo(routePolicy, RoutePolicy.class);
    }

    private void processStaticRouteSap(QAsnStaticRouteList staticRouteAsns, Map<String, QAsnUniResID> serialNum2SapKey) {
        for (Object ob : staticRouteAsns) {
            QAsnStaticRoute staticRouteAsn = (QAsnStaticRoute)ob;
            this.setSapUniResID(serialNum2SapKey, staticRouteAsn.poOutIf);
        }
    }

    private void processTunnelPolicy(L3vpnInstance l3vpn) throws VMFException {
        IAsnTranslator translator = Activator.getAsnTranslator(QAsnTnlPolicy.class, TunnelPolicy.class);
        AsnTranslationContext context = new AsnTranslationContext();
        context.setTransactionContext(new Context());
        context.setOperType(EOperationType.CREATE);
        QAsnRoutingInstance qasn = this.l3vpnMo2QAsn.get(l3vpn);
        for (Object tunnelPolicyAsn : qasn.tnlPolicyList) {
            QAsnTunnelSelection tunnelSelection = (QAsnTunnelSelection)tunnelPolicyAsn;
            if (tunnelSelection.poTnlPolicyAttr == null) continue;
            TunnelPolicy policy = (TunnelPolicy)translator.decode((FStruct)tunnelSelection.poTnlPolicyAttr, (IAsnTranslationContext)context);
            Utility.INSTANCE.deployMo(policy, TunnelPolicy.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUPEPeer(L3vpnInstance l3vpn, Context cxt) {
        QAsnRoutingInstance asn = this.l3vpnMo2QAsn.get(l3vpn);
        if (asn == null || asn.poUpePeerList == null) {
            return;
        }
        LinkedList<PeerAF> peerAfFromAsn = new LinkedList<PeerAF>();
        for (Object upePeerAsnOb : asn.poUpePeerList) {
            QAsnUpePeer upePeerAsn = (QAsnUpePeer)upePeerAsnOb;
            String peerIP = StringUtil.globalString((byte[])upePeerAsn.strIpAddress);
            if (!StringUtil.isEmpty((String)peerIP)) continue;
            PeerAF peerAf = new PeerAF();
            Utility.INSTANCE.setMoDevID((VmfMO)l3vpn, (VmfMO)peerAf);
            peerAf.setAfType(VpnInstAF.AF_TYPE_ENUM.IPV4UNI);
            peerAf.setRemoteAddress(peerIP);
            peerAfFromAsn.add(peerAf);
        }
        Context tempCxt = new Context();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(tempCxt);
        boolean isCommit = false;
        try {
            Collection existentPeerAfs = dao.exists(PeerAF.class, peerAfFromAsn);
            if (existentPeerAfs.size() != peerAfFromAsn.size()) {
                cxt.addMoOperResult((VmfMO)l3vpn, 555802650);
            }
            IMOChangeRecord changedRcd = tempCxt.addChangeRecord(VrfUpePeer.class);
            for (PeerAF peerAf : peerAfFromAsn) {
                VrfUpePeer vrfUpePeer = new VrfUpePeer();
                Utility.INSTANCE.setMoDevID((VmfMO)l3vpn, (VmfMO)vrfUpePeer);
                vrfUpePeer.setAfType(peerAf.getAfType());
                vrfUpePeer.setPeerAddr(peerAf.getRemoteAddress());
                vrfUpePeer.setVrfName(l3vpn.getVrfName());
                changedRcd.addCreate((Object)vrfUpePeer);
            }
            if (changedRcd.hasCreate()) {
                dao.merge(VrfUpePeer.class, true);
                dao.commit();
                isCommit = true;
                for (VrfUpePeer vrfUpePeer : changedRcd.getCreates()) {
                    l3vpn.addKeyRefMo((VmfMO)vrfUpePeer);
                }
            }
        }
        catch (VMFException e) {
            this.getLogger().error("processUPEPeer error", (Throwable)e);
            cxt.addMoOperResult((VmfMO)l3vpn, e.getErrorCode());
        }
        finally {
            if (!isCommit) {
                dao.rollback();
            }
        }
    }

    private void setFdn(QAsnRoutingInstance instanceAsn) {
        QAsnUniResID fdnAsn = instanceAsn.l3vpnKey;
        if (this.isValidFdn(fdnAsn)) {
            return;
        }
        L3vpnInstance mo = new L3vpnInstance();
        mo.setDevID(Integer.valueOf(fdnAsn.neID));
        mo.setVrID(Integer.valueOf(instanceAsn.poVrID == null ? 0 : instanceAsn.poVrID));
        mo.setVrfName(StringUtil.globalString((byte[])instanceAsn.vrfName));
        QAsnUniResID newFdnAsn = new L3vpnInstanceFdnParser().getUniResID((VmfMO)mo);
        fdnAsn.strFDN = newFdnAsn.strFDN;
        fdnAsn.strMOC = newFdnAsn.strMOC;
    }

    private void setSapUniResID(Map<String, QAsnUniResID> serialNum2SapKey, QAsnOspfCtpList ospfCtpList) {
        for (Object ob : ospfCtpList) {
            QAsnOspfCtp ospfCtp = (QAsnOspfCtp)ob;
            this.setSapUniResID(serialNum2SapKey, ospfCtp.l3vpnCtpKey);
        }
    }

    private void setSapUniResID(Map<String, QAsnUniResID> serialNum2SapKey, QAsnUniResID ctpKey) {
        if (ctpKey == null) {
            return;
        }
        QAsnUniResID validCtpKey = serialNum2SapKey.get(StringUtil.globalString((byte[])ctpKey.poSerialNum));
        if (validCtpKey != null) {
            ctpKey.strFDN = validCtpKey.strFDN;
            ctpKey.strMOC = validCtpKey.strMOC;
        }
    }
}

